/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.background.systemjob;

import android.app.Application;
import android.app.job.JobParameters;
import android.app.job.JobService;
import android.os.Build;
import android.os.PersistableBundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.work.Logger;
import androidx.work.WorkerParameters;
import androidx.work.impl.ExecutionListener;
import androidx.work.impl.WorkManagerImpl;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@RequiresApi(value=23)
public class SystemJobService
extends JobService
implements ExecutionListener {
    private static final String TAG = Logger.tagWithPrefix("SystemJobService");
    private WorkManagerImpl mWorkManagerImpl;
    private final Map<String, JobParameters> mJobParameters = new HashMap<String, JobParameters>();

    public void onCreate() {
        super.onCreate();
        this.mWorkManagerImpl = WorkManagerImpl.getInstance(this.getApplicationContext());
        if (this.mWorkManagerImpl == null) {
            if (!Application.class.equals(this.getApplication().getClass())) {
                throw new IllegalStateException("WorkManager needs to be initialized via a ContentProvider#onCreate() or an Application#onCreate().");
            }
            Logger.get().warning(TAG, "Could not find WorkManager instance; this may be because an auto-backup is in progress. Ignoring JobScheduler commands for now. Please make sure that you are initializing WorkManager if you have manually disabled WorkManagerInitializer.", new Throwable[0]);
        } else {
            this.mWorkManagerImpl.getProcessor().addExecutionListener(this);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mWorkManagerImpl != null) {
            this.mWorkManagerImpl.getProcessor().removeExecutionListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onStartJob(JobParameters params) {
        if (this.mWorkManagerImpl == null) {
            Logger.get().debug(TAG, "WorkManager is not initialized; requesting retry.", new Throwable[0]);
            this.jobFinished(params, true);
            return false;
        }
        PersistableBundle extras = params.getExtras();
        if (extras == null) {
            Logger.get().error(TAG, "No extras in JobParameters.", new Throwable[0]);
            return false;
        }
        String workSpecId = extras.getString("EXTRA_WORK_SPEC_ID");
        if (TextUtils.isEmpty((CharSequence)workSpecId)) {
            Logger.get().error(TAG, "WorkSpec id not found!", new Throwable[0]);
            return false;
        }
        Map<String, JobParameters> map = this.mJobParameters;
        synchronized (map) {
            if (this.mJobParameters.containsKey(workSpecId)) {
                Logger.get().debug(TAG, String.format("Job is already being executed by SystemJobService: %s", workSpecId), new Throwable[0]);
                return false;
            }
            Logger.get().debug(TAG, String.format("onStartJob for %s", workSpecId), new Throwable[0]);
            this.mJobParameters.put(workSpecId, params);
        }
        WorkerParameters.RuntimeExtras runtimeExtras = null;
        if (Build.VERSION.SDK_INT >= 24) {
            runtimeExtras = new WorkerParameters.RuntimeExtras();
            if (params.getTriggeredContentUris() != null) {
                runtimeExtras.triggeredContentUris = Arrays.asList(params.getTriggeredContentUris());
            }
            if (params.getTriggeredContentAuthorities() != null) {
                runtimeExtras.triggeredContentAuthorities = Arrays.asList(params.getTriggeredContentAuthorities());
            }
            if (Build.VERSION.SDK_INT >= 28) {
                runtimeExtras.network = params.getNetwork();
            }
        }
        this.mWorkManagerImpl.startWork(workSpecId, runtimeExtras);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onStopJob(JobParameters params) {
        if (this.mWorkManagerImpl == null) {
            Logger.get().debug(TAG, "WorkManager is not initialized; requesting retry.", new Throwable[0]);
            return true;
        }
        PersistableBundle extras = params.getExtras();
        if (extras == null) {
            Logger.get().error(TAG, "No extras in JobParameters.", new Throwable[0]);
            return false;
        }
        String workSpecId = extras.getString("EXTRA_WORK_SPEC_ID");
        if (TextUtils.isEmpty((CharSequence)workSpecId)) {
            Logger.get().error(TAG, "WorkSpec id not found!", new Throwable[0]);
            return false;
        }
        Logger.get().debug(TAG, String.format("onStopJob for %s", workSpecId), new Throwable[0]);
        Map<String, JobParameters> map = this.mJobParameters;
        synchronized (map) {
            this.mJobParameters.remove(workSpecId);
        }
        this.mWorkManagerImpl.stopWork(workSpecId);
        return !this.mWorkManagerImpl.getProcessor().isCancelled(workSpecId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onExecuted(@NonNull String workSpecId, boolean needsReschedule) {
        JobParameters parameters;
        Logger.get().debug(TAG, String.format("%s executed on JobScheduler", workSpecId), new Throwable[0]);
        Map<String, JobParameters> map = this.mJobParameters;
        synchronized (map) {
            parameters = this.mJobParameters.remove(workSpecId);
        }
        if (parameters != null) {
            this.jobFinished(parameters, needsReschedule);
        }
    }
}

