/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.background.systemalarm;

import android.content.Context;
import android.content.Intent;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import androidx.work.Logger;
import androidx.work.impl.background.systemalarm.CommandHandler;
import androidx.work.impl.background.systemalarm.ConstraintProxy;
import androidx.work.impl.background.systemalarm.SystemAlarmDispatcher;
import androidx.work.impl.constraints.WorkConstraintsTracker;
import androidx.work.impl.model.WorkSpec;
import java.util.ArrayList;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
class ConstraintsCommandHandler {
    private static final String TAG = Logger.tagWithPrefix("ConstraintsCmdHandler");
    private final Context mContext;
    private final int mStartId;
    private final SystemAlarmDispatcher mDispatcher;
    private final WorkConstraintsTracker mWorkConstraintsTracker;

    ConstraintsCommandHandler(@NonNull Context context, int startId, @NonNull SystemAlarmDispatcher dispatcher) {
        this.mContext = context;
        this.mStartId = startId;
        this.mDispatcher = dispatcher;
        this.mWorkConstraintsTracker = new WorkConstraintsTracker(this.mContext, null);
    }

    @WorkerThread
    void handleConstraintsChanged() {
        String workSpecId;
        List<WorkSpec> candidates = this.mDispatcher.getWorkManager().getWorkDatabase().workSpecDao().getScheduledWork();
        ConstraintProxy.updateAll(this.mContext, candidates);
        this.mWorkConstraintsTracker.replace(candidates);
        ArrayList<WorkSpec> eligibleWorkSpecs = new ArrayList<WorkSpec>(candidates.size());
        long now = System.currentTimeMillis();
        for (WorkSpec workSpec : candidates) {
            workSpecId = workSpec.id;
            long triggerAt = workSpec.calculateNextRunTime();
            if (now < triggerAt || workSpec.hasConstraints() && !this.mWorkConstraintsTracker.areAllConstraintsMet(workSpecId)) continue;
            eligibleWorkSpecs.add(workSpec);
        }
        for (WorkSpec workSpec : eligibleWorkSpecs) {
            workSpecId = workSpec.id;
            Intent intent = CommandHandler.createDelayMetIntent(this.mContext, workSpecId);
            Logger.get().debug(TAG, String.format("Creating a delay_met command for workSpec with id (%s)", workSpecId), new Throwable[0]);
            this.mDispatcher.postOnMainThread(new SystemAlarmDispatcher.AddRunnable(this.mDispatcher, intent, this.mStartId));
        }
        this.mWorkConstraintsTracker.reset();
    }
}

