/*
 * Decompiled with CFR 0.152.
 */
package androidx.work;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.room.TypeConverter;
import androidx.work.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Data {
    private static final String TAG = Logger.tagWithPrefix("Data");
    public static final Data EMPTY = new Builder().build();
    public static final int MAX_DATA_BYTES = 10240;
    Map<String, Object> mValues;

    Data() {
    }

    public Data(@NonNull Data other) {
        this.mValues = new HashMap<String, Object>(other.mValues);
    }

    Data(@NonNull Map<String, ?> values) {
        this.mValues = new HashMap(values);
    }

    public boolean getBoolean(@NonNull String key, boolean defaultValue) {
        Object value = this.mValues.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return defaultValue;
    }

    @Nullable
    public boolean[] getBooleanArray(@NonNull String key) {
        Object value = this.mValues.get(key);
        if (value instanceof Boolean[]) {
            Boolean[] array = (Boolean[])value;
            boolean[] returnArray = new boolean[array.length];
            for (int i = 0; i < array.length; ++i) {
                returnArray[i] = array[i];
            }
            return returnArray;
        }
        return null;
    }

    public byte getByte(@NonNull String key, byte defaultValue) {
        Object value = this.mValues.get(key);
        if (value instanceof Byte) {
            return (Byte)value;
        }
        return defaultValue;
    }

    @Nullable
    public byte[] getByteArray(@NonNull String key) {
        Object value = this.mValues.get(key);
        if (value instanceof Byte[]) {
            Byte[] array = (Byte[])value;
            byte[] returnArray = new byte[array.length];
            for (int i = 0; i < array.length; ++i) {
                returnArray[i] = array[i];
            }
            return returnArray;
        }
        return null;
    }

    public int getInt(@NonNull String key, int defaultValue) {
        Object value = this.mValues.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return defaultValue;
    }

    @Nullable
    public int[] getIntArray(@NonNull String key) {
        Object value = this.mValues.get(key);
        if (value instanceof Integer[]) {
            Integer[] array = (Integer[])value;
            int[] returnArray = new int[array.length];
            for (int i = 0; i < array.length; ++i) {
                returnArray[i] = array[i];
            }
            return returnArray;
        }
        return null;
    }

    public long getLong(@NonNull String key, long defaultValue) {
        Object value = this.mValues.get(key);
        if (value instanceof Long) {
            return (Long)value;
        }
        return defaultValue;
    }

    @Nullable
    public long[] getLongArray(@NonNull String key) {
        Object value = this.mValues.get(key);
        if (value instanceof Long[]) {
            Long[] array = (Long[])value;
            long[] returnArray = new long[array.length];
            for (int i = 0; i < array.length; ++i) {
                returnArray[i] = array[i];
            }
            return returnArray;
        }
        return null;
    }

    public float getFloat(@NonNull String key, float defaultValue) {
        Object value = this.mValues.get(key);
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        return defaultValue;
    }

    @Nullable
    public float[] getFloatArray(@NonNull String key) {
        Object value = this.mValues.get(key);
        if (value instanceof Float[]) {
            Float[] array = (Float[])value;
            float[] returnArray = new float[array.length];
            for (int i = 0; i < array.length; ++i) {
                returnArray[i] = array[i].floatValue();
            }
            return returnArray;
        }
        return null;
    }

    public double getDouble(@NonNull String key, double defaultValue) {
        Object value = this.mValues.get(key);
        if (value instanceof Double) {
            return (Double)value;
        }
        return defaultValue;
    }

    @Nullable
    public double[] getDoubleArray(@NonNull String key) {
        Object value = this.mValues.get(key);
        if (value instanceof Double[]) {
            Double[] array = (Double[])value;
            double[] returnArray = new double[array.length];
            for (int i = 0; i < array.length; ++i) {
                returnArray[i] = array[i];
            }
            return returnArray;
        }
        return null;
    }

    @Nullable
    public String getString(@NonNull String key) {
        Object value = this.mValues.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    @Nullable
    public String[] getStringArray(@NonNull String key) {
        Object value = this.mValues.get(key);
        if (value instanceof String[]) {
            return (String[])value;
        }
        return null;
    }

    @NonNull
    public Map<String, Object> getKeyValueMap() {
        return Collections.unmodifiableMap(this.mValues);
    }

    @VisibleForTesting
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int size() {
        return this.mValues.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @TypeConverter
    @NonNull
    public static byte[] toByteArray(@NonNull Data data) throws IllegalStateException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeInt(data.size());
            for (Map.Entry<String, Object> entry : data.mValues.entrySet()) {
                objectOutputStream.writeUTF(entry.getKey());
                objectOutputStream.writeObject(entry.getValue());
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Error in Data#toByteArray: ", (Throwable)e);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"Error in Data#toByteArray: ", (Throwable)e);
                }
            }
            try {
                outputStream.close();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Error in Data#toByteArray: ", (Throwable)e);
            }
        }
        if (outputStream.size() > 10240) {
            throw new IllegalStateException("Data cannot occupy more than 10240 bytes when serialized");
        }
        return outputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @TypeConverter
    @NonNull
    public static Data fromByteArray(@NonNull byte[] bytes) throws IllegalStateException {
        if (bytes.length > 10240) {
            throw new IllegalStateException("Data cannot occupy more than 10240 bytes when serialized");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(inputStream);
            for (int i = objectInputStream.readInt(); i > 0; --i) {
                map.put(objectInputStream.readUTF(), objectInputStream.readObject());
            }
        }
        catch (IOException | ClassNotFoundException e) {
            Log.e((String)TAG, (String)"Error in Data#fromByteArray: ", (Throwable)e);
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"Error in Data#fromByteArray: ", (Throwable)e);
                }
            }
            try {
                inputStream.close();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Error in Data#fromByteArray: ", (Throwable)e);
            }
        }
        return new Data(map);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Data other = (Data)o;
        return this.mValues.equals(other.mValues);
    }

    public int hashCode() {
        return 31 * this.mValues.hashCode();
    }

    @NonNull
    static Boolean[] convertPrimitiveBooleanArray(@NonNull boolean[] value) {
        Boolean[] returnValue = new Boolean[value.length];
        for (int i = 0; i < value.length; ++i) {
            returnValue[i] = value[i];
        }
        return returnValue;
    }

    @NonNull
    static Byte[] convertPrimitiveByteArray(@NonNull byte[] value) {
        Byte[] returnValue = new Byte[value.length];
        for (int i = 0; i < value.length; ++i) {
            returnValue[i] = value[i];
        }
        return returnValue;
    }

    @NonNull
    static Integer[] convertPrimitiveIntArray(@NonNull int[] value) {
        Integer[] returnValue = new Integer[value.length];
        for (int i = 0; i < value.length; ++i) {
            returnValue[i] = value[i];
        }
        return returnValue;
    }

    @NonNull
    static Long[] convertPrimitiveLongArray(@NonNull long[] value) {
        Long[] returnValue = new Long[value.length];
        for (int i = 0; i < value.length; ++i) {
            returnValue[i] = value[i];
        }
        return returnValue;
    }

    @NonNull
    static Float[] convertPrimitiveFloatArray(@NonNull float[] value) {
        Float[] returnValue = new Float[value.length];
        for (int i = 0; i < value.length; ++i) {
            returnValue[i] = Float.valueOf(value[i]);
        }
        return returnValue;
    }

    @NonNull
    static Double[] convertPrimitiveDoubleArray(@NonNull double[] value) {
        Double[] returnValue = new Double[value.length];
        for (int i = 0; i < value.length; ++i) {
            returnValue[i] = value[i];
        }
        return returnValue;
    }

    public static final class Builder {
        private Map<String, Object> mValues = new HashMap<String, Object>();

        @NonNull
        public Builder putBoolean(@NonNull String key, boolean value) {
            this.mValues.put(key, value);
            return this;
        }

        @NonNull
        public Builder putBooleanArray(@NonNull String key, @NonNull boolean[] value) {
            this.mValues.put(key, Data.convertPrimitiveBooleanArray(value));
            return this;
        }

        @NonNull
        public Builder putByte(@NonNull String key, byte value) {
            this.mValues.put(key, value);
            return this;
        }

        @NonNull
        public Builder putByteArray(@NonNull String key, @NonNull byte[] value) {
            this.mValues.put(key, Data.convertPrimitiveByteArray(value));
            return this;
        }

        @NonNull
        public Builder putInt(@NonNull String key, int value) {
            this.mValues.put(key, value);
            return this;
        }

        @NonNull
        public Builder putIntArray(@NonNull String key, @NonNull int[] value) {
            this.mValues.put(key, Data.convertPrimitiveIntArray(value));
            return this;
        }

        @NonNull
        public Builder putLong(@NonNull String key, long value) {
            this.mValues.put(key, value);
            return this;
        }

        @NonNull
        public Builder putLongArray(@NonNull String key, @NonNull long[] value) {
            this.mValues.put(key, Data.convertPrimitiveLongArray(value));
            return this;
        }

        @NonNull
        public Builder putFloat(@NonNull String key, float value) {
            this.mValues.put(key, Float.valueOf(value));
            return this;
        }

        @NonNull
        public Builder putFloatArray(@NonNull String key, @NonNull float[] value) {
            this.mValues.put(key, Data.convertPrimitiveFloatArray(value));
            return this;
        }

        @NonNull
        public Builder putDouble(@NonNull String key, double value) {
            this.mValues.put(key, value);
            return this;
        }

        @NonNull
        public Builder putDoubleArray(@NonNull String key, @NonNull double[] value) {
            this.mValues.put(key, Data.convertPrimitiveDoubleArray(value));
            return this;
        }

        @NonNull
        public Builder putString(@NonNull String key, @Nullable String value) {
            this.mValues.put(key, value);
            return this;
        }

        @NonNull
        public Builder putStringArray(@NonNull String key, @NonNull String[] value) {
            this.mValues.put(key, value);
            return this;
        }

        @NonNull
        public Builder putAll(@NonNull Data data) {
            this.putAll(data.mValues);
            return this;
        }

        @NonNull
        public Builder putAll(@NonNull Map<String, Object> values) {
            for (Map.Entry<String, Object> entry : values.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                this.put(key, value);
            }
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder put(@NonNull String key, @Nullable Object value) {
            if (value == null) {
                this.mValues.put(key, null);
            } else {
                Class<?> valueType = value.getClass();
                if (valueType == Boolean.class || valueType == Byte.class || valueType == Integer.class || valueType == Long.class || valueType == Float.class || valueType == Double.class || valueType == String.class || valueType == Boolean[].class || valueType == Byte[].class || valueType == Integer[].class || valueType == Long[].class || valueType == Float[].class || valueType == Double[].class || valueType == String[].class) {
                    this.mValues.put(key, value);
                } else if (valueType == boolean[].class) {
                    this.mValues.put(key, Data.convertPrimitiveBooleanArray((boolean[])value));
                } else if (valueType == byte[].class) {
                    this.mValues.put(key, Data.convertPrimitiveByteArray((byte[])value));
                } else if (valueType == int[].class) {
                    this.mValues.put(key, Data.convertPrimitiveIntArray((int[])value));
                } else if (valueType == long[].class) {
                    this.mValues.put(key, Data.convertPrimitiveLongArray((long[])value));
                } else if (valueType == float[].class) {
                    this.mValues.put(key, Data.convertPrimitiveFloatArray((float[])value));
                } else if (valueType == double[].class) {
                    this.mValues.put(key, Data.convertPrimitiveDoubleArray((double[])value));
                } else {
                    throw new IllegalArgumentException(String.format("Key %s has invalid type %s", key, valueType));
                }
            }
            return this;
        }

        @NonNull
        public Data build() {
            Data data = new Data(this.mValues);
            Data.toByteArray(data);
            return data;
        }
    }
}

