/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.workers;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.work.ListenableWorker;
import androidx.work.Logger;
import androidx.work.WorkerParameters;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.impl.constraints.WorkConstraintsCallback;
import androidx.work.impl.constraints.WorkConstraintsTracker;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.utils.futures.SettableFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ConstraintTrackingWorker
extends ListenableWorker
implements WorkConstraintsCallback {
    private static final String TAG = Logger.tagWithPrefix("ConstraintTrkngWrkr");
    public static final String ARGUMENT_CLASS_NAME = "androidx.work.impl.workers.ConstraintTrackingWorker.ARGUMENT_CLASS_NAME";
    private WorkerParameters mWorkerParameters;
    final Object mLock;
    volatile boolean mAreConstraintsUnmet;
    SettableFuture<ListenableWorker.Result> mFuture;
    @Nullable
    private ListenableWorker mDelegate;

    public ConstraintTrackingWorker(@NonNull Context appContext, @NonNull WorkerParameters workerParams) {
        super(appContext, workerParams);
        this.mWorkerParameters = workerParams;
        this.mLock = new Object();
        this.mAreConstraintsUnmet = false;
        this.mFuture = SettableFuture.create();
    }

    @Override
    @NonNull
    public ListenableFuture<ListenableWorker.Result> startWork() {
        this.getBackgroundExecutor().execute(new Runnable(){

            @Override
            public void run() {
                ConstraintTrackingWorker.this.setupAndRunConstraintTrackingWork();
            }
        });
        return this.mFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setupAndRunConstraintTrackingWork() {
        String className = this.getInputData().getString(ARGUMENT_CLASS_NAME);
        if (TextUtils.isEmpty((CharSequence)className)) {
            Logger.get().error(TAG, "No worker to delegate to.", new Throwable[0]);
            this.setFutureFailed();
            return;
        }
        this.mDelegate = this.getWorkerFactory().createWorkerWithDefaultFallback(this.getApplicationContext(), className, this.mWorkerParameters);
        if (this.mDelegate == null) {
            Logger.get().debug(TAG, "No worker to delegate to.", new Throwable[0]);
            this.setFutureFailed();
            return;
        }
        WorkDatabase workDatabase = this.getWorkDatabase();
        WorkSpec workSpec = workDatabase.workSpecDao().getWorkSpec(this.getId().toString());
        if (workSpec == null) {
            this.setFutureFailed();
            return;
        }
        WorkConstraintsTracker workConstraintsTracker = new WorkConstraintsTracker(this.getApplicationContext(), this);
        workConstraintsTracker.replace(Collections.singletonList(workSpec));
        if (workConstraintsTracker.areAllConstraintsMet(this.getId().toString())) {
            Logger.get().debug(TAG, String.format("Constraints met for delegate %s", className), new Throwable[0]);
            try {
                final ListenableFuture<ListenableWorker.Result> innerFuture = this.mDelegate.startWork();
                innerFuture.addListener(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = ConstraintTrackingWorker.this.mLock;
                        synchronized (object) {
                            if (ConstraintTrackingWorker.this.mAreConstraintsUnmet) {
                                ConstraintTrackingWorker.this.setFutureRetry();
                            } else {
                                ConstraintTrackingWorker.this.mFuture.setFuture((ListenableFuture<ListenableWorker.Result>)innerFuture);
                            }
                        }
                    }
                }, this.getBackgroundExecutor());
            }
            catch (Throwable exception) {
                Logger.get().debug(TAG, String.format("Delegated worker %s threw exception in startWork.", className), exception);
                Object object = this.mLock;
                synchronized (object) {
                    if (this.mAreConstraintsUnmet) {
                        Logger.get().debug(TAG, "Constraints were unmet, Retrying.", new Throwable[0]);
                        this.setFutureRetry();
                    } else {
                        this.setFutureFailed();
                    }
                }
            }
        } else {
            Logger.get().debug(TAG, String.format("Constraints not met for delegate %s. Requesting retry.", className), new Throwable[0]);
            this.setFutureRetry();
        }
    }

    void setFutureFailed() {
        this.mFuture.set(ListenableWorker.Result.failure());
    }

    void setFutureRetry() {
        this.mFuture.set(ListenableWorker.Result.retry());
    }

    @Override
    public void onStopped() {
        super.onStopped();
        if (this.mDelegate != null) {
            this.mDelegate.stop();
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @VisibleForTesting
    public WorkDatabase getWorkDatabase() {
        return WorkManagerImpl.getInstance(this.getApplicationContext()).getWorkDatabase();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @VisibleForTesting
    public ListenableWorker getDelegate() {
        return this.mDelegate;
    }

    @Override
    public void onAllConstraintsMet(@NonNull List<String> workSpecIds) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAllConstraintsNotMet(@NonNull List<String> workSpecIds) {
        Logger.get().debug(TAG, String.format("Constraints changed for %s", workSpecIds), new Throwable[0]);
        Object object = this.mLock;
        synchronized (object) {
            this.mAreConstraintsUnmet = true;
        }
    }
}

