/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.platform.view.inspector;

import android.os.Build;
import android.view.View;
import android.view.inspector.WindowInspector;
import androidx.annotation.RestrictTo;
import androidx.test.internal.platform.reflect.ReflectionException;
import androidx.test.internal.platform.reflect.ReflectiveField;
import androidx.test.internal.platform.reflect.ReflectiveMethod;
import androidx.test.internal.util.Checks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class WindowInspectorCompat {
    private static final ReflectiveMethod<Object> getWindowManagerImplReflectiveCall = new ReflectiveMethod("android.view.WindowManagerImpl", "getDefault", new Class[0]);
    private static final ReflectiveMethod<Object> getWindowManagerGlobalReflectiveCall = new ReflectiveMethod("android.view.WindowManagerGlobal", "getInstance", new Class[0]);
    private static final ReflectiveField<List<View>> windowViewsReflectiveField = new ReflectiveField("android.view.WindowManagerGlobal", "mViews");
    private static final ReflectiveField<View[]> windowViewsPreKitkatReflectiveField = new ReflectiveField("android.view.WindowManagerGlobal", "mViews");
    private static final ReflectiveField<View[]> windowViewsPreJBReflectiveField = new ReflectiveField("android.view.WindowManagerImpl", "mViews");

    private static Object getWindowManager() throws ReflectionException {
        if (Build.VERSION.SDK_INT >= 17) {
            return getWindowManagerGlobalReflectiveCall.invokeStatic(new Object[0]);
        }
        return getWindowManagerImplReflectiveCall.invokeStatic(new Object[0]);
    }

    public static List<View> getGlobalWindowViews() throws ViewRetrievalException {
        Checks.checkMainThread();
        if (Build.VERSION.SDK_INT >= 29) {
            return WindowInspector.getGlobalWindowViews();
        }
        try {
            return WindowInspectorCompat.getViews(WindowInspectorCompat.getWindowManager());
        }
        catch (ReflectionException e) {
            throw new ViewRetrievalException(e.getCause());
        }
    }

    private static List<View> getViews(Object windowManagerGlobal) throws ReflectionException {
        if (Build.VERSION.SDK_INT >= 19) {
            return windowViewsReflectiveField.get(windowManagerGlobal);
        }
        if (Build.VERSION.SDK_INT >= 17) {
            View[] views = windowViewsPreKitkatReflectiveField.get(windowManagerGlobal);
            return views != null ? Arrays.asList(views) : new ArrayList<View>();
        }
        View[] views = windowViewsPreJBReflectiveField.get(windowManagerGlobal);
        return views != null ? Arrays.asList(views) : new ArrayList<View>();
    }

    private WindowInspectorCompat() {
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static class ViewRetrievalException
    extends Exception {
        ViewRetrievalException(Throwable cause) {
            super("failed to retrieve window views", cause);
        }
    }
}

