/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner.lifecycle;

import android.app.Activity;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.RestrictTo;
import androidx.test.internal.util.Checks;
import androidx.test.runner.lifecycle.ActivityLifecycleCallback;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitor;
import androidx.test.runner.lifecycle.Stage;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class ActivityLifecycleMonitorImpl
implements ActivityLifecycleMonitor {
    private static final String TAG = "LifecycleMonitor";
    private final boolean declawThreadCheck;
    private final List<WeakReference<ActivityLifecycleCallback>> callbacks = new ArrayList<WeakReference<ActivityLifecycleCallback>>();
    private List<ActivityStatus> activityStatuses = new ArrayList<ActivityStatus>();

    @Override
    public Stage getLifecycleStageOf(Activity activity) {
        this.checkMainThread();
        Checks.checkNotNull(activity);
        Iterator<ActivityStatus> statusIterator = this.activityStatuses.iterator();
        while (statusIterator.hasNext()) {
            ActivityStatus status = statusIterator.next();
            Activity statusActivity = (Activity)status.activityRef.get();
            if (null == statusActivity) {
                statusIterator.remove();
                continue;
            }
            if (activity != statusActivity) continue;
            return status.lifecycleStage;
        }
        String string = String.valueOf(activity);
        throw new IllegalArgumentException(new StringBuilder(18 + String.valueOf(string).length()).append("Unknown activity: ").append(string).toString());
    }

    @Override
    public Collection<Activity> getActivitiesInStage(Stage stage) {
        this.checkMainThread();
        Checks.checkNotNull(stage);
        ArrayList<Activity> activities = new ArrayList<Activity>();
        Iterator<ActivityStatus> statusIterator = this.activityStatuses.iterator();
        while (statusIterator.hasNext()) {
            ActivityStatus status = statusIterator.next();
            Activity statusActivity = (Activity)status.activityRef.get();
            if (null == statusActivity) {
                statusIterator.remove();
                continue;
            }
            if (stage != status.lifecycleStage) continue;
            activities.add(statusActivity);
        }
        return activities;
    }

    public ActivityLifecycleMonitorImpl() {
        this(false);
    }

    public ActivityLifecycleMonitorImpl(boolean declawThreadCheck) {
        this.declawThreadCheck = declawThreadCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLifecycleCallback(ActivityLifecycleCallback callback) {
        Checks.checkNotNull(callback);
        List<WeakReference<ActivityLifecycleCallback>> list = this.callbacks;
        synchronized (list) {
            boolean needsAdd = true;
            Iterator<WeakReference<ActivityLifecycleCallback>> refIter = this.callbacks.iterator();
            while (refIter.hasNext()) {
                ActivityLifecycleCallback storedCallback = (ActivityLifecycleCallback)refIter.next().get();
                if (null == storedCallback) {
                    refIter.remove();
                    continue;
                }
                if (storedCallback != callback) continue;
                needsAdd = false;
            }
            if (needsAdd) {
                this.callbacks.add(new WeakReference<ActivityLifecycleCallback>(callback));
            }
        }
    }

    private void checkMainThread() {
        if (this.declawThreadCheck) {
            return;
        }
        if (!Thread.currentThread().equals(Looper.getMainLooper().getThread())) {
            throw new IllegalStateException("Querying activity state off main thread is not allowed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLifecycleCallback(ActivityLifecycleCallback callback) {
        Checks.checkNotNull(callback);
        List<WeakReference<ActivityLifecycleCallback>> list = this.callbacks;
        synchronized (list) {
            Iterator<WeakReference<ActivityLifecycleCallback>> refIter = this.callbacks.iterator();
            while (refIter.hasNext()) {
                ActivityLifecycleCallback storedCallback = (ActivityLifecycleCallback)refIter.next().get();
                if (null == storedCallback) {
                    refIter.remove();
                    continue;
                }
                if (storedCallback != callback) continue;
                refIter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalLifecycleChange(Stage stage, Activity activity) {
        String string = String.valueOf(activity);
        String string2 = String.valueOf((Object)stage);
        Log.d((String)TAG, (String)new StringBuilder(30 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Lifecycle status change: ").append(string).append(" in: ").append(string2).toString());
        boolean needsAdd = true;
        Iterator<ActivityStatus> statusIterator = this.activityStatuses.iterator();
        while (statusIterator.hasNext()) {
            ActivityStatus status = statusIterator.next();
            Activity statusActivity = (Activity)status.activityRef.get();
            if (null == statusActivity) {
                statusIterator.remove();
                continue;
            }
            if (activity != statusActivity) continue;
            needsAdd = false;
            status.lifecycleStage = stage;
        }
        if (needsAdd) {
            this.activityStatuses.add(new ActivityStatus(activity, stage));
        }
        List<WeakReference<ActivityLifecycleCallback>> list = this.callbacks;
        synchronized (list) {
            Iterator<WeakReference<ActivityLifecycleCallback>> refIter = this.callbacks.iterator();
            while (refIter.hasNext()) {
                ActivityLifecycleCallback callback = (ActivityLifecycleCallback)refIter.next().get();
                if (null == callback) {
                    refIter.remove();
                    continue;
                }
                try {
                    callback.onActivityLifecycleChanged(activity, stage);
                }
                catch (RuntimeException re) {
                    Log.e((String)TAG, (String)String.format("Callback threw exception! (callback: %s activity: %s stage: %s)", new Object[]{callback, activity, stage}), (Throwable)re);
                }
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class ActivityStatus {
        private final WeakReference<Activity> activityRef;
        private Stage lifecycleStage;

        ActivityStatus(Activity activity, Stage stage) {
            this.activityRef = new WeakReference<Activity>(Checks.checkNotNull(activity));
            this.lifecycleStage = Checks.checkNotNull(stage);
        }
    }
}

