/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.platform;

import android.os.StrictMode;
import androidx.annotation.RestrictTo;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class ServiceLoaderWrapper {
    public static <T> T loadSingleService(Class<T> serviceClass, Factory<T> defaultImplFactory) {
        T impl = ServiceLoaderWrapper.loadSingleServiceOrNull(serviceClass);
        if (impl == null) {
            return defaultImplFactory.create();
        }
        return impl;
    }

    public static <T> T loadSingleServiceOrNull(Class<T> serviceClass) {
        List<T> impls = ServiceLoaderWrapper.loadService(serviceClass);
        if (impls.isEmpty()) {
            return null;
        }
        if (impls.size() == 1) {
            return impls.get(0);
        }
        String string = String.valueOf(serviceClass.getName());
        throw new IllegalStateException(string.length() != 0 ? "Found more than one implementation for ".concat(string) : new String("Found more than one implementation for "));
    }

    public static <T> List<T> loadService(Class<T> serviceClass) {
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
        ArrayList<T> services = new ArrayList<T>();
        for (T element : ServiceLoader.load(serviceClass)) {
            services.add(element);
        }
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)oldPolicy);
        return services;
    }

    private ServiceLoaderWrapper() {
    }

    public static interface Factory<T> {
        public T create();
    }
}

