/*
 * Decompiled with CFR 0.152.
 */
package androidx.security.identity;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.security.identity.ResultData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

class SimpleResultData
extends ResultData {
    protected byte[] mStaticAuthenticationData = null;
    protected byte[] mAuthenticatedData = null;
    protected byte[] mEcdsaSignature = null;
    protected byte[] mMessageAuthenticationCode = null;
    protected Map<String, Map<String, EntryData>> mData = new LinkedHashMap<String, Map<String, EntryData>>();

    SimpleResultData() {
    }

    @Override
    @NonNull
    public byte[] getAuthenticatedData() {
        return this.mAuthenticatedData;
    }

    @Override
    @Nullable
    public byte[] getMessageAuthenticationCode() {
        return this.mMessageAuthenticationCode;
    }

    @Override
    @Nullable
    public byte[] getEcdsaSignature() {
        return this.mEcdsaSignature;
    }

    @Override
    @NonNull
    public byte[] getStaticAuthenticationData() {
        return this.mStaticAuthenticationData;
    }

    @Override
    @NonNull
    public Collection<String> getNamespaces() {
        return Collections.unmodifiableCollection(this.mData.keySet());
    }

    @Override
    @Nullable
    public Collection<String> getEntryNames(@NonNull String namespaceName) {
        Map<String, EntryData> innerMap = this.mData.get(namespaceName);
        if (innerMap == null) {
            return null;
        }
        return Collections.unmodifiableCollection(innerMap.keySet());
    }

    @Override
    @Nullable
    public Collection<String> getRetrievedEntryNames(@NonNull String namespaceName) {
        Map<String, EntryData> innerMap = this.mData.get(namespaceName);
        if (innerMap == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, EntryData> entry : innerMap.entrySet()) {
            if (entry.getValue().mStatus != 0) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    private EntryData getEntryData(@NonNull String namespaceName, @NonNull String name) {
        Map<String, EntryData> innerMap = this.mData.get(namespaceName);
        if (innerMap == null) {
            return null;
        }
        return innerMap.get(name);
    }

    @Override
    public int getStatus(@NonNull String namespaceName, @NonNull String name) {
        EntryData value = this.getEntryData(namespaceName, name);
        if (value == null) {
            return 2;
        }
        return value.mStatus;
    }

    @Override
    @Nullable
    public byte[] getEntry(@NonNull String namespaceName, @NonNull String name) {
        EntryData value = this.getEntryData(namespaceName, name);
        if (value == null) {
            return null;
        }
        return value.mValue;
    }

    static class Builder {
        private SimpleResultData mResultData = new SimpleResultData();

        Builder() {
        }

        Builder setStaticAuthenticationData(byte[] staticAuthenticationData) {
            this.mResultData.mStaticAuthenticationData = staticAuthenticationData;
            return this;
        }

        Builder setAuthenticatedData(byte[] authenticatedData) {
            this.mResultData.mAuthenticatedData = authenticatedData;
            return this;
        }

        Builder setEcdsaSignature(byte[] ecdsaSignature) {
            this.mResultData.mEcdsaSignature = ecdsaSignature;
            return this;
        }

        Builder setMessageAuthenticationCode(byte[] messageAuthenticationCode) {
            this.mResultData.mMessageAuthenticationCode = messageAuthenticationCode;
            return this;
        }

        private Map<String, EntryData> getOrCreateInnerMap(String namespaceName) {
            Map<String, EntryData> innerMap = this.mResultData.mData.get(namespaceName);
            if (innerMap == null) {
                innerMap = new LinkedHashMap<String, EntryData>();
                this.mResultData.mData.put(namespaceName, innerMap);
            }
            return innerMap;
        }

        Builder addEntry(String namespaceName, String name, byte[] value) {
            Map<String, EntryData> innerMap = this.getOrCreateInnerMap(namespaceName);
            innerMap.put(name, new EntryData(value, 0));
            return this;
        }

        Builder addErrorStatus(String namespaceName, String name, int status) {
            Map<String, EntryData> innerMap = this.getOrCreateInnerMap(namespaceName);
            innerMap.put(name, new EntryData(null, status));
            return this;
        }

        SimpleResultData build() {
            return this.mResultData;
        }
    }

    private static class EntryData {
        int mStatus;
        byte[] mValue;

        EntryData(byte[] value, int status) {
            this.mValue = value;
            this.mStatus = status;
        }
    }
}

