/*
 * Decompiled with CFR 0.152.
 */
package androidx.security.identity;

import android.icu.util.Calendar;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.security.identity.Util;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collection;

public abstract class ResultData {
    public static final int STATUS_OK = 0;
    public static final int STATUS_NO_SUCH_ENTRY = 1;
    public static final int STATUS_NOT_REQUESTED = 2;
    public static final int STATUS_NOT_IN_REQUEST_MESSAGE = 3;
    public static final int STATUS_USER_AUTHENTICATION_FAILED = 4;
    public static final int STATUS_READER_AUTHENTICATION_FAILED = 5;
    public static final int STATUS_NO_ACCESS_CONTROL_PROFILES = 6;

    @RestrictTo(value={RestrictTo.Scope.SUBCLASSES})
    protected ResultData() {
    }

    @NonNull
    public abstract byte[] getAuthenticatedData();

    @Nullable
    public abstract byte[] getMessageAuthenticationCode();

    @Nullable
    public abstract byte[] getEcdsaSignature();

    @NonNull
    public abstract byte[] getStaticAuthenticationData();

    @NonNull
    public abstract Collection<String> getNamespaces();

    @Nullable
    public abstract Collection<String> getEntryNames(@NonNull String var1);

    @Nullable
    public abstract Collection<String> getRetrievedEntryNames(@NonNull String var1);

    public abstract int getStatus(@NonNull String var1, @NonNull String var2);

    @Nullable
    public abstract byte[] getEntry(@NonNull String var1, @NonNull String var2);

    @Nullable
    public String getEntryString(@NonNull String namespaceName, @NonNull String name) {
        byte[] value = this.getEntry(namespaceName, name);
        if (value == null) {
            return null;
        }
        return Util.cborDecodeString(value);
    }

    @Nullable
    public byte[] getEntryBytestring(@NonNull String namespaceName, @NonNull String name) {
        byte[] value = this.getEntry(namespaceName, name);
        if (value == null) {
            return null;
        }
        return Util.cborDecodeBytestring(value);
    }

    public long getEntryInteger(@NonNull String namespaceName, @NonNull String name) {
        byte[] value = this.getEntry(namespaceName, name);
        if (value == null) {
            return 0L;
        }
        return Util.cborDecodeLong(value);
    }

    public boolean getEntryBoolean(@NonNull String namespaceName, @NonNull String name) {
        byte[] value = this.getEntry(namespaceName, name);
        if (value == null) {
            return false;
        }
        return Util.cborDecodeBoolean(value);
    }

    @Nullable
    public Calendar getEntryCalendar(@NonNull String namespaceName, @NonNull String name) {
        byte[] value = this.getEntry(namespaceName, name);
        if (value == null) {
            return null;
        }
        return Util.cborDecodeCalendar(value);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface Status {
    }
}

