/*
 * Decompiled with CFR 0.152.
 */
package androidx.security.identity;

import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.security.identity.AlreadyPersonalizedException;
import androidx.security.identity.CipherSuiteNotSupportedException;
import androidx.security.identity.DocTypeNotSupportedException;
import androidx.security.identity.HardwareIdentityCredentialStore;
import androidx.security.identity.IdentityCredential;
import androidx.security.identity.IdentityCredentialStoreCapabilities;
import androidx.security.identity.SoftwareIdentityCredentialStore;
import androidx.security.identity.WritableIdentityCredential;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class IdentityCredentialStore {
    public static final int CIPHERSUITE_ECDHE_HKDF_ECDSA_WITH_AES_256_GCM_SHA256 = 1;

    IdentityCredentialStore() {
    }

    @NonNull
    public static IdentityCredentialStore getInstance(@NonNull Context context) {
        IdentityCredentialStore store;
        Context appContext = context.getApplicationContext();
        if (Build.VERSION.SDK_INT >= 30 && (store = HardwareIdentityCredentialStore.getInstanceIfSupported(appContext)) != null) {
            return store;
        }
        return SoftwareIdentityCredentialStore.getInstance(appContext);
    }

    @NonNull
    public static IdentityCredentialStore getDirectAccessInstance(@NonNull Context context) {
        Context appContext;
        IdentityCredentialStore store;
        if (Build.VERSION.SDK_INT >= 30 && (store = HardwareIdentityCredentialStore.getDirectAccessInstance(appContext = context.getApplicationContext())) != null) {
            return store;
        }
        throw new RuntimeException("Direct-access IdentityCredential is not supported");
    }

    public static boolean isDirectAccessSupported(@NonNull Context context) {
        if (Build.VERSION.SDK_INT >= 30) {
            Context appContext = context.getApplicationContext();
            return HardwareIdentityCredentialStore.isDirectAccessSupported(appContext);
        }
        return false;
    }

    @Deprecated
    @NonNull
    public abstract String[] getSupportedDocTypes();

    @NonNull
    public abstract WritableIdentityCredential createCredential(@NonNull String var1, @NonNull String var2) throws AlreadyPersonalizedException, DocTypeNotSupportedException;

    @Nullable
    public abstract IdentityCredential getCredentialByName(@NonNull String var1, int var2) throws CipherSuiteNotSupportedException;

    @Deprecated
    @Nullable
    public abstract byte[] deleteCredentialByName(@NonNull String var1);

    @NonNull
    public IdentityCredentialStoreCapabilities getCapabilities() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public static IdentityCredentialStore getSoftwareInstance(@NonNull Context context) {
        return SoftwareIdentityCredentialStore.getInstance(context);
    }

    @Nullable
    public static IdentityCredentialStore getHardwareInstance(@NonNull Context context) {
        if (Build.VERSION.SDK_INT >= 30) {
            return HardwareIdentityCredentialStore.getInstance(context);
        }
        return null;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface Ciphersuite {
    }
}

