/*
 * Decompiled with CFR 0.152.
 */
package androidx.security.identity;

import android.security.identity.AccessControlProfile;
import android.security.identity.PersonalizationData;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.security.identity.AccessControlProfile;
import androidx.security.identity.AccessControlProfileId;
import androidx.security.identity.PersonalizationData;
import androidx.security.identity.WritableIdentityCredential;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;

@RequiresApi(value=30)
class HardwareWritableIdentityCredential
extends WritableIdentityCredential {
    private static final String TAG = "HardwareWritableIdentityCredential";
    android.security.identity.WritableIdentityCredential mWritableCredential = null;

    HardwareWritableIdentityCredential(android.security.identity.WritableIdentityCredential writableCredential) {
        this.mWritableCredential = writableCredential;
    }

    @Override
    @NonNull
    public Collection<X509Certificate> getCredentialKeyCertificateChain(@NonNull byte[] challenge) {
        return this.mWritableCredential.getCredentialKeyCertificateChain(challenge);
    }

    @Override
    @NonNull
    public byte[] personalize(@NonNull PersonalizationData personalizationData) {
        PersonalizationData.Builder builder = new PersonalizationData.Builder();
        for (PersonalizationData.NamespaceData nsData : personalizationData.getNamespaceDatas()) {
            for (String entryName : nsData.getEntryNames()) {
                ArrayList<android.security.identity.AccessControlProfileId> acpIds = new ArrayList<android.security.identity.AccessControlProfileId>();
                for (AccessControlProfileId id : nsData.getAccessControlProfileIds(entryName)) {
                    acpIds.add(new android.security.identity.AccessControlProfileId(id.getId()));
                }
                builder.putEntry(nsData.getNamespaceName(), entryName, acpIds, nsData.getEntryValue(entryName));
            }
        }
        for (AccessControlProfile profile : personalizationData.getAccessControlProfiles()) {
            android.security.identity.AccessControlProfileId id = new android.security.identity.AccessControlProfileId(profile.getAccessControlProfileId().getId());
            AccessControlProfile.Builder profileBuilder = new AccessControlProfile.Builder(id);
            profileBuilder.setReaderCertificate(profile.getReaderCertificate());
            profileBuilder.setUserAuthenticationTimeout(profile.getUserAuthenticationTimeout());
            profileBuilder.setUserAuthenticationRequired(profile.isUserAuthenticationRequired());
            builder.addAccessControlProfile(profileBuilder.build());
        }
        return this.mWritableCredential.personalize(builder.build());
    }
}

