/*
 * Decompiled with CFR 0.152.
 */
package androidx.security.identity;

import android.security.identity.SessionTranscriptMismatchException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.biometric.BiometricPrompt;
import androidx.security.identity.EphemeralPublicKeyNotFoundException;
import androidx.security.identity.IdentityCredential;
import androidx.security.identity.InvalidReaderSignatureException;
import androidx.security.identity.InvalidRequestMessageException;
import androidx.security.identity.MessageDecryptionException;
import androidx.security.identity.NoAuthenticationKeyAvailableException;
import androidx.security.identity.ResultData;
import androidx.security.identity.SimpleResultData;
import androidx.security.identity.UnknownAuthenticationKeyException;
import androidx.security.identity.Util;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

@RequiresApi(value=30)
class HardwareIdentityCredential
extends IdentityCredential {
    private static final String TAG = "HardwareIdentityCredential";
    private KeyPair mEphemeralKeyPair = null;
    private PublicKey mReaderEphemeralPublicKey = null;
    private byte[] mSessionTranscript = null;
    private SecretKey mSKDevice = null;
    private SecretKey mSKReader = null;
    private int mSKDeviceCounter;
    private int mSKReaderCounter;
    private android.security.identity.IdentityCredential mCredential = null;

    HardwareIdentityCredential(android.security.identity.IdentityCredential credential) {
        this.mCredential = credential;
    }

    @Override
    @NonNull
    public KeyPair createEphemeralKeyPair() {
        if (this.mEphemeralKeyPair == null) {
            this.mEphemeralKeyPair = this.mCredential.createEphemeralKeyPair();
        }
        return this.mEphemeralKeyPair;
    }

    @Override
    public void setReaderEphemeralPublicKey(@NonNull PublicKey readerEphemeralPublicKey) throws InvalidKeyException {
        this.mReaderEphemeralPublicKey = readerEphemeralPublicKey;
        this.mCredential.setReaderEphemeralPublicKey(readerEphemeralPublicKey);
    }

    @Override
    public void setSessionTranscript(@NonNull byte[] sessionTranscript) {
        if (this.mSessionTranscript != null) {
            throw new RuntimeException("SessionTranscript already set");
        }
        this.mSessionTranscript = (byte[])sessionTranscript.clone();
    }

    private void ensureSessionEncryptionKey() {
        if (this.mSKDevice != null) {
            return;
        }
        if (this.mReaderEphemeralPublicKey == null) {
            throw new RuntimeException("Reader ephemeral key not set");
        }
        if (this.mSessionTranscript == null) {
            throw new RuntimeException("Session transcript not set");
        }
        try {
            KeyAgreement ka = KeyAgreement.getInstance("ECDH");
            ka.init(this.mEphemeralKeyPair.getPrivate());
            ka.doPhase(this.mReaderEphemeralPublicKey, true);
            byte[] sharedSecret = ka.generateSecret();
            byte[] sessionTranscriptBytes = Util.prependSemanticTagForEncodedCbor(this.mSessionTranscript);
            byte[] salt = MessageDigest.getInstance("SHA-256").digest(sessionTranscriptBytes);
            byte[] info = new byte[]{83, 75, 68, 101, 118, 105, 99, 101};
            byte[] derivedKey = Util.computeHkdf("HmacSha256", sharedSecret, salt, info, 32);
            this.mSKDevice = new SecretKeySpec(derivedKey, "AES");
            info = new byte[]{83, 75, 82, 101, 97, 100, 101, 114};
            derivedKey = Util.computeHkdf("HmacSha256", sharedSecret, salt, info, 32);
            this.mSKReader = new SecretKeySpec(derivedKey, "AES");
            this.mSKDeviceCounter = 1;
            this.mSKReaderCounter = 1;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Error performing key agreement", e);
        }
    }

    @Override
    @NonNull
    public byte[] encryptMessageToReader(@NonNull byte[] messagePlaintext) {
        this.ensureSessionEncryptionKey();
        byte[] messageCiphertextAndAuthTag = null;
        try {
            ByteBuffer iv = ByteBuffer.allocate(12);
            iv.putInt(0, 0);
            iv.putInt(4, 1);
            iv.putInt(8, this.mSKDeviceCounter);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            GCMParameterSpec encryptionParameterSpec = new GCMParameterSpec(128, iv.array());
            cipher.init(1, (Key)this.mSKDevice, encryptionParameterSpec);
            messageCiphertextAndAuthTag = cipher.doFinal(messagePlaintext);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException("Error encrypting message", e);
        }
        ++this.mSKDeviceCounter;
        return messageCiphertextAndAuthTag;
    }

    @Override
    @NonNull
    public byte[] decryptMessageFromReader(@NonNull byte[] messageCiphertext) throws MessageDecryptionException {
        this.ensureSessionEncryptionKey();
        ByteBuffer iv = ByteBuffer.allocate(12);
        iv.putInt(0, 0);
        iv.putInt(4, 0);
        iv.putInt(8, this.mSKReaderCounter);
        byte[] plainText = null;
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(2, (Key)this.mSKReader, new GCMParameterSpec(128, iv.array()));
            plainText = cipher.doFinal(messageCiphertext);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new MessageDecryptionException("Error decrypting message", e);
        }
        ++this.mSKReaderCounter;
        return plainText;
    }

    @Override
    @NonNull
    public Collection<X509Certificate> getCredentialKeyCertificateChain() {
        return this.mCredential.getCredentialKeyCertificateChain();
    }

    @Override
    public void setAllowUsingExhaustedKeys(boolean allowUsingExhaustedKeys) {
        this.mCredential.setAllowUsingExhaustedKeys(allowUsingExhaustedKeys);
    }

    @Override
    @Nullable
    public BiometricPrompt.CryptoObject getCryptoObject() {
        BiometricPrompt.CryptoObject cryptoObject = new BiometricPrompt.CryptoObject(this.mCredential);
        return cryptoObject;
    }

    @Override
    @NonNull
    public ResultData getEntries(@Nullable byte[] requestMessage, @NonNull Map<String, Collection<String>> entriesToRequest, @Nullable byte[] readerSignature) throws NoAuthenticationKeyAvailableException, InvalidReaderSignatureException, InvalidRequestMessageException, EphemeralPublicKeyNotFoundException {
        android.security.identity.ResultData rd;
        try {
            rd = this.mCredential.getEntries(requestMessage, entriesToRequest, this.mSessionTranscript, readerSignature);
        }
        catch (android.security.identity.NoAuthenticationKeyAvailableException e) {
            throw new NoAuthenticationKeyAvailableException(e.getMessage(), e);
        }
        catch (android.security.identity.InvalidReaderSignatureException e) {
            throw new InvalidReaderSignatureException(e.getMessage(), e);
        }
        catch (android.security.identity.InvalidRequestMessageException e) {
            throw new InvalidRequestMessageException(e.getMessage(), e);
        }
        catch (android.security.identity.EphemeralPublicKeyNotFoundException e) {
            throw new EphemeralPublicKeyNotFoundException(e.getMessage(), e);
        }
        catch (SessionTranscriptMismatchException e) {
            throw new RuntimeException("Unexpected SessionMismatchException", e);
        }
        SimpleResultData.Builder builder = new SimpleResultData.Builder();
        builder.setMessageAuthenticationCode(rd.getMessageAuthenticationCode());
        builder.setAuthenticatedData(rd.getAuthenticatedData());
        builder.setStaticAuthenticationData(rd.getStaticAuthenticationData());
        for (String namespaceName : rd.getNamespaces()) {
            for (String entryName : rd.getEntryNames(namespaceName)) {
                int status = rd.getStatus(namespaceName, entryName);
                if (status == 0) {
                    byte[] value = rd.getEntry(namespaceName, entryName);
                    builder.addEntry(namespaceName, entryName, value);
                    continue;
                }
                builder.addErrorStatus(namespaceName, entryName, status);
            }
        }
        return builder.build();
    }

    @Override
    public void setAvailableAuthenticationKeys(int keyCount, int maxUsesPerKey) {
        this.mCredential.setAvailableAuthenticationKeys(keyCount, maxUsesPerKey);
    }

    @Override
    @NonNull
    public Collection<X509Certificate> getAuthKeysNeedingCertification() {
        return this.mCredential.getAuthKeysNeedingCertification();
    }

    @Override
    public void storeStaticAuthenticationData(@NonNull X509Certificate authenticationKey, @NonNull byte[] staticAuthData) throws UnknownAuthenticationKeyException {
        try {
            this.mCredential.storeStaticAuthenticationData(authenticationKey, staticAuthData);
        }
        catch (android.security.identity.UnknownAuthenticationKeyException e) {
            throw new UnknownAuthenticationKeyException(e.getMessage(), e);
        }
    }

    @Override
    @NonNull
    public int[] getAuthenticationDataUsageCount() {
        return this.mCredential.getAuthenticationDataUsageCount();
    }
}

