/*
 * Decompiled with CFR 0.152.
 */
package androidx.security.identity;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.security.identity.AccessControlProfileId;
import java.security.cert.X509Certificate;

public class AccessControlProfile {
    @NonNull
    AccessControlProfileId mAccessControlProfileId = new AccessControlProfileId(0);
    @Nullable
    X509Certificate mReaderCertificate = null;
    boolean mUserAuthenticationRequired = true;
    long mUserAuthenticationTimeout = 0L;

    AccessControlProfile() {
    }

    @NonNull
    AccessControlProfileId getAccessControlProfileId() {
        return this.mAccessControlProfileId;
    }

    long getUserAuthenticationTimeout() {
        return this.mUserAuthenticationTimeout;
    }

    boolean isUserAuthenticationRequired() {
        return this.mUserAuthenticationRequired;
    }

    @Nullable
    X509Certificate getReaderCertificate() {
        return this.mReaderCertificate;
    }

    public static final class Builder {
        private AccessControlProfile mProfile = new AccessControlProfile();

        public Builder(@NonNull AccessControlProfileId accessControlProfileId) {
            this.mProfile.mAccessControlProfileId = accessControlProfileId;
        }

        @NonNull
        public Builder setUserAuthenticationRequired(boolean userAuthenticationRequired) {
            this.mProfile.mUserAuthenticationRequired = userAuthenticationRequired;
            return this;
        }

        @NonNull
        public Builder setUserAuthenticationTimeout(long userAuthenticationTimeoutMillis) {
            this.mProfile.mUserAuthenticationTimeout = userAuthenticationTimeoutMillis;
            return this;
        }

        @NonNull
        public Builder setReaderCertificate(@NonNull X509Certificate readerCertificate) {
            this.mProfile.mReaderCertificate = readerCertificate;
            return this;
        }

        @NonNull
        public AccessControlProfile build() {
            return this.mProfile;
        }
    }
}

