/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.rxjava3;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.EmptyResultSetException;
import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

public final class RxRoom {
    @NonNull
    public static final Object NOTHING = new Object();

    @NonNull
    public static Flowable<Object> createFlowable(@NonNull RoomDatabase database, String ... tableNames) {
        return Flowable.create(emitter -> {
            InvalidationTracker.Observer observer = new InvalidationTracker.Observer(tableNames){

                public void onInvalidated(@NonNull Set<String> tables) {
                    if (!emitter.isCancelled()) {
                        emitter.onNext(NOTHING);
                    }
                }
            };
            if (!emitter.isCancelled()) {
                database.getInvalidationTracker().addObserver(observer);
                emitter.setDisposable(Disposable.fromAction(() -> database.getInvalidationTracker().removeObserver(observer)));
            }
            if (!emitter.isCancelled()) {
                emitter.onNext(NOTHING);
            }
        }, (BackpressureStrategy)BackpressureStrategy.LATEST);
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static <T> Flowable<T> createFlowable(@NonNull RoomDatabase database, boolean inTransaction, @NonNull String[] tableNames, @NonNull Callable<T> callable) {
        Scheduler scheduler = Schedulers.from((Executor)RxRoom.getExecutor(database, inTransaction));
        Maybe maybe = Maybe.fromCallable(callable);
        return RxRoom.createFlowable(database, tableNames).subscribeOn(scheduler).unsubscribeOn(scheduler).observeOn(scheduler).flatMapMaybe(o -> maybe);
    }

    @NonNull
    public static Observable<Object> createObservable(@NonNull RoomDatabase database, String ... tableNames) {
        return Observable.create(emitter -> {
            InvalidationTracker.Observer observer = new InvalidationTracker.Observer(tableNames){

                public void onInvalidated(@NonNull Set<String> tables) {
                    emitter.onNext(NOTHING);
                }
            };
            database.getInvalidationTracker().addObserver(observer);
            emitter.setDisposable(Disposable.fromAction(() -> database.getInvalidationTracker().removeObserver(observer)));
            emitter.onNext(NOTHING);
        });
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static <T> Observable<T> createObservable(@NonNull RoomDatabase database, boolean inTransaction, @NonNull String[] tableNames, @NonNull Callable<T> callable) {
        Scheduler scheduler = Schedulers.from((Executor)RxRoom.getExecutor(database, inTransaction));
        Maybe maybe = Maybe.fromCallable(callable);
        return RxRoom.createObservable(database, tableNames).subscribeOn(scheduler).unsubscribeOn(scheduler).observeOn(scheduler).flatMapMaybe(o -> maybe);
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static <T> Single<T> createSingle(@NonNull Callable<? extends T> callable) {
        return Single.create(emitter -> {
            try {
                emitter.onSuccess(callable.call());
            }
            catch (EmptyResultSetException e) {
                emitter.tryOnError((Throwable)e);
            }
        });
    }

    private static Executor getExecutor(@NonNull RoomDatabase database, boolean inTransaction) {
        if (inTransaction) {
            return database.getTransactionExecutor();
        }
        return database.getQueryExecutor();
    }

    private RxRoom() {
    }
}

