/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.util;

import android.database.Cursor;
import android.database.MatrixCursor;
import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import java.util.Arrays;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class CursorUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static Cursor copyAndClose(@NonNull Cursor c) {
        MatrixCursor matrixCursor;
        try {
            matrixCursor = new MatrixCursor(c.getColumnNames(), c.getCount());
            while (c.moveToNext()) {
                Object[] row = new Object[c.getColumnCount()];
                block11: for (int i = 0; i < c.getColumnCount(); ++i) {
                    switch (c.getType(i)) {
                        case 0: {
                            row[i] = null;
                            continue block11;
                        }
                        case 1: {
                            row[i] = c.getLong(i);
                            continue block11;
                        }
                        case 2: {
                            row[i] = c.getDouble(i);
                            continue block11;
                        }
                        case 3: {
                            row[i] = c.getString(i);
                            continue block11;
                        }
                        case 4: {
                            row[i] = c.getBlob(i);
                            continue block11;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
                matrixCursor.addRow(row);
            }
        }
        finally {
            c.close();
        }
        return matrixCursor;
    }

    public static int getColumnIndex(@NonNull Cursor c, @NonNull String name) {
        int index = c.getColumnIndex(name);
        if (index >= 0) {
            return index;
        }
        index = c.getColumnIndex("`" + name + "`");
        if (index >= 0) {
            return index;
        }
        return CursorUtil.findColumnIndexBySuffix(c, name);
    }

    public static int getColumnIndexOrThrow(@NonNull Cursor c, @NonNull String name) {
        int index = CursorUtil.getColumnIndex(c, name);
        if (index >= 0) {
            return index;
        }
        String availableColumns = "";
        try {
            availableColumns = Arrays.toString(c.getColumnNames());
        }
        catch (Exception e) {
            Log.d((String)"RoomCursorUtil", (String)"Cannot collect column names for debug purposes", (Throwable)e);
        }
        throw new IllegalArgumentException("column '" + name + "' does not exist. Available columns: " + availableColumns);
    }

    private static int findColumnIndexBySuffix(@NonNull Cursor cursor, @NonNull String name) {
        if (Build.VERSION.SDK_INT > 25) {
            return -1;
        }
        if (name.length() == 0) {
            return -1;
        }
        String[] columnNames = cursor.getColumnNames();
        return CursorUtil.findColumnIndexBySuffix(columnNames, name);
    }

    @VisibleForTesting(otherwise=2)
    static int findColumnIndexBySuffix(String[] columnNames, String name) {
        String dotSuffix = "." + name;
        String backtickSuffix = "." + name + "`";
        for (int index = 0; index < columnNames.length; ++index) {
            String columnName = columnNames[index];
            if (columnName.length() < name.length() + 2) continue;
            if (columnName.endsWith(dotSuffix)) {
                return index;
            }
            if (columnName.charAt(0) != '`' || !columnName.endsWith(backtickSuffix)) continue;
            return index;
        }
        return -1;
    }

    private CursorUtil() {
    }
}

