/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.util;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class CopyLock {
    private static final Map<String, Lock> sThreadLocks = new HashMap<String, Lock>();
    private final File mCopyLockFile;
    private final Lock mThreadLock;
    private final boolean mFileLevelLock;
    private FileChannel mLockChannel;

    public CopyLock(@NonNull String name, @NonNull File lockDir, boolean processLock) {
        this.mCopyLockFile = new File(lockDir, name + ".lck");
        this.mThreadLock = CopyLock.getThreadLock(this.mCopyLockFile.getAbsolutePath());
        this.mFileLevelLock = processLock;
    }

    public void lock() {
        this.mThreadLock.lock();
        if (this.mFileLevelLock) {
            try {
                this.mLockChannel = new FileOutputStream(this.mCopyLockFile).getChannel();
                this.mLockChannel.lock();
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to grab copy lock.", e);
            }
        }
    }

    public void unlock() {
        if (this.mLockChannel != null) {
            try {
                this.mLockChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.mThreadLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Lock getThreadLock(String key) {
        Map<String, Lock> map = sThreadLocks;
        synchronized (map) {
            Lock threadLock = sThreadLocks.get(key);
            if (threadLock == null) {
                threadLock = new ReentrantLock();
                sThreadLocks.put(key, threadLock);
            }
            return threadLock;
        }
    }
}

