/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteTransactionListener;
import android.os.CancellationSignal;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.room.QueryInterceptorProgram;
import androidx.room.QueryInterceptorStatement;
import androidx.room.RoomDatabase;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteProgram;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executor;

final class QueryInterceptorDatabase
implements SupportSQLiteDatabase {
    private final SupportSQLiteDatabase mDelegate;
    private final RoomDatabase.QueryCallback mQueryCallback;
    private final Executor mQueryCallbackExecutor;

    QueryInterceptorDatabase(@NonNull SupportSQLiteDatabase supportSQLiteDatabase, @NonNull RoomDatabase.QueryCallback queryCallback, @NonNull Executor queryCallbackExecutor) {
        this.mDelegate = supportSQLiteDatabase;
        this.mQueryCallback = queryCallback;
        this.mQueryCallbackExecutor = queryCallbackExecutor;
    }

    @NonNull
    public SupportSQLiteStatement compileStatement(@NonNull String sql) {
        return new QueryInterceptorStatement(this.mDelegate.compileStatement(sql), this.mQueryCallback, sql, this.mQueryCallbackExecutor);
    }

    public void beginTransaction() {
        this.mQueryCallbackExecutor.execute(() -> this.mQueryCallback.onQuery("BEGIN EXCLUSIVE TRANSACTION", Collections.emptyList()));
        this.mDelegate.beginTransaction();
    }

    public void beginTransactionNonExclusive() {
        this.mQueryCallbackExecutor.execute(() -> this.mQueryCallback.onQuery("BEGIN DEFERRED TRANSACTION", Collections.emptyList()));
        this.mDelegate.beginTransactionNonExclusive();
    }

    public void beginTransactionWithListener(@NonNull SQLiteTransactionListener transactionListener) {
        this.mQueryCallbackExecutor.execute(() -> this.mQueryCallback.onQuery("BEGIN EXCLUSIVE TRANSACTION", Collections.emptyList()));
        this.mDelegate.beginTransactionWithListener(transactionListener);
    }

    public void beginTransactionWithListenerNonExclusive(@NonNull SQLiteTransactionListener transactionListener) {
        this.mQueryCallbackExecutor.execute(() -> this.mQueryCallback.onQuery("BEGIN DEFERRED TRANSACTION", Collections.emptyList()));
        this.mDelegate.beginTransactionWithListenerNonExclusive(transactionListener);
    }

    public void endTransaction() {
        this.mQueryCallbackExecutor.execute(() -> this.mQueryCallback.onQuery("END TRANSACTION", Collections.emptyList()));
        this.mDelegate.endTransaction();
    }

    public void setTransactionSuccessful() {
        this.mQueryCallbackExecutor.execute(() -> this.mQueryCallback.onQuery("TRANSACTION SUCCESSFUL", Collections.emptyList()));
        this.mDelegate.setTransactionSuccessful();
    }

    public boolean inTransaction() {
        return this.mDelegate.inTransaction();
    }

    public boolean isDbLockedByCurrentThread() {
        return this.mDelegate.isDbLockedByCurrentThread();
    }

    public boolean yieldIfContendedSafely() {
        return this.mDelegate.yieldIfContendedSafely();
    }

    public boolean yieldIfContendedSafely(long sleepAfterYieldDelay) {
        return this.mDelegate.yieldIfContendedSafely(sleepAfterYieldDelay);
    }

    public int getVersion() {
        return this.mDelegate.getVersion();
    }

    public void setVersion(int version) {
        this.mDelegate.setVersion(version);
    }

    public long getMaximumSize() {
        return this.mDelegate.getMaximumSize();
    }

    public long setMaximumSize(long numBytes) {
        return this.mDelegate.setMaximumSize(numBytes);
    }

    public long getPageSize() {
        return this.mDelegate.getPageSize();
    }

    public void setPageSize(long numBytes) {
        this.mDelegate.setPageSize(numBytes);
    }

    @NonNull
    public Cursor query(@NonNull String query) {
        this.mQueryCallbackExecutor.execute(() -> this.mQueryCallback.onQuery(query, Collections.emptyList()));
        return this.mDelegate.query(query);
    }

    @NonNull
    public Cursor query(@NonNull String query, @NonNull Object[] bindArgs) {
        ArrayList<Object> inputArguments = new ArrayList<Object>();
        inputArguments.addAll(Arrays.asList(bindArgs));
        this.mQueryCallbackExecutor.execute(() -> this.mQueryCallback.onQuery(query, inputArguments));
        return this.mDelegate.query(query, bindArgs);
    }

    @NonNull
    public Cursor query(@NonNull SupportSQLiteQuery query) {
        QueryInterceptorProgram queryInterceptorProgram = new QueryInterceptorProgram();
        query.bindTo((SupportSQLiteProgram)queryInterceptorProgram);
        this.mQueryCallbackExecutor.execute(() -> this.mQueryCallback.onQuery(query.getSql(), queryInterceptorProgram.getBindArgs()));
        return this.mDelegate.query(query);
    }

    @NonNull
    public Cursor query(@NonNull SupportSQLiteQuery query, @NonNull CancellationSignal cancellationSignal) {
        QueryInterceptorProgram queryInterceptorProgram = new QueryInterceptorProgram();
        query.bindTo((SupportSQLiteProgram)queryInterceptorProgram);
        this.mQueryCallbackExecutor.execute(() -> this.mQueryCallback.onQuery(query.getSql(), queryInterceptorProgram.getBindArgs()));
        return this.mDelegate.query(query);
    }

    public long insert(@NonNull String table, int conflictAlgorithm, @NonNull ContentValues values) throws SQLException {
        return this.mDelegate.insert(table, conflictAlgorithm, values);
    }

    public int delete(@NonNull String table, @NonNull String whereClause, @NonNull Object[] whereArgs) {
        return this.mDelegate.delete(table, whereClause, whereArgs);
    }

    public int update(@NonNull String table, int conflictAlgorithm, @NonNull ContentValues values, @NonNull String whereClause, @NonNull Object[] whereArgs) {
        return this.mDelegate.update(table, conflictAlgorithm, values, whereClause, whereArgs);
    }

    public void execSQL(@NonNull String sql) throws SQLException {
        this.mQueryCallbackExecutor.execute(() -> this.mQueryCallback.onQuery(sql, new ArrayList<Object>(0)));
        this.mDelegate.execSQL(sql);
    }

    public void execSQL(@NonNull String sql, @NonNull Object[] bindArgs) throws SQLException {
        ArrayList<Object> inputArguments = new ArrayList<Object>();
        inputArguments.addAll(Arrays.asList(bindArgs));
        this.mQueryCallbackExecutor.execute(() -> this.mQueryCallback.onQuery(sql, inputArguments));
        this.mDelegate.execSQL(sql, inputArguments.toArray());
    }

    public boolean isReadOnly() {
        return this.mDelegate.isReadOnly();
    }

    public boolean isOpen() {
        return this.mDelegate.isOpen();
    }

    public boolean needUpgrade(int newVersion) {
        return this.mDelegate.needUpgrade(newVersion);
    }

    @NonNull
    public String getPath() {
        return this.mDelegate.getPath();
    }

    public void setLocale(@NonNull Locale locale) {
        this.mDelegate.setLocale(locale);
    }

    public void setMaxSqlCacheSize(int cacheSize) {
        this.mDelegate.setMaxSqlCacheSize(cacheSize);
    }

    @RequiresApi(api=16)
    public void setForeignKeyConstraintsEnabled(boolean enable) {
        this.mDelegate.setForeignKeyConstraintsEnabled(enable);
    }

    public boolean enableWriteAheadLogging() {
        return this.mDelegate.enableWriteAheadLogging();
    }

    @RequiresApi(api=16)
    public void disableWriteAheadLogging() {
        this.mDelegate.disableWriteAheadLogging();
    }

    @RequiresApi(api=16)
    public boolean isWriteAheadLoggingEnabled() {
        return this.mDelegate.isWriteAheadLoggingEnabled();
    }

    @NonNull
    public List<Pair<String, String>> getAttachedDbs() {
        return this.mDelegate.getAttachedDbs();
    }

    public boolean isDatabaseIntegrityOk() {
        return this.mDelegate.isDatabaseIntegrityOk();
    }

    public void close() throws IOException {
        this.mDelegate.close();
    }
}

