/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.util;

import android.annotation.SuppressLint;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class FileUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"LambdaLast"})
    public static void copy(@NonNull ReadableByteChannel input, @NonNull FileChannel output) throws IOException {
        try {
            if (Build.VERSION.SDK_INT > 23) {
                output.transferFrom(input, 0L, Long.MAX_VALUE);
            } else {
                int length;
                InputStream inputStream = Channels.newInputStream(input);
                OutputStream outputStream = Channels.newOutputStream(output);
                byte[] buffer = new byte[4096];
                while ((length = inputStream.read(buffer)) > 0) {
                    outputStream.write(buffer, 0, length);
                }
            }
            output.force(false);
        }
        finally {
            input.close();
            output.close();
        }
    }

    private FileUtil() {
    }
}

