/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.room.IMultiInstanceInvalidationCallback;
import androidx.room.IMultiInstanceInvalidationService;
import java.util.HashMap;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class MultiInstanceInvalidationService
extends Service {
    int mMaxClientId = 0;
    final HashMap<Integer, String> mClientNames = new HashMap();
    final RemoteCallbackList<IMultiInstanceInvalidationCallback> mCallbackList = new RemoteCallbackList<IMultiInstanceInvalidationCallback>(){

        public void onCallbackDied(IMultiInstanceInvalidationCallback callback, Object cookie) {
            MultiInstanceInvalidationService.this.mClientNames.remove((int)((Integer)cookie));
        }
    };
    private final IMultiInstanceInvalidationService.Stub mBinder = new IMultiInstanceInvalidationService.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int registerCallback(IMultiInstanceInvalidationCallback callback, String name) {
            if (name == null) {
                return 0;
            }
            RemoteCallbackList<IMultiInstanceInvalidationCallback> remoteCallbackList = MultiInstanceInvalidationService.this.mCallbackList;
            synchronized (remoteCallbackList) {
                ++MultiInstanceInvalidationService.this.mMaxClientId;
                int clientId = MultiInstanceInvalidationService.this.mMaxClientId--;
                if (MultiInstanceInvalidationService.this.mCallbackList.register((IInterface)callback, (Object)clientId)) {
                    MultiInstanceInvalidationService.this.mClientNames.put(clientId, name);
                    return clientId;
                }
                return 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unregisterCallback(IMultiInstanceInvalidationCallback callback, int clientId) {
            RemoteCallbackList<IMultiInstanceInvalidationCallback> remoteCallbackList = MultiInstanceInvalidationService.this.mCallbackList;
            synchronized (remoteCallbackList) {
                MultiInstanceInvalidationService.this.mCallbackList.unregister((IInterface)callback);
                MultiInstanceInvalidationService.this.mClientNames.remove(clientId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void broadcastInvalidation(int clientId, String[] tables) {
            RemoteCallbackList<IMultiInstanceInvalidationCallback> remoteCallbackList = MultiInstanceInvalidationService.this.mCallbackList;
            synchronized (remoteCallbackList) {
                String name = MultiInstanceInvalidationService.this.mClientNames.get(clientId);
                if (name == null) {
                    Log.w((String)"ROOM", (String)"Remote invalidation client ID not registered");
                    return;
                }
                int count = MultiInstanceInvalidationService.this.mCallbackList.beginBroadcast();
                try {
                    for (int i = 0; i < count; ++i) {
                        int targetClientId = (Integer)MultiInstanceInvalidationService.this.mCallbackList.getBroadcastCookie(i);
                        String targetName = MultiInstanceInvalidationService.this.mClientNames.get(targetClientId);
                        if (clientId == targetClientId || !name.equals(targetName)) continue;
                        try {
                            IMultiInstanceInvalidationCallback callback = (IMultiInstanceInvalidationCallback)MultiInstanceInvalidationService.this.mCallbackList.getBroadcastItem(i);
                            callback.onInvalidation(tables);
                            continue;
                        }
                        catch (RemoteException e) {
                            Log.w((String)"ROOM", (String)"Error invoking a remote callback", (Throwable)e);
                        }
                    }
                }
                finally {
                    MultiInstanceInvalidationService.this.mCallbackList.finishBroadcast();
                }
            }
        }
    };

    @Nullable
    public IBinder onBind(Intent intent) {
        return this.mBinder;
    }
}

