/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import androidx.annotation.RestrictTo;
import androidx.room.RoomDatabase;
import androidx.room.SharedSQLiteStatement;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public abstract class EntityInsertionAdapter<T>
extends SharedSQLiteStatement {
    public EntityInsertionAdapter(RoomDatabase database) {
        super(database);
    }

    protected abstract void bind(SupportSQLiteStatement var1, T var2);

    public final void insert(T entity) {
        SupportSQLiteStatement stmt = this.acquire();
        try {
            this.bind(stmt, entity);
            stmt.executeInsert();
        }
        finally {
            this.release(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void insert(T[] entities) {
        SupportSQLiteStatement stmt = this.acquire();
        try {
            for (T entity : entities) {
                this.bind(stmt, entity);
                stmt.executeInsert();
            }
        }
        finally {
            this.release(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void insert(Iterable<T> entities) {
        SupportSQLiteStatement stmt = this.acquire();
        try {
            for (T entity : entities) {
                this.bind(stmt, entity);
                stmt.executeInsert();
            }
        }
        finally {
            this.release(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long insertAndReturnId(T entity) {
        SupportSQLiteStatement stmt = this.acquire();
        try {
            this.bind(stmt, entity);
            long l = stmt.executeInsert();
            return l;
        }
        finally {
            this.release(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long[] insertAndReturnIdsArray(Collection<T> entities) {
        SupportSQLiteStatement stmt = this.acquire();
        try {
            long[] result = new long[entities.size()];
            int index = 0;
            for (T entity : entities) {
                this.bind(stmt, entity);
                result[index] = stmt.executeInsert();
                ++index;
            }
            Object object = result;
            return object;
        }
        finally {
            this.release(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long[] insertAndReturnIdsArray(T[] entities) {
        SupportSQLiteStatement stmt = this.acquire();
        try {
            long[] result = new long[entities.length];
            int index = 0;
            for (T entity : entities) {
                this.bind(stmt, entity);
                result[index] = stmt.executeInsert();
                ++index;
            }
            long[] lArray = result;
            return lArray;
        }
        finally {
            this.release(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Long[] insertAndReturnIdsArrayBox(Collection<T> entities) {
        SupportSQLiteStatement stmt = this.acquire();
        try {
            Long[] result = new Long[entities.size()];
            int index = 0;
            for (T entity : entities) {
                this.bind(stmt, entity);
                result[index] = stmt.executeInsert();
                ++index;
            }
            Long[] longArray = result;
            return longArray;
        }
        finally {
            this.release(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Long[] insertAndReturnIdsArrayBox(T[] entities) {
        SupportSQLiteStatement stmt = this.acquire();
        try {
            Long[] result = new Long[entities.length];
            int index = 0;
            for (T entity : entities) {
                this.bind(stmt, entity);
                result[index] = stmt.executeInsert();
                ++index;
            }
            Long[] longArray = result;
            return longArray;
        }
        finally {
            this.release(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<Long> insertAndReturnIdsList(T[] entities) {
        SupportSQLiteStatement stmt = this.acquire();
        try {
            ArrayList<Long> result = new ArrayList<Long>(entities.length);
            int index = 0;
            for (T entity : entities) {
                this.bind(stmt, entity);
                result.add(index, stmt.executeInsert());
                ++index;
            }
            ArrayList<Long> arrayList = result;
            return arrayList;
        }
        finally {
            this.release(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<Long> insertAndReturnIdsList(Collection<T> entities) {
        SupportSQLiteStatement stmt = this.acquire();
        try {
            ArrayList<Long> result = new ArrayList<Long>(entities.size());
            int index = 0;
            for (T entity : entities) {
                this.bind(stmt, entity);
                result.add(index, stmt.executeInsert());
                ++index;
            }
            ArrayList<Long> arrayList = result;
            return arrayList;
        }
        finally {
            this.release(stmt);
        }
    }
}

