/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import androidx.annotation.RestrictTo;
import androidx.room.RoomDatabase;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.concurrent.atomic.AtomicBoolean;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class SharedSQLiteStatement {
    private final AtomicBoolean mLock = new AtomicBoolean(false);
    private final RoomDatabase mDatabase;
    private volatile SupportSQLiteStatement mStmt;

    public SharedSQLiteStatement(RoomDatabase database) {
        this.mDatabase = database;
    }

    protected abstract String createQuery();

    protected void assertNotMainThread() {
        this.mDatabase.assertNotMainThread();
    }

    private SupportSQLiteStatement createNewStatement() {
        String query = this.createQuery();
        return this.mDatabase.compileStatement(query);
    }

    private SupportSQLiteStatement getStmt(boolean canUseCached) {
        SupportSQLiteStatement stmt;
        if (canUseCached) {
            if (this.mStmt == null) {
                this.mStmt = this.createNewStatement();
            }
            stmt = this.mStmt;
        } else {
            stmt = this.createNewStatement();
        }
        return stmt;
    }

    public SupportSQLiteStatement acquire() {
        this.assertNotMainThread();
        return this.getStmt(this.mLock.compareAndSet(false, true));
    }

    public void release(SupportSQLiteStatement statement) {
        if (statement == this.mStmt) {
            this.mLock.set(false);
        }
    }
}

