/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.jarjarred.org.stringtemplate.v4;

import androidx.room.jarjarred.org.antlr.runtime.ANTLRInputStream;
import androidx.room.jarjarred.org.antlr.runtime.Token;
import androidx.room.jarjarred.org.stringtemplate.v4.STGroup;
import androidx.room.jarjarred.org.stringtemplate.v4.compiler.CompiledST;
import androidx.room.jarjarred.org.stringtemplate.v4.compiler.STException;
import androidx.room.jarjarred.org.stringtemplate.v4.misc.ErrorType;
import androidx.room.jarjarred.org.stringtemplate.v4.misc.Misc;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class STGroupDir
extends STGroup {
    public String groupDirName;
    public URL root;

    public STGroupDir(String dirName) {
        this(dirName, '<', '>');
    }

    public STGroupDir(URL root) {
        this(root, "UTF-8", '<', '>');
    }

    public STGroupDir(String dirName, char delimiterStartChar, char delimiterStopChar) {
        super(delimiterStartChar, delimiterStopChar);
        this.groupDirName = dirName;
        File dir = new File(dirName);
        if (dir.exists() && dir.isDirectory()) {
            try {
                this.root = dir.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new STException("can't load dir " + dirName, e);
            }
            if (verbose) {
                System.out.println("STGroupDir(" + dirName + ") found at " + this.root);
            }
        } else {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            this.root = cl.getResource(dirName);
            if (this.root == null) {
                cl = this.getClass().getClassLoader();
                this.root = cl.getResource(dirName);
            }
            if (verbose) {
                System.out.println("STGroupDir(" + dirName + ") found via CLASSPATH at " + this.root);
            }
            if (this.root == null) {
                throw new IllegalArgumentException("No such directory: " + dirName);
            }
        }
        this.root = this.normalizeURL(this.root);
    }

    public STGroupDir(String dirName, String encoding) {
        this(dirName, encoding, '<', '>');
    }

    public STGroupDir(String dirName, String encoding, char delimiterStartChar, char delimiterStopChar) {
        this(dirName, delimiterStartChar, delimiterStopChar);
        this.encoding = encoding;
    }

    public STGroupDir(URL root, String encoding, char delimiterStartChar, char delimiterStopChar) {
        super(delimiterStartChar, delimiterStopChar);
        this.groupDirName = new File(root.getFile()).getName();
        this.root = root;
        this.encoding = encoding;
        this.root = this.normalizeURL(this.root);
    }

    @Override
    public void importTemplates(Token fileNameToken) {
        String msg = "import illegal in group files embedded in STGroupDirs; import " + fileNameToken.getText() + " in STGroupDir " + this.getName();
        throw new UnsupportedOperationException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CompiledST load(String name) {
        URL groupFileURL;
        if (verbose) {
            System.out.println("STGroupDir.load(" + name + ")");
        }
        String parent = Misc.getParent(name);
        String prefix = Misc.getPrefix(name);
        try {
            groupFileURL = new URI(this.root + parent + GROUP_FILE_EXTENSION).normalize().toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            this.errMgr.internalError(null, "bad URL: " + this.root + parent + GROUP_FILE_EXTENSION, e);
            return null;
        }
        InputStream is = null;
        try {
            is = groupFileURL.openStream();
        }
        catch (IOException ioe) {
            String unqualifiedName = Misc.getFileName(name);
            CompiledST compiledST = this.loadTemplateFile(prefix, unqualifiedName + TEMPLATE_FILE_EXTENSION);
            return compiledST;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ioe) {
                this.errMgr.internalError(null, "can't close template file stream " + name, ioe);
            }
        }
        this.loadGroupFile(prefix, this.root + parent + GROUP_FILE_EXTENSION);
        return this.rawGetTemplate(name);
    }

    public CompiledST loadTemplateFile(String prefix, String unqualifiedFileName) {
        ANTLRInputStream fs;
        URL f;
        if (verbose) {
            System.out.println("loadTemplateFile(" + unqualifiedFileName + ") in groupdir from " + this.root + " prefix=" + prefix);
        }
        try {
            f = new URI(this.root + prefix + unqualifiedFileName).normalize().toURL();
        }
        catch (MalformedURLException | URISyntaxException me) {
            this.errMgr.runTimeError(null, null, ErrorType.INVALID_TEMPLATE_NAME, me, (Object)(this.root + unqualifiedFileName));
            return null;
        }
        try {
            fs = new ANTLRInputStream(f.openStream(), this.encoding);
            fs.name = unqualifiedFileName;
        }
        catch (IOException ioe) {
            if (verbose) {
                System.out.println(this.root + "/" + unqualifiedFileName + " doesn't exist");
            }
            return null;
        }
        return this.loadTemplateFile(prefix, unqualifiedFileName, fs);
    }

    @Override
    public String getName() {
        return this.groupDirName;
    }

    @Override
    public String getFileName() {
        return this.root.getFile();
    }

    @Override
    public URL getRootDirURL() {
        return this.root;
    }

    public URL normalizeURL(URL url) {
        String urlS = url.toString();
        if (urlS.endsWith("/")) {
            try {
                url = new URL(urlS.substring(0, urlS.length() - 1));
            }
            catch (MalformedURLException e) {
                this.errMgr.internalError(null, "bad URL: " + urlS, e);
            }
        }
        return url;
    }
}

