/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.writer;

import androidx.room.compiler.codegen.CodeLanguage;
import androidx.room.compiler.codegen.VisibilityModifier;
import androidx.room.compiler.codegen.XClassName;
import androidx.room.compiler.codegen.XCodeBlock;
import androidx.room.compiler.codegen.XCodeBlockKt;
import androidx.room.compiler.codegen.XFunSpec;
import androidx.room.compiler.codegen.XName;
import androidx.room.compiler.codegen.XPropertySpec;
import androidx.room.compiler.codegen.XTypeName;
import androidx.room.compiler.codegen.XTypeSpec;
import androidx.room.compiler.codegen.compat.XConverters;
import androidx.room.compiler.processing.PropertySpecHelper;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XMethodElement;
import androidx.room.compiler.processing.XType;
import androidx.room.ext.CommonTypeNames;
import androidx.room.ext.KotlinCollectionMemberNames;
import androidx.room.ext.KotlinTypeNames;
import androidx.room.ext.RoomTypeNames;
import androidx.room.ext.String_extKt;
import androidx.room.solver.CodeGenScope;
import androidx.room.vo.AutoMigration;
import androidx.room.vo.DaoMethod;
import androidx.room.vo.Database;
import androidx.room.vo.DatabaseView;
import androidx.room.vo.Entity;
import androidx.room.writer.DatabaseWriter;
import androidx.room.writer.EntityDeleteComparator;
import androidx.room.writer.OpenDelegateWriter;
import androidx.room.writer.TypeWriter;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.TypeSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\b\u0010\u0016\u001a\u00020\u0014H\u0002J\b\u0010\u0017\u001a\u00020\u0014H\u0002J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u0014H\u0002J\b\u0010\u001e\u001a\u00020\u0014H\u0002J\b\u0010\u001f\u001a\u00020\u0012H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"Landroidx/room/writer/DatabaseWriter;", "Landroidx/room/writer/TypeWriter;", "database", "Landroidx/room/vo/Database;", "writerContext", "Landroidx/room/writer/TypeWriter$WriterContext;", "(Landroidx/room/vo/Database;Landroidx/room/writer/TypeWriter$WriterContext;)V", "className", "Landroidx/room/compiler/codegen/XClassName;", "getDatabase", "()Landroidx/room/vo/Database;", "packageName", "", "getPackageName", "()Ljava/lang/String;", "addDaoImpls", "", "builder", "Landroidx/room/compiler/codegen/XTypeSpec$Builder;", "createClearAllTables", "Landroidx/room/compiler/codegen/XFunSpec;", "createCreateAutoMigrationSpecsSet", "createCreateInvalidationTracker", "createCreateTypeConvertersMap", "createDaoGetter", "method", "Landroidx/room/vo/DaoMethod;", "daoProperty", "Landroidx/room/compiler/codegen/XPropertySpec;", "createGetAutoMigrations", "createOpenDelegate", "createTypeSpecBuilder", "room-compiler"})
@SourceDebugExtension(value={"SMAP\nDatabaseWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseWriter.kt\nandroidx/room/writer/DatabaseWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,552:1\n766#2:553\n857#2,2:554\n1549#2:556\n1620#2,3:557\n1855#2,2:560\n1855#2,2:562\n1#3:564\n*S KotlinDebug\n*F\n+ 1 DatabaseWriter.kt\nandroidx/room/writer/DatabaseWriter\n*L\n243#1:553\n243#1:554,2\n244#1:556\n244#1:557,3\n264#1:560,2\n354#1:562,2\n*E\n"})
public final class DatabaseWriter
extends TypeWriter {
    @NotNull
    private final Database database;
    @NotNull
    private final XClassName className;
    @NotNull
    private final String packageName;

    public DatabaseWriter(@NotNull Database database, @NotNull TypeWriter.WriterContext writerContext) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)writerContext, (String)"writerContext");
        super(writerContext);
        this.database = database;
        this.className = this.database.getImplTypeName();
        this.packageName = this.className.getPackageName();
    }

    @NotNull
    public final Database getDatabase() {
        return this.database;
    }

    @Override
    @NotNull
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    @NotNull
    public XTypeSpec.Builder createTypeSpecBuilder() {
        XTypeSpec.Builder builder2;
        XTypeSpec.Builder $this$createTypeSpecBuilder_u24lambda_u240 = builder2 = XTypeSpec.Companion.classBuilder$default((XTypeSpec.Companion)XTypeSpec.Companion, (XClassName)this.className, (boolean)false, (int)2, null);
        boolean bl = false;
        $this$createTypeSpecBuilder_u24lambda_u240.addOriginatingElement((XElement)this.database.getElement());
        $this$createTypeSpecBuilder_u24lambda_u240.superclass((XTypeName)this.database.getTypeName());
        $this$createTypeSpecBuilder_u24lambda_u240.setVisibility(this.database.getElement().isInternal() ? VisibilityModifier.INTERNAL : VisibilityModifier.PUBLIC);
        $this$createTypeSpecBuilder_u24lambda_u240.addFunction(this.createOpenDelegate());
        $this$createTypeSpecBuilder_u24lambda_u240.addFunction(this.createCreateInvalidationTracker());
        if (this.database.getOverrideClearAllTables()) {
            $this$createTypeSpecBuilder_u24lambda_u240.addFunction(this.createClearAllTables());
        }
        $this$createTypeSpecBuilder_u24lambda_u240.addFunction(this.createCreateTypeConvertersMap());
        $this$createTypeSpecBuilder_u24lambda_u240.addFunction(this.createCreateAutoMigrationSpecsSet());
        $this$createTypeSpecBuilder_u24lambda_u240.addFunction(this.createGetAutoMigrations());
        this.addDaoImpls($this$createTypeSpecBuilder_u24lambda_u240);
        return builder2;
    }

    private final XFunSpec createCreateTypeConvertersMap() {
        CodeGenScope scope = new CodeGenScope(this, false, 2, null);
        String typeConvertersVar = scope.getTmpVar("_typeConvertersMap");
        XCodeBlock body2 = XCodeBlockKt.buildCodeBlock((Function2)((Function2)new Function2<XCodeBlock.Builder, CodeLanguage, Unit>(typeConvertersVar, this){
            final /* synthetic */ String $typeConvertersVar;
            final /* synthetic */ DatabaseWriter this$0;
            {
                this.$typeConvertersVar = $typeConvertersVar;
                this.this$0 = $receiver;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(XCodeBlock.Builder $this$buildCodeBlock, CodeLanguage language) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)$this$buildCodeBlock, (String)"$this$buildCodeBlock");
                Intrinsics.checkNotNullParameter((Object)language, (String)"language");
                XTypeName classOfAnyTypeName = DatabaseWriter.access$createCreateTypeConvertersMap$classOfAnyTypeName(language);
                Object[] objectArray = new XTypeName[2];
                objectArray[0] = classOfAnyTypeName;
                Object object = new XTypeName[]{classOfAnyTypeName};
                objectArray[1] = CommonTypeNames.INSTANCE.getLIST().parametrizedBy(object);
                XTypeName typeConvertersTypeName = CommonTypeNames.INSTANCE.getMUTABLE_MAP().parametrizedBy((XTypeName[])objectArray);
                switch (createCreateTypeConvertersMap.body.WhenMappings.$EnumSwitchMapping$0[language.ordinal()]) {
                    case 1: {
                        Object[] objectArray2 = new XTypeName[2];
                        objectArray2[0] = classOfAnyTypeName;
                        XTypeName[] xTypeNameArray = new XTypeName[]{classOfAnyTypeName};
                        objectArray2[1] = CommonTypeNames.INSTANCE.getLIST().parametrizedBy(xTypeNameArray);
                        XCodeBlock.Builder.addLocalVariable$default((XCodeBlock.Builder)$this$buildCodeBlock, (String)this.$typeConvertersVar, (XTypeName)typeConvertersTypeName, (boolean)false, (XCodeBlock)XCodeBlock.Companion.ofNewInstance$default((XCodeBlock.Companion)XCodeBlock.Companion, (XTypeName)CommonTypeNames.INSTANCE.getHASH_MAP().parametrizedBy((XTypeName[])objectArray2), null, (Object[])new Object[0], (int)2, null), (int)4, null);
                        break;
                    }
                    case 2: {
                        Object[] objectArray2 = new Object[]{KotlinCollectionMemberNames.INSTANCE.getMUTABLE_MAP_OF()};
                        $this$buildCodeBlock.addLocalVal(this.$typeConvertersVar, typeConvertersTypeName, "%M()", objectArray2);
                    }
                }
                objectArray = this.this$0.getDatabase().getDaoMethods();
                object = this.$typeConvertersVar;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    DaoMethod it = (DaoMethod)element$iv;
                    boolean bl = false;
                    Object[] objectArray3 = new Object[4];
                    objectArray3[0] = object;
                    objectArray3[1] = switch (createCreateTypeConvertersMap.body.WhenMappings.$EnumSwitchMapping$0[language.ordinal()]) {
                        case 1 -> XCodeBlock.Companion.ofJavaClassLiteral(it.getDao().getTypeName());
                        case 2 -> XCodeBlock.Companion.ofKotlinClassLiteral(it.getDao().getTypeName());
                        default -> throw new NoWhenBranchMatchedException();
                    };
                    objectArray3[2] = it.getDao().getImplTypeName();
                    objectArray3[3] = "getRequiredConverters";
                    $this$buildCodeBlock.addStatement("%L.put(%L, %T.%L())", objectArray3);
                }
                objectArray = new Object[]{this.$typeConvertersVar};
                $this$buildCodeBlock.addStatement("return %L", objectArray);
            }
        }));
        return XFunSpec.Builder.Companion.applyTo(XFunSpec.Companion.builder$default((XFunSpec.Companion)XFunSpec.Companion, (XName)XName.Companion.of("getRequiredTypeConverters", "getRequiredTypeConverterClasses"), (VisibilityModifier)VisibilityModifier.PROTECTED, (boolean)false, (boolean)true, (boolean)false, (int)20, null), (Function2)new Function2<XFunSpec.Builder, CodeLanguage, Unit>(body2){
            final /* synthetic */ XCodeBlock $body;
            {
                this.$body = $body;
                super(2);
            }

            public final void invoke(XFunSpec.Builder $this$applyTo, CodeLanguage language) {
                Intrinsics.checkNotNullParameter((Object)$this$applyTo, (String)"$this$applyTo");
                Intrinsics.checkNotNullParameter((Object)language, (String)"language");
                XTypeName[] xTypeNameArray = new XTypeName[2];
                xTypeNameArray[0] = DatabaseWriter.access$createCreateTypeConvertersMap$classOfAnyTypeName(language);
                XTypeName[] xTypeNameArray2 = new XTypeName[]{DatabaseWriter.access$createCreateTypeConvertersMap$classOfAnyTypeName(language)};
                xTypeNameArray[1] = CommonTypeNames.INSTANCE.getLIST().parametrizedBy(xTypeNameArray2);
                $this$applyTo.returns(CommonTypeNames.INSTANCE.getMAP().parametrizedBy(xTypeNameArray));
                $this$applyTo.addCode(this.$body);
            }
        }).build();
    }

    private final XFunSpec createCreateAutoMigrationSpecsSet() {
        CodeGenScope scope = new CodeGenScope(this, false, 2, null);
        String autoMigrationSpecsVar = scope.getTmpVar("_autoMigrationSpecsSet");
        XCodeBlock body2 = XCodeBlockKt.buildCodeBlock((Function2)((Function2)new Function2<XCodeBlock.Builder, CodeLanguage, Unit>(autoMigrationSpecsVar, this){
            final /* synthetic */ String $autoMigrationSpecsVar;
            final /* synthetic */ DatabaseWriter this$0;
            {
                this.$autoMigrationSpecsVar = $autoMigrationSpecsVar;
                this.this$0 = $receiver;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(XCodeBlock.Builder $this$buildCodeBlock, CodeLanguage language) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Object[] objectArray;
                Intrinsics.checkNotNullParameter((Object)$this$buildCodeBlock, (String)"$this$buildCodeBlock");
                Intrinsics.checkNotNullParameter((Object)language, (String)"language");
                XTypeName classOfAutoMigrationSpecTypeName = DatabaseWriter.access$createCreateAutoMigrationSpecsSet$classOfAutoMigrationSpecTypeName(language);
                Object[] objectArray2 = new XTypeName[]{classOfAutoMigrationSpecTypeName};
                XTypeName autoMigrationSpecsTypeName = CommonTypeNames.INSTANCE.getMUTABLE_SET().parametrizedBy((XTypeName[])objectArray2);
                switch (createCreateAutoMigrationSpecsSet.body.WhenMappings.$EnumSwitchMapping$0[language.ordinal()]) {
                    case 1: {
                        objectArray = new XTypeName[]{classOfAutoMigrationSpecTypeName};
                        XCodeBlock.Builder.addLocalVariable$default((XCodeBlock.Builder)$this$buildCodeBlock, (String)this.$autoMigrationSpecsVar, (XTypeName)autoMigrationSpecsTypeName, (boolean)false, (XCodeBlock)XCodeBlock.Companion.ofNewInstance$default((XCodeBlock.Companion)XCodeBlock.Companion, (XTypeName)CommonTypeNames.INSTANCE.getHASH_SET().parametrizedBy((XTypeName[])objectArray), null, (Object[])new Object[0], (int)2, null), (int)4, null);
                        break;
                    }
                    case 2: {
                        objectArray = new Object[]{KotlinCollectionMemberNames.INSTANCE.getMUTABLE_SET_OF()};
                        $this$buildCodeBlock.addLocalVal(this.$autoMigrationSpecsVar, autoMigrationSpecsTypeName, "%M()", objectArray);
                    }
                }
                objectArray2 = this.this$0.getDatabase().getAutoMigrations();
                boolean $i$f$filter = false;
                objectArray = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    AutoMigration it = (AutoMigration)element$iv$iv;
                    boolean bl = false;
                    if (!it.isSpecProvided()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                String string = this.$autoMigrationSpecsVar;
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void autoMigration;
                    AutoMigration bl = (AutoMigration)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    if (autoMigration.getSpecClassName() == null) {
                        String string2 = "Required value was null.";
                        throw new IllegalStateException(string2.toString());
                    }
                    Object[] objectArray3 = new Object[2];
                    objectArray3[0] = string;
                    objectArray3[1] = switch (createCreateAutoMigrationSpecsSet.body.WhenMappings.$EnumSwitchMapping$0[language.ordinal()]) {
                        case 1 -> {
                            XClassName specClassName;
                            yield XCodeBlock.Companion.ofJavaClassLiteral(specClassName);
                        }
                        case 2 -> {
                            XClassName specClassName;
                            yield XCodeBlock.Companion.ofKotlinClassLiteral(specClassName);
                        }
                        default -> throw new NoWhenBranchMatchedException();
                    };
                    collection.add($this$buildCodeBlock.addStatement("%L.add(%L)", objectArray3));
                }
                List cfr_ignored_0 = (List)destination$iv$iv2;
                objectArray2 = new Object[]{this.$autoMigrationSpecsVar};
                $this$buildCodeBlock.addStatement("return %L", objectArray2);
            }
        }));
        return XFunSpec.Builder.Companion.applyTo(XFunSpec.Companion.builder$default((XFunSpec.Companion)XFunSpec.Companion, (XName)XName.Companion.of("getRequiredAutoMigrationSpecs", "getRequiredAutoMigrationSpecClasses"), (VisibilityModifier)VisibilityModifier.PUBLIC, (boolean)false, (boolean)true, (boolean)false, (int)20, null), (Function2)new Function2<XFunSpec.Builder, CodeLanguage, Unit>(body2){
            final /* synthetic */ XCodeBlock $body;
            {
                this.$body = $body;
                super(2);
            }

            public final void invoke(XFunSpec.Builder $this$applyTo, CodeLanguage language) {
                Intrinsics.checkNotNullParameter((Object)$this$applyTo, (String)"$this$applyTo");
                Intrinsics.checkNotNullParameter((Object)language, (String)"language");
                XTypeName[] xTypeNameArray = new XTypeName[]{DatabaseWriter.access$createCreateAutoMigrationSpecsSet$classOfAutoMigrationSpecTypeName(language)};
                $this$applyTo.returns(CommonTypeNames.INSTANCE.getSET().parametrizedBy(xTypeNameArray));
                $this$applyTo.addCode(this.$body);
            }
        }).build();
    }

    private final XFunSpec createClearAllTables() {
        XFunSpec.Builder builder2;
        XFunSpec.Builder $this$createClearAllTables_u24lambda_u241 = builder2 = XFunSpec.Companion.builder$default((XFunSpec.Companion)XFunSpec.Companion, (String)"clearAllTables", (VisibilityModifier)VisibilityModifier.PUBLIC, (boolean)false, (boolean)true, (boolean)false, (int)20, null);
        boolean bl = false;
        String tableNames2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)this.database.getEntities(), (Comparator)new EntityDeleteComparator()), (CharSequence)", ", null, null, (int)0, null, (Function1)createClearAllTables.1.tableNames.1.INSTANCE, (int)30, null);
        Object[] objectArray = new Object[]{this.database.getEnableForeignKeys(), tableNames2};
        $this$createClearAllTables_u24lambda_u241.addStatement("super.performClear(%L, %L)", objectArray);
        return builder2.build();
    }

    /*
     * WARNING - void declaration
     */
    private final XFunSpec createCreateInvalidationTracker() {
        Object element$iv22;
        XTypeName[] $this$mapTo$iv$iv;
        void $this$map$iv;
        Entity it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        XCodeBlock.Builder builder2;
        CodeGenScope scope = new CodeGenScope(this, false, 2, null);
        XCodeBlock.Builder $this$createCreateInvalidationTracker_u24lambda_u245 = builder2 = XCodeBlock.Companion.builder();
        boolean bl = false;
        String shadowTablesVar = "_shadowTablesMap";
        XClassName[] xClassNameArray = new XClassName[]{CommonTypeNames.INSTANCE.getSTRING(), CommonTypeNames.INSTANCE.getSTRING()};
        XClassName[] shadowTablesTypeParam = xClassNameArray;
        XTypeName shadowTablesTypeName = CommonTypeNames.INSTANCE.getMUTABLE_MAP().parametrizedBy((XTypeName[])Arrays.copyOf(shadowTablesTypeParam, shadowTablesTypeParam.length));
        Iterable iterable = this.database.getEntities();
        boolean $i$f$filter = false;
        void var11_11 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object objectArray2 : $this$filterTo$iv$iv) {
            it = (Entity)objectArray2;
            boolean bl2 = false;
            if (!(it.getShadowTableName() != null)) continue;
            destination$iv$iv.add(objectArray2);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object t : $this$mapTo$iv$iv) {
            it = (Entity)t;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(TuplesKt.to((Object)it.getTableName(), (Object)it.getShadowTableName()));
        }
        List shadowTableNames = (List)destination$iv$iv;
        XCodeBlock.Builder.addLocalVariable$default((XCodeBlock.Builder)$this$createCreateInvalidationTracker_u24lambda_u245, (String)shadowTablesVar, (XTypeName)shadowTablesTypeName, (boolean)false, (XCodeBlock)XCodeBlockKt.buildCodeBlock((Function2)((Function2)new Function2<XCodeBlock.Builder, CodeLanguage, Unit>(shadowTablesTypeParam, (List<Pair<String, String>>)shadowTableNames){
            final /* synthetic */ XClassName[] $shadowTablesTypeParam;
            final /* synthetic */ List<Pair<String, String>> $shadowTableNames;
            {
                this.$shadowTablesTypeParam = $shadowTablesTypeParam;
                this.$shadowTableNames = $shadowTableNames;
                super(2);
            }

            public final void invoke(XCodeBlock.Builder $this$buildCodeBlock, CodeLanguage language) {
                Intrinsics.checkNotNullParameter((Object)$this$buildCodeBlock, (String)"$this$buildCodeBlock");
                Intrinsics.checkNotNullParameter((Object)language, (String)"language");
                switch (createCreateInvalidationTracker.body.1.WhenMappings.$EnumSwitchMapping$0[language.ordinal()]) {
                    case 1: {
                        Object[] objectArray = new Object[]{CommonTypeNames.INSTANCE.getHASH_MAP().parametrizedBy((XTypeName[])Arrays.copyOf(this.$shadowTablesTypeParam, this.$shadowTablesTypeParam.length)), this.$shadowTableNames.size()};
                        $this$buildCodeBlock.add("new %T(%L)", objectArray);
                        break;
                    }
                    case 2: {
                        Object[] objectArray = new Object[]{KotlinCollectionMemberNames.INSTANCE.getMUTABLE_MAP_OF()};
                        $this$buildCodeBlock.add("%M()", objectArray);
                    }
                }
            }
        })), (int)4, null);
        Iterable $this$forEach$iv = shadowTableNames;
        boolean $i$f$forEach = false;
        for (Object element$iv22 : $this$forEach$iv) {
            Pair $i$f$mapTo22 = (Pair)element$iv22;
            boolean bl4 = false;
            String string = (String)$i$f$mapTo22.component1();
            String shadowTableName = (String)$i$f$mapTo22.component2();
            Object[] bl3 = new Object[]{shadowTablesVar, string, shadowTableName};
            $this$createCreateInvalidationTracker_u24lambda_u245.addStatement("%L.put(%S, %S)", bl3);
        }
        String viewTablesVar = scope.getTmpVar("_viewTables");
        $this$mapTo$iv$iv = new XTypeName[2];
        $this$mapTo$iv$iv[0] = CommonTypeNames.INSTANCE.getSTRING();
        element$iv22 = new XTypeName[]{CommonTypeNames.INSTANCE.getSTRING()};
        $this$mapTo$iv$iv[1] = CommonTypeNames.INSTANCE.getSET().parametrizedBy(element$iv22);
        XTypeName[] viewTableTypeParam = $this$mapTo$iv$iv;
        XTypeName viewTablesTypeName = CommonTypeNames.INSTANCE.getMUTABLE_MAP().parametrizedBy(Arrays.copyOf(viewTableTypeParam, viewTableTypeParam.length));
        XCodeBlock.Builder.addLocalVariable$default((XCodeBlock.Builder)$this$createCreateInvalidationTracker_u24lambda_u245, (String)viewTablesVar, (XTypeName)viewTablesTypeName, (boolean)false, (XCodeBlock)XCodeBlockKt.buildCodeBlock((Function2)((Function2)new Function2<XCodeBlock.Builder, CodeLanguage, Unit>(viewTableTypeParam, this){
            final /* synthetic */ XTypeName[] $viewTableTypeParam;
            final /* synthetic */ DatabaseWriter this$0;
            {
                this.$viewTableTypeParam = $viewTableTypeParam;
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(XCodeBlock.Builder $this$buildCodeBlock, CodeLanguage language) {
                Intrinsics.checkNotNullParameter((Object)$this$buildCodeBlock, (String)"$this$buildCodeBlock");
                Intrinsics.checkNotNullParameter((Object)language, (String)"language");
                switch (createCreateInvalidationTracker.body.1.WhenMappings.$EnumSwitchMapping$0[language.ordinal()]) {
                    case 1: {
                        Object[] objectArray = new Object[]{CommonTypeNames.INSTANCE.getHASH_MAP().parametrizedBy(Arrays.copyOf(this.$viewTableTypeParam, this.$viewTableTypeParam.length)), this.this$0.getDatabase().getViews().size()};
                        $this$buildCodeBlock.add("new %T(%L)", objectArray);
                        break;
                    }
                    case 2: {
                        Object[] objectArray = new Object[]{KotlinCollectionMemberNames.INSTANCE.getMUTABLE_MAP_OF()};
                        $this$buildCodeBlock.add("%M()", objectArray);
                    }
                }
            }
        })), (int)4, null);
        XTypeName[] $i$f$mapTo22 = new XTypeName[]{CommonTypeNames.INSTANCE.getSTRING()};
        XTypeName tablesType = CommonTypeNames.INSTANCE.getMUTABLE_SET().parametrizedBy($i$f$mapTo22);
        for (DatabaseView view : this.database.getViews()) {
            String string = scope.getTmpVar("_tables");
            XCodeBlock.Builder.addLocalVariable$default((XCodeBlock.Builder)$this$createCreateInvalidationTracker_u24lambda_u245, (String)string, (XTypeName)tablesType, (boolean)false, (XCodeBlock)XCodeBlockKt.buildCodeBlock((Function2)((Function2)new Function2<XCodeBlock.Builder, CodeLanguage, Unit>(view){
                final /* synthetic */ DatabaseView $view;
                {
                    this.$view = $view;
                    super(2);
                }

                public final void invoke(XCodeBlock.Builder $this$buildCodeBlock, CodeLanguage language) {
                    Intrinsics.checkNotNullParameter((Object)$this$buildCodeBlock, (String)"$this$buildCodeBlock");
                    Intrinsics.checkNotNullParameter((Object)language, (String)"language");
                    switch (createCreateInvalidationTracker.body.1.WhenMappings.$EnumSwitchMapping$0[language.ordinal()]) {
                        case 1: {
                            Object[] objectArray = new Object[2];
                            XTypeName[] xTypeNameArray = new XTypeName[]{CommonTypeNames.INSTANCE.getSTRING()};
                            objectArray[0] = CommonTypeNames.INSTANCE.getHASH_SET().parametrizedBy(xTypeNameArray);
                            objectArray[1] = this.$view.getTables().size();
                            $this$buildCodeBlock.add("new %T(%L)", objectArray);
                            break;
                        }
                        case 2: {
                            Object[] objectArray = new Object[]{KotlinCollectionMemberNames.INSTANCE.getMUTABLE_SET_OF()};
                            $this$buildCodeBlock.add("%M()", objectArray);
                        }
                    }
                }
            })), (int)4, null);
            for (String table : view.getTables()) {
                Object[] objectArray = new Object[]{string, table};
                $this$createCreateInvalidationTracker_u24lambda_u245.addStatement("%L.add(%S)", objectArray);
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = viewTablesVar;
            String string2 = view.getViewName();
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            Intrinsics.checkNotNullExpressionValue((Object)string2.toLowerCase(locale), (String)"toLowerCase(...)");
            objectArray[2] = string;
            $this$createCreateInvalidationTracker_u24lambda_u245.addStatement("%L.put(%S, %L)", objectArray);
        }
        String tableNames2 = CollectionsKt.joinToString$default((Iterable)this.database.getEntities(), (CharSequence)", ", null, null, (int)0, null, (Function1)createCreateInvalidationTracker.body.1.tableNames.1.INSTANCE, (int)30, null);
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = new Object[]{shadowTablesVar, viewTablesVar, tableNames2};
        objectArray[0] = XCodeBlock.Companion.ofNewInstance((XTypeName)RoomTypeNames.INSTANCE.getINVALIDATION_TRACKER(), "this, %L, %L, %L", objectArray2);
        $this$createCreateInvalidationTracker_u24lambda_u245.addStatement("return %L", objectArray);
        XCodeBlock body2 = builder2.build();
        XCodeBlock.Builder $this$createCreateInvalidationTracker_u24lambda_u246 = builder2 = XFunSpec.Companion.builder$default((XFunSpec.Companion)XFunSpec.Companion, (String)"createInvalidationTracker", (VisibilityModifier)VisibilityModifier.PROTECTED, (boolean)false, (boolean)true, (boolean)false, (int)20, null);
        boolean bl5 = false;
        $this$createCreateInvalidationTracker_u24lambda_u246.returns((XTypeName)RoomTypeNames.INSTANCE.getINVALIDATION_TRACKER());
        $this$createCreateInvalidationTracker_u24lambda_u246.addCode(body2);
        return builder2.build();
    }

    private final void addDaoImpls(XTypeSpec.Builder builder2) {
        CodeGenScope scope = new CodeGenScope(this, false, 2, null);
        Iterable $this$forEach$iv = this.database.getDaoMethods();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DaoMethod method = (DaoMethod)element$iv;
            boolean bl = false;
            String string = (String)CollectionsKt.first((List)method.getDao().getTypeName().getSimpleNames());
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String name = String_extKt.stripNonJava(String_extKt.decapitalize(string, locale));
            String string2 = scope.getTmpVar("_" + name);
            XPropertySpec privateDaoProperty2 = XConverters.applyToJavaPoet((XPropertySpec.Builder)XPropertySpec.Builder.Companion.applyTo(XPropertySpec.Companion.builder$default((XPropertySpec.Companion)XPropertySpec.Companion, (String)string2, (XTypeName)(switch (WhenMappings.$EnumSwitchMapping$0[scope.getLanguage().ordinal()]) {
                case 2 -> {
                    XTypeName[] var10_10 = new XTypeName[]{method.getDao().getTypeName()};
                    yield KotlinTypeNames.INSTANCE.getLAZY().parametrizedBy(var10_10);
                }
                case 1 -> (XTypeName)method.getDao().getTypeName();
                default -> throw new NoWhenBranchMatchedException();
            }), (VisibilityModifier)VisibilityModifier.PRIVATE, (scope.getLanguage() == CodeLanguage.JAVA ? 1 : 0) != 0, (boolean)false, (int)16, null), (Function2)new Function2<XPropertySpec.Builder, CodeLanguage, Unit>(method){
                final /* synthetic */ DaoMethod $method;
                {
                    this.$method = $method;
                    super(2);
                }

                public final void invoke(XPropertySpec.Builder $this$applyTo, CodeLanguage language) {
                    Intrinsics.checkNotNullParameter((Object)$this$applyTo, (String)"$this$applyTo");
                    Intrinsics.checkNotNullParameter((Object)language, (String)"language");
                    if (language == CodeLanguage.KOTLIN) {
                        XCodeBlock.Builder builder2 = XCodeBlock.Companion.builder();
                        DaoMethod daoMethod = this.$method;
                        XCodeBlock.Builder $this$invoke_u24lambda_u240 = builder2;
                        boolean bl = false;
                        $this$invoke_u24lambda_u240.beginControlFlow("lazy", new Object[0]);
                        Object[] objectArray = new Object[]{XCodeBlock.Companion.ofNewInstance((XTypeName)daoMethod.getDao().getImplTypeName(), "this", new Object[0])};
                        $this$invoke_u24lambda_u240.addStatement("%L", objectArray);
                        $this$invoke_u24lambda_u240.endControlFlow();
                        XCodeBlock lazyInit = builder2.build();
                        $this$applyTo.initializer(lazyInit);
                    }
                }
            }), (Function1)addDaoImpls.1.privateDaoProperty.2.INSTANCE).build();
            builder2.addProperty(privateDaoProperty2);
            XTypeSpec.Builder.Companion.applyTo(builder2, (Function2)new Function2<XTypeSpec.Builder, CodeLanguage, Unit>(method, this, privateDaoProperty2){
                final /* synthetic */ DaoMethod $method;
                final /* synthetic */ DatabaseWriter this$0;
                final /* synthetic */ XPropertySpec $privateDaoProperty;
                {
                    this.$method = $method;
                    this.this$0 = $receiver;
                    this.$privateDaoProperty = $privateDaoProperty;
                    super(2);
                }

                public final void invoke(XTypeSpec.Builder $this$applyTo, CodeLanguage language) {
                    Intrinsics.checkNotNullParameter((Object)$this$applyTo, (String)"$this$applyTo");
                    Intrinsics.checkNotNullParameter((Object)language, (String)"language");
                    if (language == CodeLanguage.KOTLIN && this.$method.isProperty()) {
                        XConverters.applyToKotlinPoet((XTypeSpec.Builder)$this$applyTo, (Function1)((Function1)new Function1<TypeSpec.Builder, Unit>(this.$method, this.this$0, this.$privateDaoProperty){
                            final /* synthetic */ DaoMethod $method;
                            final /* synthetic */ DatabaseWriter this$0;
                            final /* synthetic */ XPropertySpec $privateDaoProperty;
                            {
                                this.$method = $method;
                                this.this$0 = $receiver;
                                this.$privateDaoProperty = $privateDaoProperty;
                                super(1);
                            }

                            public final void invoke(TypeSpec.Builder $this$applyToKotlinPoet) {
                                Intrinsics.checkNotNullParameter((Object)$this$applyToKotlinPoet, (String)"$this$applyToKotlinPoet");
                                Object[] objectArray = new Object[]{this.$privateDaoProperty.getName()};
                                $this$applyToKotlinPoet.addProperty(PropertySpecHelper.INSTANCE.overriding(this.$method.getElement(), this.this$0.getDatabase().getType()).getter(FunSpec.Companion.getterBuilder().addCode("return %L.value", objectArray).build()).build());
                            }
                        }));
                    } else {
                        $this$applyTo.addFunction(DatabaseWriter.access$createDaoGetter(this.this$0, this.$method, this.$privateDaoProperty));
                    }
                }
            });
        }
    }

    private final XFunSpec createDaoGetter(DaoMethod method, XPropertySpec daoProperty) {
        XFunSpec.Builder builder2;
        XCodeBlock.Builder body2 = XCodeBlock.Builder.Companion.applyTo(XCodeBlock.Companion.builder(), (Function2)new Function2<XCodeBlock.Builder, CodeLanguage, Unit>(daoProperty, method){
            final /* synthetic */ XPropertySpec $daoProperty;
            final /* synthetic */ DaoMethod $method;
            {
                this.$daoProperty = $daoProperty;
                this.$method = $method;
                super(2);
            }

            public final void invoke(XCodeBlock.Builder $this$applyTo, CodeLanguage language) {
                Intrinsics.checkNotNullParameter((Object)$this$applyTo, (String)"$this$applyTo");
                Intrinsics.checkNotNullParameter((Object)language, (String)"language");
                switch (createDaoGetter.body.WhenMappings.$EnumSwitchMapping$0[language.ordinal()]) {
                    case 1: {
                        XCodeBlock.Builder builder2;
                        Object[] objectArray = new Object[]{this.$daoProperty};
                        objectArray = $this$applyTo.beginControlFlow("if (%N != null)", objectArray);
                        XPropertySpec xPropertySpec = this.$daoProperty;
                        Object[] $this$invoke_u24lambda_u240 = objectArray;
                        boolean bl = false;
                        Object[] objectArray2 = new Object[]{xPropertySpec};
                        $this$invoke_u24lambda_u240.addStatement("return %N", objectArray2);
                        objectArray = $this$applyTo.nextControlFlow("else", new Object[0]);
                        xPropertySpec = this.$daoProperty;
                        DaoMethod daoMethod = this.$method;
                        Object[] $this$invoke_u24lambda_u243 = objectArray;
                        boolean bl2 = false;
                        XCodeBlock.Builder $this$invoke_u24lambda_u243_u24lambda_u242 = builder2 = $this$invoke_u24lambda_u243.beginControlFlow("synchronized(this)", new Object[0]);
                        boolean bl3 = false;
                        Object[] objectArray3 = new Object[]{xPropertySpec};
                        Object[] $this$invoke_u24lambda_u243_u24lambda_u242_u24lambda_u241 = objectArray3 = $this$invoke_u24lambda_u243_u24lambda_u242.beginControlFlow("if(%N == null)", objectArray3);
                        boolean bl4 = false;
                        Object[] objectArray4 = new Object[]{xPropertySpec, XCodeBlock.Companion.ofNewInstance((XTypeName)daoMethod.getDao().getImplTypeName(), "this", new Object[0])};
                        $this$invoke_u24lambda_u243_u24lambda_u242_u24lambda_u241.addStatement("%N = %L", objectArray4);
                        $this$invoke_u24lambda_u243_u24lambda_u242.endControlFlow();
                        objectArray3 = new Object[]{xPropertySpec};
                        $this$invoke_u24lambda_u243_u24lambda_u242.addStatement("return %N", objectArray3);
                        $this$invoke_u24lambda_u243.endControlFlow();
                        $this$applyTo.endControlFlow();
                        break;
                    }
                    case 2: {
                        Object[] objectArray = new Object[]{this.$daoProperty};
                        $this$applyTo.addStatement("return %N.value", objectArray);
                    }
                }
            }
        });
        XFunSpec.Builder $this$createDaoGetter_u24lambda_u248 = builder2 = XFunSpec.Companion.overridingBuilder$default((XFunSpec.Companion)XFunSpec.Companion, (XMethodElement)method.getElement(), (XType)this.database.getElement().getType(), (boolean)false, (int)4, null);
        boolean bl = false;
        $this$createDaoGetter_u24lambda_u248.addCode(body2.build());
        return builder2.build();
    }

    private final XFunSpec createOpenDelegate() {
        XCodeBlock.Builder builder2;
        CodeGenScope scope = new CodeGenScope(this, false, 2, null);
        XCodeBlock.Builder $this$createOpenDelegate_u24lambda_u249 = builder2 = XCodeBlock.Companion.builder();
        boolean bl = false;
        String openDelegateVar = scope.getTmpVar("_openDelegate");
        CodeGenScope openDelegateCode = scope.fork();
        new OpenDelegateWriter(this.database).write(openDelegateVar, openDelegateCode);
        $this$createOpenDelegate_u24lambda_u249.add(openDelegateCode.generate());
        Object[] objectArray = new Object[]{openDelegateVar};
        $this$createOpenDelegate_u24lambda_u249.addStatement("return %L", objectArray);
        XCodeBlock body2 = builder2.build();
        XCodeBlock.Builder $this$createOpenDelegate_u24lambda_u2410 = builder2 = XFunSpec.Companion.builder$default((XFunSpec.Companion)XFunSpec.Companion, (String)"createOpenDelegate", (VisibilityModifier)VisibilityModifier.PROTECTED, (boolean)false, (boolean)true, (boolean)false, (int)20, null);
        boolean bl2 = false;
        $this$createOpenDelegate_u24lambda_u2410.returns((XTypeName)RoomTypeNames.INSTANCE.getROOM_OPEN_DELEGATE());
        $this$createOpenDelegate_u24lambda_u2410.addCode(body2);
        return builder2.build();
    }

    private final XFunSpec createGetAutoMigrations() {
        CodeGenScope scope = new CodeGenScope(this, false, 2, null);
        String specsMapParamName = "autoMigrationSpecs";
        String listVar = scope.getTmpVar("_autoMigrations");
        XCodeBlock body2 = XCodeBlockKt.buildCodeBlock((Function2)((Function2)new Function2<XCodeBlock.Builder, CodeLanguage, Unit>(listVar, this, specsMapParamName){
            final /* synthetic */ String $listVar;
            final /* synthetic */ DatabaseWriter this$0;
            final /* synthetic */ String $specsMapParamName;
            {
                this.$listVar = $listVar;
                this.this$0 = $receiver;
                this.$specsMapParamName = $specsMapParamName;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(XCodeBlock.Builder $this$buildCodeBlock, CodeLanguage language) {
                void $this$forEach$iv;
                Object[] objectArray;
                Intrinsics.checkNotNullParameter((Object)$this$buildCodeBlock, (String)"$this$buildCodeBlock");
                Intrinsics.checkNotNullParameter((Object)language, (String)"language");
                switch (createGetAutoMigrations.body.WhenMappings.$EnumSwitchMapping$0[language.ordinal()]) {
                    case 1: {
                        objectArray = new XTypeName[]{RoomTypeNames.INSTANCE.getMIGRATION()};
                        XTypeName xTypeName = CommonTypeNames.INSTANCE.getMUTABLE_LIST().parametrizedBy((XTypeName[])objectArray);
                        objectArray = new XTypeName[]{RoomTypeNames.INSTANCE.getMIGRATION()};
                        XCodeBlock.Builder.addLocalVariable$default((XCodeBlock.Builder)$this$buildCodeBlock, (String)this.$listVar, (XTypeName)xTypeName, (boolean)false, (XCodeBlock)XCodeBlock.Companion.ofNewInstance$default((XCodeBlock.Companion)XCodeBlock.Companion, (XTypeName)CommonTypeNames.INSTANCE.getARRAY_LIST().parametrizedBy((XTypeName[])objectArray), null, (Object[])new Object[0], (int)2, null), (int)4, null);
                        break;
                    }
                    case 2: {
                        objectArray = new XTypeName[]{RoomTypeNames.INSTANCE.getMIGRATION()};
                        XTypeName xTypeName = CommonTypeNames.INSTANCE.getMUTABLE_LIST().parametrizedBy((XTypeName[])objectArray);
                        objectArray = new Object[]{KotlinCollectionMemberNames.INSTANCE.getMUTABLE_LIST_OF()};
                        $this$buildCodeBlock.addLocalVal(this.$listVar, xTypeName, "%M()", objectArray);
                    }
                }
                Object[] objectArray2 = (Object[])this.this$0.getDatabase().getAutoMigrations();
                DatabaseWriter databaseWriter = this.this$0;
                objectArray = this.$specsMapParamName;
                String string = this.$listVar;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    XCodeBlock xCodeBlock;
                    AutoMigration autoMigrationResult = (AutoMigration)element$iv;
                    boolean bl = false;
                    XClassName implTypeName2 = autoMigrationResult.getImplTypeName(databaseWriter.getDatabase().getTypeName());
                    if (autoMigrationResult.isSpecProvided()) {
                        XClassName specClassName;
                        if (autoMigrationResult.getSpecClassName() == null) {
                            String string2 = "Required value was null.";
                            throw new IllegalStateException(string2.toString());
                        }
                        Object[] objectArray3 = new Object[]{objectArray, XName.Companion.of("get", "getValue"), XCodeBlockKt.buildCodeBlock((Function2)((Function2)new Function2<XCodeBlock.Builder, CodeLanguage, Unit>(specClassName){
                            final /* synthetic */ XClassName $specClassName;
                            {
                                this.$specClassName = $specClassName;
                                super(2);
                            }

                            public final void invoke(XCodeBlock.Builder $this$buildCodeBlock, CodeLanguage language) {
                                Intrinsics.checkNotNullParameter((Object)$this$buildCodeBlock, (String)"$this$buildCodeBlock");
                                Intrinsics.checkNotNullParameter((Object)language, (String)"language");
                                switch (createGetAutoMigrations.body.1.newInstanceCode.WhenMappings.$EnumSwitchMapping$0[language.ordinal()]) {
                                    case 1: {
                                        $this$buildCodeBlock.add(XCodeBlock.Companion.ofJavaClassLiteral(this.$specClassName));
                                        break;
                                    }
                                    case 2: {
                                        $this$buildCodeBlock.add(XCodeBlock.Companion.ofKotlinClassLiteral(this.$specClassName));
                                    }
                                }
                            }
                        }))};
                        xCodeBlock = XCodeBlock.Companion.ofNewInstance((XTypeName)implTypeName2, "%L.%L(%L)", objectArray3);
                    } else {
                        xCodeBlock = XCodeBlock.Companion.ofNewInstance$default((XCodeBlock.Companion)XCodeBlock.Companion, (XTypeName)((XTypeName)implTypeName2), null, (Object[])new Object[0], (int)2, null);
                    }
                    XCodeBlock newInstanceCode2 = xCodeBlock;
                    Object[] objectArray4 = new Object[]{string, newInstanceCode2};
                    $this$buildCodeBlock.addStatement("%L.add(%L)", objectArray4);
                }
                objectArray2 = new Object[]{this.$listVar};
                $this$buildCodeBlock.addStatement("return %L", objectArray2);
            }
        }));
        return XFunSpec.Builder.Companion.applyTo(XFunSpec.Companion.builder$default((XFunSpec.Companion)XFunSpec.Companion, (XName)XName.Companion.of("getAutoMigrations", "createAutoMigrations"), (VisibilityModifier)VisibilityModifier.PUBLIC, (boolean)false, (boolean)true, (boolean)false, (int)20, null), (Function2)new Function2<XFunSpec.Builder, CodeLanguage, Unit>(specsMapParamName, body2){
            final /* synthetic */ String $specsMapParamName;
            final /* synthetic */ XCodeBlock $body;
            {
                this.$specsMapParamName = $specsMapParamName;
                this.$body = $body;
                super(2);
            }

            public final void invoke(XFunSpec.Builder $this$applyTo, CodeLanguage language) {
                Intrinsics.checkNotNullParameter((Object)$this$applyTo, (String)"$this$applyTo");
                Intrinsics.checkNotNullParameter((Object)language, (String)"language");
                XClassName xClassName = switch (createGetAutoMigrations.WhenMappings.$EnumSwitchMapping$0[language.ordinal()]) {
                    case 1 -> CommonTypeNames.INSTANCE.getJAVA_CLASS();
                    case 2 -> CommonTypeNames.INSTANCE.getKOTLIN_CLASS();
                    default -> throw new NoWhenBranchMatchedException();
                };
                XTypeName[] xTypeNameArray = new XTypeName[]{XTypeName.Companion.getProducerExtendsName((XTypeName)RoomTypeNames.INSTANCE.getAUTO_MIGRATION_SPEC())};
                XTypeName classOfAutoMigrationSpecTypeName = xClassName.parametrizedBy(xTypeNameArray);
                xTypeNameArray = new XTypeName[]{RoomTypeNames.INSTANCE.getMIGRATION()};
                $this$applyTo.returns(CommonTypeNames.INSTANCE.getLIST().parametrizedBy(xTypeNameArray));
                xTypeNameArray = new XTypeName[]{classOfAutoMigrationSpecTypeName, RoomTypeNames.INSTANCE.getAUTO_MIGRATION_SPEC()};
                $this$applyTo.addParameter(this.$specsMapParamName, CommonTypeNames.INSTANCE.getMAP().parametrizedBy(xTypeNameArray));
                $this$applyTo.addCode(this.$body);
            }
        }).build();
    }

    private static final XTypeName createCreateTypeConvertersMap$classOfAnyTypeName(CodeLanguage language) {
        XClassName xClassName = switch (WhenMappings.$EnumSwitchMapping$0[language.ordinal()]) {
            case 1 -> CommonTypeNames.INSTANCE.getJAVA_CLASS();
            case 2 -> CommonTypeNames.INSTANCE.getKOTLIN_CLASS();
            default -> throw new NoWhenBranchMatchedException();
        };
        XTypeName[] xTypeNameArray = new XTypeName[]{XTypeName.ANY_WILDCARD};
        return xClassName.parametrizedBy(xTypeNameArray);
    }

    private static final XTypeName createCreateAutoMigrationSpecsSet$classOfAutoMigrationSpecTypeName(CodeLanguage language) {
        XClassName xClassName = switch (WhenMappings.$EnumSwitchMapping$0[language.ordinal()]) {
            case 1 -> CommonTypeNames.INSTANCE.getJAVA_CLASS();
            case 2 -> CommonTypeNames.INSTANCE.getKOTLIN_CLASS();
            default -> throw new NoWhenBranchMatchedException();
        };
        XTypeName[] xTypeNameArray = new XTypeName[]{XTypeName.Companion.getProducerExtendsName((XTypeName)RoomTypeNames.INSTANCE.getAUTO_MIGRATION_SPEC())};
        return xClassName.parametrizedBy(xTypeNameArray);
    }

    public static final /* synthetic */ XTypeName access$createCreateTypeConvertersMap$classOfAnyTypeName(CodeLanguage language) {
        return DatabaseWriter.createCreateTypeConvertersMap$classOfAnyTypeName(language);
    }

    public static final /* synthetic */ XTypeName access$createCreateAutoMigrationSpecsSet$classOfAutoMigrationSpecTypeName(CodeLanguage language) {
        return DatabaseWriter.createCreateAutoMigrationSpecsSet$classOfAutoMigrationSpecTypeName(language);
    }

    public static final /* synthetic */ XFunSpec access$createDaoGetter(DatabaseWriter $this, DaoMethod method, XPropertySpec daoProperty) {
        return $this.createDaoGetter(method, daoProperty);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CodeLanguage.values().length];
            try {
                nArray[CodeLanguage.JAVA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodeLanguage.KOTLIN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

