/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.verifier;

import androidx.room.compiler.processing.XElement;
import androidx.room.processor.Context;
import androidx.room.verifier.DatabaseVerificationErrors;
import androidx.room.verifier.Jdbc_extKt;
import androidx.room.verifier.QueryResultInfo;
import androidx.room.vo.DatabaseView;
import androidx.room.vo.Entity;
import androidx.room.vo.EntityOrView;
import androidx.room.vo.FtsEntity;
import androidx.room.vo.FtsOptions;
import androidx.room.vo.Index;
import androidx.room.vo.Warning;
import java.io.File;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.sqlite.JDBC;
import org.sqlite.SQLiteConnection;
import org.sqlite.SQLiteJDBCLoader;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB3\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0004\u001a\u00020\u0005J\u0018\u0010\u001a\u001a\n \u001b*\u0004\u0018\u00010\u00170\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Landroidx/room/verifier/DatabaseVerifier;", "", "connection", "Ljava/sql/Connection;", "context", "Landroidx/room/processor/Context;", "entities", "", "Landroidx/room/vo/Entity;", "views", "Landroidx/room/vo/DatabaseView;", "(Ljava/sql/Connection;Landroidx/room/processor/Context;Ljava/util/List;Ljava/util/List;)V", "getConnection", "()Ljava/sql/Connection;", "getContext", "()Landroidx/room/processor/Context;", "entitiesAndViews", "Landroidx/room/vo/EntityOrView;", "getEntitiesAndViews", "()Ljava/util/List;", "analyze", "Landroidx/room/verifier/QueryResultInfo;", "sql", "", "closeConnection", "", "stripLocalizeCollations", "kotlin.jvm.PlatformType", "Companion", "room-compiler"})
@SourceDebugExtension(value={"SMAP\nDatabaseVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseVerifier.kt\nandroidx/room/verifier/DatabaseVerifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,196:1\n1855#2:197\n1855#2,2:198\n1856#2:200\n1855#2,2:201\n*S KotlinDebug\n*F\n+ 1 DatabaseVerifier.kt\nandroidx/room/verifier/DatabaseVerifier\n*L\n143#1:197\n161#1:198,2\n143#1:200\n163#1:201,2\n*E\n"})
public final class DatabaseVerifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Connection connection;
    @NotNull
    private final Context context;
    @NotNull
    private final List<EntityOrView> entitiesAndViews;
    @NotNull
    private static final String CONNECTION_URL = "jdbc:sqlite::memory:";
    private static final Pattern COLLATE_LOCALIZED_UNICODE_PATTERN = Pattern.compile("\\s+COLLATE\\s+(LOCALIZED|UNICODE)", 2);
    @NotNull
    private static final Driver DRIVER;

    private DatabaseVerifier(Connection connection, Context context, List<? extends Entity> entities, List<DatabaseView> views) {
        Statement stmt;
        this.connection = connection;
        this.context = context;
        this.entitiesAndViews = CollectionsKt.plus((Collection)entities, (Iterable)views);
        Iterable $this$forEach$iv = entities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity entity = (Entity)element$iv;
            boolean bl = false;
            stmt = this.connection.createStatement();
            String createTableQuery2 = entity instanceof FtsEntity && !FtsOptions.Companion.getDefaultTokenizers().contains(((FtsEntity)entity).getFtsOptions().getTokenizer()) ? ((FtsEntity)entity).getCreateTableQueryWithoutTokenizer() : entity.getCreateTableQuery();
            try {
                stmt.executeUpdate(this.stripLocalizeCollations(createTableQuery2));
            }
            catch (SQLException e) {
                this.context.getLogger().e((XElement)entity.getElement(), String.valueOf(e.getMessage()), new Object[0]);
            }
            Iterable $this$forEach$iv2 = entity.getIndices();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Index it = (Index)element$iv2;
                boolean bl2 = false;
                stmt.executeUpdate(it.createQuery(entity.getTableName()));
            }
        }
        $this$forEach$iv = views;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatabaseView view = (DatabaseView)element$iv;
            boolean bl = false;
            stmt = this.connection.createStatement();
            try {
                stmt.executeUpdate(this.stripLocalizeCollations(view.getCreateViewQuery()));
            }
            catch (SQLException e) {
                this.context.getLogger().e((XElement)view.getElement(), String.valueOf(e.getMessage()), new Object[0]);
            }
        }
    }

    @NotNull
    public final Connection getConnection() {
        return this.connection;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final List<EntityOrView> getEntitiesAndViews() {
        return this.entitiesAndViews;
    }

    @NotNull
    public final QueryResultInfo analyze(@NotNull String sql) {
        QueryResultInfo queryResultInfo;
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        try {
            PreparedStatement stmt = this.connection.prepareStatement(this.stripLocalizeCollations(sql));
            Intrinsics.checkNotNull((Object)stmt);
            queryResultInfo = new QueryResultInfo(Jdbc_extKt.columnInfo(stmt), null, 2, null);
        }
        catch (SQLException ex) {
            queryResultInfo = new QueryResultInfo(CollectionsKt.emptyList(), ex);
        }
        return queryResultInfo;
    }

    private final String stripLocalizeCollations(String sql) {
        return COLLATE_LOCALIZED_UNICODE_PATTERN.matcher(sql).replaceAll(" COLLATE NOCASE");
    }

    public final void closeConnection(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!this.connection.isClosed()) {
            try {
                this.connection.close();
            }
            catch (Throwable t) {
                context.getLogger().d("failed to close the database connection " + t.getMessage(), new Object[0]);
            }
        }
    }

    public /* synthetic */ DatabaseVerifier(Connection connection, Context context, List entities, List views, DefaultConstructorMarker $constructor_marker) {
        this(connection, context, entities, views);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        DatabaseVerifier.Companion.verifyTempDir();
        Class<System> clazz = System.class;
        synchronized (clazz) {
            boolean bl = false;
            SQLiteJDBCLoader.initialize();
            JDBC.isValidURL((String)CONNECTION_URL);
            Driver driver = DriverManager.getDriver("jdbc:sqlite:");
            Intrinsics.checkNotNullExpressionValue((Object)driver, (String)"getDriver(...)");
            DRIVER = driver;
            if (!(DRIVER instanceof JDBC)) {
                boolean bl2 = false;
                String string = "Expected driver to be a '" + JDBC.class + "' but was '" + DRIVER.getClass() + "'";
                throw new IllegalStateException(string.toString());
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bJ4\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0013J\b\u0010\u0017\u001a\u00020\u000bH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Landroidx/room/verifier/DatabaseVerifier$Companion;", "", "()V", "COLLATE_LOCALIZED_UNICODE_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "CONNECTION_URL", "", "DRIVER", "Ljava/sql/Driver;", "cleanup", "", "create", "Landroidx/room/verifier/DatabaseVerifier;", "context", "Landroidx/room/processor/Context;", "element", "Landroidx/room/compiler/processing/XElement;", "entities", "", "Landroidx/room/vo/Entity;", "views", "Landroidx/room/vo/DatabaseView;", "verifyTempDir", "room-compiler"})
    public static final class Companion {
        private Companion() {
        }

        private final void verifyTempDir() {
            File file;
            String defaultTempDir = System.getProperty("java.io.tmpdir");
            String tempDir = System.getProperty("org.sqlite.tmpdir", defaultTempDir);
            if (tempDir == null) {
                boolean bl = false;
                String string = "Room needs the java.io.tmpdir or org.sqlite.tmpdir system property to be set to setup SQLite.";
                throw new IllegalStateException(string.toString());
            }
            File it = file = new File(tempDir);
            boolean bl = false;
            if (!(it.isDirectory() && (it.exists() || it.mkdirs()) && it.canRead() && it.canWrite())) {
                boolean bl2 = false;
                String string = "The temp dir [" + tempDir + "] needs to be a directory, must be readable, writable and allow executables. Please, provide a temporary directory that fits the requirements via the 'org.sqlite.tmpdir' property.";
                throw new IllegalStateException(string.toString());
            }
        }

        @Nullable
        public final DatabaseVerifier create(@NotNull Context context, @NotNull XElement element, @NotNull List<? extends Entity> entities, @NotNull List<DatabaseView> views) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter(entities, (String)"entities");
            Intrinsics.checkNotNullParameter(views, (String)"views");
            try {
                DriverManager.registerDriver(DRIVER);
                SQLiteConnection connection = JDBC.createConnection((String)DatabaseVerifier.CONNECTION_URL, (Properties)new Properties());
                Intrinsics.checkNotNull((Object)connection);
                return new DatabaseVerifier((Connection)connection, context, entities, views, null);
            }
            catch (Exception ex) {
                context.getLogger().w(Warning.CANNOT_CREATE_VERIFICATION_DATABASE, element, DatabaseVerificationErrors.INSTANCE.cannotCreateConnection(ex), new Object[0]);
                return null;
            }
        }

        public final void cleanup() {
            try {
                DriverManager.deregisterDriver(DRIVER);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

