/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.Entity;
import androidx.room.PrimaryKey;
import androidx.room.compiler.processing.XAnnotationBox;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XFieldElement;
import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.ext.Xtype_extKt;
import androidx.room.log.RLog;
import androidx.room.parser.SQLTypeAffinity;
import androidx.room.parser.SqlParser;
import androidx.room.preconditions.Checks;
import androidx.room.processor.Context;
import androidx.room.processor.EntityProcessor;
import androidx.room.processor.FieldProcessor;
import androidx.room.processor.ForeignKeyInput;
import androidx.room.processor.IndexInput;
import androidx.room.processor.PojoProcessor;
import androidx.room.processor.ProcessorErrors;
import androidx.room.processor.cache.Cache;
import androidx.room.vo.Constructor;
import androidx.room.vo.EmbeddedField;
import androidx.room.vo.Field;
import androidx.room.vo.Fields;
import androidx.room.vo.ForeignKey;
import androidx.room.vo.ForeignKeyAction;
import androidx.room.vo.HasFieldsKt;
import androidx.room.vo.Index;
import androidx.room.vo.Pojo;
import androidx.room.vo.Warning;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B1\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\b\u0002\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t\u00a2\u0006\u0002\u0010\nJ,\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0013H\u0002J\u001e\u0010\u0019\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u00132\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u00132\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0013H\u0002J$\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00160\u00132\u0006\u0010\u001b\u001a\u00020\u00052\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0013H\u0002J\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160\u00132\f\u0010#\u001a\b\u0012\u0004\u0012\u00020!0\u0013H\u0002J\b\u0010$\u001a\u00020%H\u0002J$\u0010&\u001a\u00020\u00162\f\u0010#\u001a\b\u0012\u0004\u0012\u00020!0\u00132\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0013H\u0002J(\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u00132\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020%H\u0016J$\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u00100\u001a\b\u0012\u0004\u0012\u0002010\u00132\u0006\u00102\u001a\u000203H\u0002J$\u00104\u001a\b\u0012\u0004\u0012\u00020\u00180\u00132\f\u00105\u001a\b\u0012\u0004\u0012\u00020(0\u00132\u0006\u00102\u001a\u000203H\u0002R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Landroidx/room/processor/TableEntityProcessor;", "Landroidx/room/processor/EntityProcessor;", "baseContext", "Landroidx/room/processor/Context;", "element", "Landroidx/room/compiler/processing/XTypeElement;", "referenceStack", "Ljava/util/LinkedHashSet;", "", "Lkotlin/collections/LinkedHashSet;", "(Landroidx/room/processor/Context;Landroidx/room/compiler/processing/XTypeElement;Ljava/util/LinkedHashSet;)V", "context", "getContext", "()Landroidx/room/processor/Context;", "getElement", "()Landroidx/room/compiler/processing/XTypeElement;", "checkIndicesForForeignKeys", "", "entityForeignKeys", "", "Landroidx/room/vo/ForeignKey;", "primaryKey", "Landroidx/room/vo/PrimaryKey;", "indices", "Landroidx/room/vo/Index;", "choosePrimaryKey", "candidates", "typeElement", "collectPrimaryKeysFromEmbeddedFields", "embeddedFields", "Landroidx/room/vo/EmbeddedField;", "collectPrimaryKeysFromEntityAnnotations", "availableFields", "Landroidx/room/vo/Field;", "collectPrimaryKeysFromPrimaryKeyAnnotations", "fields", "doProcess", "Landroidx/room/vo/Entity;", "findAndValidatePrimaryKey", "loadSuperIndices", "Landroidx/room/processor/IndexInput;", "typeMirror", "Landroidx/room/compiler/processing/XType;", "tableName", "inherit", "", "process", "validateAndCreateForeignKeyReferences", "foreignKeyInputs", "Landroidx/room/processor/ForeignKeyInput;", "pojo", "Landroidx/room/vo/Pojo;", "validateAndCreateIndices", "inputs", "room-compiler"})
@SourceDebugExtension(value={"SMAP\nTableEntityProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableEntityProcessor.kt\nandroidx/room/processor/TableEntityProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,597:1\n766#2:598\n857#2,2:599\n1603#2,9:601\n1855#2:610\n1856#2:612\n1612#2:613\n1855#2,2:614\n1855#2:616\n1549#2:617\n1620#2,3:618\n1747#2,3:621\n1856#2:624\n1549#2:625\n1620#2,2:626\n1603#2,9:628\n1855#2:637\n1856#2:639\n1612#2:640\n1622#2:641\n819#2:642\n847#2,2:643\n1855#2:645\n1855#2,2:646\n1856#2:648\n1603#2,9:649\n1855#2:658\n1856#2:660\n1612#2:661\n288#2,2:672\n1549#2:674\n1620#2,3:675\n819#2:681\n847#2,2:682\n1603#2,9:684\n1855#2:693\n1856#2:695\n1612#2:696\n766#2:697\n857#2,2:698\n1855#2,2:700\n1549#2:702\n1620#2,3:703\n1603#2,9:706\n1855#2:715\n1603#2,9:716\n1855#2:725\n1856#2:727\n1612#2:728\n1856#2:730\n1612#2:731\n1477#2:732\n1502#2,3:733\n1505#2,3:743\n1855#2,2:755\n1549#2:757\n1620#2,3:758\n1726#2,3:761\n1#3:611\n1#3:638\n1#3:659\n1#3:678\n1#3:694\n1#3:726\n1#3:729\n11383#4,9:662\n13309#4:671\n13310#4:679\n11392#4:680\n372#5,7:736\n526#5:746\n511#5,6:747\n215#6,2:753\n*S KotlinDebug\n*F\n+ 1 TableEntityProcessor.kt\nandroidx/room/processor/TableEntityProcessor\n*L\n102#1:598\n102#1:599,2\n103#1:601,9\n103#1:610\n103#1:612\n103#1:613\n157#1:614,2\n191#1:616\n192#1:617\n192#1:618,3\n195#1:621,3\n191#1:624\n220#1:625\n220#1:626,2\n262#1:628,9\n262#1:637\n262#1:639\n262#1:640\n220#1:641\n308#1:642\n308#1:643,2\n309#1:645\n310#1:646,2\n309#1:648\n352#1:649,9\n352#1:658\n352#1:660\n352#1:661\n395#1:672,2\n401#1:674\n401#1:675,3\n421#1:681\n421#1:682,2\n432#1:684,9\n432#1:693\n432#1:695\n432#1:696\n458#1:697\n458#1:698,2\n461#1:700,2\n480#1:702\n480#1:703,3\n490#1:706,9\n490#1:715\n497#1:716,9\n497#1:725\n497#1:727\n497#1:728\n490#1:730\n490#1:731\n527#1:732\n527#1:733,3\n527#1:743,3\n532#1:755,2\n574#1:757\n574#1:758,3\n189#1:761,3\n103#1:611\n262#1:638\n352#1:659\n393#1:678\n432#1:694\n497#1:726\n490#1:729\n393#1:662,9\n393#1:671\n393#1:679\n393#1:680\n527#1:736,7\n528#1:746\n528#1:747,6\n529#1:753,2\n*E\n"})
public final class TableEntityProcessor
implements EntityProcessor {
    @NotNull
    private final XTypeElement element;
    @NotNull
    private final LinkedHashSet<String> referenceStack;
    @NotNull
    private final Context context;

    public TableEntityProcessor(@NotNull Context baseContext, @NotNull XTypeElement element, @NotNull LinkedHashSet<String> referenceStack) {
        Intrinsics.checkNotNullParameter((Object)baseContext, (String)"baseContext");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(referenceStack, (String)"referenceStack");
        this.element = element;
        this.referenceStack = referenceStack;
        this.context = Context.fork$default(baseContext, (XElement)this.element, null, null, 6, null);
    }

    public /* synthetic */ TableEntityProcessor(Context context, XTypeElement xTypeElement, LinkedHashSet linkedHashSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            linkedHashSet = new LinkedHashSet<String>();
        }
        this(context, xTypeElement, linkedHashSet);
    }

    @NotNull
    public final XTypeElement getElement() {
        return this.element;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Override
    @NotNull
    public androidx.room.vo.Entity process() {
        return this.context.getCache().getEntities().get(new Cache.EntityKey((XElement)this.element), (Function0<androidx.room.vo.Entity>)((Function0)new Function0<androidx.room.vo.Entity>(this){
            final /* synthetic */ TableEntityProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final androidx.room.vo.Entity invoke() {
                return TableEntityProcessor.access$doProcess(this.this$0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final androidx.room.vo.Entity doProcess() {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        this.context.getChecker().hasAnnotation((XElement)this.element, (KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(Entity.class), ProcessorErrors.INSTANCE.getENTITY_MUST_BE_ANNOTATED_WITH_ENTITY(), new Object[0]);
        XAnnotationBox annotationBox = this.element.getAnnotation(Reflection.getOrCreateKotlinClass(Entity.class));
        String tableName = null;
        List<IndexInput> entityIndices = null;
        List<ForeignKeyInput> foreignKeyInputs = null;
        boolean inheritSuperIndices = false;
        if (annotationBox != null) {
            tableName = EntityProcessor.Companion.extractTableName(this.element, (Entity)annotationBox.getValue());
            entityIndices = EntityProcessor.Companion.extractIndices((XAnnotationBox<Entity>)annotationBox, tableName);
            inheritSuperIndices = ((Entity)annotationBox.getValue()).inheritSuperIndices();
            foreignKeyInputs = EntityProcessor.Companion.extractForeignKeys((XAnnotationBox<Entity>)annotationBox);
        } else {
            tableName = this.element.getName();
            foreignKeyInputs = CollectionsKt.emptyList();
            entityIndices = CollectionsKt.emptyList();
            inheritSuperIndices = false;
        }
        this.context.getChecker().notBlank(tableName, (XElement)this.element, ProcessorErrors.INSTANCE.getENTITY_TABLE_NAME_CANNOT_BE_EMPTY(), new Object[0]);
        this.context.getChecker().check(!StringsKt.startsWith((String)tableName, (String)"sqlite_", (boolean)true), (XElement)this.element, ProcessorErrors.INSTANCE.getENTITY_TABLE_NAME_CANNOT_START_WITH_SQLITE(), new Object[0]);
        Pojo pojo = PojoProcessor.Companion.createFor(this.context, this.element, FieldProcessor.BindingScope.TWO_WAY, null, this.referenceStack).process();
        this.context.getChecker().check(pojo.getRelations().isEmpty(), (XElement)this.element, ProcessorErrors.INSTANCE.getRELATION_IN_ENTITY(), new Object[0]);
        Iterable iterable = pojo.getFields();
        boolean $i$f$filter = false;
        void var10_10 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Field)element$iv$iv;
            boolean bl = false;
            if (!((Field)it).getIndexed()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            IndexInput indexInput;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            Field it2 = (Field)element$iv$iv;
            boolean bl2 = false;
            if (it2.getParent() != null) {
                it2.setIndexed(false);
                this.context.getLogger().w(Warning.INDEX_FROM_EMBEDDED_FIELD_IS_DROPPED, (XElement)it2.getElement(), ProcessorErrors.INSTANCE.droppedEmbeddedFieldIndex(it2.getPath(), this.element.getQualifiedName()), new Object[0]);
                indexInput = null;
            } else if (!Intrinsics.areEqual((Object)it2.getElement().getEnclosingElement(), (Object)this.element) && !inheritSuperIndices) {
                it2.setIndexed(false);
                this.context.getLogger().w(Warning.INDEX_FROM_PARENT_FIELD_IS_DROPPED, ProcessorErrors.INSTANCE.droppedSuperClassFieldIndex(it2.getColumnName(), this.element.getQualifiedName(), it2.getElement().getEnclosingElement().asClassName().toString(this.context.getCodeLanguage())), new Object[0]);
                indexInput = null;
            } else {
                indexInput = new IndexInput(EntityProcessor.Companion.createIndexName(CollectionsKt.listOf((Object)it2.getColumnName()), tableName), false, CollectionsKt.listOf((Object)it2.getColumnName()), CollectionsKt.emptyList());
            }
            if (indexInput == null) continue;
            IndexInput it$iv$iv = indexInput;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List fieldIndices = (List)destination$iv$iv;
        List<IndexInput> superIndices = this.loadSuperIndices(this.element.getSuperClass(), tableName, inheritSuperIndices);
        List indexInputs = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)entityIndices, (Iterable)fieldIndices), (Iterable)superIndices);
        List<Index> indices = this.validateAndCreateIndices(indexInputs, pojo);
        androidx.room.vo.PrimaryKey primaryKey2 = this.findAndValidatePrimaryKey(pojo.getFields(), pojo.getEmbeddedFields());
        Object object = (Field)CollectionsKt.firstOrNull((List)primaryKey2.getFields());
        if (object == null || (object = object.getAffinity()) == null) {
            object = SQLTypeAffinity.TEXT;
        }
        Object affinity = object;
        Checks checks = this.context.getChecker();
        boolean bl = !primaryKey2.getAutoGenerateId() || affinity == SQLTypeAffinity.INTEGER;
        Field field = (Field)CollectionsKt.firstOrNull((List)primaryKey2.getFields());
        if (field == null || (field = field.getElement()) == null) {
            field = this.element;
        }
        checks.check(bl, (XElement)field, ProcessorErrors.INSTANCE.getAUTO_INCREMENTED_PRIMARY_KEY_IS_NOT_INT(), new Object[0]);
        List<ForeignKey> entityForeignKeys = this.validateAndCreateForeignKeyReferences(foreignKeyInputs, pojo);
        this.checkIndicesForForeignKeys(entityForeignKeys, primaryKey2, indices);
        this.context.getChecker().check(SqlParser.Companion.isValidIdentifier(tableName), (XElement)this.element, ProcessorErrors.INSTANCE.getINVALID_TABLE_NAME(), new Object[0]);
        Iterable $this$forEach$iv = pojo.getFields();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Field it3 = (Field)element$iv;
            boolean bl4 = false;
            this.context.getChecker().check(SqlParser.Companion.isValidIdentifier(it3.getColumnName()), (XElement)it3.getElement(), ProcessorErrors.INSTANCE.getINVALID_COLUMN_NAME(), new Object[0]);
        }
        XTypeElement xTypeElement = this.element;
        XType xType = pojo.getType();
        Fields fields = pojo.getFields();
        List<EmbeddedField> list = pojo.getEmbeddedFields();
        Constructor constructor = pojo.getConstructor();
        androidx.room.vo.Entity entity = new androidx.room.vo.Entity(xTypeElement, tableName, xType, fields, list, primaryKey2, indices, entityForeignKeys, constructor, null);
        return entity;
    }

    /*
     * Unable to fully structure code
     */
    private final void checkIndicesForForeignKeys(List<ForeignKey> entityForeignKeys, androidx.room.vo.PrimaryKey primaryKey, List<Index> indices) {
        $this$forEach$iv = entityForeignKeys;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            block8: {
                fKey = (ForeignKey)element$iv;
                $i$a$-forEach-TableEntityProcessor$checkIndicesForForeignKeys$1 = false;
                $this$map$iv = fKey.getChildFields();
                $i$f$map = false;
                var12_14 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var17_22 = (Field)item$iv$iv;
                    var18_23 = destination$iv$iv;
                    $i$a$-map-TableEntityProcessor$checkIndicesForForeignKeys$1$columnNames$1 = false;
                    var18_23.add(it.getColumnName());
                }
                columnNames = (List)destination$iv$iv;
                if (TableEntityProcessor.checkIndicesForForeignKeys$covers(columnNames, primaryKey.getFields())) ** GOTO lbl-1000
                $this$any$iv = indices;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        index = (Index)element$iv;
                        $i$a$-any-TableEntityProcessor$checkIndicesForForeignKeys$1$exists$1 = false;
                        if (!TableEntityProcessor.checkIndicesForForeignKeys$covers(columnNames, index.getFields())) continue;
                        v0 = true;
                        break block8;
                    }
                    v0 = false;
                }
            }
            if (v0) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            if (exists = v1) continue;
            if (columnNames.size() == 1) {
                this.context.getLogger().w(Warning.MISSING_INDEX_ON_FOREIGN_KEY_CHILD, (XElement)this.element, ProcessorErrors.INSTANCE.foreignKeyMissingIndexInChildColumn((String)columnNames.get(0)), new Object[0]);
                continue;
            }
            this.context.getLogger().w(Warning.MISSING_INDEX_ON_FOREIGN_KEY_CHILD, (XElement)this.element, ProcessorErrors.INSTANCE.foreignKeyMissingIndexInChildColumns(columnNames), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<ForeignKey> validateAndCreateForeignKeyReferences(List<ForeignKeyInput> foreignKeyInputs, Pojo pojo) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = foreignKeyInputs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ForeignKey foreignKey;
            void it;
            ForeignKeyInput foreignKeyInput = (ForeignKeyInput)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (it.getOnUpdate() == null) {
                this.context.getLogger().e((XElement)this.element, ProcessorErrors.INSTANCE.getINVALID_FOREIGN_KEY_ACTION(), new Object[0]);
                foreignKey = null;
            } else if (it.getOnDelete() == null) {
                this.context.getLogger().e((XElement)this.element, ProcessorErrors.INSTANCE.getINVALID_FOREIGN_KEY_ACTION(), new Object[0]);
                foreignKey = null;
            } else if (it.getChildColumns().isEmpty()) {
                this.context.getLogger().e((XElement)this.element, ProcessorErrors.INSTANCE.getFOREIGN_KEY_EMPTY_CHILD_COLUMN_LIST(), new Object[0]);
                foreignKey = null;
            } else if (it.getParentColumns().isEmpty()) {
                this.context.getLogger().e((XElement)this.element, ProcessorErrors.INSTANCE.getFOREIGN_KEY_EMPTY_PARENT_COLUMN_LIST(), new Object[0]);
                foreignKey = null;
            } else if (it.getChildColumns().size() != it.getParentColumns().size()) {
                this.context.getLogger().e((XElement)this.element, ProcessorErrors.INSTANCE.foreignKeyColumnNumberMismatch(it.getChildColumns(), it.getParentColumns()), new Object[0]);
                foreignKey = null;
            } else {
                XTypeElement parentElement = it.getParent().getTypeElement();
                if (parentElement == null) {
                    this.context.getLogger().e((XElement)this.element, ProcessorErrors.INSTANCE.getFOREIGN_KEY_CANNOT_FIND_PARENT(), new Object[0]);
                    foreignKey = null;
                } else {
                    XAnnotationBox parentAnnotation = parentElement.getAnnotation(Reflection.getOrCreateKotlinClass(Entity.class));
                    if (parentAnnotation == null) {
                        this.context.getLogger().e((XElement)this.element, ProcessorErrors.INSTANCE.foreignKeyNotAnEntity(parentElement.getQualifiedName()), new Object[0]);
                        foreignKey = null;
                    } else {
                        void $this$mapNotNullTo$iv$iv;
                        String tableName = EntityProcessor.Companion.extractTableName(parentElement, (Entity)parentAnnotation.getValue());
                        Iterable $this$mapNotNull$iv = it.getChildColumns();
                        boolean $i$f$mapNotNull = false;
                        Object object = $this$mapNotNull$iv;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            Field it$iv$iv;
                            Object element$iv$iv$iv;
                            Object element$iv$iv = element$iv$iv$iv = iterator.next();
                            boolean bl2 = false;
                            String columnName = (String)element$iv$iv;
                            boolean bl3 = false;
                            Field field = HasFieldsKt.findFieldByColumnName(pojo, columnName);
                            if (field == null) {
                                this.context.getLogger().e((XElement)pojo.getElement(), ProcessorErrors.INSTANCE.foreignKeyChildColumnDoesNotExist(columnName, HasFieldsKt.getColumnNames(pojo)), new Object[0]);
                            }
                            if (field == null) continue;
                            boolean bl4 = false;
                            destination$iv$iv2.add(it$iv$iv);
                        }
                        List fields = (List)destination$iv$iv2;
                        if (fields.size() != it.getChildColumns().size()) {
                            foreignKey = null;
                        } else {
                            List<String> list = it.getParentColumns();
                            ForeignKeyAction foreignKeyAction = it.getOnDelete();
                            object = it.getOnUpdate();
                            boolean bl5 = it.getDeferred();
                            foreignKey = new ForeignKey(tableName, list, fields, foreignKeyAction, (ForeignKeyAction)((Object)object), bl5);
                        }
                    }
                }
            }
            collection.add(foreignKey);
        }
        return CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final androidx.room.vo.PrimaryKey findAndValidatePrimaryKey(List<Field> fields, List<EmbeddedField> embeddedFields) {
        void $this$forEach$iv;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        List candidates = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.collectPrimaryKeysFromEntityAnnotations(this.element, fields), (Iterable)this.collectPrimaryKeysFromPrimaryKeyAnnotations(fields)), (Iterable)this.collectPrimaryKeysFromEmbeddedFields(embeddedFields));
        this.context.getChecker().check(!((Collection)candidates).isEmpty(), (XElement)this.element, ProcessorErrors.INSTANCE.getMISSING_PRIMARY_KEY(), new Object[0]);
        Set verifiedFields = new LinkedHashSet();
        Iterable iterable = candidates;
        boolean $i$f$filterNot = false;
        Iterator iterator = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            androidx.room.vo.PrimaryKey it = (androidx.room.vo.PrimaryKey)element$iv$iv;
            boolean bl = false;
            if (it.getAutoGenerateId()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            androidx.room.vo.PrimaryKey candidate = (androidx.room.vo.PrimaryKey)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = candidate.getFields();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Field field = (Field)element$iv2;
                boolean bl2 = false;
                if (candidate.getFields().size() <= 1 && (candidate.getFields().size() != 1 || field.getAffinity() == SQLTypeAffinity.INTEGER)) continue;
                if (!verifiedFields.contains(field)) {
                    this.context.getChecker().check(field.getNonNull(), (XElement)field.getElement(), ProcessorErrors.INSTANCE.primaryKeyNull(field.getPath()), new Object[0]);
                    verifiedFields.add(field);
                }
                EmbeddedField parent = field.getParent();
                while (parent != null) {
                    Field parentField = parent.getField();
                    if (!verifiedFields.contains(parentField)) {
                        this.context.getChecker().check(parentField.getNonNull(), (XElement)parentField.getElement(), ProcessorErrors.INSTANCE.primaryKeyNull(parentField.getPath()), new Object[0]);
                        verifiedFields.add(parentField);
                    }
                    parent = parentField.getParent();
                }
            }
        }
        if (candidates.size() == 1) {
            return (androidx.room.vo.PrimaryKey)CollectionsKt.first((List)candidates);
        }
        return this.choosePrimaryKey(candidates, this.element);
    }

    /*
     * WARNING - void declaration
     */
    private final List<androidx.room.vo.PrimaryKey> collectPrimaryKeysFromPrimaryKeyAnnotations(List<Field> fields) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = fields;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            androidx.room.vo.PrimaryKey primaryKey2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Field field = (Field)element$iv$iv;
            boolean bl2 = false;
            if (field.getElement().getAnnotation(Reflection.getOrCreateKotlinClass(PrimaryKey.class)) != null) {
                boolean bl3 = false;
                if (field.getParent() != null) {
                    XFieldElement grandParentField = field.getParent().getMRootParent().getField().getElement();
                    Context.fork$default(this.context, (XElement)grandParentField, null, null, 6, null).getLogger().w(Warning.PRIMARY_KEY_FROM_EMBEDDED_IS_DROPPED, (XElement)grandParentField, ProcessorErrors.INSTANCE.embeddedPrimaryKeyIsDropped(this.element.getQualifiedName(), field.getName()), new Object[0]);
                    primaryKey2 = null;
                } else {
                    XAnnotationBox it;
                    primaryKey2 = new androidx.room.vo.PrimaryKey((XElement)field.getElement().getEnclosingElement(), new Fields(field), ((PrimaryKey)it.getValue()).autoGenerate());
                }
            } else {
                primaryKey2 = null;
            }
            if (primaryKey2 == null) continue;
            androidx.room.vo.PrimaryKey it$iv$iv = primaryKey2;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<androidx.room.vo.PrimaryKey> collectPrimaryKeysFromEntityAnnotations(XTypeElement typeElement, List<Field> availableFields) {
        List<androidx.room.vo.PrimaryKey> list;
        XType mySuper;
        Object myPkeys;
        Object primaryKeyColumns;
        block14: {
            Object object;
            block13: {
                List list2;
                object = typeElement.getAnnotation(Reflection.getOrCreateKotlinClass(Entity.class));
                if (object == null) break block13;
                XAnnotationBox it = object;
                boolean bl = false;
                primaryKeyColumns = ((Entity)it.getValue()).primaryKeys();
                if (((String[])primaryKeyColumns).length == 0) {
                    list2 = CollectionsKt.emptyList();
                } else {
                    void $this$mapNotNullTo$iv$iv;
                    String[] $this$mapNotNull$iv = primaryKeyColumns;
                    boolean $i$f$mapNotNull = false;
                    String[] stringArray = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    int n = ((void)$this$forEach$iv$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        Field it$iv$iv;
                        Collection<String> collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Object v2;
                        Iterable $this$firstOrNull$iv;
                        void pKeyColumnName;
                        block12: {
                            void element$iv$iv$iv;
                            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                            boolean bl2 = false;
                            pKeyColumnName = element$iv$iv;
                            boolean bl3 = false;
                            $this$firstOrNull$iv = availableFields;
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                Field it2 = (Field)element$iv;
                                boolean bl4 = false;
                                if (!Intrinsics.areEqual((Object)it2.getColumnName(), (Object)pKeyColumnName)) continue;
                                v2 = element$iv;
                                break block12;
                            }
                            v2 = null;
                        }
                        Field field = v2;
                        $this$firstOrNull$iv = availableFields;
                        void var31_31 = pKeyColumnName;
                        ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
                        XElement xElement = (XElement)typeElement;
                        boolean bl5 = field != null;
                        Checks checks = this.context.getChecker();
                        boolean $i$f$map = false;
                        Iterator iterator = $this$map$iv;
                        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it3;
                            Field field2 = (Field)item$iv$iv;
                            collection = destination$iv$iv2;
                            boolean bl6 = false;
                            collection.add(it3.getColumnName());
                        }
                        collection = (List)destination$iv$iv2;
                        checks.check(bl5, xElement, processorErrors.primaryKeyColumnDoesNotExist((String)var31_31, (List<String>)collection), new Object[0]);
                        if (field == null) continue;
                        boolean bl7 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List fields = (List)destination$iv$iv;
                    list2 = CollectionsKt.listOf((Object)new androidx.room.vo.PrimaryKey((XElement)typeElement, new Fields(fields), false));
                }
                object = list2;
                if (list2 != null) break block14;
            }
            object = myPkeys = CollectionsKt.emptyList();
        }
        if ((mySuper = typeElement.getSuperClass()) != null && Xtype_extKt.isNotNone(mySuper)) {
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = availableFields;
            boolean $i$f$filterNot = false;
            primaryKeyColumns = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Field it = (Field)element$iv$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getElement().getEnclosingElement(), (Object)typeElement)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List remainingFields = (List)destination$iv$iv;
            XTypeElement xTypeElement = mySuper.getTypeElement();
            Intrinsics.checkNotNull((Object)xTypeElement);
            list = this.collectPrimaryKeysFromEntityAnnotations(xTypeElement, remainingFields);
        } else {
            list = CollectionsKt.emptyList();
        }
        List<androidx.room.vo.PrimaryKey> superPKeys = list;
        return CollectionsKt.plus((Collection)superPKeys, (Iterable)((Iterable)myPkeys));
    }

    /*
     * WARNING - void declaration
     */
    private final List<androidx.room.vo.PrimaryKey> collectPrimaryKeysFromEmbeddedFields(List<EmbeddedField> embeddedFields) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = embeddedFields;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            androidx.room.vo.PrimaryKey primaryKey2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            EmbeddedField embeddedField = (EmbeddedField)element$iv$iv;
            boolean bl2 = false;
            if (embeddedField.getField().getElement().getAnnotation(Reflection.getOrCreateKotlinClass(PrimaryKey.class)) != null) {
                XAnnotationBox it;
                boolean bl3 = false;
                this.context.getChecker().check(!((PrimaryKey)it.getValue()).autoGenerate() || embeddedField.getPojo().getFields().size() == 1, (XElement)embeddedField.getField().getElement(), ProcessorErrors.INSTANCE.getAUTO_INCREMENT_EMBEDDED_HAS_MULTIPLE_FIELDS(), new Object[0]);
                primaryKey2 = new androidx.room.vo.PrimaryKey((XElement)embeddedField.getField().getElement().getEnclosingElement(), embeddedField.getPojo().getFields(), ((PrimaryKey)it.getValue()).autoGenerate());
            } else {
                primaryKey2 = null;
            }
            if (primaryKey2 == null) continue;
            androidx.room.vo.PrimaryKey it$iv$iv = primaryKey2;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final androidx.room.vo.PrimaryKey choosePrimaryKey(List<androidx.room.vo.PrimaryKey> candidates, XTypeElement typeElement) {
        androidx.room.vo.PrimaryKey primaryKey2;
        androidx.room.vo.PrimaryKey candidate;
        Iterator $this$filterTo$iv$iv;
        Iterable $this$filter$iv = candidates;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            candidate = (androidx.room.vo.PrimaryKey)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)candidate.getDeclaredIn(), (Object)typeElement)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List myPKeys = (List)destination$iv$iv;
        if (myPKeys.size() == 1) {
            Iterable $this$forEach$iv = CollectionsKt.minus((Iterable)candidates, (Iterable)myPKeys);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                androidx.room.vo.PrimaryKey it = (androidx.room.vo.PrimaryKey)element$iv;
                boolean bl = false;
                this.context.getLogger().d((XElement)this.element, it.toHumanReadableString() + " is overridden by " + ((androidx.room.vo.PrimaryKey)CollectionsKt.first((List)myPKeys)).toHumanReadableString(), new Object[0]);
            }
            primaryKey2 = (androidx.room.vo.PrimaryKey)CollectionsKt.first((List)myPKeys);
        } else if (myPKeys.isEmpty()) {
            mySuper = typeElement.getSuperClass();
            if (mySuper != null && Xtype_extKt.isNotNone(mySuper)) {
                XTypeElement xTypeElement = mySuper.getTypeElement();
                Intrinsics.checkNotNull((Object)xTypeElement);
                return this.choosePrimaryKey(candidates, xTypeElement);
            }
            primaryKey2 = androidx.room.vo.PrimaryKey.Companion.getMISSING();
        } else {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            mySuper = myPKeys;
            ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
            XElement xElement = (XElement)this.element;
            RLog rLog = this.context.getLogger();
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                candidate = (androidx.room.vo.PrimaryKey)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(p0.toHumanReadableString());
            }
            collection = (List)destination$iv$iv;
            rLog.e(xElement, processorErrors.multiplePrimaryKeyAnnotations((List<String>)collection), new Object[0]);
            primaryKey2 = androidx.room.vo.PrimaryKey.Companion.getMISSING();
        }
        return primaryKey2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Index> validateAndCreateIndices(List<IndexInput> inputs, Pojo pojo) {
        Iterable $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Object $this$filter$iv;
        Object it;
        void $this$groupByTo$iv$iv;
        Object $this$groupBy$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = inputs;
        boolean $i$f$mapNotNull = false;
        Iterator iterator = $this$mapNotNull$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator<Object> $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean bl = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Index it$iv$iv;
            void $this$mapNotNullTo$iv$iv2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl2 = false;
            IndexInput input = (IndexInput)element$iv$iv;
            boolean bl22 = false;
            this.context.getChecker().check(!((Collection)input.getColumnNames()).isEmpty(), (XElement)this.element, ProcessorErrors.INSTANCE.getINDEX_COLUMNS_CANNOT_BE_EMPTY(), new Object[0]);
            Iterable $this$mapNotNull$iv2 = input.getColumnNames();
            boolean $i$f$mapNotNull2 = false;
            Iterable iterable = $this$mapNotNull$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach2 = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv2.iterator();
            while (iterator3.hasNext()) {
                Field it$iv$iv2;
                Object element$iv$iv$iv2;
                Object element$iv$iv2 = element$iv$iv$iv2 = iterator3.next();
                boolean bl3 = false;
                String columnName = (String)element$iv$iv2;
                boolean bl32 = false;
                Field field = HasFieldsKt.findFieldByColumnName(pojo, columnName);
                this.context.getChecker().check(field != null, (XElement)this.element, ProcessorErrors.INSTANCE.indexColumnDoesNotExist(columnName, HasFieldsKt.getColumnNames(pojo)), new Object[0]);
                if (field == null) continue;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv2);
            }
            List fields = (List)destination$iv$iv2;
            if (!((Collection)input.getOrders()).isEmpty()) {
                this.context.getChecker().check(input.getColumnNames().size() == input.getOrders().size(), (XElement)this.element, ProcessorErrors.INSTANCE.getINVALID_INDEX_ORDERS_SIZE(), new Object[0]);
            }
            if ((fields.isEmpty() ? null : new Index(input.getName(), input.getUnique(), fields, input.getOrders())) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List indices = (List)destination$iv$iv;
        $this$mapNotNull$iv = indices;
        boolean $i$f$groupBy = false;
        $this$mapNotNullTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object t : $this$groupByTo$iv$iv) {
            Object object;
            it = (Index)t;
            boolean bl4 = false;
            String key$iv$iv = ((Index)it).getName();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl6 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(t);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        for (Map.Entry entry : $this$filterTo$iv$iv.entrySet()) {
            it = entry;
            boolean bl5 = false;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv.put(entry.getKey(), entry.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        boolean $i$f$forEach3 = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it2 = element$iv = (Map.Entry)iterator.next();
            boolean bl6 = false;
            this.context.getLogger().e((XElement)this.element, ProcessorErrors.INSTANCE.duplicateIndexInEntity((String)it2.getKey()), new Object[0]);
        }
        $this$forEach$iv = pojo.getEmbeddedFields();
        boolean $i$f$forEach = false;
        for (Map.Entry element$iv : $this$forEach$iv) {
            EmbeddedField embedded = (EmbeddedField)((Object)element$iv);
            boolean bl7 = false;
            XTypeElement xTypeElement = embedded.getPojo().getElement();
            if (xTypeElement.getAnnotation(Reflection.getOrCreateKotlinClass(Entity.class)) == null) continue;
            boolean bl72 = false;
            List<IndexInput> subIndices = EntityProcessor.Companion.extractIndices((XAnnotationBox<Entity>)it, "");
            if (!(!((Collection)subIndices).isEmpty())) continue;
            this.context.getLogger().w(Warning.INDEX_FROM_EMBEDDED_ENTITY_IS_DROPPED, (XElement)embedded.getField().getElement(), ProcessorErrors.INSTANCE.droppedEmbeddedIndex(embedded.getPojo().getTypeName().toString(this.context.getCodeLanguage()), embedded.getField().getPath(), this.element.getQualifiedName()), new Object[0]);
        }
        return indices;
    }

    /*
     * WARNING - void declaration
     */
    private final List<IndexInput> loadSuperIndices(XType typeMirror, String tableName, boolean inherit) {
        Object object;
        XTypeElement parentTypeElement;
        block11: {
            block10: {
                List list;
                if (typeMirror == null || typeMirror.isNone()) {
                    return CollectionsKt.emptyList();
                }
                parentTypeElement = typeMirror.getTypeElement();
                if (parentTypeElement == null) {
                    return CollectionsKt.emptyList();
                }
                object = parentTypeElement.getAnnotation(Reflection.getOrCreateKotlinClass(Entity.class));
                if (object == null) break block10;
                XAnnotationBox annotation = object;
                boolean bl = false;
                List<IndexInput> indices = EntityProcessor.Companion.extractIndices((XAnnotationBox<Entity>)annotation, "super");
                if (indices.isEmpty()) {
                    list = CollectionsKt.emptyList();
                } else if (inherit) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = indices;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        IndexInput indexInput = (IndexInput)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(new IndexInput(EntityProcessor.Companion.createIndexName(it.getColumnNames(), tableName), it.getUnique(), it.getColumnNames(), it.getOrders()));
                    }
                    list = (List)destination$iv$iv;
                } else {
                    this.context.getLogger().w(Warning.INDEX_FROM_PARENT_IS_DROPPED, (XElement)parentTypeElement, ProcessorErrors.INSTANCE.droppedSuperClassIndex(this.element.getQualifiedName(), parentTypeElement.getQualifiedName()), new Object[0]);
                    list = CollectionsKt.emptyList();
                }
                object = list;
                if (list != null) break block11;
            }
            object = CollectionsKt.emptyList();
        }
        Object myIndices = object;
        return CollectionsKt.plus((Collection)((Collection)myIndices), (Iterable)this.loadSuperIndices(parentTypeElement.getSuperClass(), tableName, inherit));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean checkIndicesForForeignKeys$covers(List<String> columnNames2, List<Field> fields) {
        IndexedValue it;
        if (fields.size() < columnNames2.size()) return false;
        Iterable $this$all$iv = CollectionsKt.withIndex((Iterable)columnNames2);
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            it = (IndexedValue)element$iv;
            boolean bl = false;
        } while (Intrinsics.areEqual((Object)fields.get(it.getIndex()).getColumnName(), (Object)it.getValue()));
        return false;
    }

    public static final /* synthetic */ androidx.room.vo.Entity access$doProcess(TableEntityProcessor $this) {
        return $this.doProcess();
    }
}

