/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.writer;

import androidx.annotation.VisibleForTesting;
import androidx.room.compiler.codegen.CodeLanguage;
import androidx.room.compiler.codegen.VisibilityModifier;
import androidx.room.compiler.codegen.XCodeBlock;
import androidx.room.compiler.codegen.XFunSpec;
import androidx.room.compiler.codegen.XTypeName;
import androidx.room.compiler.codegen.XTypeSpec;
import androidx.room.ext.RoomMemberNames;
import androidx.room.ext.RoomTypeNames;
import androidx.room.ext.SQLiteDriverMemberNames;
import androidx.room.ext.SQLiteDriverTypeNames;
import androidx.room.solver.CodeGenScope;
import androidx.room.vo.Database;
import androidx.room.vo.DatabaseView;
import androidx.room.vo.Entity;
import androidx.room.vo.FtsEntity;
import androidx.room.vo.Pojo;
import androidx.room.writer.FtsTableInfoValidationWriter;
import androidx.room.writer.TableInfoValidationWriter;
import androidx.room.writer.ValidationWriter;
import androidx.room.writer.ViewInfoValidationWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u001c2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006!"}, d2={"Landroidx/room/writer/OpenDelegateWriter;", "", "database", "Landroidx/room/vo/Database;", "(Landroidx/room/vo/Database;)V", "connectionParamName", "", "getDatabase", "()Landroidx/room/vo/Database;", "createCreateAllTables", "Landroidx/room/compiler/codegen/XFunSpec;", "scope", "Landroidx/room/solver/CodeGenScope;", "createDropAllTables", "createDropTableQuery", "entity", "Landroidx/room/vo/Entity;", "createDropViewQuery", "view", "Landroidx/room/vo/DatabaseView;", "createOnCreate", "createOnOpen", "createOnPostMigrate", "createOnPreMigrate", "createOpenDelegate", "Landroidx/room/compiler/codegen/XTypeSpec;", "createTableQuery", "createValidateMigration", "", "createViewQuery", "write", "", "outVar", "room-compiler"})
@SourceDebugExtension(value={"SMAP\nOpenDelegateWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenDelegateWriter.kt\nandroidx/room/writer/OpenDelegateWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,343:1\n1855#2,2:344\n1855#2,2:346\n1549#2:348\n1620#2,3:349\n1855#2,2:353\n1855#2,2:355\n1855#2,2:357\n766#2:359\n857#2,2:360\n1360#2:362\n1446#2,5:363\n1855#2,2:368\n1#3:352\n*S KotlinDebug\n*F\n+ 1 OpenDelegateWriter.kt\nandroidx/room/writer/OpenDelegateWriter\n*L\n70#1:344,2\n149#1:346,2\n179#1:348\n179#1:349,3\n227#1:353,2\n251#1:355,2\n262#1:357,2\n306#1:359\n306#1:360,2\n307#1:362\n307#1:363,5\n308#1:368,2\n*E\n"})
public final class OpenDelegateWriter {
    @NotNull
    private final Database database;
    @NotNull
    private final String connectionParamName;

    public OpenDelegateWriter(@NotNull Database database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        this.database = database;
        this.connectionParamName = "connection";
    }

    @NotNull
    public final Database getDatabase() {
        return this.database;
    }

    public final void write(@NotNull String outVar, @NotNull CodeGenScope scope) {
        XCodeBlock.Builder builder2;
        Intrinsics.checkNotNullParameter((Object)outVar, (String)"outVar");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        XCodeBlock.Builder $this$write_u24lambda_u240 = builder2 = scope.getBuilder();
        boolean bl = false;
        Object[] objectArray = new Object[]{this.createOpenDelegate(scope)};
        XCodeBlock.Builder.Companion.addLocalVal($this$write_u24lambda_u240, outVar, (XTypeName)RoomTypeNames.INSTANCE.getROOM_OPEN_DELEGATE(), "%L", objectArray);
    }

    private final XTypeSpec createOpenDelegate(CodeGenScope scope) {
        Object[] objectArray = new Object[]{this.database.getVersion(), this.database.getIdentityHash(), this.database.getLegacyIdentityHash()};
        Object[] $this$createOpenDelegate_u24lambda_u242 = objectArray = XTypeSpec.Companion.anonymousClassBuilder(scope.getLanguage(), "%L, %S, %S", objectArray);
        boolean bl = false;
        $this$createOpenDelegate_u24lambda_u242.superclass((XTypeName)RoomTypeNames.INSTANCE.getROOM_OPEN_DELEGATE());
        $this$createOpenDelegate_u24lambda_u242.addFunction(this.createCreateAllTables(scope));
        $this$createOpenDelegate_u24lambda_u242.addFunction(this.createDropAllTables(scope.fork()));
        $this$createOpenDelegate_u24lambda_u242.addFunction(this.createOnCreate(scope.fork()));
        $this$createOpenDelegate_u24lambda_u242.addFunction(this.createOnOpen(scope.fork()));
        $this$createOpenDelegate_u24lambda_u242.addFunction(this.createOnPreMigrate(scope));
        $this$createOpenDelegate_u24lambda_u242.addFunction(this.createOnPostMigrate(scope));
        Iterable $this$forEach$iv = this.createValidateMigration(scope.fork());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            XFunSpec it = (XFunSpec)element$iv;
            boolean bl2 = false;
            $this$createOpenDelegate_u24lambda_u242.addFunction(it);
        }
        return objectArray.build();
    }

    /*
     * WARNING - void declaration
     */
    private final List<XFunSpec> createValidateMigration(CodeGenScope scope) {
        void $this$mapTo$iv$iv;
        Object $this$createValidateMigration_u24lambda_u246;
        Object methodScope;
        String methodName;
        List methodBuilders = new ArrayList();
        ArrayDeque entities = new ArrayDeque(this.database.getEntities());
        ArrayDeque views = new ArrayDeque(this.database.getViews());
        while (!entities.isEmpty() || !views.isEmpty()) {
            int statementCount;
            ValidationWriter validationWriter;
            XFunSpec.Builder builder2;
            boolean isPrimaryMethod = methodBuilders.isEmpty();
            methodName = isPrimaryMethod ? "onValidateSchema" : "onValidateSchema" + (methodBuilders.size() + 1);
            XFunSpec.Builder $this$createValidateMigration_u24lambda_u243 = builder2 = XFunSpec.Companion.builder$default((XFunSpec.Companion)XFunSpec.Companion, (CodeLanguage)scope.getLanguage(), (String)methodName, (VisibilityModifier)(isPrimaryMethod ? VisibilityModifier.PUBLIC : VisibilityModifier.PRIVATE), (boolean)false, (boolean)isPrimaryMethod, (int)8, null);
            boolean bl = false;
            $this$createValidateMigration_u24lambda_u243.returns((XTypeName)RoomTypeNames.INSTANCE.getROOM_OPEN_DELEGATE_VALIDATION_RESULT());
            XFunSpec.Builder.addParameter$default((XFunSpec.Builder)$this$createValidateMigration_u24lambda_u243, (XTypeName)((XTypeName)SQLiteDriverTypeNames.INSTANCE.getCONNECTION()), (String)this.connectionParamName, null, (int)4, null);
            for (statementCount = 0; !entities.isEmpty() && statementCount < 1000; statementCount += validationWriter.statementCount()) {
                ValidationWriter validationWriter2;
                methodScope = scope.fork();
                Entity entity = (Entity)entities.poll();
                if (entity instanceof FtsEntity) {
                    Intrinsics.checkNotNull((Object)entity);
                    validationWriter2 = new FtsTableInfoValidationWriter((FtsEntity)entity);
                } else {
                    Intrinsics.checkNotNull((Object)entity);
                    validationWriter2 = new TableInfoValidationWriter(entity);
                }
                validationWriter = validationWriter2;
                validationWriter.write(this.connectionParamName, (CodeGenScope)methodScope);
                $this$createValidateMigration_u24lambda_u243.addCode(((CodeGenScope)methodScope).generate());
            }
            while (!views.isEmpty() && statementCount < 1000) {
                methodScope = scope.fork();
                DatabaseView view = (DatabaseView)views.poll();
                Intrinsics.checkNotNull((Object)view);
                validationWriter = new ViewInfoValidationWriter(view);
                validationWriter.write(this.connectionParamName, (CodeGenScope)methodScope);
                $this$createValidateMigration_u24lambda_u243.addCode(((CodeGenScope)methodScope).generate());
                statementCount += validationWriter.statementCount();
            }
            if (!isPrimaryMethod) {
                methodScope = new Object[]{XCodeBlock.Companion.ofNewInstance(scope.getLanguage(), (XTypeName)RoomTypeNames.INSTANCE.getROOM_OPEN_DELEGATE_VALIDATION_RESULT(), "true, null", new Object[0])};
                XFunSpec.Builder.Companion.addStatement($this$createValidateMigration_u24lambda_u243, "return %L", (Object[])methodScope);
            }
            XFunSpec.Builder validateMethod = builder2;
            methodBuilders.add(validateMethod);
        }
        if (methodBuilders.size() > 1) {
            methodName = XCodeBlock.Companion.builder(scope.getLanguage());
            $this$createValidateMigration_u24lambda_u246 = methodName;
            boolean bl = false;
            String resultVar = scope.getTmpVar("_result");
            XCodeBlock.Builder.addLocalVariable$default((XCodeBlock.Builder)$this$createValidateMigration_u24lambda_u246, (String)resultVar, (XTypeName)((XTypeName)RoomTypeNames.INSTANCE.getROOM_OPEN_DELEGATE_VALIDATION_RESULT()), (boolean)true, null, (int)8, null);
            Iterable $this$forEach$iv = CollectionsKt.drop((Iterable)methodBuilders, (int)1);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                XFunSpec.Builder it = (XFunSpec.Builder)element$iv;
                boolean bl2 = false;
                Object[] objectArray = new Object[]{resultVar, it.getName(), this.connectionParamName};
                $this$createValidateMigration_u24lambda_u246.addStatement("%L = %L(%L)", objectArray);
                objectArray = new Object[]{resultVar};
                Object[] $this$createValidateMigration_u24lambda_u246_u24lambda_u245_u24lambda_u244 = objectArray = $this$createValidateMigration_u24lambda_u246.beginControlFlow("if (!%L.isValid)", objectArray);
                boolean bl3 = false;
                Object[] objectArray2 = new Object[]{resultVar};
                $this$createValidateMigration_u24lambda_u246_u24lambda_u245_u24lambda_u244.addStatement("return %L", objectArray2);
                $this$createValidateMigration_u24lambda_u246.endControlFlow();
            }
            Object[] objectArray = new Object[]{XCodeBlock.Companion.ofNewInstance(scope.getLanguage(), (XTypeName)RoomTypeNames.INSTANCE.getROOM_OPEN_DELEGATE_VALIDATION_RESULT(), "true, null", new Object[0])};
            $this$createValidateMigration_u24lambda_u246.addStatement("return %L", objectArray);
            XCodeBlock body2 = methodName.build();
            ((XFunSpec.Builder)CollectionsKt.first((List)methodBuilders)).addCode(body2);
        } else if (methodBuilders.size() == 1) {
            Object[] body2 = new Object[]{XCodeBlock.Companion.ofNewInstance(scope.getLanguage(), (XTypeName)RoomTypeNames.INSTANCE.getROOM_OPEN_DELEGATE_VALIDATION_RESULT(), "true, null", new Object[0])};
            XFunSpec.Builder.Companion.addStatement((XFunSpec.Builder)CollectionsKt.first((List)methodBuilders), "return %L", body2);
        }
        Iterable $this$map$iv = methodBuilders;
        boolean $i$f$map = false;
        $this$createValidateMigration_u24lambda_u246 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            methodScope = (XFunSpec.Builder)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.build());
        }
        return (List)destination$iv$iv;
    }

    private final XFunSpec createOnCreate(CodeGenScope scope) {
        XFunSpec.Builder builder2;
        XFunSpec.Builder $this$createOnCreate_u24lambda_u248 = builder2 = XFunSpec.Companion.builder$default((XFunSpec.Companion)XFunSpec.Companion, (CodeLanguage)scope.getLanguage(), (String)"onCreate", (VisibilityModifier)VisibilityModifier.PUBLIC, (boolean)false, (boolean)true, (int)8, null);
        boolean bl = false;
        XFunSpec.Builder.addParameter$default((XFunSpec.Builder)$this$createOnCreate_u24lambda_u248, (XTypeName)((XTypeName)SQLiteDriverTypeNames.INSTANCE.getCONNECTION()), (String)this.connectionParamName, null, (int)4, null);
        return builder2.build();
    }

    private final XFunSpec createOnOpen(CodeGenScope scope) {
        Object[] objectArray;
        XFunSpec.Builder builder2;
        XFunSpec.Builder $this$createOnOpen_u24lambda_u249 = builder2 = XFunSpec.Companion.builder$default((XFunSpec.Companion)XFunSpec.Companion, (CodeLanguage)scope.getLanguage(), (String)"onOpen", (VisibilityModifier)VisibilityModifier.PUBLIC, (boolean)false, (boolean)true, (int)8, null);
        boolean bl = false;
        XFunSpec.Builder.addParameter$default((XFunSpec.Builder)$this$createOnOpen_u24lambda_u249, (XTypeName)((XTypeName)SQLiteDriverTypeNames.INSTANCE.getCONNECTION()), (String)this.connectionParamName, null, (int)4, null);
        if (this.database.getEnableForeignKeys()) {
            objectArray = new Object[1];
            Object[] objectArray2 = new Object[]{"PRAGMA foreign_keys = ON"};
            objectArray[0] = XCodeBlock.Companion.ofExtensionCall(scope.getLanguage(), SQLiteDriverMemberNames.INSTANCE.getCONNECTION_EXEC_SQL(), this.connectionParamName, XCodeBlock.Companion.of(scope.getLanguage(), "%S", objectArray2));
            XFunSpec.Builder.Companion.addStatement($this$createOnOpen_u24lambda_u249, "%L", objectArray);
        }
        objectArray = new Object[]{this.connectionParamName};
        XFunSpec.Builder.Companion.addStatement($this$createOnOpen_u24lambda_u249, "internalInitInvalidationTracker(%L)", objectArray);
        return builder2.build();
    }

    private final XFunSpec createCreateAllTables(CodeGenScope scope) {
        XFunSpec.Builder builder2;
        XFunSpec.Builder $this$createCreateAllTables_u24lambda_u2411 = builder2 = XFunSpec.Companion.builder$default((XFunSpec.Companion)XFunSpec.Companion, (CodeLanguage)scope.getLanguage(), (String)"createAllTables", (VisibilityModifier)VisibilityModifier.PUBLIC, (boolean)false, (boolean)true, (int)8, null);
        boolean bl = false;
        XFunSpec.Builder.addParameter$default((XFunSpec.Builder)$this$createCreateAllTables_u24lambda_u2411, (XTypeName)((XTypeName)SQLiteDriverTypeNames.INSTANCE.getCONNECTION()), (String)this.connectionParamName, null, (int)4, null);
        Iterable $this$forEach$iv = this.database.getBundle().buildCreateQueries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String createQuery = (String)element$iv;
            boolean bl2 = false;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = new Object[]{createQuery};
            objectArray[0] = XCodeBlock.Companion.ofExtensionCall(scope.getLanguage(), SQLiteDriverMemberNames.INSTANCE.getCONNECTION_EXEC_SQL(), this.connectionParamName, XCodeBlock.Companion.of(scope.getLanguage(), "%S", objectArray2));
            XFunSpec.Builder.Companion.addStatement($this$createCreateAllTables_u24lambda_u2411, "%L", objectArray);
        }
        return builder2.build();
    }

    private final XFunSpec createDropAllTables(CodeGenScope scope) {
        Object[] objectArray;
        Object[] objectArray2;
        Pojo it;
        XFunSpec.Builder builder2;
        XFunSpec.Builder $this$createDropAllTables_u24lambda_u2414 = builder2 = XFunSpec.Companion.builder$default((XFunSpec.Companion)XFunSpec.Companion, (CodeLanguage)scope.getLanguage(), (String)"dropAllTables", (VisibilityModifier)VisibilityModifier.PUBLIC, (boolean)false, (boolean)true, (int)8, null);
        boolean bl = false;
        XFunSpec.Builder.addParameter$default((XFunSpec.Builder)$this$createDropAllTables_u24lambda_u2414, (XTypeName)((XTypeName)SQLiteDriverTypeNames.INSTANCE.getCONNECTION()), (String)this.connectionParamName, null, (int)4, null);
        Iterable $this$forEach$iv = this.database.getEntities();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Entity)element$iv;
            boolean bl2 = false;
            objectArray2 = new Object[1];
            objectArray = new Object[]{this.createDropTableQuery((Entity)it)};
            objectArray2[0] = XCodeBlock.Companion.ofExtensionCall(scope.getLanguage(), SQLiteDriverMemberNames.INSTANCE.getCONNECTION_EXEC_SQL(), this.connectionParamName, XCodeBlock.Companion.of(scope.getLanguage(), "%S", objectArray));
            XFunSpec.Builder.Companion.addStatement($this$createDropAllTables_u24lambda_u2414, "%L", objectArray2);
        }
        $this$forEach$iv = this.database.getViews();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (DatabaseView)element$iv;
            boolean bl3 = false;
            objectArray2 = new Object[1];
            objectArray = new Object[]{this.createDropViewQuery((DatabaseView)it)};
            objectArray2[0] = XCodeBlock.Companion.ofExtensionCall(scope.getLanguage(), SQLiteDriverMemberNames.INSTANCE.getCONNECTION_EXEC_SQL(), this.connectionParamName, XCodeBlock.Companion.of(scope.getLanguage(), "%S", objectArray));
            XFunSpec.Builder.Companion.addStatement($this$createDropAllTables_u24lambda_u2414, "%L", objectArray2);
        }
        return builder2.build();
    }

    private final XFunSpec createOnPreMigrate(CodeGenScope scope) {
        XFunSpec.Builder builder2;
        XFunSpec.Builder $this$createOnPreMigrate_u24lambda_u2415 = builder2 = XFunSpec.Companion.builder$default((XFunSpec.Companion)XFunSpec.Companion, (CodeLanguage)scope.getLanguage(), (String)"onPreMigrate", (VisibilityModifier)VisibilityModifier.PUBLIC, (boolean)false, (boolean)true, (int)8, null);
        boolean bl = false;
        XFunSpec.Builder.addParameter$default((XFunSpec.Builder)$this$createOnPreMigrate_u24lambda_u2415, (XTypeName)((XTypeName)SQLiteDriverTypeNames.INSTANCE.getCONNECTION()), (String)this.connectionParamName, null, (int)4, null);
        Object[] objectArray = new Object[]{RoomMemberNames.INSTANCE.getDB_UTIL_DROP_FTS_SYNC_TRIGGERS(), this.connectionParamName};
        XFunSpec.Builder.Companion.addStatement($this$createOnPreMigrate_u24lambda_u2415, "%M(%L)", objectArray);
        return builder2.build();
    }

    /*
     * WARNING - void declaration
     */
    private final XFunSpec createOnPostMigrate(CodeGenScope scope) {
        void $this$forEach$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        FtsEntity it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        XFunSpec.Builder builder2;
        XFunSpec.Builder $this$createOnPostMigrate_u24lambda_u2419 = builder2 = XFunSpec.Companion.builder$default((XFunSpec.Companion)XFunSpec.Companion, (CodeLanguage)scope.getLanguage(), (String)"onPostMigrate", (VisibilityModifier)VisibilityModifier.PUBLIC, (boolean)false, (boolean)true, (int)8, null);
        boolean bl = false;
        XFunSpec.Builder.addParameter$default((XFunSpec.Builder)$this$createOnPostMigrate_u24lambda_u2419, (XTypeName)((XTypeName)SQLiteDriverTypeNames.INSTANCE.getCONNECTION()), (String)this.connectionParamName, null, (int)4, null);
        Iterable iterable = CollectionsKt.filterIsInstance((Iterable)this.database.getEntities(), FtsEntity.class);
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (FtsEntity)element$iv$iv;
            boolean bl2 = false;
            if (!(it.getFtsOptions().getContentEntity() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (FtsEntity)element$iv$iv;
            boolean bl3 = false;
            Iterable list$iv$iv = it.getContentSyncTriggerCreateQueries();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String syncTriggerQuery = (String)element$iv;
            boolean bl4 = false;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = new Object[]{syncTriggerQuery};
            objectArray[0] = XCodeBlock.Companion.ofExtensionCall(scope.getLanguage(), SQLiteDriverMemberNames.INSTANCE.getCONNECTION_EXEC_SQL(), this.connectionParamName, XCodeBlock.Companion.of(scope.getLanguage(), "%S", objectArray2));
            XFunSpec.Builder.Companion.addStatement($this$createOnPostMigrate_u24lambda_u2419, "%L", objectArray);
        }
        return builder2.build();
    }

    @VisibleForTesting
    @NotNull
    public final String createTableQuery(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return entity.getCreateTableQuery();
    }

    @VisibleForTesting
    @NotNull
    public final String createViewQuery(@NotNull DatabaseView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        return view.getCreateViewQuery();
    }

    @VisibleForTesting
    @NotNull
    public final String createDropTableQuery(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return "DROP TABLE IF EXISTS `" + entity.getTableName() + "`";
    }

    @VisibleForTesting
    @NotNull
    public final String createDropViewQuery(@NotNull DatabaseView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        return "DROP VIEW IF EXISTS `" + view.getViewName() + "`";
    }
}

