/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.compiler.processing.XAnnotationBox;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XExecutableParameterElement;
import androidx.room.compiler.processing.XMethodElement;
import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.ext.Xelement_extKt;
import androidx.room.preconditions.Checks;
import androidx.room.processor.Context;
import androidx.room.processor.EntityProcessorKt;
import androidx.room.processor.FieldProcessor;
import androidx.room.processor.MethodProcessorDelegate;
import androidx.room.processor.MethodProcessorDelegateKt;
import androidx.room.processor.PojoProcessor;
import androidx.room.processor.ProcessorErrors;
import androidx.room.processor.ShortcutParameterProcessor;
import androidx.room.solver.shortcut.binder.DeleteOrUpdateMethodBinder;
import androidx.room.solver.shortcut.binder.InsertOrUpsertMethodBinder;
import androidx.room.vo.Entity;
import androidx.room.vo.Field;
import androidx.room.vo.HasFieldsKt;
import androidx.room.vo.Pojo;
import androidx.room.vo.ShortcutEntity;
import androidx.room.vo.ShortcutQueryParameter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ.\u0010\u0012\u001a\n\u0012\u0004\u0012\u0002H\u0014\u0018\u00010\u0013\"\b\b\u0000\u0010\u0014*\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00140\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\"\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001c0\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002JP\u0010 \u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001c0\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e0!2\b\u0010\"\u001a\u0004\u0018\u00010\u00052\u0006\u0010#\u001a\u00020\u00192\u0018\u0010$\u001a\u0014\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(0%JD\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010*\u001a\u00020&2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0018\u0010$\u001a\u0014\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(0%H\u0002J\u0006\u0010+\u001a\u00020\u0005J\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0005J\u001c\u0010/\u001a\u0002002\u0006\u0010.\u001a\u00020\u00052\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eJ\u001c\u00101\u001a\u0002002\u0006\u0010.\u001a\u00020\u00052\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eJ!\u00102\u001a\u0004\u0018\u00010&2\u0006\u00103\u001a\u0002042\f\u00105\u001a\b\u0012\u0004\u0012\u00020(06H\u0082\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u00067"}, d2={"Landroidx/room/processor/ShortcutMethodProcessor;", "", "baseContext", "Landroidx/room/processor/Context;", "containing", "Landroidx/room/compiler/processing/XType;", "executableElement", "Landroidx/room/compiler/processing/XMethodElement;", "(Landroidx/room/processor/Context;Landroidx/room/compiler/processing/XType;Landroidx/room/compiler/processing/XMethodElement;)V", "getContaining", "()Landroidx/room/compiler/processing/XType;", "context", "getContext", "()Landroidx/room/processor/Context;", "delegate", "Landroidx/room/processor/MethodProcessorDelegate;", "getExecutableElement", "()Landroidx/room/compiler/processing/XMethodElement;", "extractAnnotation", "Landroidx/room/compiler/processing/XAnnotationBox;", "T", "", "klass", "Lkotlin/reflect/KClass;", "errorMsg", "", "extractEntities", "", "Landroidx/room/vo/ShortcutEntity;", "params", "", "Landroidx/room/vo/ShortcutQueryParameter;", "extractParams", "Lkotlin/Pair;", "targetEntityType", "missingParamError", "onValidatePartialEntity", "Lkotlin/Function2;", "Landroidx/room/vo/Entity;", "Landroidx/room/vo/Pojo;", "", "extractPartialEntities", "targetEntity", "extractReturnType", "findDeleteOrUpdateMethodBinder", "Landroidx/room/solver/shortcut/binder/DeleteOrUpdateMethodBinder;", "returnType", "findInsertMethodBinder", "Landroidx/room/solver/shortcut/binder/InsertOrUpsertMethodBinder;", "findUpsertMethodBinder", "processEntity", "element", "Landroidx/room/compiler/processing/XTypeElement;", "onInvalid", "Lkotlin/Function0;", "room-compiler"})
@SourceDebugExtension(value={"SMAP\nShortcutMethodProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShortcutMethodProcessor.kt\nandroidx/room/processor/ShortcutMethodProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,241:1\n225#1,6:246\n225#1,6:275\n1549#2:242\n1620#2,3:243\n766#2:252\n857#2,2:253\n1208#2,2:255\n1238#2,2:257\n766#2:259\n857#2,2:260\n1855#2,2:262\n1241#2:264\n1603#2,9:265\n1855#2:274\n1856#2:282\n1612#2:283\n1#3:281\n*S KotlinDebug\n*F\n+ 1 ShortcutMethodProcessor.kt\nandroidx/room/processor/ShortcutMethodProcessor\n*L\n94#1:246,6\n209#1:275,6\n74#1:242\n74#1:243,3\n111#1:252\n111#1:253,2\n128#1:255,2\n128#1:257,2\n157#1:259\n157#1:260,2\n161#1:262,2\n128#1:264\n199#1:265,9\n199#1:274\n199#1:282\n199#1:283\n199#1:281\n*E\n"})
public final class ShortcutMethodProcessor {
    @NotNull
    private final XType containing;
    @NotNull
    private final XMethodElement executableElement;
    @NotNull
    private final Context context;
    @NotNull
    private final MethodProcessorDelegate delegate;

    public ShortcutMethodProcessor(@NotNull Context baseContext, @NotNull XType containing, @NotNull XMethodElement executableElement) {
        Intrinsics.checkNotNullParameter((Object)baseContext, (String)"baseContext");
        Intrinsics.checkNotNullParameter((Object)containing, (String)"containing");
        Intrinsics.checkNotNullParameter((Object)executableElement, (String)"executableElement");
        this.containing = containing;
        this.executableElement = executableElement;
        this.context = Context.fork$default(baseContext, (XElement)this.executableElement, null, null, 6, null);
        this.delegate = MethodProcessorDelegate.Companion.createFor(this.context, this.containing, this.executableElement);
    }

    @NotNull
    public final XType getContaining() {
        return this.containing;
    }

    @NotNull
    public final XMethodElement getExecutableElement() {
        return this.executableElement;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Nullable
    public final <T extends Annotation> XAnnotationBox<T> extractAnnotation(@NotNull KClass<T> klass, @NotNull String errorMsg) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)errorMsg, (String)"errorMsg");
        XAnnotationBox annotation = this.executableElement.getAnnotation(klass);
        this.context.getChecker().check(annotation != null, (XElement)this.executableElement, errorMsg, new Object[0]);
        return annotation;
    }

    @NotNull
    public final XType extractReturnType() {
        XType returnType = this.delegate.extractReturnType();
        boolean returnsDeferredType = MethodProcessorDelegateKt.returnsDeferredType(this.delegate);
        boolean isSuspendFunction = this.delegate.getExecutableElement().isSuspendFunction();
        Checks checks = this.context.getChecker();
        boolean bl = !isSuspendFunction || !returnsDeferredType;
        XElement xElement = (XElement)this.executableElement;
        String string = returnType.getRawType().getTypeName().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        checks.check(bl, xElement, ProcessorErrors.INSTANCE.suspendReturnsDeferredType(string), new Object[0]);
        if (!(isSuspendFunction || returnsDeferredType || this.context.isAndroidOnlyTarget())) {
            this.context.getLogger().e((XElement)this.executableElement, ProcessorErrors.INSTANCE.getINVALID_BLOCKING_DAO_FUNCTION_NON_ANDROID(), new Object[0]);
        }
        return returnType;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public final Pair<Map<String, ShortcutEntity>, List<ShortcutQueryParameter>> extractParams(@Nullable XType targetEntityType, @NotNull String missingParamError, @NotNull Function2<? super Entity, ? super Pojo, Unit> onValidatePartialEntity) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Object this_$iv;
        Entity entity;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)missingParamError, (String)"missingParamError");
        Intrinsics.checkNotNullParameter(onValidatePartialEntity, (String)"onValidatePartialEntity");
        Iterable $this$map$iv = this.delegate.extractParams();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            XExecutableParameterElement xExecutableParameterElement = (XExecutableParameterElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ShortcutParameterProcessor(this.context, this.containing, (XExecutableParameterElement)it).process());
        }
        List params2 = (List)destination$iv$iv;
        this.context.getChecker().check(!((Collection)params2).isEmpty(), (XElement)this.executableElement, missingParamError, new Object[0]);
        if (targetEntityType != null && !targetEntityType.isTypeOf(Reflection.getOrCreateKotlinClass(Object.class))) {
            XTypeElement targetTypeElement = targetEntityType.getTypeElement();
            if (targetTypeElement == null) {
                this.context.getLogger().e((XElement)this.executableElement, ProcessorErrors.INSTANCE.getINVALID_TARGET_ENTITY_IN_SHORTCUT_METHOD(), new Object[0]);
                entity = null;
            } else {
                this_$iv = this;
                boolean $i$f$processEntity = false;
                if (!Xelement_extKt.isEntityElement((XElement)targetTypeElement)) {
                    boolean bl = false;
                    this.context.getLogger().e((XElement)this.executableElement, ProcessorErrors.INSTANCE.getINVALID_TARGET_ENTITY_IN_SHORTCUT_METHOD(), new Object[0]);
                    return TuplesKt.to((Object)MapsKt.emptyMap(), (Object)CollectionsKt.emptyList());
                }
                entity = EntityProcessorKt.EntityProcessor$default(((ShortcutMethodProcessor)this_$iv).context, targetTypeElement, null, 4, null).process();
            }
        } else {
            entity = null;
        }
        Entity targetEntity = entity;
        this_$iv = params2;
        boolean $i$f$filter = false;
        void bl = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ShortcutQueryParameter it = (ShortcutQueryParameter)element$iv$iv;
            boolean bl2 = false;
            if (!(it.getPojoType() != null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List it = (List)destination$iv$iv2;
        boolean bl3 = false;
        Map<String, ShortcutEntity> entities = targetEntity != null ? this.extractPartialEntities(targetEntity, it, onValidatePartialEntity) : this.extractEntities(it);
        return new Pair(entities, (Object)params2);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, ShortcutEntity> extractPartialEntities(Entity targetEntity, List<ShortcutQueryParameter> params2, Function2<? super Entity, ? super Pojo, Unit> onValidatePartialEntity) {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = params2;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            ShortcutEntity shortcutEntity;
            void param;
            ShortcutQueryParameter shortcutQueryParameter = (ShortcutQueryParameter)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            ShortcutQueryParameter it = (ShortcutQueryParameter)element$iv$iv;
            String string = it.getName();
            boolean bl2 = false;
            XType xType = targetEntity.getType();
            XType xType2 = param.getPojoType();
            Intrinsics.checkNotNull((Object)xType2);
            if (xType.isSameType(xType2)) {
                shortcutEntity = new ShortcutEntity(targetEntity, null);
            } else {
                Pojo pojo;
                XTypeElement pojoTypeElement = param.getPojoType().getTypeElement();
                if (pojoTypeElement == null) {
                    this.context.getLogger().e((XElement)targetEntity.getElement(), ProcessorErrors.INSTANCE.shortcutMethodArgumentMustBeAClass(param.getPojoType().asTypeName().toString(this.context.getCodeLanguage())), new Object[0]);
                    pojo = null;
                } else {
                    void $this$forEach$iv;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    Pojo pojo2;
                    Pojo pojo3 = pojo2 = PojoProcessor.Companion.createFor$default(PojoProcessor.Companion, this.context, pojoTypeElement, FieldProcessor.BindingScope.BIND_TO_STMT, null, null, 16, null).process();
                    boolean bl3 = false;
                    Iterable iterable2 = pojo3.getFields();
                    boolean $i$f$filter = false;
                    Iterator iterator = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                        Field it2 = (Field)element$iv$iv2;
                        boolean bl4 = false;
                        boolean bl5 = HasFieldsKt.findFieldByColumnName(targetEntity, it2.getColumnName()) == null;
                        if (!bl5) continue;
                        destination$iv$iv2.add(element$iv$iv2);
                    }
                    $this$filter$iv = (List)destination$iv$iv2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Field it3 = (Field)element$iv;
                        boolean bl6 = false;
                        this.context.getLogger().e((XElement)it3.getElement(), ProcessorErrors.INSTANCE.cannotFindAsEntityField(targetEntity.getTypeName().toString(this.context.getCodeLanguage())), new Object[0]);
                    }
                    if (!((Collection)pojo3.getRelations()).isEmpty()) {
                        this.context.getLogger().e((XElement)pojo3.getElement(), ProcessorErrors.INSTANCE.getINVALID_RELATION_IN_PARTIAL_ENTITY(), new Object[0]);
                    }
                    if (pojo3.getFields().isEmpty()) {
                        this.context.getLogger().e((XElement)this.executableElement, ProcessorErrors.INSTANCE.noColumnsInPartialEntity(pojo3.getTypeName().toString(this.context.getCodeLanguage())), new Object[0]);
                    }
                    onValidatePartialEntity.invoke((Object)targetEntity, (Object)pojo3);
                    pojo = pojo2;
                }
                Pojo pojo4 = pojo;
                shortcutEntity = new ShortcutEntity(targetEntity, pojo4);
            }
            ShortcutEntity shortcutEntity2 = shortcutEntity;
            map.put(string, shortcutEntity2);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, ShortcutEntity> extractEntities(List<ShortcutQueryParameter> params2) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = params2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            XTypeElement entityTypeElement;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ShortcutQueryParameter it = (ShortcutQueryParameter)element$iv$iv;
            boolean bl2 = false;
            XType xType = it.getPojoType();
            Object object = entityTypeElement = xType != null ? xType.getTypeElement() : null;
            if (entityTypeElement == null) {
                this.context.getLogger().e((XElement)it.getElement(), ProcessorErrors.INSTANCE.getCANNOT_FIND_ENTITY_FOR_SHORTCUT_QUERY_PARAMETER(), new Object[0]);
                pair = null;
            } else {
                ShortcutMethodProcessor this_$iv = this;
                boolean $i$f$processEntity = false;
                if (!Xelement_extKt.isEntityElement((XElement)entityTypeElement)) {
                    boolean bl3 = false;
                    this.context.getLogger().e((XElement)it.getElement(), ProcessorErrors.INSTANCE.getCANNOT_FIND_ENTITY_FOR_SHORTCUT_QUERY_PARAMETER(), new Object[0]);
                    pair = null;
                } else {
                    Entity entity = EntityProcessorKt.EntityProcessor$default(this_$iv.context, entityTypeElement, null, 4, null).process();
                    String string = it.getName();
                    Entity entity2 = entity;
                    Intrinsics.checkNotNull((Object)entity2);
                    pair = TuplesKt.to((Object)string, (Object)new ShortcutEntity(entity2, null));
                }
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final Entity processEntity(XTypeElement element, Function0<Unit> onInvalid) {
        Entity entity;
        boolean $i$f$processEntity = false;
        if (Xelement_extKt.isEntityElement((XElement)element)) {
            entity = EntityProcessorKt.EntityProcessor$default(this.context, element, null, 4, null).process();
        } else {
            onInvalid.invoke();
            entity = null;
        }
        return entity;
    }

    @NotNull
    public final InsertOrUpsertMethodBinder findInsertMethodBinder(@NotNull XType returnType, @NotNull List<ShortcutQueryParameter> params2) {
        Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
        Intrinsics.checkNotNullParameter(params2, (String)"params");
        return this.delegate.findInsertMethodBinder(returnType, params2);
    }

    @NotNull
    public final InsertOrUpsertMethodBinder findUpsertMethodBinder(@NotNull XType returnType, @NotNull List<ShortcutQueryParameter> params2) {
        Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
        Intrinsics.checkNotNullParameter(params2, (String)"params");
        return this.delegate.findUpsertMethodBinder(returnType, params2);
    }

    @NotNull
    public final DeleteOrUpdateMethodBinder findDeleteOrUpdateMethodBinder(@NotNull XType returnType) {
        Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
        return this.delegate.findDeleteOrUpdateMethodBinder(returnType);
    }
}

