/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.text.tx3g;

import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.text.style.TypefaceSpan;
import android.text.style.UnderlineSpan;
import androidx.media3.common.text.Cue;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Consumer;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.extractor.text.CuesWithTiming;
import androidx.media3.extractor.text.SubtitleParser;
import com.google.common.collect.ImmutableList;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;

@UnstableApi
public final class Tx3gParser
implements SubtitleParser {
    public static final int CUE_REPLACEMENT_BEHAVIOR = 2;
    private static final String TAG = "Tx3gParser";
    private static final int TYPE_STYL = 1937013100;
    private static final int TYPE_TBOX = 1952608120;
    private static final String TX3G_SERIF = "Serif";
    private static final int SIZE_ATOM_HEADER = 8;
    private static final int SIZE_SHORT = 2;
    private static final int SIZE_STYLE_RECORD = 12;
    private static final int FONT_FACE_BOLD = 1;
    private static final int FONT_FACE_ITALIC = 2;
    private static final int FONT_FACE_UNDERLINE = 4;
    private static final int SPAN_PRIORITY_LOW = 0xFF0000;
    private static final int SPAN_PRIORITY_HIGH = 0;
    private static final int DEFAULT_FONT_FACE = 0;
    private static final int DEFAULT_COLOR = -1;
    private static final String DEFAULT_FONT_FAMILY = "sans-serif";
    private static final float DEFAULT_VERTICAL_PLACEMENT = 0.85f;
    private final ParsableByteArray parsableByteArray = new ParsableByteArray();
    private final boolean customVerticalPlacement;
    private final int defaultFontFace;
    private final int defaultColorRgba;
    private final String defaultFontFamily;
    private final float defaultVerticalPlacement;
    private final int calculatedVideoTrackHeight;

    public Tx3gParser(List<byte[]> initializationData) {
        if (initializationData.size() == 1 && (initializationData.get(0).length == 48 || initializationData.get(0).length == 53)) {
            byte[] initializationBytes = initializationData.get(0);
            this.defaultFontFace = initializationBytes[24];
            this.defaultColorRgba = (initializationBytes[26] & 0xFF) << 24 | (initializationBytes[27] & 0xFF) << 16 | (initializationBytes[28] & 0xFF) << 8 | initializationBytes[29] & 0xFF;
            String fontFamily = Util.fromUtf8Bytes((byte[])initializationBytes, (int)43, (int)(initializationBytes.length - 43));
            this.defaultFontFamily = TX3G_SERIF.equals(fontFamily) ? "serif" : DEFAULT_FONT_FAMILY;
            this.calculatedVideoTrackHeight = 20 * initializationBytes[25];
            boolean bl = this.customVerticalPlacement = (initializationBytes[0] & 0x20) != 0;
            if (this.customVerticalPlacement) {
                int requestedVerticalPlacement = (initializationBytes[10] & 0xFF) << 8 | initializationBytes[11] & 0xFF;
                this.defaultVerticalPlacement = Util.constrainValue((float)((float)requestedVerticalPlacement / (float)this.calculatedVideoTrackHeight), (float)0.0f, (float)0.95f);
            } else {
                this.defaultVerticalPlacement = 0.85f;
            }
        } else {
            this.defaultFontFace = 0;
            this.defaultColorRgba = -1;
            this.defaultFontFamily = DEFAULT_FONT_FAMILY;
            this.customVerticalPlacement = false;
            this.defaultVerticalPlacement = 0.85f;
            this.calculatedVideoTrackHeight = -1;
        }
    }

    @Override
    public int getCueReplacementBehavior() {
        return 2;
    }

    @Override
    public void parse(byte[] data, int offset, int length, SubtitleParser.OutputOptions outputOptions, Consumer<CuesWithTiming> output) {
        this.parsableByteArray.reset(data, offset + length);
        this.parsableByteArray.setPosition(offset);
        String cueTextString = Tx3gParser.readSubtitleText(this.parsableByteArray);
        if (cueTextString.isEmpty()) {
            output.accept((Object)new CuesWithTiming((List<Cue>)ImmutableList.of(), -9223372036854775807L, -9223372036854775807L));
            return;
        }
        SpannableStringBuilder cueText = new SpannableStringBuilder((CharSequence)cueTextString);
        Tx3gParser.attachFontFace(cueText, this.defaultFontFace, 0, 0, cueText.length(), 0xFF0000);
        Tx3gParser.attachColor(cueText, this.defaultColorRgba, -1, 0, cueText.length(), 0xFF0000);
        Tx3gParser.attachFontFamily(cueText, this.defaultFontFamily, 0, cueText.length());
        float verticalPlacement = this.defaultVerticalPlacement;
        while (this.parsableByteArray.bytesLeft() >= 8) {
            int position = this.parsableByteArray.getPosition();
            int atomSize = this.parsableByteArray.readInt();
            int atomType = this.parsableByteArray.readInt();
            if (atomType == 1937013100) {
                Assertions.checkArgument((this.parsableByteArray.bytesLeft() >= 2 ? 1 : 0) != 0);
                int styleRecordCount = this.parsableByteArray.readUnsignedShort();
                for (int i = 0; i < styleRecordCount; ++i) {
                    this.applyStyleRecord(this.parsableByteArray, cueText);
                }
            } else if (atomType == 1952608120 && this.customVerticalPlacement) {
                Assertions.checkArgument((this.parsableByteArray.bytesLeft() >= 2 ? 1 : 0) != 0);
                int requestedVerticalPlacement = this.parsableByteArray.readUnsignedShort();
                verticalPlacement = (float)requestedVerticalPlacement / (float)this.calculatedVideoTrackHeight;
                verticalPlacement = Util.constrainValue((float)verticalPlacement, (float)0.0f, (float)0.95f);
            }
            this.parsableByteArray.setPosition(position + atomSize);
        }
        Cue cue = new Cue.Builder().setText((CharSequence)cueText).setLine(verticalPlacement, 0).setLineAnchor(0).build();
        output.accept((Object)new CuesWithTiming((List<Cue>)ImmutableList.of((Object)cue), -9223372036854775807L, -9223372036854775807L));
    }

    private static String readSubtitleText(ParsableByteArray parsableByteArray) {
        Assertions.checkArgument((parsableByteArray.bytesLeft() >= 2 ? 1 : 0) != 0);
        int textLength = parsableByteArray.readUnsignedShort();
        if (textLength == 0) {
            return "";
        }
        int textStartPosition = parsableByteArray.getPosition();
        Charset charset = parsableByteArray.readUtfCharsetFromBom();
        int bomSize = parsableByteArray.getPosition() - textStartPosition;
        return parsableByteArray.readString(textLength - bomSize, charset != null ? charset : StandardCharsets.UTF_8);
    }

    private void applyStyleRecord(ParsableByteArray parsableByteArray, SpannableStringBuilder cueText) {
        Assertions.checkArgument((parsableByteArray.bytesLeft() >= 12 ? 1 : 0) != 0);
        int start = parsableByteArray.readUnsignedShort();
        int end = parsableByteArray.readUnsignedShort();
        parsableByteArray.skipBytes(2);
        int fontFace = parsableByteArray.readUnsignedByte();
        parsableByteArray.skipBytes(1);
        int colorRgba = parsableByteArray.readInt();
        if (end > cueText.length()) {
            Log.w((String)TAG, (String)("Truncating styl end (" + end + ") to cueText.length() (" + cueText.length() + ")."));
            end = cueText.length();
        }
        if (start >= end) {
            Log.w((String)TAG, (String)("Ignoring styl with start (" + start + ") >= end (" + end + ")."));
            return;
        }
        Tx3gParser.attachFontFace(cueText, fontFace, this.defaultFontFace, start, end, 0);
        Tx3gParser.attachColor(cueText, colorRgba, this.defaultColorRgba, start, end, 0);
    }

    private static void attachFontFace(SpannableStringBuilder cueText, int fontFace, int defaultFontFace, int start, int end, int spanPriority) {
        if (fontFace != defaultFontFace) {
            boolean isUnderlined;
            boolean isItalic;
            int flags = 0x21 | spanPriority;
            boolean isBold = (fontFace & 1) != 0;
            boolean bl = isItalic = (fontFace & 2) != 0;
            if (isBold) {
                if (isItalic) {
                    cueText.setSpan((Object)new StyleSpan(3), start, end, flags);
                } else {
                    cueText.setSpan((Object)new StyleSpan(1), start, end, flags);
                }
            } else if (isItalic) {
                cueText.setSpan((Object)new StyleSpan(2), start, end, flags);
            }
            boolean bl2 = isUnderlined = (fontFace & 4) != 0;
            if (isUnderlined) {
                cueText.setSpan((Object)new UnderlineSpan(), start, end, flags);
            }
            if (!(isUnderlined || isBold || isItalic)) {
                cueText.setSpan((Object)new StyleSpan(0), start, end, flags);
            }
        }
    }

    private static void attachColor(SpannableStringBuilder cueText, int colorRgba, int defaultColorRgba, int start, int end, int spanPriority) {
        if (colorRgba != defaultColorRgba) {
            int colorArgb = (colorRgba & 0xFF) << 24 | colorRgba >>> 8;
            cueText.setSpan((Object)new ForegroundColorSpan(colorArgb), start, end, 0x21 | spanPriority);
        }
    }

    private static void attachFontFamily(SpannableStringBuilder cueText, String fontFamily, int start, int end) {
        if (fontFamily != DEFAULT_FONT_FAMILY) {
            cueText.setSpan((Object)new TypefaceSpan(fontFamily), start, end, 16711713);
        }
    }
}

