/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.text.subrip;

import android.text.Html;
import android.text.Spanned;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.media3.common.text.Cue;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Consumer;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.extractor.text.CuesWithTiming;
import androidx.media3.extractor.text.SubtitleParser;
import com.google.common.collect.ImmutableList;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@UnstableApi
public final class SubripParser
implements SubtitleParser {
    public static final int CUE_REPLACEMENT_BEHAVIOR = 1;
    private static final float START_FRACTION = 0.08f;
    private static final float END_FRACTION = 0.92f;
    private static final float MID_FRACTION = 0.5f;
    private static final String TAG = "SubripParser";
    private static final String SUBRIP_TIMECODE = "(?:(\\d+):)?(\\d+):(\\d+)(?:,(\\d+))?";
    private static final Pattern SUBRIP_TIMING_LINE = Pattern.compile("\\s*((?:(\\d+):)?(\\d+):(\\d+)(?:,(\\d+))?)\\s*-->\\s*((?:(\\d+):)?(\\d+):(\\d+)(?:,(\\d+))?)\\s*");
    private static final Pattern SUBRIP_TAG_PATTERN = Pattern.compile("\\{\\\\.*?\\}");
    private static final String SUBRIP_ALIGNMENT_TAG = "\\{\\\\an[1-9]\\}";
    private static final String ALIGN_BOTTOM_LEFT = "{\\an1}";
    private static final String ALIGN_BOTTOM_MID = "{\\an2}";
    private static final String ALIGN_BOTTOM_RIGHT = "{\\an3}";
    private static final String ALIGN_MID_LEFT = "{\\an4}";
    private static final String ALIGN_MID_MID = "{\\an5}";
    private static final String ALIGN_MID_RIGHT = "{\\an6}";
    private static final String ALIGN_TOP_LEFT = "{\\an7}";
    private static final String ALIGN_TOP_MID = "{\\an8}";
    private static final String ALIGN_TOP_RIGHT = "{\\an9}";
    private final StringBuilder textBuilder = new StringBuilder();
    private final ArrayList<String> tags = new ArrayList();
    private final ParsableByteArray parsableByteArray = new ParsableByteArray();

    @Override
    public int getCueReplacementBehavior() {
        return 1;
    }

    @Override
    public void parse(byte[] data, int offset, int length, SubtitleParser.OutputOptions outputOptions, Consumer<CuesWithTiming> output) {
        String currentLine;
        ArrayList<CuesWithTiming> cuesWithTimingBeforeRequestedStartTimeUs;
        this.parsableByteArray.reset(data, offset + length);
        this.parsableByteArray.setPosition(offset);
        Charset charset = this.detectUtfCharset(this.parsableByteArray);
        ArrayList<CuesWithTiming> arrayList = cuesWithTimingBeforeRequestedStartTimeUs = outputOptions.startTimeUs != -9223372036854775807L && outputOptions.outputAllCues ? new ArrayList<CuesWithTiming>() : null;
        while ((currentLine = this.parsableByteArray.readLine(charset)) != null) {
            if (currentLine.length() == 0) continue;
            try {
                Integer.parseInt(currentLine);
            }
            catch (NumberFormatException e) {
                Log.w((String)TAG, (String)("Skipping invalid index: " + currentLine));
                continue;
            }
            currentLine = this.parsableByteArray.readLine(charset);
            if (currentLine == null) {
                Log.w((String)TAG, (String)"Unexpected end");
                break;
            }
            Matcher matcher = SUBRIP_TIMING_LINE.matcher(currentLine);
            if (!matcher.matches()) {
                Log.w((String)TAG, (String)("Skipping invalid timing: " + currentLine));
                continue;
            }
            long startTimeUs = SubripParser.parseTimecode(matcher, 1);
            long endTimeUs = SubripParser.parseTimecode(matcher, 6);
            this.textBuilder.setLength(0);
            this.tags.clear();
            currentLine = this.parsableByteArray.readLine(charset);
            while (!TextUtils.isEmpty((CharSequence)currentLine)) {
                if (this.textBuilder.length() > 0) {
                    this.textBuilder.append("<br>");
                }
                this.textBuilder.append(this.processLine(currentLine, this.tags));
                currentLine = this.parsableByteArray.readLine(charset);
            }
            Spanned text = Html.fromHtml((String)this.textBuilder.toString());
            String alignmentTag = null;
            for (int i = 0; i < this.tags.size(); ++i) {
                String tag = this.tags.get(i);
                if (!tag.matches(SUBRIP_ALIGNMENT_TAG)) continue;
                alignmentTag = tag;
                break;
            }
            if (outputOptions.startTimeUs == -9223372036854775807L || startTimeUs >= outputOptions.startTimeUs) {
                output.accept((Object)new CuesWithTiming((List<Cue>)ImmutableList.of((Object)this.buildCue(text, alignmentTag)), startTimeUs, endTimeUs - startTimeUs));
                continue;
            }
            if (cuesWithTimingBeforeRequestedStartTimeUs == null) continue;
            cuesWithTimingBeforeRequestedStartTimeUs.add(new CuesWithTiming((List<Cue>)ImmutableList.of((Object)this.buildCue(text, alignmentTag)), startTimeUs, endTimeUs - startTimeUs));
        }
        if (cuesWithTimingBeforeRequestedStartTimeUs != null) {
            for (CuesWithTiming cuesWithTiming : cuesWithTimingBeforeRequestedStartTimeUs) {
                output.accept((Object)cuesWithTiming);
            }
        }
    }

    private Charset detectUtfCharset(ParsableByteArray data) {
        Charset charset = data.readUtfCharsetFromBom();
        return charset != null ? charset : StandardCharsets.UTF_8;
    }

    private String processLine(String line, ArrayList<String> tags) {
        line = line.trim();
        int removedCharacterCount = 0;
        StringBuilder processedLine = new StringBuilder(line);
        Matcher matcher = SUBRIP_TAG_PATTERN.matcher(line);
        while (matcher.find()) {
            String tag = matcher.group();
            tags.add(tag);
            int start = matcher.start() - removedCharacterCount;
            int tagLength = tag.length();
            processedLine.replace(start, start + tagLength, "");
            removedCharacterCount += tagLength;
        }
        return processedLine.toString();
    }

    private Cue buildCue(Spanned text, @Nullable String alignmentTag) {
        Cue.Builder cue = new Cue.Builder().setText((CharSequence)text);
        if (alignmentTag == null) {
            return cue.build();
        }
        switch (alignmentTag) {
            case "{\\an1}": 
            case "{\\an4}": 
            case "{\\an7}": {
                cue.setPositionAnchor(0);
                break;
            }
            case "{\\an3}": 
            case "{\\an6}": 
            case "{\\an9}": {
                cue.setPositionAnchor(2);
                break;
            }
            default: {
                cue.setPositionAnchor(1);
            }
        }
        switch (alignmentTag) {
            case "{\\an1}": 
            case "{\\an2}": 
            case "{\\an3}": {
                cue.setLineAnchor(2);
                break;
            }
            case "{\\an7}": 
            case "{\\an8}": 
            case "{\\an9}": {
                cue.setLineAnchor(0);
                break;
            }
            default: {
                cue.setLineAnchor(1);
            }
        }
        return cue.setPosition(SubripParser.getFractionalPositionForAnchorType(cue.getPositionAnchor())).setLine(SubripParser.getFractionalPositionForAnchorType(cue.getLineAnchor()), 0).build();
    }

    private static long parseTimecode(Matcher matcher, int groupOffset) {
        String hours = matcher.group(groupOffset + 1);
        long timestampMs = hours != null ? Long.parseLong(hours) * 60L * 60L * 1000L : 0L;
        timestampMs += Long.parseLong((String)Assertions.checkNotNull((Object)matcher.group(groupOffset + 2))) * 60L * 1000L;
        timestampMs += Long.parseLong((String)Assertions.checkNotNull((Object)matcher.group(groupOffset + 3))) * 1000L;
        String millis = matcher.group(groupOffset + 4);
        if (millis != null) {
            timestampMs += Long.parseLong(millis);
        }
        return timestampMs * 1000L;
    }

    @VisibleForTesting(otherwise=2)
    public static float getFractionalPositionForAnchorType(int anchorType) {
        switch (anchorType) {
            case 0: {
                return 0.08f;
            }
            case 1: {
                return 0.5f;
            }
            case 2: {
                return 0.92f;
            }
        }
        throw new IllegalArgumentException();
    }
}

