/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.avi;

import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Util;
import androidx.media3.extractor.ExtractorInput;
import androidx.media3.extractor.SeekMap;
import androidx.media3.extractor.SeekPoint;
import androidx.media3.extractor.TrackOutput;
import java.io.IOException;
import java.util.Arrays;

final class ChunkReader {
    private static final int INITIAL_INDEX_SIZE = 512;
    private static final int CHUNK_TYPE_VIDEO_COMPRESSED = 1667497984;
    private static final int CHUNK_TYPE_VIDEO_UNCOMPRESSED = 1650720768;
    private static final int CHUNK_TYPE_AUDIO = 1651965952;
    protected final TrackOutput trackOutput;
    private final int chunkId;
    private final int alternativeChunkId;
    private final long durationUs;
    private final int streamHeaderChunkCount;
    private int currentChunkSize;
    private int bytesRemainingInCurrentChunk;
    private int currentChunkIndex;
    private int indexChunkCount;
    private int indexSize;
    private long firstIndexChunkOffset;
    private long[] keyFrameOffsets;
    private int[] keyFrameIndices;

    public ChunkReader(int id, int trackType, long durationUs, int streamHeaderChunkCount, TrackOutput trackOutput) {
        Assertions.checkArgument((trackType == 1 || trackType == 2 ? 1 : 0) != 0);
        this.durationUs = durationUs;
        this.streamHeaderChunkCount = streamHeaderChunkCount;
        this.trackOutput = trackOutput;
        int chunkType = trackType == 2 ? 1667497984 : 1651965952;
        this.chunkId = ChunkReader.getChunkIdFourCc(id, chunkType);
        this.alternativeChunkId = trackType == 2 ? ChunkReader.getChunkIdFourCc(id, 1650720768) : -1;
        this.firstIndexChunkOffset = -1L;
        this.keyFrameOffsets = new long[512];
        this.keyFrameIndices = new int[512];
    }

    public void appendIndexChunk(long offset, boolean isKeyFrame) {
        if (this.firstIndexChunkOffset == -1L) {
            this.firstIndexChunkOffset = offset;
        }
        if (isKeyFrame) {
            if (this.indexSize == this.keyFrameIndices.length) {
                this.keyFrameOffsets = Arrays.copyOf(this.keyFrameOffsets, this.keyFrameOffsets.length * 3 / 2);
                this.keyFrameIndices = Arrays.copyOf(this.keyFrameIndices, this.keyFrameIndices.length * 3 / 2);
            }
            this.keyFrameOffsets[this.indexSize] = offset;
            this.keyFrameIndices[this.indexSize] = this.indexChunkCount;
            ++this.indexSize;
        }
        ++this.indexChunkCount;
    }

    public void advanceCurrentChunk() {
        ++this.currentChunkIndex;
    }

    public long getCurrentChunkTimestampUs() {
        return this.getChunkTimestampUs(this.currentChunkIndex);
    }

    public long getFrameDurationUs() {
        return this.getChunkTimestampUs(1);
    }

    public void compactIndex() {
        this.keyFrameOffsets = Arrays.copyOf(this.keyFrameOffsets, this.indexSize);
        this.keyFrameIndices = Arrays.copyOf(this.keyFrameIndices, this.indexSize);
    }

    public boolean handlesChunkId(int chunkId) {
        return this.chunkId == chunkId || this.alternativeChunkId == chunkId;
    }

    public boolean isCurrentFrameAKeyFrame() {
        return Arrays.binarySearch(this.keyFrameIndices, this.currentChunkIndex) >= 0;
    }

    public boolean isVideo() {
        return (this.chunkId & 0x63640000) == 1667497984;
    }

    public boolean isAudio() {
        return (this.chunkId & 0x62770000) == 1651965952;
    }

    public void onChunkStart(int size) {
        this.currentChunkSize = size;
        this.bytesRemainingInCurrentChunk = size;
    }

    public boolean onChunkData(ExtractorInput input) throws IOException {
        boolean done;
        this.bytesRemainingInCurrentChunk -= this.trackOutput.sampleData(input, this.bytesRemainingInCurrentChunk, false);
        boolean bl = done = this.bytesRemainingInCurrentChunk == 0;
        if (done) {
            if (this.currentChunkSize > 0) {
                this.trackOutput.sampleMetadata(this.getCurrentChunkTimestampUs(), this.isCurrentFrameAKeyFrame() ? 1 : 0, this.currentChunkSize, 0, null);
            }
            this.advanceCurrentChunk();
        }
        return done;
    }

    public void seekToPosition(long position) {
        if (this.indexSize == 0) {
            this.currentChunkIndex = 0;
        } else {
            int index = Util.binarySearchFloor((long[])this.keyFrameOffsets, (long)position, (boolean)true, (boolean)true);
            this.currentChunkIndex = this.keyFrameIndices[index];
        }
    }

    public SeekMap.SeekPoints getSeekPoints(long timeUs) {
        if (this.indexSize == 0) {
            return new SeekMap.SeekPoints(new SeekPoint(0L, this.firstIndexChunkOffset));
        }
        int targetFrameIndex = (int)(timeUs / this.getFrameDurationUs());
        int keyFrameIndex = Util.binarySearchFloor((int[])this.keyFrameIndices, (int)targetFrameIndex, (boolean)true, (boolean)true);
        if (this.keyFrameIndices[keyFrameIndex] == targetFrameIndex) {
            return new SeekMap.SeekPoints(this.getSeekPoint(keyFrameIndex));
        }
        SeekPoint precedingKeyFrameSeekPoint = this.getSeekPoint(keyFrameIndex);
        if (keyFrameIndex + 1 < this.keyFrameOffsets.length) {
            return new SeekMap.SeekPoints(precedingKeyFrameSeekPoint, this.getSeekPoint(keyFrameIndex + 1));
        }
        return new SeekMap.SeekPoints(precedingKeyFrameSeekPoint);
    }

    private long getChunkTimestampUs(int chunkIndex) {
        return this.durationUs * (long)chunkIndex / (long)this.streamHeaderChunkCount;
    }

    private SeekPoint getSeekPoint(int keyFrameIndex) {
        return new SeekPoint((long)this.keyFrameIndices[keyFrameIndex] * this.getFrameDurationUs(), this.keyFrameOffsets[keyFrameIndex]);
    }

    private static int getChunkIdFourCc(int streamId, int chunkType) {
        int tens = streamId / 10;
        int ones = streamId % 10;
        return 48 + ones << 8 | 48 + tens | chunkType;
    }
}

