/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor;

import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.LongArray;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.extractor.SeekMap;
import androidx.media3.extractor.SeekPoint;

@UnstableApi
public final class IndexSeekMap
implements SeekMap {
    private final LongArray positions;
    private final LongArray timesUs;
    private long durationUs;

    public IndexSeekMap(long[] positions, long[] timesUs, long durationUs) {
        Assertions.checkArgument((positions.length == timesUs.length ? 1 : 0) != 0);
        int length = timesUs.length;
        if (length > 0 && timesUs[0] > 0L) {
            this.positions = new LongArray(length + 1);
            this.timesUs = new LongArray(length + 1);
            this.positions.add(0L);
            this.timesUs.add(0L);
        } else {
            this.positions = new LongArray(length);
            this.timesUs = new LongArray(length);
        }
        this.positions.addAll(positions);
        this.timesUs.addAll(timesUs);
        this.durationUs = durationUs;
    }

    @Override
    public boolean isSeekable() {
        return this.timesUs.size() > 0;
    }

    @Override
    public long getDurationUs() {
        return this.durationUs;
    }

    @Override
    public SeekMap.SeekPoints getSeekPoints(long timeUs) {
        if (this.timesUs.size() == 0) {
            return new SeekMap.SeekPoints(SeekPoint.START);
        }
        int targetIndex = Util.binarySearchFloor((LongArray)this.timesUs, (long)timeUs, (boolean)true, (boolean)true);
        SeekPoint leftSeekPoint = new SeekPoint(this.timesUs.get(targetIndex), this.positions.get(targetIndex));
        if (leftSeekPoint.timeUs == timeUs || targetIndex == this.timesUs.size() - 1) {
            return new SeekMap.SeekPoints(leftSeekPoint);
        }
        SeekPoint rightSeekPoint = new SeekPoint(this.timesUs.get(targetIndex + 1), this.positions.get(targetIndex + 1));
        return new SeekMap.SeekPoints(leftSeekPoint, rightSeekPoint);
    }

    public void addSeekPoint(long timeUs, long position) {
        if (this.timesUs.size() == 0 && timeUs > 0L) {
            this.positions.add(0L);
            this.timesUs.add(0L);
        }
        this.positions.add(position);
        this.timesUs.add(timeUs);
    }

    public long getTimeUs(long position) {
        if (this.timesUs.size() == 0) {
            return -9223372036854775807L;
        }
        int targetIndex = Util.binarySearchFloor((LongArray)this.positions, (long)position, (boolean)true, (boolean)true);
        return this.timesUs.get(targetIndex);
    }

    public boolean isTimeUsInIndex(long timeUs, long minTimeBetweenPointsUs) {
        if (this.timesUs.size() == 0) {
            return false;
        }
        return timeUs - this.timesUs.get(this.timesUs.size() - 1) < minTimeBetweenPointsUs;
    }

    public void setDurationUs(long durationUs) {
        this.durationUs = durationUs;
    }
}

