/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor;

import androidx.annotation.Nullable;
import androidx.media3.common.ParserException;
import androidx.media3.common.util.CodecSpecificDataUtil;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.container.NalUnitUtil;
import java.util.Collections;
import java.util.List;

@UnstableApi
public final class HevcConfig {
    public final List<byte[]> initializationData;
    public final int nalUnitLengthFieldLength;
    public final int width;
    public final int height;
    public final int bitdepthLuma;
    public final int bitdepthChroma;
    public final int colorSpace;
    public final int colorRange;
    public final int colorTransfer;
    public final int stereoMode;
    public final float pixelWidthHeightRatio;
    public final int maxNumReorderPics;
    @Nullable
    public final String codecs;
    @Nullable
    public final NalUnitUtil.H265VpsData vpsData;

    public static HevcConfig parse(ParsableByteArray data) throws ParserException {
        return HevcConfig.parseImpl(data, false, null);
    }

    public static HevcConfig parseLayered(ParsableByteArray data, NalUnitUtil.H265VpsData vpsData) throws ParserException {
        return HevcConfig.parseImpl(data, true, vpsData);
    }

    private static HevcConfig parseImpl(ParsableByteArray data, boolean layered, @Nullable NalUnitUtil.H265VpsData vpsData) throws ParserException {
        try {
            if (layered) {
                data.skipBytes(4);
            } else {
                data.skipBytes(21);
            }
            int lengthSizeMinusOne = data.readUnsignedByte() & 3;
            int numberOfArrays = data.readUnsignedByte();
            int csdLength = 0;
            int csdStartPosition = data.getPosition();
            for (int i = 0; i < numberOfArrays; ++i) {
                data.skipBytes(1);
                int numberOfNalUnits = data.readUnsignedShort();
                for (int j = 0; j < numberOfNalUnits; ++j) {
                    int nalUnitLength = data.readUnsignedShort();
                    csdLength += 4 + nalUnitLength;
                    data.skipBytes(nalUnitLength);
                }
            }
            data.setPosition(csdStartPosition);
            byte[] buffer = new byte[csdLength];
            int bufferPosition = 0;
            int width = -1;
            int height = -1;
            int bitdepthLuma = -1;
            int bitdepthChroma = -1;
            int colorSpace = -1;
            int colorRange = -1;
            int colorTransfer = -1;
            int stereoMode = -1;
            float pixelWidthHeightRatio = 1.0f;
            int maxNumReorderPics = -1;
            String codecs = null;
            NalUnitUtil.H265VpsData currentVpsData = vpsData;
            for (int i = 0; i < numberOfArrays; ++i) {
                int nalUnitType = data.readUnsignedByte() & 0x3F;
                int numberOfNalUnits = data.readUnsignedShort();
                for (int j = 0; j < numberOfNalUnits; ++j) {
                    NalUnitUtil.H265Sei3dRefDisplayInfoData seiData;
                    int nalUnitLength = data.readUnsignedShort();
                    System.arraycopy(NalUnitUtil.NAL_START_CODE, 0, buffer, bufferPosition, NalUnitUtil.NAL_START_CODE.length);
                    System.arraycopy(data.getData(), data.getPosition(), buffer, bufferPosition += NalUnitUtil.NAL_START_CODE.length, nalUnitLength);
                    if (nalUnitType == 32 && j == 0) {
                        currentVpsData = NalUnitUtil.parseH265VpsNalUnit((byte[])buffer, (int)bufferPosition, (int)(bufferPosition + nalUnitLength));
                    } else if (nalUnitType == 33 && j == 0) {
                        NalUnitUtil.H265SpsData spsData = NalUnitUtil.parseH265SpsNalUnit((byte[])buffer, (int)bufferPosition, (int)(bufferPosition + nalUnitLength), (NalUnitUtil.H265VpsData)currentVpsData);
                        width = spsData.width;
                        height = spsData.height;
                        bitdepthLuma = spsData.bitDepthLumaMinus8 + 8;
                        bitdepthChroma = spsData.bitDepthChromaMinus8 + 8;
                        colorSpace = spsData.colorSpace;
                        colorRange = spsData.colorRange;
                        colorTransfer = spsData.colorTransfer;
                        pixelWidthHeightRatio = spsData.pixelWidthHeightRatio;
                        maxNumReorderPics = spsData.maxNumReorderPics;
                        if (spsData.profileTierLevel != null) {
                            codecs = CodecSpecificDataUtil.buildHevcCodecString((int)spsData.profileTierLevel.generalProfileSpace, (boolean)spsData.profileTierLevel.generalTierFlag, (int)spsData.profileTierLevel.generalProfileIdc, (int)spsData.profileTierLevel.generalProfileCompatibilityFlags, (int[])spsData.profileTierLevel.constraintBytes, (int)spsData.profileTierLevel.generalLevelIdc);
                        }
                    } else if (nalUnitType == 39 && j == 0 && (seiData = NalUnitUtil.parseH265Sei3dRefDisplayInfo((byte[])buffer, (int)bufferPosition, (int)(bufferPosition + nalUnitLength))) != null && currentVpsData != null) {
                        stereoMode = seiData.leftViewId == ((NalUnitUtil.H265LayerInfo)currentVpsData.layerInfos.get((int)0)).viewId ? 4 : 5;
                    }
                    bufferPosition += nalUnitLength;
                    data.skipBytes(nalUnitLength);
                }
            }
            List<byte[]> initializationData = csdLength == 0 ? Collections.emptyList() : Collections.singletonList(buffer);
            return new HevcConfig(initializationData, lengthSizeMinusOne + 1, width, height, bitdepthLuma, bitdepthChroma, colorSpace, colorRange, colorTransfer, stereoMode, pixelWidthHeightRatio, maxNumReorderPics, codecs, currentVpsData);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw ParserException.createForMalformedContainer((String)("Error parsing" + (layered ? "L-HEVC config" : "HEVC config")), (Throwable)e);
        }
    }

    private HevcConfig(List<byte[]> initializationData, int nalUnitLengthFieldLength, int width, int height, int bitdepthLuma, int bitdepthChroma, int colorSpace, int colorRange, int colorTransfer, int stereoMode, float pixelWidthHeightRatio, int maxNumReorderPics, @Nullable String codecs, @Nullable NalUnitUtil.H265VpsData vpsData) {
        this.initializationData = initializationData;
        this.nalUnitLengthFieldLength = nalUnitLengthFieldLength;
        this.width = width;
        this.height = height;
        this.bitdepthLuma = bitdepthLuma;
        this.bitdepthChroma = bitdepthChroma;
        this.colorSpace = colorSpace;
        this.colorRange = colorRange;
        this.colorTransfer = colorTransfer;
        this.stereoMode = stereoMode;
        this.pixelWidthHeightRatio = pixelWidthHeightRatio;
        this.maxNumReorderPics = maxNumReorderPics;
        this.codecs = codecs;
        this.vpsData = vpsData;
    }
}

