/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor;

import androidx.annotation.Nullable;
import androidx.media3.common.DrmInitData;
import androidx.media3.common.Format;
import androidx.media3.common.ParserException;
import androidx.media3.common.util.ParsableBitArray;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.UnstableApi;
import java.nio.ByteBuffer;

@UnstableApi
public final class Ac4Util {
    private static final int CHANNEL_MODE_UNKNOWN = -1;
    private static final int CHANNEL_MODE_MONO = 0;
    private static final int CHANNEL_MODE_STEREO = 1;
    private static final int CHANNEL_MODE_3_0 = 2;
    private static final int CHANNEL_MODE_5_0 = 3;
    private static final int CHANNEL_MODE_5_1 = 4;
    private static final int CHANNEL_MODE_7_0_34 = 5;
    private static final int CHANNEL_MODE_7_1_34 = 6;
    private static final int CHANNEL_MODE_7_0_52 = 7;
    private static final int CHANNEL_MODE_7_1_52 = 8;
    private static final int CHANNEL_MODE_7_0_322 = 9;
    private static final int CHANNEL_MODE_7_1_322 = 10;
    private static final int CHANNEL_MODE_7_0_4 = 11;
    private static final int CHANNEL_MODE_7_1_4 = 12;
    private static final int CHANNEL_MODE_9_0_4 = 13;
    private static final int CHANNEL_MODE_9_1_4 = 14;
    private static final int CHANNEL_MODE_22_2 = 15;
    public static final int AC40_SYNCWORD = 44096;
    public static final int AC41_SYNCWORD = 44097;
    public static final int MAX_RATE_BYTES_PER_SECOND = 336000;
    private static final int CHANNEL_COUNT_2 = 2;
    public static final int SAMPLE_HEADER_SIZE = 7;
    public static final int HEADER_SIZE_FOR_PARSER = 16;
    private static final int[] SAMPLE_COUNT = new int[]{2002, 2000, 1920, 1601, 1600, 1001, 1000, 960, 800, 800, 480, 400, 400, 2048};

    public static Format parseAc4AnnexEFormat(ParsableByteArray data, String trackId, String language, @Nullable DrmInitData drmInitData) throws ParserException {
        int channelCount;
        ParsableBitArray dataBitArray = new ParsableBitArray();
        dataBitArray.reset(data);
        int dsiSize = dataBitArray.bitsLeft();
        int ac4DsiVersion = dataBitArray.readBits(3);
        if (ac4DsiVersion > 1) {
            throw ParserException.createForUnsupportedContainerFeature((String)("Unsupported AC-4 DSI version: " + ac4DsiVersion));
        }
        int bitstreamVersion = dataBitArray.readBits(7);
        int sampleRate = dataBitArray.readBit() ? 48000 : 44100;
        dataBitArray.skipBits(4);
        int numberOfPresentations = dataBitArray.readBits(9);
        if (bitstreamVersion > 1) {
            if (ac4DsiVersion == 0) {
                throw ParserException.createForUnsupportedContainerFeature((String)("Invalid AC-4 DSI version: " + ac4DsiVersion));
            }
            if (dataBitArray.readBit()) {
                dataBitArray.skipBits(16);
                if (dataBitArray.readBit()) {
                    dataBitArray.skipBits(128);
                }
            }
        }
        if (ac4DsiVersion == 1) {
            if (!Ac4Util.skipDsiBitrate(dataBitArray)) {
                throw ParserException.createForUnsupportedContainerFeature((String)"Invalid AC-4 DSI bitrate.");
            }
            dataBitArray.byteAlign();
        }
        Ac4Presentation ac4Presentation = new Ac4Presentation();
        for (int presentationIdx = 0; presentationIdx < numberOfPresentations; ++presentationIdx) {
            int presentationBytes;
            block59: {
                int j;
                boolean addEmdfSubstreams;
                int presentationVersion;
                int presentationConfig;
                int start;
                boolean isSingleSubstreamGroup;
                boolean isSingleSubstream;
                block58: {
                    block57: {
                        isSingleSubstream = false;
                        isSingleSubstreamGroup = false;
                        presentationBytes = 0;
                        start = 0;
                        if (ac4DsiVersion != 0) break block57;
                        isSingleSubstream = dataBitArray.readBit();
                        presentationConfig = dataBitArray.readBits(5);
                        presentationVersion = dataBitArray.readBits(5);
                        break block58;
                    }
                    presentationVersion = dataBitArray.readBits(8);
                    presentationBytes = dataBitArray.readBits(8);
                    if (presentationBytes == 255) {
                        presentationBytes += dataBitArray.readBits(16);
                    }
                    if (presentationVersion > 2) break block59;
                    start = (dsiSize - dataBitArray.bitsLeft()) / 8;
                    presentationConfig = dataBitArray.readBits(5);
                    boolean bl = isSingleSubstreamGroup = presentationConfig == 31;
                }
                if (!isSingleSubstream && !isSingleSubstreamGroup && presentationConfig == 6) {
                    addEmdfSubstreams = true;
                } else {
                    ac4Presentation.level = dataBitArray.readBits(3);
                    if (dataBitArray.readBit()) {
                        dataBitArray.skipBits(5);
                    }
                    dataBitArray.skipBits(2);
                    if (ac4DsiVersion == 1 && (presentationVersion == 1 || presentationVersion == 2)) {
                        dataBitArray.skipBits(2);
                    }
                    dataBitArray.skipBits(5);
                    dataBitArray.skipBits(10);
                    if (ac4DsiVersion == 1) {
                        if (presentationVersion > 0) {
                            ac4Presentation.isChannelCoded = dataBitArray.readBit();
                        }
                        if (ac4Presentation.isChannelCoded) {
                            if (presentationVersion == 1 || presentationVersion == 2) {
                                int channelMode = dataBitArray.readBits(5);
                                if (channelMode >= 0 && channelMode <= 15) {
                                    ac4Presentation.channelMode = channelMode;
                                }
                                if (channelMode >= 11 && channelMode <= 14) {
                                    ac4Presentation.hasBackChannels = dataBitArray.readBit();
                                    ac4Presentation.topChannelPairs = dataBitArray.readBits(2);
                                }
                            }
                            dataBitArray.skipBits(24);
                        }
                        if (presentationVersion == 1 || presentationVersion == 2) {
                            if (dataBitArray.readBit() && dataBitArray.readBit()) {
                                dataBitArray.skipBits(2);
                            }
                            if (dataBitArray.readBit()) {
                                dataBitArray.skipBit();
                                int filterBytes = dataBitArray.readBits(8);
                                for (int i = 0; i < filterBytes; ++i) {
                                    dataBitArray.skipBits(8);
                                }
                            }
                        }
                    }
                    if (isSingleSubstream || isSingleSubstreamGroup) {
                        if (presentationVersion == 0) {
                            Ac4Util.parseDsiSubstream(dataBitArray, ac4Presentation);
                        } else {
                            Ac4Util.parseDsiSubstreamGroup(dataBitArray, ac4Presentation);
                        }
                    } else {
                        dataBitArray.skipBit();
                        switch (presentationConfig) {
                            case 0: 
                            case 1: 
                            case 2: {
                                int substreamGroupId;
                                int substreamId;
                                if (presentationVersion == 0) {
                                    for (substreamId = 0; substreamId < 2; ++substreamId) {
                                        Ac4Util.parseDsiSubstream(dataBitArray, ac4Presentation);
                                    }
                                } else {
                                    for (substreamGroupId = 0; substreamGroupId < 2; ++substreamGroupId) {
                                        Ac4Util.parseDsiSubstreamGroup(dataBitArray, ac4Presentation);
                                    }
                                }
                                break;
                            }
                            case 3: 
                            case 4: {
                                int substreamGroupId;
                                int substreamId;
                                if (presentationVersion == 0) {
                                    for (substreamId = 0; substreamId < 3; ++substreamId) {
                                        Ac4Util.parseDsiSubstream(dataBitArray, ac4Presentation);
                                    }
                                } else {
                                    for (substreamGroupId = 0; substreamGroupId < 3; ++substreamGroupId) {
                                        Ac4Util.parseDsiSubstreamGroup(dataBitArray, ac4Presentation);
                                    }
                                }
                                break;
                            }
                            case 5: {
                                if (presentationVersion == 0) {
                                    Ac4Util.parseDsiSubstream(dataBitArray, ac4Presentation);
                                    break;
                                }
                                int nSubstreamGroupsMinus2 = dataBitArray.readBits(3);
                                for (int substreamGroupId = 0; substreamGroupId < nSubstreamGroupsMinus2 + 2; ++substreamGroupId) {
                                    Ac4Util.parseDsiSubstreamGroup(dataBitArray, ac4Presentation);
                                }
                                break;
                            }
                            default: {
                                int nSkipBytes = dataBitArray.readBits(7);
                                for (j = 0; j < nSkipBytes; ++j) {
                                    dataBitArray.skipBits(8);
                                }
                            }
                        }
                    }
                    dataBitArray.skipBit();
                    addEmdfSubstreams = dataBitArray.readBit();
                }
                if (addEmdfSubstreams) {
                    int nAddEmdfSubstreams = dataBitArray.readBits(7);
                    for (j = 0; j < nAddEmdfSubstreams; ++j) {
                        dataBitArray.skipBits(15);
                    }
                }
                if (presentationVersion > 0) {
                    if (dataBitArray.readBit() && !Ac4Util.skipDsiBitrate(dataBitArray)) {
                        throw ParserException.createForUnsupportedContainerFeature((String)"Can't parse bitrate DSI.");
                    }
                    if (dataBitArray.readBit()) {
                        dataBitArray.byteAlign();
                        int nameLen = dataBitArray.readBits(16);
                        dataBitArray.skipBytes(nameLen);
                        int nTargets = dataBitArray.readBits(5);
                        for (int i = 0; i < nTargets; ++i) {
                            dataBitArray.skipBits(3);
                            dataBitArray.skipBits(8);
                        }
                    }
                }
                dataBitArray.byteAlign();
                if (ac4DsiVersion == 1) {
                    int end = (dsiSize - dataBitArray.bitsLeft()) / 8;
                    int presentationBytesRead = end - start;
                    if (presentationBytes < presentationBytesRead) {
                        throw ParserException.createForUnsupportedContainerFeature((String)"pres_bytes is smaller than presentation bytes read.");
                    }
                    int skipBytes = presentationBytes - presentationBytesRead;
                    dataBitArray.skipBytes(skipBytes);
                }
                if (!ac4Presentation.isChannelCoded || ac4Presentation.channelMode != -1) break;
                throw ParserException.createForUnsupportedContainerFeature((String)("Can't determine channel mode of presentation " + presentationIdx));
            }
            dataBitArray.skipBits(presentationBytes * 8);
        }
        if (ac4Presentation.isChannelCoded) {
            channelCount = Ac4Util.getAdjustedChannelCount(ac4Presentation.channelMode, ac4Presentation.hasBackChannels, ac4Presentation.topChannelPairs);
        } else {
            int lfeChannelCount = 1;
            channelCount = ac4Presentation.numOfUmxObjects + lfeChannelCount;
            if (ac4Presentation.level == 4) {
                int n = channelCount = channelCount == 17 ? 21 : channelCount;
            }
        }
        if (channelCount <= 0) {
            throw ParserException.createForUnsupportedContainerFeature((String)"Can't determine channel count of presentation.");
        }
        return new Format.Builder().setId(trackId).setSampleMimeType("audio/ac4").setChannelCount(channelCount).setSampleRate(sampleRate).setDrmInitData(drmInitData).setLanguage(language).build();
    }

    private static void parseDsiSubstream(ParsableBitArray data, Ac4Presentation ac4Presentation) throws ParserException {
        int channelMode = data.readBits(5);
        data.skipBits(2);
        if (data.readBit()) {
            data.skipBits(5);
        }
        if (channelMode >= 7 && channelMode <= 10) {
            data.skipBit();
        }
        if (data.readBit()) {
            int contentClassifier = data.readBits(3);
            if (ac4Presentation.channelMode == -1 && channelMode >= 0 && channelMode <= 15 && (contentClassifier == 0 || contentClassifier == 1)) {
                ac4Presentation.channelMode = channelMode;
            }
            if (data.readBit()) {
                Ac4Util.skipDsiLanguage(data);
            }
        }
    }

    private static void parseDsiSubstreamGroup(ParsableBitArray data, Ac4Presentation ac4Presentation) throws ParserException {
        data.skipBits(2);
        boolean channelCoded = data.readBit();
        int numberOfSubstreams = data.readBits(8);
        for (int i = 0; i < numberOfSubstreams; ++i) {
            data.skipBits(2);
            if (data.readBit()) {
                data.skipBits(5);
            }
            if (channelCoded) {
                data.skipBits(24);
                continue;
            }
            if (data.readBit()) {
                if (!data.readBit()) {
                    data.skipBits(4);
                }
                ac4Presentation.numOfUmxObjects = data.readBits(6) + 1;
            }
            data.skipBits(4);
        }
        if (data.readBit()) {
            data.skipBits(3);
            if (data.readBit()) {
                Ac4Util.skipDsiLanguage(data);
            }
        }
    }

    private static void skipDsiLanguage(ParsableBitArray data) throws ParserException {
        int languageTagBytesNumber = data.readBits(6);
        if (languageTagBytesNumber < 2 || languageTagBytesNumber > 42) {
            throw ParserException.createForUnsupportedContainerFeature((String)String.format("Invalid language tag bytes number: %d. Must be between 2 and 42.", languageTagBytesNumber));
        }
        data.skipBits(languageTagBytesNumber * 8);
    }

    private static boolean skipDsiBitrate(ParsableBitArray data) {
        int totalBitsToSkip = 66;
        if (data.bitsLeft() < totalBitsToSkip) {
            return false;
        }
        data.skipBits(totalBitsToSkip);
        return true;
    }

    private static int getAdjustedChannelCount(int channelMode, boolean hasBackChannels, int topChannelPairs) {
        int channelCount = Ac4Util.getChannelCountFromChannelMode(channelMode);
        if (channelMode == 11 || channelMode == 12 || channelMode == 13 || channelMode == 14) {
            if (!hasBackChannels) {
                channelCount -= 2;
            }
            switch (topChannelPairs) {
                case 0: {
                    channelCount -= 4;
                    break;
                }
                case 1: {
                    channelCount -= 2;
                    break;
                }
            }
        }
        return channelCount;
    }

    private static int getChannelCountFromChannelMode(int channelMode) {
        switch (channelMode) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 6;
            }
            case 5: 
            case 7: 
            case 9: {
                return 7;
            }
            case 6: 
            case 8: 
            case 10: {
                return 8;
            }
            case 11: {
                return 11;
            }
            case 12: {
                return 12;
            }
            case 13: {
                return 13;
            }
            case 14: {
                return 14;
            }
            case 15: {
                return 24;
            }
        }
        return -1;
    }

    public static SyncFrameInfo parseAc4SyncframeInfo(ParsableBitArray data) {
        int bitstreamVersion;
        int headerSize = 0;
        int syncWord = data.readBits(16);
        headerSize += 2;
        int frameSize = data.readBits(16);
        headerSize += 2;
        if (frameSize == 65535) {
            frameSize = data.readBits(24);
            headerSize += 3;
        }
        frameSize += headerSize;
        if (syncWord == 44097) {
            frameSize += 2;
        }
        if ((bitstreamVersion = data.readBits(2)) == 3) {
            bitstreamVersion += Ac4Util.readVariableBits(data, 2);
        }
        int sequenceCounter = data.readBits(10);
        if (data.readBit() && data.readBits(3) > 0) {
            data.skipBits(2);
        }
        int sampleRate = data.readBit() ? 48000 : 44100;
        int frameRateIndex = data.readBits(4);
        int sampleCount = 0;
        if (sampleRate == 44100 && frameRateIndex == 13) {
            sampleCount = SAMPLE_COUNT[frameRateIndex];
        } else if (sampleRate == 48000 && frameRateIndex < SAMPLE_COUNT.length) {
            sampleCount = SAMPLE_COUNT[frameRateIndex];
            switch (sequenceCounter % 5) {
                case 1: 
                case 3: {
                    if (frameRateIndex != 3 && frameRateIndex != 8) break;
                    ++sampleCount;
                    break;
                }
                case 2: {
                    if (frameRateIndex != 8 && frameRateIndex != 11) break;
                    ++sampleCount;
                    break;
                }
                case 4: {
                    if (frameRateIndex != 3 && frameRateIndex != 8 && frameRateIndex != 11) break;
                    ++sampleCount;
                    break;
                }
            }
        }
        return new SyncFrameInfo(bitstreamVersion, 2, sampleRate, frameSize, sampleCount);
    }

    public static int parseAc4SyncframeSize(byte[] data, int syncword) {
        if (data.length < 7) {
            return -1;
        }
        int headerSize = 2;
        int frameSize = (data[2] & 0xFF) << 8 | data[3] & 0xFF;
        headerSize += 2;
        if (frameSize == 65535) {
            frameSize = (data[4] & 0xFF) << 16 | (data[5] & 0xFF) << 8 | data[6] & 0xFF;
            headerSize += 3;
        }
        if (syncword == 44097) {
            headerSize += 2;
        }
        return frameSize += headerSize;
    }

    public static int parseAc4SyncframeAudioSampleCount(ByteBuffer buffer) {
        byte[] bufferBytes = new byte[16];
        int position = buffer.position();
        buffer.get(bufferBytes);
        buffer.position(position);
        return Ac4Util.parseAc4SyncframeInfo((ParsableBitArray)new ParsableBitArray((byte[])bufferBytes)).sampleCount;
    }

    public static void getAc4SampleHeader(int size, ParsableByteArray buffer) {
        buffer.reset(7);
        byte[] data = buffer.getData();
        data[0] = -84;
        data[1] = 64;
        data[2] = -1;
        data[3] = -1;
        data[4] = (byte)(size >> 16 & 0xFF);
        data[5] = (byte)(size >> 8 & 0xFF);
        data[6] = (byte)(size & 0xFF);
    }

    private static int readVariableBits(ParsableBitArray data, int bitsPerRead) {
        int value = 0;
        while (true) {
            value += data.readBits(bitsPerRead);
            if (!data.readBit()) break;
            ++value;
            value <<= bitsPerRead;
        }
        return value;
    }

    private Ac4Util() {
    }

    private static final class Ac4Presentation {
        public boolean isChannelCoded = true;
        public int channelMode = -1;
        public int numOfUmxObjects = -1;
        public boolean hasBackChannels = true;
        public int topChannelPairs = 2;
        public int level = 0;

        private Ac4Presentation() {
        }
    }

    public static final class SyncFrameInfo {
        public final int bitstreamVersion;
        public final int sampleRate;
        public final int channelCount;
        public final int frameSize;
        public final int sampleCount;

        private SyncFrameInfo(int bitstreamVersion, int channelCount, int sampleRate, int frameSize, int sampleCount) {
            this.bitstreamVersion = bitstreamVersion;
            this.channelCount = channelCount;
            this.sampleRate = sampleRate;
            this.frameSize = frameSize;
            this.sampleCount = sampleCount;
        }
    }
}

