/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.webp;

import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.extractor.Extractor;
import androidx.media3.extractor.ExtractorInput;
import androidx.media3.extractor.ExtractorOutput;
import androidx.media3.extractor.PositionHolder;
import androidx.media3.extractor.SingleSampleExtractor;
import java.io.IOException;

@UnstableApi
public final class WebpExtractor
implements Extractor {
    private static final int FILE_SIGNATURE_SEGMENT_LENGTH = 4;
    private static final int RIFF_FILE_SIGNATURE = 1380533830;
    private static final int WEBP_FILE_SIGNATURE = 1464156752;
    private final ParsableByteArray scratch = new ParsableByteArray(4);
    private final SingleSampleExtractor imageExtractor = new SingleSampleExtractor(-1, -1, "image/webp");

    @Override
    public boolean sniff(ExtractorInput input) throws IOException {
        this.scratch.reset(4);
        input.peekFully(this.scratch.getData(), 0, 4);
        if (this.scratch.readUnsignedInt() != 1380533830L) {
            return false;
        }
        input.advancePeekPosition(4);
        this.scratch.reset(4);
        input.peekFully(this.scratch.getData(), 0, 4);
        return this.scratch.readUnsignedInt() == 1464156752L;
    }

    @Override
    public void init(ExtractorOutput output) {
        this.imageExtractor.init(output);
    }

    @Override
    public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException {
        return this.imageExtractor.read(input, seekPosition);
    }

    @Override
    public void seek(long position, long timeUs) {
        this.imageExtractor.seek(position, timeUs);
    }

    @Override
    public void release() {
    }
}

