/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.ts;

import android.util.SparseArray;
import androidx.annotation.Nullable;
import androidx.media3.common.ParserException;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.TimestampAdjuster;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.extractor.ExtractorOutput;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.List;

@UnstableApi
public interface TsPayloadReader {
    public static final int FLAG_PAYLOAD_UNIT_START_INDICATOR = 1;
    public static final int FLAG_RANDOM_ACCESS_INDICATOR = 2;
    public static final int FLAG_DATA_ALIGNMENT_INDICATOR = 4;

    public void init(TimestampAdjuster var1, ExtractorOutput var2, TrackIdGenerator var3);

    public void seek();

    public void consume(ParsableByteArray var1, int var2) throws ParserException;

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface Flags {
    }

    public static final class TrackIdGenerator {
        private static final int ID_UNSET = Integer.MIN_VALUE;
        private final String formatIdPrefix;
        private final int firstTrackId;
        private final int trackIdIncrement;
        private int trackId;
        private String formatId;

        public TrackIdGenerator(int firstTrackId, int trackIdIncrement) {
            this(Integer.MIN_VALUE, firstTrackId, trackIdIncrement);
        }

        public TrackIdGenerator(int programNumber, int firstTrackId, int trackIdIncrement) {
            this.formatIdPrefix = programNumber != Integer.MIN_VALUE ? programNumber + "/" : "";
            this.firstTrackId = firstTrackId;
            this.trackIdIncrement = trackIdIncrement;
            this.trackId = Integer.MIN_VALUE;
            this.formatId = "";
        }

        public void generateNewId() {
            this.trackId = this.trackId == Integer.MIN_VALUE ? this.firstTrackId : this.trackId + this.trackIdIncrement;
            this.formatId = this.formatIdPrefix + this.trackId;
        }

        public int getTrackId() {
            this.maybeThrowUninitializedError();
            return this.trackId;
        }

        public String getFormatId() {
            this.maybeThrowUninitializedError();
            return this.formatId;
        }

        private void maybeThrowUninitializedError() {
            if (this.trackId == Integer.MIN_VALUE) {
                throw new IllegalStateException("generateNewId() must be called before retrieving ids.");
            }
        }
    }

    public static final class DvbSubtitleInfo {
        public final String language;
        public final int type;
        public final byte[] initializationData;

        public DvbSubtitleInfo(String language, int type, byte[] initializationData) {
            this.language = language;
            this.type = type;
            this.initializationData = initializationData;
        }
    }

    public static final class EsInfo {
        public static final int AUDIO_TYPE_UNDEFINED = 0;
        public static final int AUDIO_TYPE_CLEAN_EFFECTS = 1;
        public static final int AUDIO_TYPE_HEARING_IMPAIRED = 2;
        public static final int AUDIO_TYPE_VISUAL_IMPAIRED_COMMENTARY = 3;
        public final int streamType;
        @Nullable
        public final String language;
        public final int audioType;
        public final List<DvbSubtitleInfo> dvbSubtitleInfos;
        public final byte[] descriptorBytes;

        public int getRoleFlags() {
            switch (this.audioType) {
                case 2: {
                    return 2048;
                }
                case 3: {
                    return 512;
                }
            }
            return 0;
        }

        public EsInfo(int streamType, @Nullable String language, int audioType, @Nullable List<DvbSubtitleInfo> dvbSubtitleInfos, byte[] descriptorBytes) {
            this.streamType = streamType;
            this.language = language;
            this.audioType = audioType;
            this.dvbSubtitleInfos = dvbSubtitleInfos == null ? Collections.emptyList() : Collections.unmodifiableList(dvbSubtitleInfos);
            this.descriptorBytes = descriptorBytes;
        }

        @Documented
        @Retention(value=RetentionPolicy.SOURCE)
        @Target(value={ElementType.TYPE_USE})
        public static @interface AudioType {
        }
    }

    public static interface Factory {
        public SparseArray<TsPayloadReader> createInitialPayloadReaders();

        @Nullable
        public TsPayloadReader createPayloadReader(int var1, EsInfo var2);
    }
}

