/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.ts;

import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.TimestampAdjuster;
import androidx.media3.common.util.Util;
import androidx.media3.extractor.ExtractorInput;
import androidx.media3.extractor.PositionHolder;
import androidx.media3.extractor.ts.TsUtil;
import java.io.IOException;

final class TsDurationReader {
    private static final String TAG = "TsDurationReader";
    private final int timestampSearchBytes;
    private final TimestampAdjuster pcrTimestampAdjuster;
    private final ParsableByteArray packetBuffer;
    private boolean isDurationRead;
    private boolean isFirstPcrValueRead;
    private boolean isLastPcrValueRead;
    private long firstPcrValue;
    private long lastPcrValue;
    private long durationUs;

    TsDurationReader(int timestampSearchBytes) {
        this.timestampSearchBytes = timestampSearchBytes;
        this.pcrTimestampAdjuster = new TimestampAdjuster(0L);
        this.firstPcrValue = -9223372036854775807L;
        this.lastPcrValue = -9223372036854775807L;
        this.durationUs = -9223372036854775807L;
        this.packetBuffer = new ParsableByteArray();
    }

    public boolean isDurationReadFinished() {
        return this.isDurationRead;
    }

    public int readDuration(ExtractorInput input, PositionHolder seekPositionHolder, int pcrPid) throws IOException {
        if (pcrPid <= 0) {
            return this.finishReadDuration(input);
        }
        if (!this.isLastPcrValueRead) {
            return this.readLastPcrValue(input, seekPositionHolder, pcrPid);
        }
        if (this.lastPcrValue == -9223372036854775807L) {
            return this.finishReadDuration(input);
        }
        if (!this.isFirstPcrValueRead) {
            return this.readFirstPcrValue(input, seekPositionHolder, pcrPid);
        }
        if (this.firstPcrValue == -9223372036854775807L) {
            return this.finishReadDuration(input);
        }
        long minPcrPositionUs = this.pcrTimestampAdjuster.adjustTsTimestamp(this.firstPcrValue);
        long maxPcrPositionUs = this.pcrTimestampAdjuster.adjustTsTimestampGreaterThanPreviousTimestamp(this.lastPcrValue);
        this.durationUs = maxPcrPositionUs - minPcrPositionUs;
        return this.finishReadDuration(input);
    }

    public long getDurationUs() {
        return this.durationUs;
    }

    public TimestampAdjuster getPcrTimestampAdjuster() {
        return this.pcrTimestampAdjuster;
    }

    private int finishReadDuration(ExtractorInput input) {
        this.packetBuffer.reset(Util.EMPTY_BYTE_ARRAY);
        this.isDurationRead = true;
        input.resetPeekPosition();
        return 0;
    }

    private int readFirstPcrValue(ExtractorInput input, PositionHolder seekPositionHolder, int pcrPid) throws IOException {
        int bytesToSearch = (int)Math.min((long)this.timestampSearchBytes, input.getLength());
        int searchStartPosition = 0;
        if (input.getPosition() != (long)searchStartPosition) {
            seekPositionHolder.position = searchStartPosition;
            return 1;
        }
        this.packetBuffer.reset(bytesToSearch);
        input.resetPeekPosition();
        input.peekFully(this.packetBuffer.getData(), 0, bytesToSearch);
        this.firstPcrValue = this.readFirstPcrValueFromBuffer(this.packetBuffer, pcrPid);
        this.isFirstPcrValueRead = true;
        return 0;
    }

    private long readFirstPcrValueFromBuffer(ParsableByteArray packetBuffer, int pcrPid) {
        int searchStartPosition = packetBuffer.getPosition();
        int searchEndPosition = packetBuffer.limit();
        for (int searchPosition = searchStartPosition; searchPosition < searchEndPosition; ++searchPosition) {
            long pcrValue;
            if (packetBuffer.getData()[searchPosition] != 71 || (pcrValue = TsUtil.readPcrFromPacket(packetBuffer, searchPosition, pcrPid)) == -9223372036854775807L) continue;
            return pcrValue;
        }
        return -9223372036854775807L;
    }

    private int readLastPcrValue(ExtractorInput input, PositionHolder seekPositionHolder, int pcrPid) throws IOException {
        long inputLength = input.getLength();
        int bytesToSearch = (int)Math.min((long)this.timestampSearchBytes, inputLength);
        long searchStartPosition = inputLength - (long)bytesToSearch;
        if (input.getPosition() != searchStartPosition) {
            seekPositionHolder.position = searchStartPosition;
            return 1;
        }
        this.packetBuffer.reset(bytesToSearch);
        input.resetPeekPosition();
        input.peekFully(this.packetBuffer.getData(), 0, bytesToSearch);
        this.lastPcrValue = this.readLastPcrValueFromBuffer(this.packetBuffer, pcrPid);
        this.isLastPcrValueRead = true;
        return 0;
    }

    private long readLastPcrValueFromBuffer(ParsableByteArray packetBuffer, int pcrPid) {
        int searchStartPosition = packetBuffer.getPosition();
        int searchEndPosition = packetBuffer.limit();
        for (int searchPosition = searchEndPosition - 188; searchPosition >= searchStartPosition; --searchPosition) {
            long pcrValue;
            if (!TsUtil.isStartOfTsPacket(packetBuffer.getData(), searchStartPosition, searchEndPosition, searchPosition) || (pcrValue = TsUtil.readPcrFromPacket(packetBuffer, searchPosition, pcrPid)) == -9223372036854775807L) continue;
            return pcrValue;
        }
        return -9223372036854775807L;
    }
}

