/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor;

import androidx.annotation.Nullable;
import androidx.media3.common.DataReader;
import androidx.media3.common.Format;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.extractor.TrackOutput;
import java.io.EOFException;
import java.io.IOException;

@UnstableApi
public final class DiscardingTrackOutput
implements TrackOutput {
    private final byte[] readBuffer = new byte[4096];

    @Override
    public void format(Format format) {
    }

    @Override
    public int sampleData(DataReader input, int length, boolean allowEndOfInput, int sampleDataPart) throws IOException {
        int bytesToSkipByReading = Math.min(this.readBuffer.length, length);
        int bytesSkipped = input.read(this.readBuffer, 0, bytesToSkipByReading);
        if (bytesSkipped == -1) {
            if (allowEndOfInput) {
                return -1;
            }
            throw new EOFException();
        }
        return bytesSkipped;
    }

    @Override
    public void sampleData(ParsableByteArray data, int length, int sampleDataPart) {
        data.skipBytes(length);
    }

    @Override
    public void sampleMetadata(long timeUs, int flags, int size, int offset, @Nullable TrackOutput.CryptoData cryptoData) {
    }
}

