/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.mp3;

import androidx.annotation.Nullable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.Util;
import androidx.media3.extractor.SeekMap;
import androidx.media3.extractor.SeekPoint;
import androidx.media3.extractor.mp3.Seeker;
import androidx.media3.extractor.mp3.XingFrame;

final class XingSeeker
implements Seeker {
    private static final String TAG = "XingSeeker";
    private final long dataStartPosition;
    private final int xingFrameSize;
    private final long durationUs;
    private final long dataSize;
    private final long dataEndPosition;
    @Nullable
    private final long[] tableOfContents;

    @Nullable
    public static XingSeeker create(long inputLength, XingFrame xingFrame, long position) {
        if (xingFrame.frameCount == -1L && xingFrame.frameCount == 0L) {
            return null;
        }
        long durationUs = Util.sampleCountToDurationUs((long)(xingFrame.frameCount * (long)xingFrame.header.samplesPerFrame - 1L), (int)xingFrame.header.sampleRate);
        if (xingFrame.dataSize == -1L || xingFrame.tableOfContents == null) {
            return new XingSeeker(position, xingFrame.header.frameSize, durationUs);
        }
        if (inputLength != -1L && inputLength != position + xingFrame.dataSize) {
            Log.w((String)TAG, (String)("XING data size mismatch: " + inputLength + ", " + (position + xingFrame.dataSize)));
        }
        return new XingSeeker(position, xingFrame.header.frameSize, durationUs, xingFrame.dataSize, xingFrame.tableOfContents);
    }

    private XingSeeker(long dataStartPosition, int xingFrameSize, long durationUs) {
        this(dataStartPosition, xingFrameSize, durationUs, -1L, null);
    }

    private XingSeeker(long dataStartPosition, int xingFrameSize, long durationUs, long dataSize, @Nullable long[] tableOfContents) {
        this.dataStartPosition = dataStartPosition;
        this.xingFrameSize = xingFrameSize;
        this.durationUs = durationUs;
        this.tableOfContents = tableOfContents;
        this.dataSize = dataSize;
        this.dataEndPosition = dataSize == -1L ? -1L : dataStartPosition + dataSize;
    }

    @Override
    public boolean isSeekable() {
        return this.tableOfContents != null;
    }

    @Override
    public SeekMap.SeekPoints getSeekPoints(long timeUs) {
        double scaledPosition;
        if (!this.isSeekable()) {
            return new SeekMap.SeekPoints(new SeekPoint(0L, this.dataStartPosition + (long)this.xingFrameSize));
        }
        double percent = (double)(timeUs = Util.constrainValue((long)timeUs, (long)0L, (long)this.durationUs)) * 100.0 / (double)this.durationUs;
        if (percent <= 0.0) {
            scaledPosition = 0.0;
        } else if (percent >= 100.0) {
            scaledPosition = 256.0;
        } else {
            int prevTableIndex = (int)percent;
            long[] tableOfContents = (long[])Assertions.checkStateNotNull((Object)this.tableOfContents);
            double prevScaledPosition = tableOfContents[prevTableIndex];
            double nextScaledPosition = prevTableIndex == 99 ? 256.0 : (double)tableOfContents[prevTableIndex + 1];
            double interpolateFraction = percent - (double)prevTableIndex;
            scaledPosition = prevScaledPosition + interpolateFraction * (nextScaledPosition - prevScaledPosition);
        }
        long positionOffset = Math.round(scaledPosition / 256.0 * (double)this.dataSize);
        positionOffset = Util.constrainValue((long)positionOffset, (long)this.xingFrameSize, (long)(this.dataSize - 1L));
        return new SeekMap.SeekPoints(new SeekPoint(timeUs, this.dataStartPosition + positionOffset));
    }

    @Override
    public long getTimeUs(long position) {
        long positionOffset = position - this.dataStartPosition;
        if (!this.isSeekable() || positionOffset <= (long)this.xingFrameSize) {
            return 0L;
        }
        long[] tableOfContents = (long[])Assertions.checkStateNotNull((Object)this.tableOfContents);
        double scaledPosition = (double)positionOffset * 256.0 / (double)this.dataSize;
        int prevTableIndex = Util.binarySearchFloor((long[])tableOfContents, (long)((long)scaledPosition), (boolean)true, (boolean)true);
        long prevTimeUs = this.getTimeUsForTableIndex(prevTableIndex);
        long prevScaledPosition = tableOfContents[prevTableIndex];
        long nextTimeUs = this.getTimeUsForTableIndex(prevTableIndex + 1);
        long nextScaledPosition = prevTableIndex == 99 ? 256L : tableOfContents[prevTableIndex + 1];
        double interpolateFraction = prevScaledPosition == nextScaledPosition ? 0.0 : (scaledPosition - (double)prevScaledPosition) / (double)(nextScaledPosition - prevScaledPosition);
        return prevTimeUs + Math.round(interpolateFraction * (double)(nextTimeUs - prevTimeUs));
    }

    @Override
    public long getDurationUs() {
        return this.durationUs;
    }

    @Override
    public long getDataEndPosition() {
        return this.dataEndPosition;
    }

    private long getTimeUsForTableIndex(int tableIndex) {
        return this.durationUs * (long)tableIndex / 100L;
    }
}

