/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.ts;

import androidx.annotation.Nullable;
import androidx.media3.common.Format;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.extractor.ExtractorOutput;
import androidx.media3.extractor.MpegAudioUtil;
import androidx.media3.extractor.TrackOutput;
import androidx.media3.extractor.ts.ElementaryStreamReader;
import androidx.media3.extractor.ts.TsPayloadReader;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

@UnstableApi
public final class MpegAudioReader
implements ElementaryStreamReader {
    private static final int STATE_FINDING_HEADER = 0;
    private static final int STATE_READING_HEADER = 1;
    private static final int STATE_READING_FRAME = 2;
    private static final int HEADER_SIZE = 4;
    private final ParsableByteArray headerScratch = new ParsableByteArray(4);
    private final MpegAudioUtil.Header header;
    @Nullable
    private final String language;
    private @MonotonicNonNull TrackOutput output;
    private @MonotonicNonNull String formatId;
    private int state = 0;
    private int frameBytesRead;
    private boolean hasOutputFormat;
    private boolean lastByteWasFF;
    private long frameDurationUs;
    private int frameSize;
    private long timeUs;

    public MpegAudioReader() {
        this(null);
    }

    public MpegAudioReader(@Nullable String language) {
        this.headerScratch.getData()[0] = -1;
        this.header = new MpegAudioUtil.Header();
        this.timeUs = -9223372036854775807L;
        this.language = language;
    }

    @Override
    public void seek() {
        this.state = 0;
        this.frameBytesRead = 0;
        this.lastByteWasFF = false;
        this.timeUs = -9223372036854775807L;
    }

    @Override
    public void createTracks(ExtractorOutput extractorOutput, TsPayloadReader.TrackIdGenerator idGenerator) {
        idGenerator.generateNewId();
        this.formatId = idGenerator.getFormatId();
        this.output = extractorOutput.track(idGenerator.getTrackId(), 1);
    }

    @Override
    public void packetStarted(long pesTimeUs, int flags) {
        if (pesTimeUs != -9223372036854775807L) {
            this.timeUs = pesTimeUs;
        }
    }

    @Override
    public void consume(ParsableByteArray data) {
        Assertions.checkStateNotNull((Object)this.output);
        block5: while (data.bytesLeft() > 0) {
            switch (this.state) {
                case 0: {
                    this.findHeader(data);
                    continue block5;
                }
                case 1: {
                    this.readHeaderRemainder(data);
                    continue block5;
                }
                case 2: {
                    this.readFrameRemainder(data);
                    continue block5;
                }
            }
            throw new IllegalStateException();
        }
    }

    @Override
    public void packetFinished(boolean isEndOfInput) {
    }

    private void findHeader(ParsableByteArray source) {
        byte[] data = source.getData();
        int startOffset = source.getPosition();
        int endOffset = source.limit();
        for (int i = startOffset; i < endOffset; ++i) {
            boolean byteIsFF = (data[i] & 0xFF) == 255;
            boolean found = this.lastByteWasFF && (data[i] & 0xE0) == 224;
            this.lastByteWasFF = byteIsFF;
            if (!found) continue;
            source.setPosition(i + 1);
            this.lastByteWasFF = false;
            this.headerScratch.getData()[1] = data[i];
            this.frameBytesRead = 2;
            this.state = 1;
            return;
        }
        source.setPosition(endOffset);
    }

    @RequiresNonNull(value={"output"})
    private void readHeaderRemainder(ParsableByteArray source) {
        int bytesToRead = Math.min(source.bytesLeft(), 4 - this.frameBytesRead);
        source.readBytes(this.headerScratch.getData(), this.frameBytesRead, bytesToRead);
        this.frameBytesRead += bytesToRead;
        if (this.frameBytesRead < 4) {
            return;
        }
        this.headerScratch.setPosition(0);
        boolean parsedHeader = this.header.setForHeaderData(this.headerScratch.readInt());
        if (!parsedHeader) {
            this.frameBytesRead = 0;
            this.state = 1;
            return;
        }
        this.frameSize = this.header.frameSize;
        if (!this.hasOutputFormat) {
            this.frameDurationUs = 1000000L * (long)this.header.samplesPerFrame / (long)this.header.sampleRate;
            Format format = new Format.Builder().setId(this.formatId).setSampleMimeType(this.header.mimeType).setMaxInputSize(4096).setChannelCount(this.header.channels).setSampleRate(this.header.sampleRate).setLanguage(this.language).build();
            this.output.format(format);
            this.hasOutputFormat = true;
        }
        this.headerScratch.setPosition(0);
        this.output.sampleData(this.headerScratch, 4);
        this.state = 2;
    }

    @RequiresNonNull(value={"output"})
    private void readFrameRemainder(ParsableByteArray source) {
        int bytesToRead = Math.min(source.bytesLeft(), this.frameSize - this.frameBytesRead);
        this.output.sampleData(source, bytesToRead);
        this.frameBytesRead += bytesToRead;
        if (this.frameBytesRead < this.frameSize) {
            return;
        }
        if (this.timeUs != -9223372036854775807L) {
            this.output.sampleMetadata(this.timeUs, 1, this.frameSize, 0, null);
            this.timeUs += this.frameDurationUs;
        }
        this.frameBytesRead = 0;
        this.state = 0;
    }
}

