/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.text;

import androidx.annotation.Nullable;
import androidx.media3.common.DataReader;
import androidx.media3.common.Format;
import androidx.media3.common.MimeTypes;
import androidx.media3.common.text.Cue;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Consumer;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.Util;
import androidx.media3.extractor.TrackOutput;
import androidx.media3.extractor.text.CueEncoder;
import androidx.media3.extractor.text.CuesWithTiming;
import androidx.media3.extractor.text.SubtitleParser;
import java.io.EOFException;
import java.io.IOException;
import java.util.List;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

class SubtitleTranscodingTrackOutput
implements TrackOutput {
    private final TrackOutput delegate;
    private final SubtitleParser.Factory subtitleParserFactory;
    private final CueEncoder cueEncoder;
    private final ParsableByteArray parsableScratch;
    private int sampleDataStart;
    private int sampleDataEnd;
    private byte[] sampleData;
    @Nullable
    private SubtitleParser currentSubtitleParser;
    private @MonotonicNonNull Format currentFormat;

    public SubtitleTranscodingTrackOutput(TrackOutput delegate, SubtitleParser.Factory subtitleParserFactory) {
        this.delegate = delegate;
        this.subtitleParserFactory = subtitleParserFactory;
        this.cueEncoder = new CueEncoder();
        this.sampleDataStart = 0;
        this.sampleDataEnd = 0;
        this.sampleData = Util.EMPTY_BYTE_ARRAY;
        this.parsableScratch = new ParsableByteArray();
    }

    public void resetSubtitleParser() {
        if (this.currentSubtitleParser != null) {
            this.currentSubtitleParser.reset();
        }
    }

    @Override
    public void format(Format format) {
        Assertions.checkNotNull((Object)format.sampleMimeType);
        Assertions.checkArgument((MimeTypes.getTrackType((String)format.sampleMimeType) == 3 ? 1 : 0) != 0);
        if (!format.equals((Object)this.currentFormat)) {
            this.currentFormat = format;
            SubtitleParser subtitleParser = this.currentSubtitleParser = this.subtitleParserFactory.supportsFormat(format) ? this.subtitleParserFactory.create(format) : null;
        }
        if (this.currentSubtitleParser == null) {
            this.delegate.format(format);
        } else {
            this.delegate.format(format.buildUpon().setSampleMimeType("application/x-media3-cues").setCodecs(format.sampleMimeType).setSubsampleOffsetUs(Long.MAX_VALUE).setCueReplacementBehavior(this.subtitleParserFactory.getCueReplacementBehavior(format)).build());
        }
    }

    @Override
    public int sampleData(DataReader input, int length, boolean allowEndOfInput, int sampleDataPart) throws IOException {
        if (this.currentSubtitleParser == null) {
            return this.delegate.sampleData(input, length, allowEndOfInput, sampleDataPart);
        }
        this.ensureSampleDataCapacity(length);
        int bytesRead = input.read(this.sampleData, this.sampleDataEnd, length);
        if (bytesRead == -1) {
            if (allowEndOfInput) {
                return -1;
            }
            throw new EOFException();
        }
        this.sampleDataEnd += bytesRead;
        return bytesRead;
    }

    @Override
    public void sampleData(ParsableByteArray data, int length, int sampleDataPart) {
        if (this.currentSubtitleParser == null) {
            this.delegate.sampleData(data, length, sampleDataPart);
            return;
        }
        this.ensureSampleDataCapacity(length);
        data.readBytes(this.sampleData, this.sampleDataEnd, length);
        this.sampleDataEnd += length;
    }

    @Override
    public void sampleMetadata(long timeUs, int flags, int size, int offset, @Nullable TrackOutput.CryptoData cryptoData) {
        if (this.currentSubtitleParser == null) {
            this.delegate.sampleMetadata(timeUs, flags, size, offset, cryptoData);
            return;
        }
        Assertions.checkArgument((cryptoData == null ? 1 : 0) != 0, (Object)"DRM on subtitles is not supported");
        int sampleStart = this.sampleDataEnd - offset - size;
        this.currentSubtitleParser.parse(this.sampleData, sampleStart, size, SubtitleParser.OutputOptions.allCues(), (Consumer<CuesWithTiming>)((Consumer)cuesWithTiming -> this.outputSample((CuesWithTiming)cuesWithTiming, timeUs, flags)));
        this.sampleDataStart = sampleStart + size;
    }

    private void outputSample(CuesWithTiming cuesWithTiming, long timeUs, int flags) {
        long outputSampleTimeUs;
        Assertions.checkStateNotNull((Object)this.currentFormat);
        byte[] cuesWithDurationBytes = this.cueEncoder.encode((List<Cue>)cuesWithTiming.cues, cuesWithTiming.durationUs);
        this.parsableScratch.reset(cuesWithDurationBytes);
        this.delegate.sampleData(this.parsableScratch, cuesWithDurationBytes.length);
        flags &= Integer.MAX_VALUE;
        if (cuesWithTiming.startTimeUs == -9223372036854775807L) {
            Assertions.checkState((this.currentFormat.subsampleOffsetUs == Long.MAX_VALUE ? 1 : 0) != 0);
            outputSampleTimeUs = timeUs;
        } else {
            outputSampleTimeUs = this.currentFormat.subsampleOffsetUs == Long.MAX_VALUE ? timeUs + cuesWithTiming.startTimeUs : cuesWithTiming.startTimeUs + this.currentFormat.subsampleOffsetUs;
        }
        this.delegate.sampleMetadata(outputSampleTimeUs, flags, cuesWithDurationBytes.length, 0, null);
    }

    private void ensureSampleDataCapacity(int newSampleSize) {
        if (this.sampleData.length - this.sampleDataEnd >= newSampleSize) {
            return;
        }
        int existingSampleDataLength = this.sampleDataEnd - this.sampleDataStart;
        int targetLength = Math.max(existingSampleDataLength * 2, this.sampleDataEnd + newSampleSize);
        byte[] newSampleData = targetLength <= this.sampleData.length ? this.sampleData : new byte[targetLength];
        System.arraycopy(this.sampleData, this.sampleDataStart, newSampleData, 0, existingSampleDataLength);
        this.sampleDataStart = 0;
        this.sampleDataEnd = existingSampleDataLength;
        this.sampleData = newSampleData;
    }
}

