/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.mp4;

import android.util.Pair;
import androidx.annotation.Nullable;
import androidx.media3.common.ColorInfo;
import androidx.media3.common.DrmInitData;
import androidx.media3.common.Format;
import androidx.media3.common.Metadata;
import androidx.media3.common.MimeTypes;
import androidx.media3.common.ParserException;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.CodecSpecificDataUtil;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.NullableType;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.Util;
import androidx.media3.container.MdtaMetadataEntry;
import androidx.media3.container.Mp4LocationData;
import androidx.media3.container.Mp4TimestampData;
import androidx.media3.extractor.AacUtil;
import androidx.media3.extractor.Ac3Util;
import androidx.media3.extractor.Ac4Util;
import androidx.media3.extractor.AvcConfig;
import androidx.media3.extractor.DolbyVisionConfig;
import androidx.media3.extractor.ExtractorUtil;
import androidx.media3.extractor.GaplessInfoHolder;
import androidx.media3.extractor.HevcConfig;
import androidx.media3.extractor.OpusUtil;
import androidx.media3.extractor.VorbisUtil;
import androidx.media3.extractor.metadata.mp4.SmtaMetadataEntry;
import androidx.media3.extractor.mp4.Atom;
import androidx.media3.extractor.mp4.FixedSampleSizeRechunker;
import androidx.media3.extractor.mp4.MetadataUtil;
import androidx.media3.extractor.mp4.Track;
import androidx.media3.extractor.mp4.TrackEncryptionBox;
import androidx.media3.extractor.mp4.TrackSampleTable;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class AtomParsers {
    private static final String TAG = "AtomParsers";
    private static final int TYPE_clcp = 1668047728;
    private static final int TYPE_mdta = 1835299937;
    private static final int TYPE_meta = 1835365473;
    private static final int TYPE_nclc = 1852009571;
    private static final int TYPE_nclx = 1852009592;
    private static final int TYPE_sbtl = 1935832172;
    private static final int TYPE_soun = 1936684398;
    private static final int TYPE_subt = 1937072756;
    private static final int TYPE_text = 1952807028;
    private static final int TYPE_vide = 1986618469;
    private static final int MAX_GAPLESS_TRIM_SIZE_SAMPLES = 4;
    private static final byte[] opusMagic = Util.getUtf8Bytes((String)"OpusHead");

    public static List<TrackSampleTable> parseTraks(Atom.ContainerAtom moov, GaplessInfoHolder gaplessInfoHolder, long duration, @Nullable DrmInitData drmInitData, boolean ignoreEditLists, boolean isQuickTime, Function<@NullableType Track, @NullableType Track> modifyTrackFunction) throws ParserException {
        ArrayList<TrackSampleTable> trackSampleTables = new ArrayList<TrackSampleTable>();
        for (int i = 0; i < moov.containerChildren.size(); ++i) {
            Track track;
            Atom.ContainerAtom atom = moov.containerChildren.get(i);
            if (atom.type != 1953653099 || (track = (Track)modifyTrackFunction.apply((Object)AtomParsers.parseTrak(atom, (Atom.LeafAtom)Assertions.checkNotNull((Object)moov.getLeafAtomOfType(1836476516)), duration, drmInitData, ignoreEditLists, isQuickTime))) == null) continue;
            Atom.ContainerAtom stblAtom = (Atom.ContainerAtom)Assertions.checkNotNull((Object)((Atom.ContainerAtom)Assertions.checkNotNull((Object)((Atom.ContainerAtom)Assertions.checkNotNull((Object)atom.getContainerAtomOfType(1835297121))).getContainerAtomOfType(1835626086))).getContainerAtomOfType(1937007212));
            TrackSampleTable trackSampleTable = AtomParsers.parseStbl(track, stblAtom, gaplessInfoHolder);
            trackSampleTables.add(trackSampleTable);
        }
        return trackSampleTables;
    }

    public static Metadata parseUdta(Atom.LeafAtom udtaAtom) {
        ParsableByteArray udtaData = udtaAtom.data;
        udtaData.setPosition(8);
        Metadata metadata = new Metadata(new Metadata.Entry[0]);
        while (udtaData.bytesLeft() >= 8) {
            int atomPosition = udtaData.getPosition();
            int atomSize = udtaData.readInt();
            int atomType = udtaData.readInt();
            if (atomType == 1835365473) {
                udtaData.setPosition(atomPosition);
                metadata = metadata.copyWithAppendedEntriesFrom(AtomParsers.parseUdtaMeta(udtaData, atomPosition + atomSize));
            } else if (atomType == 1936553057) {
                udtaData.setPosition(atomPosition);
                metadata = metadata.copyWithAppendedEntriesFrom(AtomParsers.parseSmta(udtaData, atomPosition + atomSize));
            } else if (atomType == -1451722374) {
                metadata = metadata.copyWithAppendedEntriesFrom(AtomParsers.parseXyz(udtaData));
            }
            udtaData.setPosition(atomPosition + atomSize);
        }
        return metadata;
    }

    public static Mp4TimestampData parseMvhd(ParsableByteArray mvhd) {
        long modificationTimestampSeconds;
        long creationTimestampSeconds;
        mvhd.setPosition(8);
        int fullAtom = mvhd.readInt();
        int version = Atom.parseFullAtomVersion(fullAtom);
        if (version == 0) {
            creationTimestampSeconds = mvhd.readUnsignedInt();
            modificationTimestampSeconds = mvhd.readUnsignedInt();
        } else {
            creationTimestampSeconds = mvhd.readLong();
            modificationTimestampSeconds = mvhd.readLong();
        }
        long timescale = mvhd.readUnsignedInt();
        return new Mp4TimestampData(creationTimestampSeconds, modificationTimestampSeconds, timescale);
    }

    @Nullable
    public static Metadata parseMdtaFromMeta(Atom.ContainerAtom meta) {
        Atom.LeafAtom hdlrAtom = meta.getLeafAtomOfType(1751411826);
        Atom.LeafAtom keysAtom = meta.getLeafAtomOfType(1801812339);
        Atom.LeafAtom ilstAtom = meta.getLeafAtomOfType(1768715124);
        if (hdlrAtom == null || keysAtom == null || ilstAtom == null || AtomParsers.parseHdlr(hdlrAtom.data) != 1835299937) {
            return null;
        }
        ParsableByteArray keys = keysAtom.data;
        keys.setPosition(12);
        int entryCount = keys.readInt();
        String[] keyNames = new String[entryCount];
        for (int i = 0; i < entryCount; ++i) {
            int entrySize = keys.readInt();
            keys.skipBytes(4);
            int keySize = entrySize - 8;
            keyNames[i] = keys.readString(keySize);
        }
        ParsableByteArray ilst = ilstAtom.data;
        ilst.setPosition(8);
        ArrayList<MdtaMetadataEntry> entries = new ArrayList<MdtaMetadataEntry>();
        while (ilst.bytesLeft() > 8) {
            int atomPosition = ilst.getPosition();
            int atomSize = ilst.readInt();
            int keyIndex = ilst.readInt() - 1;
            if (keyIndex >= 0 && keyIndex < keyNames.length) {
                String key = keyNames[keyIndex];
                MdtaMetadataEntry entry = MetadataUtil.parseMdtaMetadataEntryFromIlst(ilst, atomPosition + atomSize, key);
                if (entry != null) {
                    entries.add(entry);
                }
            } else {
                Log.w((String)TAG, (String)("Skipped metadata with unknown key index: " + keyIndex));
            }
            ilst.setPosition(atomPosition + atomSize);
        }
        return entries.isEmpty() ? null : new Metadata(entries);
    }

    public static void maybeSkipRemainingMetaAtomHeaderBytes(ParsableByteArray meta) {
        int endPosition = meta.getPosition();
        meta.skipBytes(4);
        if (meta.readInt() != 1751411826) {
            endPosition += 4;
        }
        meta.setPosition(endPosition);
    }

    @Nullable
    private static Track parseTrak(Atom.ContainerAtom trak, Atom.LeafAtom mvhd, long duration, @Nullable DrmInitData drmInitData, boolean ignoreEditLists, boolean isQuickTime) throws ParserException {
        Pair<long[], long[]> edtsData;
        Atom.ContainerAtom edtsAtom;
        Atom.ContainerAtom mdia = (Atom.ContainerAtom)Assertions.checkNotNull((Object)trak.getContainerAtomOfType(1835297121));
        int trackType = AtomParsers.getTrackTypeForHdlr(AtomParsers.parseHdlr(((Atom.LeafAtom)Assertions.checkNotNull((Object)mdia.getLeafAtomOfType((int)1751411826))).data));
        if (trackType == -1) {
            return null;
        }
        TkhdData tkhdData = AtomParsers.parseTkhd(((Atom.LeafAtom)Assertions.checkNotNull((Object)trak.getLeafAtomOfType((int)1953196132))).data);
        if (duration == -9223372036854775807L) {
            duration = tkhdData.duration;
        }
        long movieTimescale = AtomParsers.parseMvhd((ParsableByteArray)mvhd.data).timescale;
        long durationUs = duration == -9223372036854775807L ? -9223372036854775807L : Util.scaleLargeTimestamp((long)duration, (long)1000000L, (long)movieTimescale);
        Atom.ContainerAtom stbl = (Atom.ContainerAtom)Assertions.checkNotNull((Object)((Atom.ContainerAtom)Assertions.checkNotNull((Object)mdia.getContainerAtomOfType(1835626086))).getContainerAtomOfType(1937007212));
        Pair<Long, String> mdhdData = AtomParsers.parseMdhd(((Atom.LeafAtom)Assertions.checkNotNull((Object)mdia.getLeafAtomOfType((int)1835296868))).data);
        Atom.LeafAtom stsd = stbl.getLeafAtomOfType(1937011556);
        if (stsd == null) {
            throw ParserException.createForMalformedContainer((String)"Malformed sample table (stbl) missing sample description (stsd)", null);
        }
        StsdData stsdData = AtomParsers.parseStsd(stsd.data, tkhdData.id, tkhdData.rotationDegrees, (String)mdhdData.second, drmInitData, isQuickTime);
        long[] editListDurations = null;
        long[] editListMediaTimes = null;
        if (!ignoreEditLists && (edtsAtom = trak.getContainerAtomOfType(1701082227)) != null && (edtsData = AtomParsers.parseEdts(edtsAtom)) != null) {
            editListDurations = (long[])edtsData.first;
            editListMediaTimes = (long[])edtsData.second;
        }
        return stsdData.format == null ? null : new Track(tkhdData.id, trackType, (Long)mdhdData.first, movieTimescale, durationUs, stsdData.format, stsdData.requiredSampleTransformation, stsdData.trackEncryptionBoxes, stsdData.nalUnitLengthFieldLength, editListDurations, editListMediaTimes);
    }

    private static TrackSampleTable parseStbl(Track track, Atom.ContainerAtom stblAtom, GaplessInfoHolder gaplessInfoHolder) throws ParserException {
        long editEndTime;
        long editStartTime;
        long duration;
        int[] flags;
        long[] timestamps;
        int[] sizes;
        long[] offsets;
        SampleSizeBox sampleSizeBox;
        Atom.LeafAtom stszAtom = stblAtom.getLeafAtomOfType(1937011578);
        if (stszAtom != null) {
            sampleSizeBox = new StszSampleSizeBox(stszAtom, track.format);
        } else {
            Atom.LeafAtom stz2Atom = stblAtom.getLeafAtomOfType(1937013298);
            if (stz2Atom == null) {
                throw ParserException.createForMalformedContainer((String)"Track has no sample table size information", null);
            }
            sampleSizeBox = new Stz2SampleSizeBox(stz2Atom);
        }
        int sampleCount = sampleSizeBox.getSampleCount();
        if (sampleCount == 0) {
            return new TrackSampleTable(track, new long[0], new int[0], 0, new long[0], new int[0], 0L);
        }
        boolean chunkOffsetsAreLongs = false;
        Atom.LeafAtom chunkOffsetsAtom = stblAtom.getLeafAtomOfType(1937007471);
        if (chunkOffsetsAtom == null) {
            chunkOffsetsAreLongs = true;
            chunkOffsetsAtom = (Atom.LeafAtom)Assertions.checkNotNull((Object)stblAtom.getLeafAtomOfType(1668232756));
        }
        ParsableByteArray chunkOffsets = chunkOffsetsAtom.data;
        ParsableByteArray stsc = ((Atom.LeafAtom)Assertions.checkNotNull((Object)stblAtom.getLeafAtomOfType((int)1937011555))).data;
        ParsableByteArray stts = ((Atom.LeafAtom)Assertions.checkNotNull((Object)stblAtom.getLeafAtomOfType((int)0x73747473))).data;
        Atom.LeafAtom stssAtom = stblAtom.getLeafAtomOfType(0x73747373);
        ParsableByteArray stss = stssAtom != null ? stssAtom.data : null;
        Atom.LeafAtom cttsAtom = stblAtom.getLeafAtomOfType(1668576371);
        ParsableByteArray ctts = cttsAtom != null ? cttsAtom.data : null;
        ChunkIterator chunkIterator = new ChunkIterator(stsc, chunkOffsets, chunkOffsetsAreLongs);
        stts.setPosition(12);
        int remainingTimestampDeltaChanges = stts.readUnsignedIntToInt() - 1;
        int remainingSamplesAtTimestampDelta = stts.readUnsignedIntToInt();
        int timestampDeltaInTimeUnits = stts.readUnsignedIntToInt();
        int remainingSamplesAtTimestampOffset = 0;
        int remainingTimestampOffsetChanges = 0;
        int timestampOffset = 0;
        if (ctts != null) {
            ctts.setPosition(12);
            remainingTimestampOffsetChanges = ctts.readUnsignedIntToInt();
        }
        int nextSynchronizationSampleIndex = -1;
        int remainingSynchronizationSamples = 0;
        if (stss != null) {
            stss.setPosition(12);
            remainingSynchronizationSamples = stss.readUnsignedIntToInt();
            if (remainingSynchronizationSamples > 0) {
                nextSynchronizationSampleIndex = stss.readUnsignedIntToInt() - 1;
            } else {
                stss = null;
            }
        }
        int fixedSampleSize = sampleSizeBox.getFixedSampleSize();
        String sampleMimeType = track.format.sampleMimeType;
        boolean rechunkFixedSizeSamples = fixedSampleSize != -1 && ("audio/raw".equals(sampleMimeType) || "audio/g711-mlaw".equals(sampleMimeType) || "audio/g711-alaw".equals(sampleMimeType)) && remainingTimestampDeltaChanges == 0 && remainingTimestampOffsetChanges == 0 && remainingSynchronizationSamples == 0;
        int maximumSize = 0;
        long timestampTimeUnits = 0L;
        if (rechunkFixedSizeSamples) {
            long[] chunkOffsetsBytes = new long[chunkIterator.length];
            int[] chunkSampleCounts = new int[chunkIterator.length];
            while (chunkIterator.moveNext()) {
                chunkOffsetsBytes[chunkIterator.index] = chunkIterator.offset;
                chunkSampleCounts[chunkIterator.index] = chunkIterator.numSamples;
            }
            FixedSampleSizeRechunker.Results rechunkedResults = FixedSampleSizeRechunker.rechunk(fixedSampleSize, chunkOffsetsBytes, chunkSampleCounts, timestampDeltaInTimeUnits);
            offsets = rechunkedResults.offsets;
            sizes = rechunkedResults.sizes;
            maximumSize = rechunkedResults.maximumSize;
            timestamps = rechunkedResults.timestamps;
            flags = rechunkedResults.flags;
            duration = rechunkedResults.duration;
        } else {
            offsets = new long[sampleCount];
            sizes = new int[sampleCount];
            timestamps = new long[sampleCount];
            flags = new int[sampleCount];
            long offset = 0L;
            int remainingSamplesInChunk = 0;
            for (int i = 0; i < sampleCount; ++i) {
                boolean chunkDataComplete = true;
                while (remainingSamplesInChunk == 0 && (chunkDataComplete = chunkIterator.moveNext())) {
                    offset = chunkIterator.offset;
                    remainingSamplesInChunk = chunkIterator.numSamples;
                }
                if (!chunkDataComplete) {
                    Log.w((String)TAG, (String)"Unexpected end of chunk data");
                    sampleCount = i;
                    offsets = Arrays.copyOf(offsets, sampleCount);
                    sizes = Arrays.copyOf(sizes, sampleCount);
                    timestamps = Arrays.copyOf(timestamps, sampleCount);
                    flags = Arrays.copyOf(flags, sampleCount);
                    break;
                }
                if (ctts != null) {
                    while (remainingSamplesAtTimestampOffset == 0 && remainingTimestampOffsetChanges > 0) {
                        remainingSamplesAtTimestampOffset = ctts.readUnsignedIntToInt();
                        timestampOffset = ctts.readInt();
                        --remainingTimestampOffsetChanges;
                    }
                    --remainingSamplesAtTimestampOffset;
                }
                offsets[i] = offset;
                sizes[i] = sampleSizeBox.readNextSampleSize();
                if (sizes[i] > maximumSize) {
                    maximumSize = sizes[i];
                }
                timestamps[i] = timestampTimeUnits + (long)timestampOffset;
                int n = flags[i] = stss == null ? 1 : 0;
                if (i == nextSynchronizationSampleIndex) {
                    flags[i] = 1;
                    if (--remainingSynchronizationSamples > 0) {
                        nextSynchronizationSampleIndex = ((ParsableByteArray)Assertions.checkNotNull((Object)stss)).readUnsignedIntToInt() - 1;
                    }
                }
                timestampTimeUnits += (long)timestampDeltaInTimeUnits;
                if (--remainingSamplesAtTimestampDelta == 0 && remainingTimestampDeltaChanges > 0) {
                    remainingSamplesAtTimestampDelta = stts.readUnsignedIntToInt();
                    timestampDeltaInTimeUnits = stts.readInt();
                    --remainingTimestampDeltaChanges;
                }
                offset += (long)sizes[i];
                --remainingSamplesInChunk;
            }
            duration = timestampTimeUnits + (long)timestampOffset;
            boolean isCttsValid = true;
            if (ctts != null) {
                while (remainingTimestampOffsetChanges > 0) {
                    if (ctts.readUnsignedIntToInt() != 0) {
                        isCttsValid = false;
                        break;
                    }
                    ctts.readInt();
                    --remainingTimestampOffsetChanges;
                }
            }
            if (remainingSynchronizationSamples != 0 || remainingSamplesAtTimestampDelta != 0 || remainingSamplesInChunk != 0 || remainingTimestampDeltaChanges != 0 || remainingSamplesAtTimestampOffset != 0 || !isCttsValid) {
                Log.w((String)TAG, (String)("Inconsistent stbl box for track " + track.id + ": remainingSynchronizationSamples " + remainingSynchronizationSamples + ", remainingSamplesAtTimestampDelta " + remainingSamplesAtTimestampDelta + ", remainingSamplesInChunk " + remainingSamplesInChunk + ", remainingTimestampDeltaChanges " + remainingTimestampDeltaChanges + ", remainingSamplesAtTimestampOffset " + remainingSamplesAtTimestampOffset + (!isCttsValid ? ", ctts invalid" : "")));
            }
        }
        long durationUs = Util.scaleLargeTimestamp((long)duration, (long)1000000L, (long)track.timescale);
        if (track.editListDurations == null) {
            Util.scaleLargeTimestampsInPlace((long[])timestamps, (long)1000000L, (long)track.timescale);
            return new TrackSampleTable(track, offsets, sizes, maximumSize, timestamps, flags, durationUs);
        }
        if (track.editListDurations.length == 1 && track.type == 1 && timestamps.length >= 2 && AtomParsers.canApplyEditWithGaplessInfo(timestamps, duration, editStartTime = ((long[])Assertions.checkNotNull((Object)track.editListMediaTimes))[0], editEndTime = editStartTime + Util.scaleLargeTimestamp((long)track.editListDurations[0], (long)track.timescale, (long)track.movieTimescale))) {
            long paddingTimeUnits = duration - editEndTime;
            long encoderDelay = Util.scaleLargeTimestamp((long)(editStartTime - timestamps[0]), (long)track.format.sampleRate, (long)track.timescale);
            long encoderPadding = Util.scaleLargeTimestamp((long)paddingTimeUnits, (long)track.format.sampleRate, (long)track.timescale);
            if ((encoderDelay != 0L || encoderPadding != 0L) && encoderDelay <= Integer.MAX_VALUE && encoderPadding <= Integer.MAX_VALUE) {
                gaplessInfoHolder.encoderDelay = (int)encoderDelay;
                gaplessInfoHolder.encoderPadding = (int)encoderPadding;
                Util.scaleLargeTimestampsInPlace((long[])timestamps, (long)1000000L, (long)track.timescale);
                long editedDurationUs = Util.scaleLargeTimestamp((long)track.editListDurations[0], (long)1000000L, (long)track.movieTimescale);
                return new TrackSampleTable(track, offsets, sizes, maximumSize, timestamps, flags, editedDurationUs);
            }
        }
        if (track.editListDurations.length == 1 && track.editListDurations[0] == 0L) {
            editStartTime = ((long[])Assertions.checkNotNull((Object)track.editListMediaTimes))[0];
            for (int i = 0; i < timestamps.length; ++i) {
                timestamps[i] = Util.scaleLargeTimestamp((long)(timestamps[i] - editStartTime), (long)1000000L, (long)track.timescale);
            }
            durationUs = Util.scaleLargeTimestamp((long)(duration - editStartTime), (long)1000000L, (long)track.timescale);
            return new TrackSampleTable(track, offsets, sizes, maximumSize, timestamps, flags, durationUs);
        }
        boolean omitClippedSample = track.type == 1;
        int editedSampleCount = 0;
        int nextSampleIndex = 0;
        boolean copyMetadata = false;
        int[] startIndices = new int[track.editListDurations.length];
        int[] endIndices = new int[track.editListDurations.length];
        long[] editListMediaTimes = (long[])Assertions.checkNotNull((Object)track.editListMediaTimes);
        for (int i = 0; i < track.editListDurations.length; ++i) {
            long editMediaTime = editListMediaTimes[i];
            if (editMediaTime == -1L) continue;
            long editDuration = Util.scaleLargeTimestamp((long)track.editListDurations[i], (long)track.timescale, (long)track.movieTimescale);
            startIndices[i] = Util.binarySearchFloor((long[])timestamps, (long)editMediaTime, (boolean)true, (boolean)true);
            endIndices[i] = Util.binarySearchCeil((long[])timestamps, (long)(editMediaTime + editDuration), (boolean)omitClippedSample, (boolean)false);
            while (startIndices[i] < endIndices[i] && (flags[startIndices[i]] & 1) == 0) {
                int n = i;
                startIndices[n] = startIndices[n] + 1;
            }
            editedSampleCount += endIndices[i] - startIndices[i];
            copyMetadata |= nextSampleIndex != startIndices[i];
            nextSampleIndex = endIndices[i];
        }
        long[] editedOffsets = (copyMetadata |= editedSampleCount != sampleCount) ? new long[editedSampleCount] : offsets;
        int[] editedSizes = copyMetadata ? new int[editedSampleCount] : sizes;
        int editedMaximumSize = copyMetadata ? 0 : maximumSize;
        int[] editedFlags = copyMetadata ? new int[editedSampleCount] : flags;
        long[] editedTimestamps = new long[editedSampleCount];
        long pts = 0L;
        int sampleIndex = 0;
        for (int i = 0; i < track.editListDurations.length; ++i) {
            long editMediaTime = track.editListMediaTimes[i];
            int startIndex = startIndices[i];
            int endIndex = endIndices[i];
            if (copyMetadata) {
                int count = endIndex - startIndex;
                System.arraycopy(offsets, startIndex, editedOffsets, sampleIndex, count);
                System.arraycopy(sizes, startIndex, editedSizes, sampleIndex, count);
                System.arraycopy(flags, startIndex, editedFlags, sampleIndex, count);
            }
            for (int j = startIndex; j < endIndex; ++j) {
                long ptsUs = Util.scaleLargeTimestamp((long)pts, (long)1000000L, (long)track.movieTimescale);
                long timeInSegmentUs = Util.scaleLargeTimestamp((long)(timestamps[j] - editMediaTime), (long)1000000L, (long)track.timescale);
                if (AtomParsers.canTrimSamplesWithTimestampChange(track.type)) {
                    timeInSegmentUs = Math.max(0L, timeInSegmentUs);
                }
                editedTimestamps[sampleIndex] = ptsUs + timeInSegmentUs;
                if (copyMetadata && editedSizes[sampleIndex] > editedMaximumSize) {
                    editedMaximumSize = sizes[j];
                }
                ++sampleIndex;
            }
            pts += track.editListDurations[i];
        }
        long editedDurationUs = Util.scaleLargeTimestamp((long)pts, (long)1000000L, (long)track.movieTimescale);
        return new TrackSampleTable(track, editedOffsets, editedSizes, editedMaximumSize, editedTimestamps, editedFlags, editedDurationUs);
    }

    private static boolean canTrimSamplesWithTimestampChange(int trackType) {
        return trackType != 1;
    }

    @Nullable
    private static Metadata parseUdtaMeta(ParsableByteArray meta, int limit) {
        meta.skipBytes(8);
        AtomParsers.maybeSkipRemainingMetaAtomHeaderBytes(meta);
        while (meta.getPosition() < limit) {
            int atomPosition = meta.getPosition();
            int atomSize = meta.readInt();
            int atomType = meta.readInt();
            if (atomType == 1768715124) {
                meta.setPosition(atomPosition);
                return AtomParsers.parseIlst(meta, atomPosition + atomSize);
            }
            meta.setPosition(atomPosition + atomSize);
        }
        return null;
    }

    @Nullable
    private static Metadata parseIlst(ParsableByteArray ilst, int limit) {
        ilst.skipBytes(8);
        ArrayList<Metadata.Entry> entries = new ArrayList<Metadata.Entry>();
        while (ilst.getPosition() < limit) {
            Metadata.Entry entry = MetadataUtil.parseIlstElement(ilst);
            if (entry == null) continue;
            entries.add(entry);
        }
        return entries.isEmpty() ? null : new Metadata(entries);
    }

    @Nullable
    private static Metadata parseXyz(ParsableByteArray xyzBox) {
        short length = xyzBox.readShort();
        xyzBox.skipBytes(2);
        String location = xyzBox.readString((int)length);
        int plusSignIndex = location.lastIndexOf(43);
        int minusSignIndex = location.lastIndexOf(45);
        int latitudeEndIndex = Math.max(plusSignIndex, minusSignIndex);
        try {
            float latitude = Float.parseFloat(location.substring(0, latitudeEndIndex));
            float longitude = Float.parseFloat(location.substring(latitudeEndIndex, location.length() - 1));
            return new Metadata(new Metadata.Entry[]{new Mp4LocationData(latitude, longitude)});
        }
        catch (IndexOutOfBoundsException | NumberFormatException exception) {
            return null;
        }
    }

    @Nullable
    private static Metadata parseSmta(ParsableByteArray smta, int limit) {
        smta.skipBytes(12);
        while (smta.getPosition() < limit) {
            int atomPosition = smta.getPosition();
            int atomSize = smta.readInt();
            int atomType = smta.readInt();
            if (atomType == 1935766900) {
                if (atomSize < 14) {
                    return null;
                }
                smta.skipBytes(5);
                int recordingMode = smta.readUnsignedByte();
                if (recordingMode != 12 && recordingMode != 13) {
                    return null;
                }
                float captureFrameRate = recordingMode == 12 ? 240.0f : 120.0f;
                smta.skipBytes(1);
                int svcTemporalLayerCount = smta.readUnsignedByte();
                return new Metadata(new Metadata.Entry[]{new SmtaMetadataEntry(captureFrameRate, svcTemporalLayerCount)});
            }
            smta.setPosition(atomPosition + atomSize);
        }
        return null;
    }

    private static TkhdData parseTkhd(ParsableByteArray tkhd) {
        long duration;
        tkhd.setPosition(8);
        int fullAtom = tkhd.readInt();
        int version = Atom.parseFullAtomVersion(fullAtom);
        tkhd.skipBytes(version == 0 ? 8 : 16);
        int trackId = tkhd.readInt();
        tkhd.skipBytes(4);
        boolean durationUnknown = true;
        int durationPosition = tkhd.getPosition();
        int durationByteCount = version == 0 ? 4 : 8;
        for (int i = 0; i < durationByteCount; ++i) {
            if (tkhd.getData()[durationPosition + i] == -1) continue;
            durationUnknown = false;
            break;
        }
        if (durationUnknown) {
            tkhd.skipBytes(durationByteCount);
            duration = -9223372036854775807L;
        } else {
            long l = duration = version == 0 ? tkhd.readUnsignedInt() : tkhd.readUnsignedLongToLong();
            if (duration == 0L) {
                duration = -9223372036854775807L;
            }
        }
        tkhd.skipBytes(16);
        int a00 = tkhd.readInt();
        int a01 = tkhd.readInt();
        tkhd.skipBytes(4);
        int a10 = tkhd.readInt();
        int a11 = tkhd.readInt();
        int fixedOne = 65536;
        int rotationDegrees = a00 == 0 && a01 == fixedOne && a10 == -fixedOne && a11 == 0 ? 90 : (a00 == 0 && a01 == -fixedOne && a10 == fixedOne && a11 == 0 ? 270 : (a00 == -fixedOne && a01 == 0 && a10 == 0 && a11 == -fixedOne ? 180 : 0));
        return new TkhdData(trackId, duration, rotationDegrees);
    }

    private static int parseHdlr(ParsableByteArray hdlr) {
        hdlr.setPosition(16);
        return hdlr.readInt();
    }

    private static int getTrackTypeForHdlr(int hdlr) {
        if (hdlr == 1936684398) {
            return 1;
        }
        if (hdlr == 1986618469) {
            return 2;
        }
        if (hdlr == 1952807028 || hdlr == 1935832172 || hdlr == 1937072756 || hdlr == 1668047728) {
            return 3;
        }
        if (hdlr == 1835365473) {
            return 5;
        }
        return -1;
    }

    private static Pair<Long, String> parseMdhd(ParsableByteArray mdhd) {
        mdhd.setPosition(8);
        int fullAtom = mdhd.readInt();
        int version = Atom.parseFullAtomVersion(fullAtom);
        mdhd.skipBytes(version == 0 ? 8 : 16);
        long timescale = mdhd.readUnsignedInt();
        mdhd.skipBytes(version == 0 ? 4 : 8);
        int languageCode = mdhd.readUnsignedShort();
        String language = "" + (char)((languageCode >> 10 & 0x1F) + 96) + (char)((languageCode >> 5 & 0x1F) + 96) + (char)((languageCode & 0x1F) + 96);
        return Pair.create((Object)timescale, (Object)language);
    }

    private static StsdData parseStsd(ParsableByteArray stsd, int trackId, int rotationDegrees, String language, @Nullable DrmInitData drmInitData, boolean isQuickTime) throws ParserException {
        stsd.setPosition(12);
        int numberOfEntries = stsd.readInt();
        StsdData out = new StsdData(numberOfEntries);
        for (int i = 0; i < numberOfEntries; ++i) {
            int childStartPosition = stsd.getPosition();
            int childAtomSize = stsd.readInt();
            ExtractorUtil.checkContainerInput(childAtomSize > 0, "childAtomSize must be positive");
            int childAtomType = stsd.readInt();
            if (childAtomType == 1635148593 || childAtomType == 1635148595 || childAtomType == 1701733238 || childAtomType == 1831958048 || childAtomType == 1836070006 || childAtomType == 1752589105 || childAtomType == 1751479857 || childAtomType == 1932670515 || childAtomType == 1211250227 || childAtomType == 1987063864 || childAtomType == 1987063865 || childAtomType == 1635135537 || childAtomType == 1685479798 || childAtomType == 1685479729 || childAtomType == 1685481573 || childAtomType == 1685481521) {
                AtomParsers.parseVideoSampleEntry(stsd, childAtomType, childStartPosition, childAtomSize, trackId, rotationDegrees, drmInitData, out, i);
            } else if (childAtomType == 1836069985 || childAtomType == 1701733217 || childAtomType == 1633889587 || childAtomType == 1700998451 || childAtomType == 1633889588 || childAtomType == 1835823201 || childAtomType == 1685353315 || childAtomType == 1685353317 || childAtomType == 1685353320 || childAtomType == 1685353324 || childAtomType == 1685353336 || childAtomType == 1935764850 || childAtomType == 1935767394 || childAtomType == 1819304813 || childAtomType == 1936684916 || childAtomType == 1953984371 || childAtomType == 778924082 || childAtomType == 778924083 || childAtomType == 1835557169 || childAtomType == 1835560241 || childAtomType == 1634492771 || childAtomType == 1634492791 || childAtomType == 1970037111 || childAtomType == 1332770163 || childAtomType == 1716281667) {
                AtomParsers.parseAudioSampleEntry(stsd, childAtomType, childStartPosition, childAtomSize, trackId, language, isQuickTime, drmInitData, out, i);
            } else if (childAtomType == 1414810956 || childAtomType == 1954034535 || childAtomType == 0x77767474 || childAtomType == 1937010800 || childAtomType == 1664495672) {
                AtomParsers.parseTextSampleEntry(stsd, childAtomType, childStartPosition, childAtomSize, trackId, language, out);
            } else if (childAtomType == 1835365492) {
                AtomParsers.parseMetaDataSampleEntry(stsd, childAtomType, childStartPosition, trackId, out);
            } else if (childAtomType == 1667329389) {
                out.format = new Format.Builder().setId(trackId).setSampleMimeType("application/x-camera-motion").build();
            }
            stsd.setPosition(childStartPosition + childAtomSize);
        }
        return out;
    }

    private static void parseTextSampleEntry(ParsableByteArray parent, int atomType, int position, int atomSize, int trackId, String language, StsdData out) {
        String mimeType;
        parent.setPosition(position + 8 + 8);
        ImmutableList initializationData = null;
        long subsampleOffsetUs = Long.MAX_VALUE;
        if (atomType == 1414810956) {
            mimeType = "application/ttml+xml";
        } else if (atomType == 1954034535) {
            mimeType = "application/x-quicktime-tx3g";
            int sampleDescriptionLength = atomSize - 8 - 8;
            byte[] sampleDescriptionData = new byte[sampleDescriptionLength];
            parent.readBytes(sampleDescriptionData, 0, sampleDescriptionLength);
            initializationData = ImmutableList.of((Object)sampleDescriptionData);
        } else if (atomType == 0x77767474) {
            mimeType = "application/x-mp4-vtt";
        } else if (atomType == 1937010800) {
            mimeType = "application/ttml+xml";
            subsampleOffsetUs = 0L;
        } else if (atomType == 1664495672) {
            mimeType = "application/x-mp4-cea-608";
            out.requiredSampleTransformation = 1;
        } else {
            throw new IllegalStateException();
        }
        out.format = new Format.Builder().setId(trackId).setSampleMimeType(mimeType).setLanguage(language).setSubsampleOffsetUs(subsampleOffsetUs).setInitializationData(initializationData).build();
    }

    private static void parseVideoSampleEntry(ParsableByteArray parent, int atomType, int position, int size, int trackId, int rotationDegrees, @Nullable DrmInitData drmInitData, StsdData out, int entryIndex) throws ParserException {
        parent.setPosition(position + 8 + 8);
        parent.skipBytes(16);
        int width = parent.readUnsignedShort();
        int height = parent.readUnsignedShort();
        boolean pixelWidthHeightRatioFromPasp = false;
        float pixelWidthHeightRatio = 1.0f;
        int bitdepthLuma = 8;
        int bitdepthChroma = 8;
        parent.skipBytes(50);
        int childPosition = parent.getPosition();
        if (atomType == 1701733238) {
            Pair<Integer, TrackEncryptionBox> sampleEntryEncryptionData = AtomParsers.parseSampleEntryEncryptionData(parent, position, size);
            if (sampleEntryEncryptionData != null) {
                atomType = (Integer)sampleEntryEncryptionData.first;
                drmInitData = drmInitData == null ? null : drmInitData.copyWithSchemeType(((TrackEncryptionBox)sampleEntryEncryptionData.second).schemeType);
                out.trackEncryptionBoxes[entryIndex] = (TrackEncryptionBox)sampleEntryEncryptionData.second;
            }
            parent.setPosition(childPosition);
        }
        String mimeType = null;
        if (atomType == 1831958048) {
            mimeType = "video/mpeg";
        } else if (atomType == 1211250227) {
            mimeType = "video/3gpp";
        }
        ImmutableList initializationData = null;
        String codecs = null;
        byte[] projectionData = null;
        int stereoMode = -1;
        EsdsData esdsData = null;
        int colorSpace = -1;
        int colorRange = -1;
        int colorTransfer = -1;
        ByteBuffer hdrStaticInfo = null;
        while (childPosition - position < size) {
            parent.setPosition(childPosition);
            int childStartPosition = parent.getPosition();
            int childAtomSize = parent.readInt();
            if (childAtomSize == 0 && parent.getPosition() - position == size) break;
            ExtractorUtil.checkContainerInput(childAtomSize > 0, "childAtomSize must be positive");
            int childAtomType = parent.readInt();
            if (childAtomType == 1635148611) {
                ExtractorUtil.checkContainerInput(mimeType == null, null);
                mimeType = "video/avc";
                parent.setPosition(childStartPosition + 8);
                AvcConfig avcConfig = AvcConfig.parse(parent);
                initializationData = avcConfig.initializationData;
                out.nalUnitLengthFieldLength = avcConfig.nalUnitLengthFieldLength;
                if (!pixelWidthHeightRatioFromPasp) {
                    pixelWidthHeightRatio = avcConfig.pixelWidthHeightRatio;
                }
                codecs = avcConfig.codecs;
                colorSpace = avcConfig.colorSpace;
                colorRange = avcConfig.colorRange;
                colorTransfer = avcConfig.colorTransfer;
                bitdepthLuma = avcConfig.bitdepthLuma;
                bitdepthChroma = avcConfig.bitdepthChroma;
            } else if (childAtomType == 1752589123) {
                ExtractorUtil.checkContainerInput(mimeType == null, null);
                mimeType = "video/hevc";
                parent.setPosition(childStartPosition + 8);
                HevcConfig hevcConfig = HevcConfig.parse(parent);
                initializationData = hevcConfig.initializationData;
                out.nalUnitLengthFieldLength = hevcConfig.nalUnitLengthFieldLength;
                if (!pixelWidthHeightRatioFromPasp) {
                    pixelWidthHeightRatio = hevcConfig.pixelWidthHeightRatio;
                }
                codecs = hevcConfig.codecs;
                colorSpace = hevcConfig.colorSpace;
                colorRange = hevcConfig.colorRange;
                colorTransfer = hevcConfig.colorTransfer;
                bitdepthLuma = hevcConfig.bitdepthLuma;
                bitdepthChroma = hevcConfig.bitdepthChroma;
            } else if (childAtomType == 1685480259 || childAtomType == 1685485123) {
                DolbyVisionConfig dolbyVisionConfig = DolbyVisionConfig.parse(parent);
                if (dolbyVisionConfig != null) {
                    codecs = dolbyVisionConfig.codecs;
                    mimeType = "video/dolby-vision";
                }
            } else if (childAtomType == 1987076931) {
                ExtractorUtil.checkContainerInput(mimeType == null, null);
                mimeType = atomType == 1987063864 ? "video/x-vnd.on2.vp8" : "video/x-vnd.on2.vp9";
                parent.setPosition(childStartPosition + 12);
                parent.skipBytes(2);
                int byte3 = parent.readUnsignedByte();
                bitdepthChroma = bitdepthLuma = byte3 >> 4;
                boolean fullRangeFlag = (byte3 & 1) != 0;
                int colorPrimaries = parent.readUnsignedByte();
                int transferCharacteristics = parent.readUnsignedByte();
                colorSpace = ColorInfo.isoColorPrimariesToColorSpace((int)colorPrimaries);
                colorRange = fullRangeFlag ? 1 : 2;
                colorTransfer = ColorInfo.isoTransferCharacteristicsToColorTransfer((int)transferCharacteristics);
            } else if (childAtomType == 1635135811) {
                boolean highBitdepth;
                ExtractorUtil.checkContainerInput(mimeType == null, null);
                mimeType = "video/av01";
                parent.setPosition(childStartPosition + 8);
                parent.skipBytes(1);
                int byte2 = parent.readUnsignedByte();
                int seqProfile = byte2 >> 5;
                int byte3 = parent.readUnsignedByte();
                boolean bl = highBitdepth = (byte3 >> 6 & 1) != 0;
                if (seqProfile == 2 && highBitdepth) {
                    boolean twelveBit = (byte3 >> 5 & 1) != 0;
                    bitdepthLuma = twelveBit ? 12 : 10;
                } else if (seqProfile <= 2) {
                    bitdepthLuma = highBitdepth ? 10 : 8;
                }
                bitdepthChroma = bitdepthLuma;
            } else if (childAtomType == 1668050025) {
                if (hdrStaticInfo == null) {
                    hdrStaticInfo = AtomParsers.allocateHdrStaticInfo();
                }
                hdrStaticInfo.position(21);
                hdrStaticInfo.putShort(parent.readShort());
                hdrStaticInfo.putShort(parent.readShort());
            } else if (childAtomType == 1835295606) {
                if (hdrStaticInfo == null) {
                    hdrStaticInfo = AtomParsers.allocateHdrStaticInfo();
                }
                short displayPrimariesGX = parent.readShort();
                short displayPrimariesGY = parent.readShort();
                short displayPrimariesBX = parent.readShort();
                short displayPrimariesBY = parent.readShort();
                short displayPrimariesRX = parent.readShort();
                short displayPrimariesRY = parent.readShort();
                short whitePointX = parent.readShort();
                short whitePointY = parent.readShort();
                long maxDisplayMasteringLuminance = parent.readUnsignedInt();
                long minDisplayMasteringLuminance = parent.readUnsignedInt();
                hdrStaticInfo.position(1);
                hdrStaticInfo.putShort(displayPrimariesRX);
                hdrStaticInfo.putShort(displayPrimariesRY);
                hdrStaticInfo.putShort(displayPrimariesGX);
                hdrStaticInfo.putShort(displayPrimariesGY);
                hdrStaticInfo.putShort(displayPrimariesBX);
                hdrStaticInfo.putShort(displayPrimariesBY);
                hdrStaticInfo.putShort(whitePointX);
                hdrStaticInfo.putShort(whitePointY);
                hdrStaticInfo.putShort((short)(maxDisplayMasteringLuminance / 10000L));
                hdrStaticInfo.putShort((short)(minDisplayMasteringLuminance / 10000L));
            } else if (childAtomType == 1681012275) {
                ExtractorUtil.checkContainerInput(mimeType == null, null);
                mimeType = "video/3gpp";
            } else if (childAtomType == 1702061171) {
                ExtractorUtil.checkContainerInput(mimeType == null, null);
                esdsData = AtomParsers.parseEsdsFromParent(parent, childStartPosition);
                mimeType = esdsData.mimeType;
                byte[] initializationDataBytes = esdsData.initializationData;
                if (initializationDataBytes != null) {
                    initializationData = ImmutableList.of((Object)initializationDataBytes);
                }
            } else if (childAtomType == 1885434736) {
                pixelWidthHeightRatio = AtomParsers.parsePaspFromParent(parent, childStartPosition);
                pixelWidthHeightRatioFromPasp = true;
            } else if (childAtomType == 1937126244) {
                projectionData = AtomParsers.parseProjFromParent(parent, childStartPosition, childAtomSize);
            } else if (childAtomType == 1936995172) {
                int version = parent.readUnsignedByte();
                parent.skipBytes(3);
                if (version == 0) {
                    int layout = parent.readUnsignedByte();
                    switch (layout) {
                        case 0: {
                            stereoMode = 0;
                            break;
                        }
                        case 1: {
                            stereoMode = 1;
                            break;
                        }
                        case 2: {
                            stereoMode = 2;
                            break;
                        }
                        case 3: {
                            stereoMode = 3;
                            break;
                        }
                    }
                }
            } else if (childAtomType == 1668246642 && colorSpace == -1 && colorTransfer == -1) {
                int colorType = parent.readInt();
                if (colorType == 1852009592 || colorType == 1852009571) {
                    int colorPrimaries = parent.readUnsignedShort();
                    int transferCharacteristics = parent.readUnsignedShort();
                    parent.skipBytes(2);
                    boolean fullRangeFlag = childAtomSize == 19 && (parent.readUnsignedByte() & 0x80) != 0;
                    colorSpace = ColorInfo.isoColorPrimariesToColorSpace((int)colorPrimaries);
                    colorRange = fullRangeFlag ? 1 : 2;
                    colorTransfer = ColorInfo.isoTransferCharacteristicsToColorTransfer((int)transferCharacteristics);
                } else {
                    Log.w((String)TAG, (String)("Unsupported color type: " + Atom.getAtomTypeString(colorType)));
                }
            }
            childPosition += childAtomSize;
        }
        if (mimeType == null) {
            return;
        }
        Format.Builder formatBuilder = new Format.Builder().setId(trackId).setSampleMimeType(mimeType).setCodecs(codecs).setWidth(width).setHeight(height).setPixelWidthHeightRatio(pixelWidthHeightRatio).setRotationDegrees(rotationDegrees).setProjectionData(projectionData).setStereoMode(stereoMode).setInitializationData(initializationData).setDrmInitData(drmInitData).setColorInfo(new ColorInfo.Builder().setColorSpace(colorSpace).setColorRange(colorRange).setColorTransfer(colorTransfer).setHdrStaticInfo(hdrStaticInfo != null ? hdrStaticInfo.array() : null).setLumaBitdepth(bitdepthLuma).setChromaBitdepth(bitdepthChroma).build());
        if (esdsData != null) {
            formatBuilder.setAverageBitrate(Ints.saturatedCast((long)esdsData.bitrate)).setPeakBitrate(Ints.saturatedCast((long)esdsData.peakBitrate));
        }
        out.format = formatBuilder.build();
    }

    private static ByteBuffer allocateHdrStaticInfo() {
        return ByteBuffer.allocate(25).order(ByteOrder.LITTLE_ENDIAN);
    }

    private static void parseMetaDataSampleEntry(ParsableByteArray parent, int atomType, int position, int trackId, StsdData out) {
        parent.setPosition(position + 8 + 8);
        if (atomType == 1835365492) {
            parent.readNullTerminatedString();
            String mimeType = parent.readNullTerminatedString();
            if (mimeType != null) {
                out.format = new Format.Builder().setId(trackId).setSampleMimeType(mimeType).build();
            }
        }
    }

    @Nullable
    private static Pair<long[], long[]> parseEdts(Atom.ContainerAtom edtsAtom) {
        Atom.LeafAtom elstAtom = edtsAtom.getLeafAtomOfType(1701606260);
        if (elstAtom == null) {
            return null;
        }
        ParsableByteArray elstData = elstAtom.data;
        elstData.setPosition(8);
        int fullAtom = elstData.readInt();
        int version = Atom.parseFullAtomVersion(fullAtom);
        int entryCount = elstData.readUnsignedIntToInt();
        long[] editListDurations = new long[entryCount];
        long[] editListMediaTimes = new long[entryCount];
        for (int i = 0; i < entryCount; ++i) {
            editListDurations[i] = version == 1 ? elstData.readUnsignedLongToLong() : elstData.readUnsignedInt();
            editListMediaTimes[i] = version == 1 ? elstData.readLong() : (long)elstData.readInt();
            short mediaRateInteger = elstData.readShort();
            if (mediaRateInteger != 1) {
                throw new IllegalArgumentException("Unsupported media rate.");
            }
            elstData.skipBytes(2);
        }
        return Pair.create((Object)editListDurations, (Object)editListMediaTimes);
    }

    private static float parsePaspFromParent(ParsableByteArray parent, int position) {
        parent.setPosition(position + 8);
        int hSpacing = parent.readUnsignedIntToInt();
        int vSpacing = parent.readUnsignedIntToInt();
        return (float)hSpacing / (float)vSpacing;
    }

    private static void parseAudioSampleEntry(ParsableByteArray parent, int atomType, int position, int size, int trackId, String language, boolean isQuickTime, @Nullable DrmInitData drmInitData, StsdData out, int entryIndex) throws ParserException {
        int sampleRate;
        int channelCount;
        parent.setPosition(position + 8 + 8);
        int quickTimeSoundDescriptionVersion = 0;
        if (isQuickTime) {
            quickTimeSoundDescriptionVersion = parent.readUnsignedShort();
            parent.skipBytes(6);
        } else {
            parent.skipBytes(8);
        }
        int sampleRateMlp = 0;
        int pcmEncoding = -1;
        String codecs = null;
        EsdsData esdsData = null;
        if (quickTimeSoundDescriptionVersion == 0 || quickTimeSoundDescriptionVersion == 1) {
            channelCount = parent.readUnsignedShort();
            parent.skipBytes(6);
            sampleRate = parent.readUnsignedFixedPoint1616();
            parent.setPosition(parent.getPosition() - 4);
            sampleRateMlp = parent.readInt();
            if (quickTimeSoundDescriptionVersion == 1) {
                parent.skipBytes(16);
            }
        } else if (quickTimeSoundDescriptionVersion == 2) {
            boolean isBigEndian;
            parent.skipBytes(16);
            sampleRate = (int)Math.round(parent.readDouble());
            channelCount = parent.readUnsignedIntToInt();
            parent.skipBytes(4);
            int bitsPerSample = parent.readUnsignedIntToInt();
            int formatSpecificFlags = parent.readUnsignedIntToInt();
            boolean isFloat = (formatSpecificFlags & 1) != 0;
            boolean bl = isBigEndian = (formatSpecificFlags & 2) != 0;
            if (!isFloat) {
                if (bitsPerSample == 8) {
                    pcmEncoding = 3;
                } else if (bitsPerSample == 16) {
                    pcmEncoding = isBigEndian ? 0x10000000 : 2;
                } else if (bitsPerSample == 24) {
                    pcmEncoding = isBigEndian ? 0x50000000 : 0x20000000;
                } else if (bitsPerSample == 32) {
                    pcmEncoding = isBigEndian ? 0x60000000 : 0x30000000;
                }
            } else if (bitsPerSample == 32) {
                pcmEncoding = 4;
            }
            parent.skipBytes(8);
        } else {
            return;
        }
        int childPosition = parent.getPosition();
        if (atomType == 1701733217) {
            Pair<Integer, TrackEncryptionBox> sampleEntryEncryptionData = AtomParsers.parseSampleEntryEncryptionData(parent, position, size);
            if (sampleEntryEncryptionData != null) {
                atomType = (Integer)sampleEntryEncryptionData.first;
                drmInitData = drmInitData == null ? null : drmInitData.copyWithSchemeType(((TrackEncryptionBox)sampleEntryEncryptionData.second).schemeType);
                out.trackEncryptionBoxes[entryIndex] = (TrackEncryptionBox)sampleEntryEncryptionData.second;
            }
            parent.setPosition(childPosition);
        }
        String mimeType = null;
        if (atomType == 1633889587) {
            mimeType = "audio/ac3";
        } else if (atomType == 1700998451) {
            mimeType = "audio/eac3";
        } else if (atomType == 1633889588) {
            mimeType = "audio/ac4";
        } else if (atomType == 1685353315) {
            mimeType = "audio/vnd.dts";
        } else if (atomType == 1685353320 || atomType == 1685353324) {
            mimeType = "audio/vnd.dts.hd";
        } else if (atomType == 1685353317) {
            mimeType = "audio/vnd.dts.hd;profile=lbr";
        } else if (atomType == 1685353336) {
            mimeType = "audio/vnd.dts.uhd;profile=p2";
        } else if (atomType == 1935764850) {
            mimeType = "audio/3gpp";
        } else if (atomType == 1935767394) {
            mimeType = "audio/amr-wb";
        } else if (atomType == 1936684916) {
            mimeType = "audio/raw";
            pcmEncoding = 2;
        } else if (atomType == 1953984371) {
            mimeType = "audio/raw";
            pcmEncoding = 0x10000000;
        } else if (atomType == 1819304813) {
            mimeType = "audio/raw";
            if (pcmEncoding == -1) {
                pcmEncoding = 2;
            }
        } else if (atomType == 778924082 || atomType == 778924083) {
            mimeType = "audio/mpeg";
        } else if (atomType == 1835557169) {
            mimeType = "audio/mha1";
        } else if (atomType == 1835560241) {
            mimeType = "audio/mhm1";
        } else if (atomType == 1634492771) {
            mimeType = "audio/alac";
        } else if (atomType == 1634492791) {
            mimeType = "audio/g711-alaw";
        } else if (atomType == 1970037111) {
            mimeType = "audio/g711-mlaw";
        } else if (atomType == 1332770163) {
            mimeType = "audio/opus";
        } else if (atomType == 1716281667) {
            mimeType = "audio/flac";
        } else if (atomType == 1835823201) {
            mimeType = "audio/true-hd";
        }
        Object initializationData = null;
        while (childPosition - position < size) {
            int childAtomBodySize;
            parent.setPosition(childPosition);
            int childAtomSize = parent.readInt();
            ExtractorUtil.checkContainerInput(childAtomSize > 0, "childAtomSize must be positive");
            int childAtomType = parent.readInt();
            if (childAtomType == 1835557187) {
                int mhacHeaderSize = 13;
                int childAtomBodySize2 = childAtomSize - mhacHeaderSize;
                byte[] initializationDataBytes = new byte[childAtomBodySize2];
                parent.setPosition(childPosition + mhacHeaderSize);
                parent.readBytes(initializationDataBytes, 0, childAtomBodySize2);
                initializationData = ImmutableList.of((Object)initializationDataBytes);
            } else if (childAtomType == 1702061171 || isQuickTime && childAtomType == 2002876005) {
                int esdsAtomPosition;
                int n = esdsAtomPosition = childAtomType == 1702061171 ? childPosition : AtomParsers.findBoxPosition(parent, 1702061171, childPosition, childAtomSize);
                if (esdsAtomPosition != -1) {
                    esdsData = AtomParsers.parseEsdsFromParent(parent, esdsAtomPosition);
                    mimeType = esdsData.mimeType;
                    byte[] initializationDataBytes = esdsData.initializationData;
                    if (initializationDataBytes != null) {
                        if ("audio/vorbis".equals(mimeType)) {
                            initializationData = VorbisUtil.parseVorbisCsdFromEsdsInitializationData(initializationDataBytes);
                        } else {
                            if ("audio/mp4a-latm".equals(mimeType)) {
                                AacUtil.Config aacConfig = AacUtil.parseAudioSpecificConfig(initializationDataBytes);
                                sampleRate = aacConfig.sampleRateHz;
                                channelCount = aacConfig.channelCount;
                                codecs = aacConfig.codecs;
                            }
                            initializationData = ImmutableList.of((Object)initializationDataBytes);
                        }
                    }
                }
            } else if (childAtomType == 1684103987) {
                parent.setPosition(8 + childPosition);
                out.format = Ac3Util.parseAc3AnnexFFormat(parent, Integer.toString(trackId), language, drmInitData);
            } else if (childAtomType == 1684366131) {
                parent.setPosition(8 + childPosition);
                out.format = Ac3Util.parseEAc3AnnexFFormat(parent, Integer.toString(trackId), language, drmInitData);
            } else if (childAtomType == 1684103988) {
                parent.setPosition(8 + childPosition);
                out.format = Ac4Util.parseAc4AnnexEFormat(parent, Integer.toString(trackId), language, drmInitData);
            } else if (childAtomType == 1684892784) {
                if (sampleRateMlp <= 0) {
                    throw ParserException.createForMalformedContainer((String)("Invalid sample rate for Dolby TrueHD MLP stream: " + sampleRateMlp), null);
                }
                sampleRate = sampleRateMlp;
                channelCount = 2;
            } else if (childAtomType == 1684305011 || childAtomType == 1969517683) {
                out.format = new Format.Builder().setId(trackId).setSampleMimeType(mimeType).setChannelCount(channelCount).setSampleRate(sampleRate).setDrmInitData(drmInitData).setLanguage(language).build();
            } else if (childAtomType == 1682927731) {
                childAtomBodySize = childAtomSize - 8;
                byte[] headerBytes = Arrays.copyOf(opusMagic, opusMagic.length + childAtomBodySize);
                parent.setPosition(childPosition + 8);
                parent.readBytes(headerBytes, opusMagic.length, childAtomBodySize);
                initializationData = OpusUtil.buildInitializationData(headerBytes);
            } else if (childAtomType == 1684425825) {
                childAtomBodySize = childAtomSize - 12;
                byte[] initializationDataBytes = new byte[4 + childAtomBodySize];
                initializationDataBytes[0] = 102;
                initializationDataBytes[1] = 76;
                initializationDataBytes[2] = 97;
                initializationDataBytes[3] = 67;
                parent.setPosition(childPosition + 12);
                parent.readBytes(initializationDataBytes, 4, childAtomBodySize);
                initializationData = ImmutableList.of((Object)initializationDataBytes);
            } else if (childAtomType == 1634492771) {
                childAtomBodySize = childAtomSize - 12;
                byte[] initializationDataBytes = new byte[childAtomBodySize];
                parent.setPosition(childPosition + 12);
                parent.readBytes(initializationDataBytes, 0, childAtomBodySize);
                Pair audioSpecificConfig = CodecSpecificDataUtil.parseAlacAudioSpecificConfig((byte[])initializationDataBytes);
                sampleRate = (Integer)audioSpecificConfig.first;
                channelCount = (Integer)audioSpecificConfig.second;
                initializationData = ImmutableList.of((Object)initializationDataBytes);
            }
            childPosition += childAtomSize;
        }
        if (out.format == null && mimeType != null) {
            Format.Builder formatBuilder = new Format.Builder().setId(trackId).setSampleMimeType(mimeType).setCodecs(codecs).setChannelCount(channelCount).setSampleRate(sampleRate).setPcmEncoding(pcmEncoding).setInitializationData(initializationData).setDrmInitData(drmInitData).setLanguage(language);
            if (esdsData != null) {
                formatBuilder.setAverageBitrate(Ints.saturatedCast((long)esdsData.bitrate)).setPeakBitrate(Ints.saturatedCast((long)esdsData.peakBitrate));
            }
            out.format = formatBuilder.build();
        }
    }

    private static int findBoxPosition(ParsableByteArray parent, int boxType, int parentBoxPosition, int parentBoxSize) throws ParserException {
        int childAtomPosition = parent.getPosition();
        ExtractorUtil.checkContainerInput(childAtomPosition >= parentBoxPosition, null);
        while (childAtomPosition - parentBoxPosition < parentBoxSize) {
            parent.setPosition(childAtomPosition);
            int childAtomSize = parent.readInt();
            ExtractorUtil.checkContainerInput(childAtomSize > 0, "childAtomSize must be positive");
            int childType = parent.readInt();
            if (childType == boxType) {
                return childAtomPosition;
            }
            childAtomPosition += childAtomSize;
        }
        return -1;
    }

    private static EsdsData parseEsdsFromParent(ParsableByteArray parent, int position) {
        parent.setPosition(position + 8 + 4);
        parent.skipBytes(1);
        AtomParsers.parseExpandableClassSize(parent);
        parent.skipBytes(2);
        int flags = parent.readUnsignedByte();
        if ((flags & 0x80) != 0) {
            parent.skipBytes(2);
        }
        if ((flags & 0x40) != 0) {
            parent.skipBytes(parent.readUnsignedByte());
        }
        if ((flags & 0x20) != 0) {
            parent.skipBytes(2);
        }
        parent.skipBytes(1);
        AtomParsers.parseExpandableClassSize(parent);
        int objectTypeIndication = parent.readUnsignedByte();
        String mimeType = MimeTypes.getMimeTypeFromMp4ObjectType((int)objectTypeIndication);
        if ("audio/mpeg".equals(mimeType) || "audio/vnd.dts".equals(mimeType) || "audio/vnd.dts.hd".equals(mimeType)) {
            return new EsdsData(mimeType, null, -1L, -1L);
        }
        parent.skipBytes(4);
        long peakBitrate = parent.readUnsignedInt();
        long bitrate = parent.readUnsignedInt();
        parent.skipBytes(1);
        int initializationDataSize = AtomParsers.parseExpandableClassSize(parent);
        byte[] initializationData = new byte[initializationDataSize];
        parent.readBytes(initializationData, 0, initializationDataSize);
        return new EsdsData(mimeType, initializationData, bitrate > 0L ? bitrate : -1L, peakBitrate > 0L ? peakBitrate : -1L);
    }

    @Nullable
    private static Pair<Integer, TrackEncryptionBox> parseSampleEntryEncryptionData(ParsableByteArray parent, int position, int size) throws ParserException {
        int childPosition = parent.getPosition();
        while (childPosition - position < size) {
            Pair<Integer, TrackEncryptionBox> result;
            parent.setPosition(childPosition);
            int childAtomSize = parent.readInt();
            ExtractorUtil.checkContainerInput(childAtomSize > 0, "childAtomSize must be positive");
            int childAtomType = parent.readInt();
            if (childAtomType == 1936289382 && (result = AtomParsers.parseCommonEncryptionSinfFromParent(parent, childPosition, childAtomSize)) != null) {
                return result;
            }
            childPosition += childAtomSize;
        }
        return null;
    }

    @Nullable
    static Pair<Integer, TrackEncryptionBox> parseCommonEncryptionSinfFromParent(ParsableByteArray parent, int position, int size) throws ParserException {
        int childPosition = position + 8;
        int schemeInformationBoxPosition = -1;
        int schemeInformationBoxSize = 0;
        String schemeType = null;
        Integer dataFormat = null;
        while (childPosition - position < size) {
            parent.setPosition(childPosition);
            int childAtomSize = parent.readInt();
            int childAtomType = parent.readInt();
            if (childAtomType == 1718775137) {
                dataFormat = parent.readInt();
            } else if (childAtomType == 1935894637) {
                parent.skipBytes(4);
                schemeType = parent.readString(4);
            } else if (childAtomType == 1935894633) {
                schemeInformationBoxPosition = childPosition;
                schemeInformationBoxSize = childAtomSize;
            }
            childPosition += childAtomSize;
        }
        if ("cenc".equals(schemeType) || "cbc1".equals(schemeType) || "cens".equals(schemeType) || "cbcs".equals(schemeType)) {
            ExtractorUtil.checkContainerInput(dataFormat != null, "frma atom is mandatory");
            ExtractorUtil.checkContainerInput(schemeInformationBoxPosition != -1, "schi atom is mandatory");
            TrackEncryptionBox encryptionBox = AtomParsers.parseSchiFromParent(parent, schemeInformationBoxPosition, schemeInformationBoxSize, schemeType);
            ExtractorUtil.checkContainerInput(encryptionBox != null, "tenc atom is mandatory");
            return Pair.create((Object)dataFormat, (Object)((TrackEncryptionBox)Util.castNonNull((Object)encryptionBox)));
        }
        return null;
    }

    @Nullable
    private static TrackEncryptionBox parseSchiFromParent(ParsableByteArray parent, int position, int size, String schemeType) {
        int childPosition = position + 8;
        while (childPosition - position < size) {
            parent.setPosition(childPosition);
            int childAtomSize = parent.readInt();
            int childAtomType = parent.readInt();
            if (childAtomType == 1952804451) {
                int fullAtom = parent.readInt();
                int version = Atom.parseFullAtomVersion(fullAtom);
                parent.skipBytes(1);
                int defaultCryptByteBlock = 0;
                int defaultSkipByteBlock = 0;
                if (version == 0) {
                    parent.skipBytes(1);
                } else {
                    int patternByte = parent.readUnsignedByte();
                    defaultCryptByteBlock = (patternByte & 0xF0) >> 4;
                    defaultSkipByteBlock = patternByte & 0xF;
                }
                boolean defaultIsProtected = parent.readUnsignedByte() == 1;
                int defaultPerSampleIvSize = parent.readUnsignedByte();
                byte[] defaultKeyId = new byte[16];
                parent.readBytes(defaultKeyId, 0, defaultKeyId.length);
                byte[] constantIv = null;
                if (defaultIsProtected && defaultPerSampleIvSize == 0) {
                    int constantIvSize = parent.readUnsignedByte();
                    constantIv = new byte[constantIvSize];
                    parent.readBytes(constantIv, 0, constantIvSize);
                }
                return new TrackEncryptionBox(defaultIsProtected, schemeType, defaultPerSampleIvSize, defaultKeyId, defaultCryptByteBlock, defaultSkipByteBlock, constantIv);
            }
            childPosition += childAtomSize;
        }
        return null;
    }

    @Nullable
    private static byte[] parseProjFromParent(ParsableByteArray parent, int position, int size) {
        int childPosition = position + 8;
        while (childPosition - position < size) {
            parent.setPosition(childPosition);
            int childAtomSize = parent.readInt();
            int childAtomType = parent.readInt();
            if (childAtomType == 1886547818) {
                return Arrays.copyOfRange(parent.getData(), childPosition, childPosition + childAtomSize);
            }
            childPosition += childAtomSize;
        }
        return null;
    }

    private static int parseExpandableClassSize(ParsableByteArray data) {
        int currentByte = data.readUnsignedByte();
        int size = currentByte & 0x7F;
        while ((currentByte & 0x80) == 128) {
            currentByte = data.readUnsignedByte();
            size = size << 7 | currentByte & 0x7F;
        }
        return size;
    }

    private static boolean canApplyEditWithGaplessInfo(long[] timestamps, long duration, long editStartTime, long editEndTime) {
        int lastIndex = timestamps.length - 1;
        int latestDelayIndex = Util.constrainValue((int)4, (int)0, (int)lastIndex);
        int earliestPaddingIndex = Util.constrainValue((int)(timestamps.length - 4), (int)0, (int)lastIndex);
        return timestamps[0] <= editStartTime && editStartTime < timestamps[latestDelayIndex] && timestamps[earliestPaddingIndex] < editEndTime && editEndTime <= duration;
    }

    private AtomParsers() {
    }

    private static final class TkhdData {
        private final int id;
        private final long duration;
        private final int rotationDegrees;

        public TkhdData(int id, long duration, int rotationDegrees) {
            this.id = id;
            this.duration = duration;
            this.rotationDegrees = rotationDegrees;
        }
    }

    private static final class StsdData {
        public static final int STSD_HEADER_SIZE = 8;
        public final TrackEncryptionBox[] trackEncryptionBoxes;
        @Nullable
        public Format format;
        public int nalUnitLengthFieldLength;
        public int requiredSampleTransformation;

        public StsdData(int numberOfEntries) {
            this.trackEncryptionBoxes = new TrackEncryptionBox[numberOfEntries];
            this.requiredSampleTransformation = 0;
        }
    }

    static final class StszSampleSizeBox
    implements SampleSizeBox {
        private final int fixedSampleSize;
        private final int sampleCount;
        private final ParsableByteArray data;

        public StszSampleSizeBox(Atom.LeafAtom stszAtom, Format trackFormat) {
            this.data = stszAtom.data;
            this.data.setPosition(12);
            int fixedSampleSize = this.data.readUnsignedIntToInt();
            if ("audio/raw".equals(trackFormat.sampleMimeType)) {
                int pcmFrameSize = Util.getPcmFrameSize((int)trackFormat.pcmEncoding, (int)trackFormat.channelCount);
                if (fixedSampleSize == 0 || fixedSampleSize % pcmFrameSize != 0) {
                    Log.w((String)AtomParsers.TAG, (String)("Audio sample size mismatch. stsd sample size: " + pcmFrameSize + ", stsz sample size: " + fixedSampleSize));
                    fixedSampleSize = pcmFrameSize;
                }
            }
            this.fixedSampleSize = fixedSampleSize == 0 ? -1 : fixedSampleSize;
            this.sampleCount = this.data.readUnsignedIntToInt();
        }

        @Override
        public int getSampleCount() {
            return this.sampleCount;
        }

        @Override
        public int getFixedSampleSize() {
            return this.fixedSampleSize;
        }

        @Override
        public int readNextSampleSize() {
            return this.fixedSampleSize == -1 ? this.data.readUnsignedIntToInt() : this.fixedSampleSize;
        }
    }

    static final class Stz2SampleSizeBox
    implements SampleSizeBox {
        private final ParsableByteArray data;
        private final int sampleCount;
        private final int fieldSize;
        private int sampleIndex;
        private int currentByte;

        public Stz2SampleSizeBox(Atom.LeafAtom stz2Atom) {
            this.data = stz2Atom.data;
            this.data.setPosition(12);
            this.fieldSize = this.data.readUnsignedIntToInt() & 0xFF;
            this.sampleCount = this.data.readUnsignedIntToInt();
        }

        @Override
        public int getSampleCount() {
            return this.sampleCount;
        }

        @Override
        public int getFixedSampleSize() {
            return -1;
        }

        @Override
        public int readNextSampleSize() {
            if (this.fieldSize == 8) {
                return this.data.readUnsignedByte();
            }
            if (this.fieldSize == 16) {
                return this.data.readUnsignedShort();
            }
            if (this.sampleIndex++ % 2 == 0) {
                this.currentByte = this.data.readUnsignedByte();
                return (this.currentByte & 0xF0) >> 4;
            }
            return this.currentByte & 0xF;
        }
    }

    private static interface SampleSizeBox {
        public int getSampleCount();

        public int getFixedSampleSize();

        public int readNextSampleSize();
    }

    private static final class ChunkIterator {
        public final int length;
        public int index;
        public int numSamples;
        public long offset;
        private final boolean chunkOffsetsAreLongs;
        private final ParsableByteArray chunkOffsets;
        private final ParsableByteArray stsc;
        private int nextSamplesPerChunkChangeIndex;
        private int remainingSamplesPerChunkChanges;

        public ChunkIterator(ParsableByteArray stsc, ParsableByteArray chunkOffsets, boolean chunkOffsetsAreLongs) throws ParserException {
            this.stsc = stsc;
            this.chunkOffsets = chunkOffsets;
            this.chunkOffsetsAreLongs = chunkOffsetsAreLongs;
            chunkOffsets.setPosition(12);
            this.length = chunkOffsets.readUnsignedIntToInt();
            stsc.setPosition(12);
            this.remainingSamplesPerChunkChanges = stsc.readUnsignedIntToInt();
            ExtractorUtil.checkContainerInput(stsc.readInt() == 1, "first_chunk must be 1");
            this.index = -1;
        }

        public boolean moveNext() {
            if (++this.index == this.length) {
                return false;
            }
            long l = this.offset = this.chunkOffsetsAreLongs ? this.chunkOffsets.readUnsignedLongToLong() : this.chunkOffsets.readUnsignedInt();
            if (this.index == this.nextSamplesPerChunkChangeIndex) {
                this.numSamples = this.stsc.readUnsignedIntToInt();
                this.stsc.skipBytes(4);
                this.nextSamplesPerChunkChangeIndex = --this.remainingSamplesPerChunkChanges > 0 ? this.stsc.readUnsignedIntToInt() - 1 : -1;
            }
            return true;
        }
    }

    private static final class EsdsData {
        private final @NullableType String mimeType;
        private final byte @NullableType [] initializationData;
        private final long bitrate;
        private final long peakBitrate;

        public EsdsData(@NullableType String mimeType, byte @NullableType [] initializationData, long bitrate, long peakBitrate) {
            this.mimeType = mimeType;
            this.initializationData = initializationData;
            this.bitrate = bitrate;
            this.peakBitrate = peakBitrate;
        }
    }
}

