/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.container;

import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;

@UnstableApi
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class ReorderingSeiMessageQueue {
    private final SeiConsumer seiConsumer;
    private final ArrayDeque<ParsableByteArray> unusedParsableByteArrays;
    private final ArrayDeque<SampleSeiMessages> unusedSampleSeiMessages;
    private final PriorityQueue<SampleSeiMessages> pendingSeiMessages;
    private int reorderingQueueSize;
    @Nullable
    private SampleSeiMessages lastQueuedMessage;

    public ReorderingSeiMessageQueue(SeiConsumer seiConsumer) {
        this.seiConsumer = seiConsumer;
        this.unusedParsableByteArrays = new ArrayDeque();
        this.unusedSampleSeiMessages = new ArrayDeque();
        this.pendingSeiMessages = new PriorityQueue();
        this.reorderingQueueSize = -1;
    }

    public void setMaxSize(int reorderingQueueSize) {
        Assertions.checkState((reorderingQueueSize >= 0 ? 1 : 0) != 0);
        this.reorderingQueueSize = reorderingQueueSize;
        this.flushQueueDownToSize(reorderingQueueSize);
    }

    public int getMaxSize() {
        return this.reorderingQueueSize;
    }

    public void add(long presentationTimeUs, ParsableByteArray seiBuffer) {
        if (this.reorderingQueueSize == 0 || this.reorderingQueueSize != -1 && this.pendingSeiMessages.size() >= this.reorderingQueueSize && presentationTimeUs < ((SampleSeiMessages)Util.castNonNull((Object)this.pendingSeiMessages.peek())).presentationTimeUs) {
            this.seiConsumer.consume(presentationTimeUs, seiBuffer);
            return;
        }
        ParsableByteArray seiBufferCopy = this.copy(seiBuffer);
        if (this.lastQueuedMessage != null && presentationTimeUs == this.lastQueuedMessage.presentationTimeUs) {
            this.lastQueuedMessage.nalBuffers.add(seiBufferCopy);
            return;
        }
        SampleSeiMessages sampleSeiMessages = this.unusedSampleSeiMessages.isEmpty() ? new SampleSeiMessages() : this.unusedSampleSeiMessages.pop();
        sampleSeiMessages.init(presentationTimeUs, seiBufferCopy);
        this.pendingSeiMessages.add(sampleSeiMessages);
        this.lastQueuedMessage = sampleSeiMessages;
        if (this.reorderingQueueSize != -1) {
            this.flushQueueDownToSize(this.reorderingQueueSize);
        }
    }

    private ParsableByteArray copy(ParsableByteArray input) {
        ParsableByteArray result = this.unusedParsableByteArrays.isEmpty() ? new ParsableByteArray() : this.unusedParsableByteArrays.pop();
        result.reset(input.bytesLeft());
        System.arraycopy(input.getData(), input.getPosition(), result.getData(), 0, result.bytesLeft());
        return result;
    }

    public void flush() {
        this.flushQueueDownToSize(0);
    }

    private void flushQueueDownToSize(int targetSize) {
        while (this.pendingSeiMessages.size() > targetSize) {
            SampleSeiMessages sampleSeiMessages = (SampleSeiMessages)Util.castNonNull((Object)this.pendingSeiMessages.poll());
            for (int i = 0; i < sampleSeiMessages.nalBuffers.size(); ++i) {
                this.seiConsumer.consume(sampleSeiMessages.presentationTimeUs, sampleSeiMessages.nalBuffers.get(i));
                this.unusedParsableByteArrays.push(sampleSeiMessages.nalBuffers.get(i));
            }
            sampleSeiMessages.nalBuffers.clear();
            if (this.lastQueuedMessage != null && this.lastQueuedMessage.presentationTimeUs == sampleSeiMessages.presentationTimeUs) {
                this.lastQueuedMessage = null;
            }
            this.unusedSampleSeiMessages.push(sampleSeiMessages);
        }
    }

    public static interface SeiConsumer {
        public void consume(long var1, ParsableByteArray var3);
    }

    private static final class SampleSeiMessages
    implements Comparable<SampleSeiMessages> {
        public final List<ParsableByteArray> nalBuffers = new ArrayList<ParsableByteArray>();
        public long presentationTimeUs = -9223372036854775807L;

        public void init(long presentationTimeUs, ParsableByteArray nalBuffer) {
            Assertions.checkArgument((presentationTimeUs != -9223372036854775807L ? 1 : 0) != 0);
            Assertions.checkState((boolean)this.nalBuffers.isEmpty());
            this.presentationTimeUs = presentationTimeUs;
            this.nalBuffers.add(nalBuffer);
        }

        @Override
        public int compareTo(SampleSeiMessages other) {
            return Long.compare(this.presentationTimeUs, other.presentationTimeUs);
        }
    }
}

