/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common.util;

import android.content.Context;
import android.opengl.GLES20;
import androidx.annotation.Nullable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.GlUtil;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import java.io.IOException;
import java.nio.Buffer;
import java.util.HashMap;
import java.util.Map;

@UnstableApi
public final class GlProgram {
    private static final int GL_SAMPLER_EXTERNAL_2D_Y2Y_EXT = 35815;
    private final int programId = GLES20.glCreateProgram();
    private final Attribute[] attributes;
    private final Uniform[] uniforms;
    private final Map<String, Attribute> attributeByName;
    private final Map<String, Uniform> uniformByName;
    private boolean externalTexturesRequireNearestSampling;

    public GlProgram(Context context, String vertexShaderFilePath, String fragmentShaderFilePath) throws IOException, GlUtil.GlException {
        this(Util.loadAsset(context, vertexShaderFilePath), Util.loadAsset(context, fragmentShaderFilePath));
    }

    public GlProgram(String vertexShaderGlsl, String fragmentShaderGlsl) throws GlUtil.GlException {
        GlUtil.checkGlError();
        GlProgram.addShader(this.programId, 35633, vertexShaderGlsl);
        GlProgram.addShader(this.programId, 35632, fragmentShaderGlsl);
        GLES20.glLinkProgram((int)this.programId);
        int[] linkStatus = new int[]{0};
        GLES20.glGetProgramiv((int)this.programId, (int)35714, (int[])linkStatus, (int)0);
        GlUtil.checkGlException(linkStatus[0] == 1, "Unable to link shader program: \n" + GLES20.glGetProgramInfoLog((int)this.programId));
        GLES20.glUseProgram((int)this.programId);
        this.attributeByName = new HashMap<String, Attribute>();
        int[] attributeCount = new int[1];
        GLES20.glGetProgramiv((int)this.programId, (int)35721, (int[])attributeCount, (int)0);
        this.attributes = new Attribute[attributeCount[0]];
        for (int i = 0; i < attributeCount[0]; ++i) {
            Attribute attribute;
            this.attributes[i] = attribute = Attribute.create(this.programId, i);
            this.attributeByName.put(attribute.name, attribute);
        }
        this.uniformByName = new HashMap<String, Uniform>();
        int[] uniformCount = new int[1];
        GLES20.glGetProgramiv((int)this.programId, (int)35718, (int[])uniformCount, (int)0);
        this.uniforms = new Uniform[uniformCount[0]];
        for (int i = 0; i < uniformCount[0]; ++i) {
            Uniform uniform;
            this.uniforms[i] = uniform = Uniform.create(this.programId, i);
            this.uniformByName.put(uniform.name, uniform);
        }
        GlUtil.checkGlError();
    }

    private static void addShader(int programId, int type, String glsl) throws GlUtil.GlException {
        int shader = GLES20.glCreateShader((int)type);
        GLES20.glShaderSource((int)shader, (String)glsl);
        GLES20.glCompileShader((int)shader);
        int[] result = new int[]{0};
        GLES20.glGetShaderiv((int)shader, (int)35713, (int[])result, (int)0);
        GlUtil.checkGlException(result[0] == 1, GLES20.glGetShaderInfoLog((int)shader) + ", source: \n" + glsl);
        GLES20.glAttachShader((int)programId, (int)shader);
        GLES20.glDeleteShader((int)shader);
        GlUtil.checkGlError();
    }

    private static int getAttributeLocation(int programId, String attributeName) {
        return GLES20.glGetAttribLocation((int)programId, (String)attributeName);
    }

    private int getAttributeLocation(String attributeName) {
        return GlProgram.getAttributeLocation(this.programId, attributeName);
    }

    private static int getUniformLocation(int programId, String uniformName) {
        return GLES20.glGetUniformLocation((int)programId, (String)uniformName);
    }

    public int getUniformLocation(String uniformName) {
        return GlProgram.getUniformLocation(this.programId, uniformName);
    }

    public void use() throws GlUtil.GlException {
        GLES20.glUseProgram((int)this.programId);
        GlUtil.checkGlError();
    }

    public void delete() throws GlUtil.GlException {
        GLES20.glDeleteProgram((int)this.programId);
        GlUtil.checkGlError();
    }

    public int getAttributeArrayLocationAndEnable(String attributeName) throws GlUtil.GlException {
        int location = this.getAttributeLocation(attributeName);
        GLES20.glEnableVertexAttribArray((int)location);
        GlUtil.checkGlError();
        return location;
    }

    public void setBufferAttribute(String name, float[] values, int size) {
        Assertions.checkNotNull(this.attributeByName.get(name)).setBuffer(values, size);
    }

    public void setSamplerTexIdUniform(String name, int texId, int texUnitIndex) {
        Assertions.checkNotNull(this.uniformByName.get(name)).setSamplerTexId(texId, texUnitIndex);
    }

    public void setIntUniform(String name, int value) {
        Assertions.checkNotNull(this.uniformByName.get(name)).setInt(value);
    }

    public void setIntsUniform(String name, int[] value) {
        Assertions.checkNotNull(this.uniformByName.get(name)).setInts(value);
    }

    public void setFloatUniform(String name, float value) {
        Assertions.checkNotNull(this.uniformByName.get(name)).setFloat(value);
    }

    public void setFloatsUniform(String name, float[] value) {
        Assertions.checkNotNull(this.uniformByName.get(name)).setFloats(value);
    }

    public void setFloatsUniformIfPresent(String name, float[] value) {
        Uniform uniform = this.uniformByName.get(name);
        if (uniform == null) {
            return;
        }
        uniform.setFloats(value);
    }

    public void bindAttributesAndUniforms() throws GlUtil.GlException {
        for (Attribute attribute : this.attributes) {
            attribute.bind();
        }
        for (Uniform uniform : this.uniforms) {
            uniform.bind(this.externalTexturesRequireNearestSampling);
        }
    }

    public void setExternalTexturesRequireNearestSampling(boolean externalTexturesRequireNearestSampling) {
        this.externalTexturesRequireNearestSampling = externalTexturesRequireNearestSampling;
    }

    private static int getCStringLength(byte[] cString) {
        for (int i = 0; i < cString.length; ++i) {
            if (cString[i] != 0) continue;
            return i;
        }
        return cString.length;
    }

    private static final class Attribute {
        public final String name;
        private final int location;
        @Nullable
        private Buffer buffer;
        private int size;

        public static Attribute create(int programId, int index) {
            int[] attributeNameMaxLength = new int[1];
            GLES20.glGetProgramiv((int)programId, (int)35722, (int[])attributeNameMaxLength, (int)0);
            byte[] nameBytes = new byte[attributeNameMaxLength[0]];
            GLES20.glGetActiveAttrib((int)programId, (int)index, (int)attributeNameMaxLength[0], (int[])new int[1], (int)0, (int[])new int[1], (int)0, (int[])new int[1], (int)0, (byte[])nameBytes, (int)0);
            String name = new String(nameBytes, 0, GlProgram.getCStringLength(nameBytes));
            int location = GlProgram.getAttributeLocation(programId, name);
            return new Attribute(name, location);
        }

        private Attribute(String name, int location) {
            this.name = name;
            this.location = location;
        }

        public void setBuffer(float[] buffer, int size) {
            this.buffer = GlUtil.createBuffer(buffer);
            this.size = size;
        }

        public void bind() throws GlUtil.GlException {
            Buffer buffer = Assertions.checkNotNull(this.buffer, "call setBuffer before bind");
            GLES20.glBindBuffer((int)34962, (int)0);
            GLES20.glVertexAttribPointer((int)this.location, (int)this.size, (int)5126, (boolean)false, (int)0, (Buffer)buffer);
            GLES20.glEnableVertexAttribArray((int)this.location);
            GlUtil.checkGlError();
        }
    }

    private static final class Uniform {
        public final String name;
        private final int location;
        private final int type;
        private final float[] floatValue;
        private final int[] intValue;
        private int texIdValue;
        private int texUnitIndex;

        public static Uniform create(int programId, int index) {
            int[] length = new int[1];
            GLES20.glGetProgramiv((int)programId, (int)35719, (int[])length, (int)0);
            int[] type = new int[1];
            byte[] nameBytes = new byte[length[0]];
            GLES20.glGetActiveUniform((int)programId, (int)index, (int)length[0], (int[])new int[1], (int)0, (int[])new int[1], (int)0, (int[])type, (int)0, (byte[])nameBytes, (int)0);
            String name = new String(nameBytes, 0, GlProgram.getCStringLength(nameBytes));
            int location = GlProgram.getUniformLocation(programId, name);
            return new Uniform(name, location, type[0]);
        }

        private Uniform(String name, int location, int type) {
            this.name = name;
            this.location = location;
            this.type = type;
            this.floatValue = new float[16];
            this.intValue = new int[4];
        }

        public void setSamplerTexId(int texId, int texUnitIndex) {
            this.texIdValue = texId;
            this.texUnitIndex = texUnitIndex;
        }

        public void setInt(int value) {
            this.intValue[0] = value;
        }

        public void setInts(int[] value) {
            System.arraycopy(value, 0, this.intValue, 0, value.length);
        }

        public void setFloat(float value) {
            this.floatValue[0] = value;
        }

        public void setFloats(float[] value) {
            System.arraycopy(value, 0, this.floatValue, 0, value.length);
        }

        public void bind(boolean externalTexturesRequireNearestSampling) throws GlUtil.GlException {
            switch (this.type) {
                case 5124: {
                    GLES20.glUniform1iv((int)this.location, (int)1, (int[])this.intValue, (int)0);
                    GlUtil.checkGlError();
                    break;
                }
                case 35667: {
                    GLES20.glUniform2iv((int)this.location, (int)1, (int[])this.intValue, (int)0);
                    GlUtil.checkGlError();
                    break;
                }
                case 35668: {
                    GLES20.glUniform3iv((int)this.location, (int)1, (int[])this.intValue, (int)0);
                    GlUtil.checkGlError();
                    break;
                }
                case 35669: {
                    GLES20.glUniform4iv((int)this.location, (int)1, (int[])this.intValue, (int)0);
                    GlUtil.checkGlError();
                    break;
                }
                case 5126: {
                    GLES20.glUniform1fv((int)this.location, (int)1, (float[])this.floatValue, (int)0);
                    GlUtil.checkGlError();
                    break;
                }
                case 35664: {
                    GLES20.glUniform2fv((int)this.location, (int)1, (float[])this.floatValue, (int)0);
                    GlUtil.checkGlError();
                    break;
                }
                case 35665: {
                    GLES20.glUniform3fv((int)this.location, (int)1, (float[])this.floatValue, (int)0);
                    GlUtil.checkGlError();
                    break;
                }
                case 35666: {
                    GLES20.glUniform4fv((int)this.location, (int)1, (float[])this.floatValue, (int)0);
                    GlUtil.checkGlError();
                    break;
                }
                case 35675: {
                    GLES20.glUniformMatrix3fv((int)this.location, (int)1, (boolean)false, (float[])this.floatValue, (int)0);
                    GlUtil.checkGlError();
                    break;
                }
                case 35676: {
                    GLES20.glUniformMatrix4fv((int)this.location, (int)1, (boolean)false, (float[])this.floatValue, (int)0);
                    GlUtil.checkGlError();
                    break;
                }
                case 35678: 
                case 35815: 
                case 36198: {
                    if (this.texIdValue == 0) {
                        throw new IllegalStateException("No call to setSamplerTexId() before bind.");
                    }
                    GLES20.glActiveTexture((int)(33984 + this.texUnitIndex));
                    GlUtil.checkGlError();
                    GlUtil.bindTexture(this.type == 35678 ? 3553 : 36197, this.texIdValue, this.type == 35678 || !externalTexturesRequireNearestSampling ? 9729 : 9728);
                    GLES20.glUniform1i((int)this.location, (int)this.texUnitIndex);
                    GlUtil.checkGlError();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected uniform type: " + this.type);
                }
            }
        }
    }
}

