/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common.util;

import android.os.Bundle;
import android.util.SparseArray;
import androidx.annotation.Nullable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@UnstableApi
public final class BundleCollectionUtil {
    public static <T> ImmutableList<Bundle> toBundleList(List<T> list, Function<T, Bundle> toBundleFunc) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < list.size(); ++i) {
            T item = list.get(i);
            builder.add((Object)((Bundle)toBundleFunc.apply(item)));
        }
        return builder.build();
    }

    public static <T> ImmutableList<T> fromBundleList(Function<Bundle, T> fromBundleFunc, List<Bundle> bundleList) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < bundleList.size(); ++i) {
            Bundle bundle = Assertions.checkNotNull(bundleList.get(i));
            Object item = fromBundleFunc.apply((Object)bundle);
            builder.add(item);
        }
        return builder.build();
    }

    public static <T> ArrayList<Bundle> toBundleArrayList(Collection<T> items, Function<T, Bundle> toBundleFunc) {
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>(items.size());
        for (T item : items) {
            arrayList.add((Bundle)toBundleFunc.apply(item));
        }
        return arrayList;
    }

    public static <T> SparseArray<T> fromBundleSparseArray(Function<Bundle, T> fromBundleFunc, SparseArray<Bundle> bundleSparseArray) {
        SparseArray result = new SparseArray(bundleSparseArray.size());
        for (int i = 0; i < bundleSparseArray.size(); ++i) {
            result.put(bundleSparseArray.keyAt(i), fromBundleFunc.apply((Object)((Bundle)bundleSparseArray.valueAt(i))));
        }
        return result;
    }

    public static <T> SparseArray<Bundle> toBundleSparseArray(SparseArray<T> items, Function<T, Bundle> toBundleFunc) {
        SparseArray sparseArray = new SparseArray(items.size());
        for (int i = 0; i < items.size(); ++i) {
            sparseArray.put(items.keyAt(i), (Object)((Bundle)toBundleFunc.apply(items.valueAt(i))));
        }
        return sparseArray;
    }

    public static Bundle stringMapToBundle(Map<String, String> map) {
        Bundle bundle = new Bundle();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            bundle.putString(entry.getKey(), entry.getValue());
        }
        return bundle;
    }

    public static HashMap<String, String> bundleToStringHashMap(Bundle bundle) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (bundle == Bundle.EMPTY) {
            return map;
        }
        for (String key : bundle.keySet()) {
            String value = bundle.getString(key);
            if (value == null) continue;
            map.put(key, value);
        }
        return map;
    }

    public static ImmutableMap<String, String> bundleToStringImmutableMap(Bundle bundle) {
        if (bundle == Bundle.EMPTY) {
            return ImmutableMap.of();
        }
        HashMap<String, String> map = BundleCollectionUtil.bundleToStringHashMap(bundle);
        return ImmutableMap.copyOf(map);
    }

    public static Bundle getBundleWithDefault(Bundle bundle, String field, Bundle defaultValue) {
        Bundle result = bundle.getBundle(field);
        return result != null ? result : defaultValue;
    }

    public static ArrayList<Integer> getIntegerArrayListWithDefault(Bundle bundle, String field, ArrayList<Integer> defaultValue) {
        ArrayList<Integer> result = bundle.getIntegerArrayList(field);
        return result != null ? result : defaultValue;
    }

    public static void ensureClassLoader(@Nullable Bundle bundle) {
        if (bundle != null) {
            bundle.setClassLoader(Util.castNonNull(BundleCollectionUtil.class.getClassLoader()));
        }
    }

    private BundleCollectionUtil() {
    }
}

