/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common.text;

import android.text.Spannable;
import android.text.style.RelativeSizeSpan;
import androidx.media3.common.util.UnstableApi;

@UnstableApi
public final class SpanUtil {
    public static void addOrReplaceSpan(Spannable spannable, Object span, int start, int end, int spanFlags) {
        Object[] existingSpans;
        for (Object existingSpan : existingSpans = spannable.getSpans(start, end, span.getClass())) {
            SpanUtil.removeIfStartEndAndFlagsMatch(spannable, existingSpan, start, end, spanFlags);
        }
        spannable.setSpan(span, start, end, spanFlags);
    }

    public static void addInheritedRelativeSizeSpan(Spannable spannable, float size, int start, int end, int spanFlags) {
        for (RelativeSizeSpan existingSpan : (RelativeSizeSpan[])spannable.getSpans(start, end, RelativeSizeSpan.class)) {
            if (spannable.getSpanStart((Object)existingSpan) <= start && spannable.getSpanEnd((Object)existingSpan) >= end) {
                size *= existingSpan.getSizeChange();
            }
            SpanUtil.removeIfStartEndAndFlagsMatch(spannable, existingSpan, start, end, spanFlags);
        }
        spannable.setSpan((Object)new RelativeSizeSpan(size), start, end, spanFlags);
    }

    private static void removeIfStartEndAndFlagsMatch(Spannable spannable, Object span, int start, int end, int spanFlags) {
        if (spannable.getSpanStart(span) == start && spannable.getSpanEnd(span) == end && spannable.getSpanFlags(span) == spanFlags) {
            spannable.removeSpan(span);
        }
    }

    private SpanUtil() {
    }
}

