/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common;

import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.Nullable;
import androidx.media3.common.AudioAttributes;
import androidx.media3.common.MediaItem;
import androidx.media3.common.MediaMetadata;
import androidx.media3.common.Metadata;
import androidx.media3.common.PlaybackParameters;
import androidx.media3.common.Player;
import androidx.media3.common.SimpleBasePlayer;
import androidx.media3.common.TrackSelectionParameters;
import androidx.media3.common.Tracks;
import androidx.media3.common.util.UnstableApi;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;

@UnstableApi
public class ForwardingSimpleBasePlayer
extends SimpleBasePlayer {
    private final Player player;
    private ForwardingPositionSupplier currentPositionSupplier;
    private Metadata lastTimedMetadata;
    private int playWhenReadyChangeReason;
    private int pendingDiscontinuityReason;
    private long pendingPositionDiscontinuityNewPositionMs;
    private boolean pendingFirstFrameRendered;

    public ForwardingSimpleBasePlayer(final Player player) {
        super(player.getApplicationLooper());
        this.player = player;
        this.lastTimedMetadata = new Metadata(-9223372036854775807L, new Metadata.Entry[0]);
        this.playWhenReadyChangeReason = 1;
        this.pendingDiscontinuityReason = 5;
        this.currentPositionSupplier = new ForwardingPositionSupplier(player);
        player.addListener(new Player.Listener(){

            @Override
            public void onMetadata(Metadata metadata) {
                ForwardingSimpleBasePlayer.this.lastTimedMetadata = metadata;
            }

            @Override
            public void onPlayWhenReadyChanged(boolean playWhenReady, int reason) {
                ForwardingSimpleBasePlayer.this.playWhenReadyChangeReason = reason;
            }

            @Override
            public void onPositionDiscontinuity(Player.PositionInfo oldPosition, Player.PositionInfo newPosition, int reason) {
                ForwardingSimpleBasePlayer.this.pendingDiscontinuityReason = reason;
                ForwardingSimpleBasePlayer.this.pendingPositionDiscontinuityNewPositionMs = newPosition.positionMs;
                ForwardingSimpleBasePlayer.this.currentPositionSupplier.setConstant(oldPosition.positionMs, oldPosition.contentPositionMs);
                ForwardingSimpleBasePlayer.this.currentPositionSupplier = new ForwardingPositionSupplier(player);
            }

            @Override
            public void onRenderedFirstFrame() {
                ForwardingSimpleBasePlayer.this.pendingFirstFrameRendered = true;
            }

            @Override
            public void onEvents(Player player2, Player.Events events) {
                ForwardingSimpleBasePlayer.this.invalidateState();
            }
        });
    }

    protected final Player getPlayer() {
        return this.player;
    }

    @Override
    protected SimpleBasePlayer.State getState() {
        SimpleBasePlayer.State.Builder state = new SimpleBasePlayer.State.Builder();
        ForwardingPositionSupplier positionSupplier = this.currentPositionSupplier;
        if (this.player.isCommandAvailable(16)) {
            state.setAdBufferedPositionMs(positionSupplier::getBufferedPositionMs);
            state.setAdPositionMs(positionSupplier::getCurrentPositionMs);
        }
        if (this.player.isCommandAvailable(21)) {
            state.setAudioAttributes(this.player.getAudioAttributes());
        }
        state.setAvailableCommands(this.player.getAvailableCommands());
        if (this.player.isCommandAvailable(16)) {
            state.setContentBufferedPositionMs(positionSupplier::getContentBufferedPositionMs);
            state.setContentPositionMs(positionSupplier::getContentPositionMs);
            if (this.player.isCommandAvailable(17)) {
                state.setCurrentAd(this.player.getCurrentAdGroupIndex(), this.player.getCurrentAdIndexInAdGroup());
            }
        }
        if (this.player.isCommandAvailable(28)) {
            state.setCurrentCues(this.player.getCurrentCues());
        }
        if (this.player.isCommandAvailable(17)) {
            state.setCurrentMediaItemIndex(this.player.getCurrentMediaItemIndex());
        }
        state.setDeviceInfo(this.player.getDeviceInfo());
        if (this.player.isCommandAvailable(23)) {
            state.setDeviceVolume(this.player.getDeviceVolume());
            state.setIsDeviceMuted(this.player.isDeviceMuted());
        }
        state.setIsLoading(this.player.isLoading());
        state.setMaxSeekToPreviousPositionMs(this.player.getMaxSeekToPreviousPosition());
        if (this.pendingFirstFrameRendered) {
            state.setNewlyRenderedFirstFrame(true);
            this.pendingFirstFrameRendered = false;
        }
        state.setPlaybackParameters(this.player.getPlaybackParameters());
        state.setPlaybackState(this.player.getPlaybackState());
        state.setPlaybackSuppressionReason(this.player.getPlaybackSuppressionReason());
        state.setPlayerError(this.player.getPlayerError());
        if (this.player.isCommandAvailable(17)) {
            Tracks tracks = this.player.isCommandAvailable(30) ? this.player.getCurrentTracks() : Tracks.EMPTY;
            MediaMetadata mediaMetadata = this.player.isCommandAvailable(18) ? this.player.getMediaMetadata() : null;
            state.setPlaylist(this.player.getCurrentTimeline(), tracks, mediaMetadata);
        }
        if (this.player.isCommandAvailable(18)) {
            state.setPlaylistMetadata(this.player.getPlaylistMetadata());
        }
        state.setPlayWhenReady(this.player.getPlayWhenReady(), this.playWhenReadyChangeReason);
        if (this.pendingPositionDiscontinuityNewPositionMs != -9223372036854775807L) {
            state.setPositionDiscontinuity(this.pendingDiscontinuityReason, this.pendingPositionDiscontinuityNewPositionMs);
            this.pendingPositionDiscontinuityNewPositionMs = -9223372036854775807L;
        }
        state.setRepeatMode(this.player.getRepeatMode());
        state.setSeekBackIncrementMs(this.player.getSeekBackIncrement());
        state.setSeekForwardIncrementMs(this.player.getSeekForwardIncrement());
        state.setShuffleModeEnabled(this.player.getShuffleModeEnabled());
        state.setSurfaceSize(this.player.getSurfaceSize());
        state.setTimedMetadata(this.lastTimedMetadata);
        if (this.player.isCommandAvailable(16)) {
            state.setTotalBufferedDurationMs(positionSupplier::getTotalBufferedDurationMs);
        }
        state.setTrackSelectionParameters(this.player.getTrackSelectionParameters());
        state.setVideoSize(this.player.getVideoSize());
        if (this.player.isCommandAvailable(22)) {
            state.setVolume(this.player.getVolume());
        }
        return state.build();
    }

    @Override
    protected ListenableFuture<?> handleSetPlayWhenReady(boolean playWhenReady) {
        this.player.setPlayWhenReady(playWhenReady);
        return Futures.immediateVoidFuture();
    }

    @Override
    protected ListenableFuture<?> handlePrepare() {
        this.player.prepare();
        return Futures.immediateVoidFuture();
    }

    @Override
    protected ListenableFuture<?> handleStop() {
        this.player.stop();
        return Futures.immediateVoidFuture();
    }

    @Override
    protected ListenableFuture<?> handleRelease() {
        this.player.release();
        return Futures.immediateVoidFuture();
    }

    @Override
    protected ListenableFuture<?> handleSetRepeatMode(int repeatMode) {
        this.player.setRepeatMode(repeatMode);
        return Futures.immediateVoidFuture();
    }

    @Override
    protected ListenableFuture<?> handleSetShuffleModeEnabled(boolean shuffleModeEnabled) {
        this.player.setShuffleModeEnabled(shuffleModeEnabled);
        return Futures.immediateVoidFuture();
    }

    @Override
    protected ListenableFuture<?> handleSetPlaybackParameters(PlaybackParameters playbackParameters) {
        this.player.setPlaybackParameters(playbackParameters);
        return Futures.immediateVoidFuture();
    }

    @Override
    protected ListenableFuture<?> handleSetTrackSelectionParameters(TrackSelectionParameters trackSelectionParameters) {
        this.player.setTrackSelectionParameters(trackSelectionParameters);
        return Futures.immediateVoidFuture();
    }

    @Override
    protected ListenableFuture<?> handleSetPlaylistMetadata(MediaMetadata playlistMetadata) {
        this.player.setPlaylistMetadata(playlistMetadata);
        return Futures.immediateVoidFuture();
    }

    @Override
    protected ListenableFuture<?> handleSetVolume(float volume) {
        this.player.setVolume(volume);
        return Futures.immediateVoidFuture();
    }

    @Override
    protected ListenableFuture<?> handleSetDeviceVolume(int deviceVolume, int flags) {
        if (this.player.isCommandAvailable(33)) {
            this.player.setDeviceVolume(deviceVolume, flags);
        } else {
            this.player.setDeviceVolume(deviceVolume);
        }
        return Futures.immediateVoidFuture();
    }

    @Override
    protected ListenableFuture<?> handleIncreaseDeviceVolume(int flags) {
        if (this.player.isCommandAvailable(34)) {
            this.player.increaseDeviceVolume(flags);
        } else {
            this.player.increaseDeviceVolume();
        }
        return Futures.immediateVoidFuture();
    }

    @Override
    protected ListenableFuture<?> handleDecreaseDeviceVolume(int flags) {
        if (this.player.isCommandAvailable(34)) {
            this.player.decreaseDeviceVolume(flags);
        } else {
            this.player.decreaseDeviceVolume();
        }
        return Futures.immediateVoidFuture();
    }

    @Override
    protected ListenableFuture<?> handleSetDeviceMuted(boolean muted, int flags) {
        if (this.player.isCommandAvailable(34)) {
            this.player.setDeviceMuted(muted, flags);
        } else {
            this.player.setDeviceMuted(muted);
        }
        return Futures.immediateVoidFuture();
    }

    @Override
    protected ListenableFuture<?> handleSetAudioAttributes(AudioAttributes audioAttributes, boolean handleAudioFocus) {
        this.player.setAudioAttributes(audioAttributes, handleAudioFocus);
        return Futures.immediateVoidFuture();
    }

    @Override
    protected ListenableFuture<?> handleSetVideoOutput(Object videoOutput) {
        if (videoOutput instanceof SurfaceView) {
            this.player.setVideoSurfaceView((SurfaceView)videoOutput);
        } else if (videoOutput instanceof TextureView) {
            this.player.setVideoTextureView((TextureView)videoOutput);
        } else if (videoOutput instanceof SurfaceHolder) {
            this.player.setVideoSurfaceHolder((SurfaceHolder)videoOutput);
        } else if (videoOutput instanceof Surface) {
            this.player.setVideoSurface((Surface)videoOutput);
        } else {
            throw new IllegalStateException();
        }
        return Futures.immediateVoidFuture();
    }

    @Override
    protected ListenableFuture<?> handleClearVideoOutput(@Nullable Object videoOutput) {
        if (videoOutput instanceof SurfaceView) {
            this.player.clearVideoSurfaceView((SurfaceView)videoOutput);
        } else if (videoOutput instanceof TextureView) {
            this.player.clearVideoTextureView((TextureView)videoOutput);
        } else if (videoOutput instanceof SurfaceHolder) {
            this.player.clearVideoSurfaceHolder((SurfaceHolder)videoOutput);
        } else if (videoOutput instanceof Surface) {
            this.player.clearVideoSurface((Surface)videoOutput);
        } else if (videoOutput == null) {
            this.player.clearVideoSurface();
        } else {
            throw new IllegalStateException();
        }
        return Futures.immediateVoidFuture();
    }

    @Override
    protected ListenableFuture<?> handleSetMediaItems(List<MediaItem> mediaItems, int startIndex, long startPositionMs) {
        boolean useSingleItemCall;
        boolean bl = useSingleItemCall = mediaItems.size() == 1 && this.player.isCommandAvailable(31);
        if (startIndex == -1) {
            if (useSingleItemCall) {
                this.player.setMediaItem(mediaItems.get(0));
            } else {
                this.player.setMediaItems(mediaItems);
            }
        } else if (useSingleItemCall) {
            this.player.setMediaItem(mediaItems.get(0), startPositionMs);
        } else {
            this.player.setMediaItems(mediaItems, startIndex, startPositionMs);
        }
        return Futures.immediateVoidFuture();
    }

    @Override
    protected ListenableFuture<?> handleAddMediaItems(int index, List<MediaItem> mediaItems) {
        if (mediaItems.size() == 1) {
            this.player.addMediaItem(index, mediaItems.get(0));
        } else {
            this.player.addMediaItems(index, mediaItems);
        }
        return Futures.immediateVoidFuture();
    }

    @Override
    protected ListenableFuture<?> handleMoveMediaItems(int fromIndex, int toIndex, int newIndex) {
        if (toIndex == fromIndex + 1) {
            this.player.moveMediaItem(fromIndex, newIndex);
        } else {
            this.player.moveMediaItems(fromIndex, toIndex, newIndex);
        }
        return Futures.immediateVoidFuture();
    }

    @Override
    protected ListenableFuture<?> handleReplaceMediaItems(int fromIndex, int toIndex, List<MediaItem> mediaItems) {
        if (toIndex == fromIndex + 1 && mediaItems.size() == 1) {
            this.player.replaceMediaItem(fromIndex, mediaItems.get(0));
        } else {
            this.player.replaceMediaItems(fromIndex, toIndex, mediaItems);
        }
        return Futures.immediateVoidFuture();
    }

    @Override
    protected ListenableFuture<?> handleRemoveMediaItems(int fromIndex, int toIndex) {
        if (toIndex == fromIndex + 1) {
            this.player.removeMediaItem(fromIndex);
        } else {
            this.player.removeMediaItems(fromIndex, toIndex);
        }
        return Futures.immediateVoidFuture();
    }

    @Override
    protected ListenableFuture<?> handleSeek(int mediaItemIndex, long positionMs, int seekCommand) {
        switch (seekCommand) {
            case 11: {
                this.player.seekBack();
                break;
            }
            case 12: {
                this.player.seekForward();
                break;
            }
            case 5: {
                this.player.seekTo(positionMs);
                break;
            }
            case 4: {
                this.player.seekToDefaultPosition();
                break;
            }
            case 10: {
                if (mediaItemIndex == -1) break;
                this.player.seekTo(mediaItemIndex, positionMs);
                break;
            }
            case 9: {
                this.player.seekToNext();
                break;
            }
            case 8: {
                this.player.seekToNextMediaItem();
                break;
            }
            case 7: {
                this.player.seekToPrevious();
                break;
            }
            case 6: {
                this.player.seekToPreviousMediaItem();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return Futures.immediateVoidFuture();
    }

    private static final class ForwardingPositionSupplier {
        private final Player player;
        private long positionsMs;
        private long contentPositionMs;

        public ForwardingPositionSupplier(Player player) {
            this.player = player;
            this.positionsMs = -9223372036854775807L;
            this.contentPositionMs = -9223372036854775807L;
        }

        public void setConstant(long positionMs, long contentPositionMs) {
            this.positionsMs = positionMs;
            this.contentPositionMs = contentPositionMs;
        }

        public long getCurrentPositionMs() {
            return this.positionsMs == -9223372036854775807L ? this.player.getCurrentPosition() : this.positionsMs;
        }

        public long getBufferedPositionMs() {
            return this.positionsMs == -9223372036854775807L ? this.player.getBufferedPosition() : this.positionsMs;
        }

        public long getContentPositionMs() {
            return this.contentPositionMs == -9223372036854775807L ? this.player.getContentPosition() : this.contentPositionMs;
        }

        public long getContentBufferedPositionMs() {
            return this.contentPositionMs == -9223372036854775807L ? this.player.getContentBufferedPosition() : this.contentPositionMs;
        }

        public long getTotalBufferedDurationMs() {
            return this.positionsMs == -9223372036854775807L ? this.player.getTotalBufferedDuration() : 0L;
        }
    }
}

