/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common;

import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.media3.common.C;
import androidx.media3.common.ColorInfo;
import androidx.media3.common.DrmInitData;
import androidx.media3.common.Label;
import androidx.media3.common.Metadata;
import androidx.media3.common.MimeTypes;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.BundleCollectionUtil;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.math.DoubleMath;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public final class Format {
    @UnstableApi
    public static final int CUE_REPLACEMENT_BEHAVIOR_MERGE = 1;
    @UnstableApi
    public static final int CUE_REPLACEMENT_BEHAVIOR_REPLACE = 2;
    public static final int NO_VALUE = -1;
    @UnstableApi
    public static final long OFFSET_SAMPLE_RELATIVE = Long.MAX_VALUE;
    private static final Format DEFAULT = new Builder().build();
    @Nullable
    public final String id;
    @Nullable
    public final String label;
    @UnstableApi
    public final List<Label> labels;
    @Nullable
    public final String language;
    public final int selectionFlags;
    public final int roleFlags;
    @UnstableApi
    public final int auxiliaryTrackType;
    @UnstableApi
    public final int averageBitrate;
    @UnstableApi
    public final int peakBitrate;
    @UnstableApi
    public final int bitrate;
    @Nullable
    public final String codecs;
    @UnstableApi
    @Nullable
    public final Metadata metadata;
    @UnstableApi
    @Nullable
    public final Object customData;
    @Nullable
    public final String containerMimeType;
    @Nullable
    public final String sampleMimeType;
    @UnstableApi
    public final int maxInputSize;
    @UnstableApi
    public final int maxNumReorderSamples;
    @UnstableApi
    public final List<byte[]> initializationData;
    @UnstableApi
    @Nullable
    public final DrmInitData drmInitData;
    @UnstableApi
    public final long subsampleOffsetUs;
    @UnstableApi
    public final boolean hasPrerollSamples;
    public final int width;
    public final int height;
    public final float frameRate;
    @UnstableApi
    public final int rotationDegrees;
    public final float pixelWidthHeightRatio;
    @UnstableApi
    @Nullable
    public final byte[] projectionData;
    @UnstableApi
    public final int stereoMode;
    @UnstableApi
    @Nullable
    public final ColorInfo colorInfo;
    public final int channelCount;
    public final int sampleRate;
    @UnstableApi
    public final int pcmEncoding;
    @UnstableApi
    public final int encoderDelay;
    @UnstableApi
    public final int encoderPadding;
    @UnstableApi
    public final int accessibilityChannel;
    @UnstableApi
    public final int cueReplacementBehavior;
    @UnstableApi
    public final int tileCountHorizontal;
    @UnstableApi
    public final int tileCountVertical;
    @UnstableApi
    public final int cryptoType;
    private int hashCode;
    private static final String FIELD_ID = Util.intToStringMaxRadix(0);
    private static final String FIELD_LABEL = Util.intToStringMaxRadix(1);
    private static final String FIELD_LANGUAGE = Util.intToStringMaxRadix(2);
    private static final String FIELD_SELECTION_FLAGS = Util.intToStringMaxRadix(3);
    private static final String FIELD_ROLE_FLAGS = Util.intToStringMaxRadix(4);
    private static final String FIELD_AVERAGE_BITRATE = Util.intToStringMaxRadix(5);
    private static final String FIELD_PEAK_BITRATE = Util.intToStringMaxRadix(6);
    private static final String FIELD_CODECS = Util.intToStringMaxRadix(7);
    private static final String FIELD_METADATA = Util.intToStringMaxRadix(8);
    private static final String FIELD_CONTAINER_MIME_TYPE = Util.intToStringMaxRadix(9);
    private static final String FIELD_SAMPLE_MIME_TYPE = Util.intToStringMaxRadix(10);
    private static final String FIELD_MAX_INPUT_SIZE = Util.intToStringMaxRadix(11);
    private static final String FIELD_INITIALIZATION_DATA = Util.intToStringMaxRadix(12);
    private static final String FIELD_DRM_INIT_DATA = Util.intToStringMaxRadix(13);
    private static final String FIELD_SUBSAMPLE_OFFSET_US = Util.intToStringMaxRadix(14);
    private static final String FIELD_WIDTH = Util.intToStringMaxRadix(15);
    private static final String FIELD_HEIGHT = Util.intToStringMaxRadix(16);
    private static final String FIELD_FRAME_RATE = Util.intToStringMaxRadix(17);
    private static final String FIELD_ROTATION_DEGREES = Util.intToStringMaxRadix(18);
    private static final String FIELD_PIXEL_WIDTH_HEIGHT_RATIO = Util.intToStringMaxRadix(19);
    private static final String FIELD_PROJECTION_DATA = Util.intToStringMaxRadix(20);
    private static final String FIELD_STEREO_MODE = Util.intToStringMaxRadix(21);
    private static final String FIELD_COLOR_INFO = Util.intToStringMaxRadix(22);
    private static final String FIELD_CHANNEL_COUNT = Util.intToStringMaxRadix(23);
    private static final String FIELD_SAMPLE_RATE = Util.intToStringMaxRadix(24);
    private static final String FIELD_PCM_ENCODING = Util.intToStringMaxRadix(25);
    private static final String FIELD_ENCODER_DELAY = Util.intToStringMaxRadix(26);
    private static final String FIELD_ENCODER_PADDING = Util.intToStringMaxRadix(27);
    private static final String FIELD_ACCESSIBILITY_CHANNEL = Util.intToStringMaxRadix(28);
    private static final String FIELD_CRYPTO_TYPE = Util.intToStringMaxRadix(29);
    private static final String FIELD_TILE_COUNT_HORIZONTAL = Util.intToStringMaxRadix(30);
    private static final String FIELD_TILE_COUNT_VERTICAL = Util.intToStringMaxRadix(31);
    private static final String FIELD_LABELS = Util.intToStringMaxRadix(32);
    private static final String FIELD_AUXILIARY_TRACK_TYPE = Util.intToStringMaxRadix(33);

    private static boolean isLabelPartOfLabels(Builder builder) {
        if (builder.labels.isEmpty() && builder.label == null) {
            return true;
        }
        for (int i = 0; i < builder.labels.size(); ++i) {
            if (!((Label)((Builder)builder).labels.get((int)i)).value.equals(builder.label)) continue;
            return true;
        }
        return false;
    }

    private Format(Builder builder) {
        this.id = builder.id;
        this.language = Util.normalizeLanguageCode(builder.language);
        if (builder.labels.isEmpty() && builder.label != null) {
            this.labels = ImmutableList.of((Object)new Label(this.language, builder.label));
            this.label = builder.label;
        } else if (!builder.labels.isEmpty() && builder.label == null) {
            this.labels = builder.labels;
            this.label = Format.getDefaultLabel(builder.labels, this.language);
        } else {
            Assertions.checkState(Format.isLabelPartOfLabels(builder));
            this.labels = builder.labels;
            this.label = builder.label;
        }
        this.selectionFlags = builder.selectionFlags;
        Assertions.checkState(builder.auxiliaryTrackType == 0 || (builder.roleFlags & 0x8000) != 0, "Auxiliary track type must only be set to a value other than AUXILIARY_TRACK_TYPE_UNDEFINED only when ROLE_FLAG_AUXILIARY is set");
        this.roleFlags = builder.roleFlags;
        this.auxiliaryTrackType = builder.auxiliaryTrackType;
        this.averageBitrate = builder.averageBitrate;
        this.peakBitrate = builder.peakBitrate;
        this.bitrate = this.peakBitrate != -1 ? this.peakBitrate : this.averageBitrate;
        this.codecs = builder.codecs;
        this.metadata = builder.metadata;
        this.customData = builder.customData;
        this.containerMimeType = builder.containerMimeType;
        this.sampleMimeType = builder.sampleMimeType;
        this.maxInputSize = builder.maxInputSize;
        this.maxNumReorderSamples = builder.maxNumReorderSamples;
        this.initializationData = builder.initializationData == null ? Collections.emptyList() : builder.initializationData;
        this.drmInitData = builder.drmInitData;
        this.subsampleOffsetUs = builder.subsampleOffsetUs;
        this.hasPrerollSamples = builder.hasPrerollSamples;
        this.width = builder.width;
        this.height = builder.height;
        this.frameRate = builder.frameRate;
        this.rotationDegrees = builder.rotationDegrees == -1 ? 0 : builder.rotationDegrees;
        this.pixelWidthHeightRatio = builder.pixelWidthHeightRatio == -1.0f ? 1.0f : builder.pixelWidthHeightRatio;
        this.projectionData = builder.projectionData;
        this.stereoMode = builder.stereoMode;
        this.colorInfo = builder.colorInfo;
        this.channelCount = builder.channelCount;
        this.sampleRate = builder.sampleRate;
        this.pcmEncoding = builder.pcmEncoding;
        this.encoderDelay = builder.encoderDelay == -1 ? 0 : builder.encoderDelay;
        this.encoderPadding = builder.encoderPadding == -1 ? 0 : builder.encoderPadding;
        this.accessibilityChannel = builder.accessibilityChannel;
        this.cueReplacementBehavior = builder.cueReplacementBehavior;
        this.tileCountHorizontal = builder.tileCountHorizontal;
        this.tileCountVertical = builder.tileCountVertical;
        this.cryptoType = builder.cryptoType == 0 && this.drmInitData != null ? 1 : builder.cryptoType;
    }

    @UnstableApi
    public Builder buildUpon() {
        return new Builder(this);
    }

    @UnstableApi
    public Format withManifestFormatInfo(Format manifestFormat) {
        String codecsOfType;
        if (this == manifestFormat) {
            return this;
        }
        int trackType = MimeTypes.getTrackType(this.sampleMimeType);
        String id = manifestFormat.id;
        int tileCountHorizontal = manifestFormat.tileCountHorizontal;
        int tileCountVertical = manifestFormat.tileCountVertical;
        String label = manifestFormat.label != null ? manifestFormat.label : this.label;
        List<Label> labels = !manifestFormat.labels.isEmpty() ? manifestFormat.labels : this.labels;
        String language = this.language;
        if ((trackType == 3 || trackType == 1) && manifestFormat.language != null) {
            language = manifestFormat.language;
        }
        int averageBitrate = this.averageBitrate == -1 ? manifestFormat.averageBitrate : this.averageBitrate;
        int peakBitrate = this.peakBitrate == -1 ? manifestFormat.peakBitrate : this.peakBitrate;
        String codecs = this.codecs;
        if (codecs == null && Util.splitCodecs(codecsOfType = Util.getCodecsOfType(manifestFormat.codecs, trackType)).length == 1) {
            codecs = codecsOfType;
        }
        Metadata metadata = this.metadata == null ? manifestFormat.metadata : this.metadata.copyWithAppendedEntriesFrom(manifestFormat.metadata);
        float frameRate = this.frameRate;
        if (frameRate == -1.0f && trackType == 2) {
            frameRate = manifestFormat.frameRate;
        }
        int selectionFlags = this.selectionFlags | manifestFormat.selectionFlags;
        int roleFlags = this.roleFlags | manifestFormat.roleFlags;
        DrmInitData drmInitData = DrmInitData.createSessionCreationData(manifestFormat.drmInitData, this.drmInitData);
        return this.buildUpon().setId(id).setLabel(label).setLabels(labels).setLanguage(language).setSelectionFlags(selectionFlags).setRoleFlags(roleFlags).setAverageBitrate(averageBitrate).setPeakBitrate(peakBitrate).setCodecs(codecs).setMetadata(metadata).setDrmInitData(drmInitData).setFrameRate(frameRate).setTileCountHorizontal(tileCountHorizontal).setTileCountVertical(tileCountVertical).build();
    }

    @UnstableApi
    public Format copyWithCryptoType(int cryptoType) {
        return this.buildUpon().setCryptoType(cryptoType).build();
    }

    @UnstableApi
    public int getPixelCount() {
        return this.width == -1 || this.height == -1 ? -1 : this.width * this.height;
    }

    public String toString() {
        return "Format(" + this.id + ", " + this.label + ", " + this.containerMimeType + ", " + this.sampleMimeType + ", " + this.codecs + ", " + this.bitrate + ", " + this.language + ", [" + this.width + ", " + this.height + ", " + this.frameRate + ", " + this.colorInfo + "], [" + this.channelCount + ", " + this.sampleRate + "])";
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
            result = 31 * result + this.labels.hashCode();
            result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
            result = 31 * result + this.selectionFlags;
            result = 31 * result + this.roleFlags;
            result = 31 * result + this.auxiliaryTrackType;
            result = 31 * result + this.averageBitrate;
            result = 31 * result + this.peakBitrate;
            result = 31 * result + (this.codecs == null ? 0 : this.codecs.hashCode());
            result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
            result = 31 * result + (this.customData == null ? 0 : this.customData.hashCode());
            result = 31 * result + (this.containerMimeType == null ? 0 : this.containerMimeType.hashCode());
            result = 31 * result + (this.sampleMimeType == null ? 0 : this.sampleMimeType.hashCode());
            result = 31 * result + this.maxInputSize;
            result = 31 * result + (int)this.subsampleOffsetUs;
            result = 31 * result + this.width;
            result = 31 * result + this.height;
            result = 31 * result + Float.floatToIntBits(this.frameRate);
            result = 31 * result + this.rotationDegrees;
            result = 31 * result + Float.floatToIntBits(this.pixelWidthHeightRatio);
            result = 31 * result + this.stereoMode;
            result = 31 * result + this.channelCount;
            result = 31 * result + this.sampleRate;
            result = 31 * result + this.pcmEncoding;
            result = 31 * result + this.encoderDelay;
            result = 31 * result + this.encoderPadding;
            result = 31 * result + this.accessibilityChannel;
            result = 31 * result + this.tileCountHorizontal;
            result = 31 * result + this.tileCountVertical;
            this.hashCode = result = 31 * result + this.cryptoType;
        }
        return this.hashCode;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Format other = (Format)obj;
        if (this.hashCode != 0 && other.hashCode != 0 && this.hashCode != other.hashCode) {
            return false;
        }
        return this.selectionFlags == other.selectionFlags && this.roleFlags == other.roleFlags && this.auxiliaryTrackType == other.auxiliaryTrackType && this.averageBitrate == other.averageBitrate && this.peakBitrate == other.peakBitrate && this.maxInputSize == other.maxInputSize && this.subsampleOffsetUs == other.subsampleOffsetUs && this.width == other.width && this.height == other.height && this.rotationDegrees == other.rotationDegrees && this.stereoMode == other.stereoMode && this.channelCount == other.channelCount && this.sampleRate == other.sampleRate && this.pcmEncoding == other.pcmEncoding && this.encoderDelay == other.encoderDelay && this.encoderPadding == other.encoderPadding && this.accessibilityChannel == other.accessibilityChannel && this.tileCountHorizontal == other.tileCountHorizontal && this.tileCountVertical == other.tileCountVertical && this.cryptoType == other.cryptoType && Float.compare(this.frameRate, other.frameRate) == 0 && Float.compare(this.pixelWidthHeightRatio, other.pixelWidthHeightRatio) == 0 && Objects.equals(this.id, other.id) && Objects.equals(this.label, other.label) && this.labels.equals(other.labels) && Objects.equals(this.codecs, other.codecs) && Objects.equals(this.containerMimeType, other.containerMimeType) && Objects.equals(this.sampleMimeType, other.sampleMimeType) && Objects.equals(this.language, other.language) && Arrays.equals(this.projectionData, other.projectionData) && Objects.equals(this.metadata, other.metadata) && Objects.equals(this.colorInfo, other.colorInfo) && Objects.equals(this.drmInitData, other.drmInitData) && this.initializationDataEquals(other) && Objects.equals(this.customData, other.customData);
    }

    @UnstableApi
    public boolean initializationDataEquals(Format other) {
        if (this.initializationData.size() != other.initializationData.size()) {
            return false;
        }
        for (int i = 0; i < this.initializationData.size(); ++i) {
            if (Arrays.equals(this.initializationData.get(i), other.initializationData.get(i))) continue;
            return false;
        }
        return true;
    }

    @UnstableApi
    public static String toLogString(@Nullable Format format) {
        if (format == null) {
            return "null";
        }
        Joiner commaJoiner = Joiner.on((char)',');
        StringBuilder builder = new StringBuilder();
        builder.append("id=").append(format.id).append(", mimeType=").append(format.sampleMimeType);
        if (format.containerMimeType != null) {
            builder.append(", container=").append(format.containerMimeType);
        }
        if (format.bitrate != -1) {
            builder.append(", bitrate=").append(format.bitrate);
        }
        if (format.codecs != null) {
            builder.append(", codecs=").append(format.codecs);
        }
        if (format.drmInitData != null) {
            LinkedHashSet<String> schemes = new LinkedHashSet<String>();
            for (int i = 0; i < format.drmInitData.schemeDataCount; ++i) {
                UUID schemeUuid = format.drmInitData.get((int)i).uuid;
                if (schemeUuid.equals(C.COMMON_PSSH_UUID)) {
                    schemes.add("cenc");
                    continue;
                }
                if (schemeUuid.equals(C.CLEARKEY_UUID)) {
                    schemes.add("clearkey");
                    continue;
                }
                if (schemeUuid.equals(C.PLAYREADY_UUID)) {
                    schemes.add("playready");
                    continue;
                }
                if (schemeUuid.equals(C.WIDEVINE_UUID)) {
                    schemes.add("widevine");
                    continue;
                }
                if (schemeUuid.equals(C.UUID_NIL)) {
                    schemes.add("universal");
                    continue;
                }
                schemes.add("unknown (" + schemeUuid + ")");
            }
            builder.append(", drm=[");
            commaJoiner.appendTo(builder, schemes);
            builder.append(']');
        }
        if (format.width != -1 && format.height != -1) {
            builder.append(", res=").append(format.width).append("x").append(format.height);
        }
        if (!DoubleMath.fuzzyEquals((double)format.pixelWidthHeightRatio, (double)1.0, (double)0.001)) {
            builder.append(", par=").append(Util.formatInvariant("%.3f", Float.valueOf(format.pixelWidthHeightRatio)));
        }
        if (format.colorInfo != null && format.colorInfo.isValid()) {
            builder.append(", color=").append(format.colorInfo.toLogString());
        }
        if (format.frameRate != -1.0f) {
            builder.append(", fps=").append(format.frameRate);
        }
        if (format.channelCount != -1) {
            builder.append(", channels=").append(format.channelCount);
        }
        if (format.sampleRate != -1) {
            builder.append(", sample_rate=").append(format.sampleRate);
        }
        if (format.language != null) {
            builder.append(", language=").append(format.language);
        }
        if (!format.labels.isEmpty()) {
            builder.append(", labels=[");
            commaJoiner.appendTo(builder, (Iterable)Lists.transform(format.labels, l -> l.language + ": " + l.value));
            builder.append("]");
        }
        if (format.selectionFlags != 0) {
            builder.append(", selectionFlags=[");
            commaJoiner.appendTo(builder, Util.getSelectionFlagStrings(format.selectionFlags));
            builder.append("]");
        }
        if (format.roleFlags != 0) {
            builder.append(", roleFlags=[");
            commaJoiner.appendTo(builder, Util.getRoleFlagStrings(format.roleFlags));
            builder.append("]");
        }
        if (format.customData != null) {
            builder.append(", customData=").append(format.customData);
        }
        if ((format.roleFlags & 0x8000) != 0) {
            builder.append(", auxiliaryTrackType=").append(Util.getAuxiliaryTrackTypeString(format.auxiliaryTrackType));
        }
        return builder.toString();
    }

    @Deprecated
    @UnstableApi
    public Bundle toBundle() {
        return this.toBundle(false);
    }

    @UnstableApi
    public Bundle toBundle(boolean excludeMetadata) {
        Bundle bundle = new Bundle();
        bundle.putString(FIELD_ID, this.id);
        bundle.putString(FIELD_LABEL, this.label);
        bundle.putParcelableArrayList(FIELD_LABELS, BundleCollectionUtil.toBundleArrayList(this.labels, Label::toBundle));
        bundle.putString(FIELD_LANGUAGE, this.language);
        bundle.putInt(FIELD_SELECTION_FLAGS, this.selectionFlags);
        bundle.putInt(FIELD_ROLE_FLAGS, this.roleFlags);
        if (this.auxiliaryTrackType != Format.DEFAULT.auxiliaryTrackType) {
            bundle.putInt(FIELD_AUXILIARY_TRACK_TYPE, this.auxiliaryTrackType);
        }
        bundle.putInt(FIELD_AVERAGE_BITRATE, this.averageBitrate);
        bundle.putInt(FIELD_PEAK_BITRATE, this.peakBitrate);
        bundle.putString(FIELD_CODECS, this.codecs);
        if (!excludeMetadata) {
            bundle.putParcelable(FIELD_METADATA, (Parcelable)this.metadata);
        }
        bundle.putString(FIELD_CONTAINER_MIME_TYPE, this.containerMimeType);
        bundle.putString(FIELD_SAMPLE_MIME_TYPE, this.sampleMimeType);
        bundle.putInt(FIELD_MAX_INPUT_SIZE, this.maxInputSize);
        for (int i = 0; i < this.initializationData.size(); ++i) {
            bundle.putByteArray(Format.keyForInitializationData(i), this.initializationData.get(i));
        }
        bundle.putParcelable(FIELD_DRM_INIT_DATA, (Parcelable)this.drmInitData);
        bundle.putLong(FIELD_SUBSAMPLE_OFFSET_US, this.subsampleOffsetUs);
        bundle.putInt(FIELD_WIDTH, this.width);
        bundle.putInt(FIELD_HEIGHT, this.height);
        bundle.putFloat(FIELD_FRAME_RATE, this.frameRate);
        bundle.putInt(FIELD_ROTATION_DEGREES, this.rotationDegrees);
        bundle.putFloat(FIELD_PIXEL_WIDTH_HEIGHT_RATIO, this.pixelWidthHeightRatio);
        bundle.putByteArray(FIELD_PROJECTION_DATA, this.projectionData);
        bundle.putInt(FIELD_STEREO_MODE, this.stereoMode);
        if (this.colorInfo != null) {
            bundle.putBundle(FIELD_COLOR_INFO, this.colorInfo.toBundle());
        }
        bundle.putInt(FIELD_CHANNEL_COUNT, this.channelCount);
        bundle.putInt(FIELD_SAMPLE_RATE, this.sampleRate);
        bundle.putInt(FIELD_PCM_ENCODING, this.pcmEncoding);
        bundle.putInt(FIELD_ENCODER_DELAY, this.encoderDelay);
        bundle.putInt(FIELD_ENCODER_PADDING, this.encoderPadding);
        bundle.putInt(FIELD_ACCESSIBILITY_CHANNEL, this.accessibilityChannel);
        bundle.putInt(FIELD_TILE_COUNT_HORIZONTAL, this.tileCountHorizontal);
        bundle.putInt(FIELD_TILE_COUNT_VERTICAL, this.tileCountVertical);
        bundle.putInt(FIELD_CRYPTO_TYPE, this.cryptoType);
        return bundle;
    }

    @UnstableApi
    public static Format fromBundle(Bundle bundle) {
        byte[] data;
        Builder builder = new Builder();
        BundleCollectionUtil.ensureClassLoader(bundle);
        builder.setId(Format.defaultIfNull(bundle.getString(FIELD_ID), Format.DEFAULT.id)).setLabel(Format.defaultIfNull(bundle.getString(FIELD_LABEL), Format.DEFAULT.label));
        ArrayList labelsBundles = bundle.getParcelableArrayList(FIELD_LABELS);
        ImmutableList labels = labelsBundles == null ? ImmutableList.of() : BundleCollectionUtil.fromBundleList(Label::fromBundle, labelsBundles);
        builder.setLabels((List<Label>)labels).setLanguage(Format.defaultIfNull(bundle.getString(FIELD_LANGUAGE), Format.DEFAULT.language)).setSelectionFlags(bundle.getInt(FIELD_SELECTION_FLAGS, Format.DEFAULT.selectionFlags)).setRoleFlags(bundle.getInt(FIELD_ROLE_FLAGS, Format.DEFAULT.roleFlags)).setAuxiliaryTrackType(bundle.getInt(FIELD_AUXILIARY_TRACK_TYPE, Format.DEFAULT.auxiliaryTrackType)).setAverageBitrate(bundle.getInt(FIELD_AVERAGE_BITRATE, Format.DEFAULT.averageBitrate)).setPeakBitrate(bundle.getInt(FIELD_PEAK_BITRATE, Format.DEFAULT.peakBitrate)).setCodecs(Format.defaultIfNull(bundle.getString(FIELD_CODECS), Format.DEFAULT.codecs)).setMetadata(Format.defaultIfNull((Metadata)bundle.getParcelable(FIELD_METADATA), Format.DEFAULT.metadata)).setContainerMimeType(Format.defaultIfNull(bundle.getString(FIELD_CONTAINER_MIME_TYPE), Format.DEFAULT.containerMimeType)).setSampleMimeType(Format.defaultIfNull(bundle.getString(FIELD_SAMPLE_MIME_TYPE), Format.DEFAULT.sampleMimeType)).setMaxInputSize(bundle.getInt(FIELD_MAX_INPUT_SIZE, Format.DEFAULT.maxInputSize));
        ArrayList<byte[]> initializationData = new ArrayList<byte[]>();
        int i = 0;
        while ((data = bundle.getByteArray(Format.keyForInitializationData(i))) != null) {
            initializationData.add(data);
            ++i;
        }
        builder.setInitializationData(initializationData).setDrmInitData((DrmInitData)bundle.getParcelable(FIELD_DRM_INIT_DATA)).setSubsampleOffsetUs(bundle.getLong(FIELD_SUBSAMPLE_OFFSET_US, Format.DEFAULT.subsampleOffsetUs)).setWidth(bundle.getInt(FIELD_WIDTH, Format.DEFAULT.width)).setHeight(bundle.getInt(FIELD_HEIGHT, Format.DEFAULT.height)).setFrameRate(bundle.getFloat(FIELD_FRAME_RATE, Format.DEFAULT.frameRate)).setRotationDegrees(bundle.getInt(FIELD_ROTATION_DEGREES, Format.DEFAULT.rotationDegrees)).setPixelWidthHeightRatio(bundle.getFloat(FIELD_PIXEL_WIDTH_HEIGHT_RATIO, Format.DEFAULT.pixelWidthHeightRatio)).setProjectionData(bundle.getByteArray(FIELD_PROJECTION_DATA)).setStereoMode(bundle.getInt(FIELD_STEREO_MODE, Format.DEFAULT.stereoMode));
        Bundle colorInfoBundle = bundle.getBundle(FIELD_COLOR_INFO);
        if (colorInfoBundle != null) {
            builder.setColorInfo(ColorInfo.fromBundle(colorInfoBundle));
        }
        builder.setChannelCount(bundle.getInt(FIELD_CHANNEL_COUNT, Format.DEFAULT.channelCount)).setSampleRate(bundle.getInt(FIELD_SAMPLE_RATE, Format.DEFAULT.sampleRate)).setPcmEncoding(bundle.getInt(FIELD_PCM_ENCODING, Format.DEFAULT.pcmEncoding)).setEncoderDelay(bundle.getInt(FIELD_ENCODER_DELAY, Format.DEFAULT.encoderDelay)).setEncoderPadding(bundle.getInt(FIELD_ENCODER_PADDING, Format.DEFAULT.encoderPadding)).setAccessibilityChannel(bundle.getInt(FIELD_ACCESSIBILITY_CHANNEL, Format.DEFAULT.accessibilityChannel)).setTileCountHorizontal(bundle.getInt(FIELD_TILE_COUNT_HORIZONTAL, Format.DEFAULT.tileCountHorizontal)).setTileCountVertical(bundle.getInt(FIELD_TILE_COUNT_VERTICAL, Format.DEFAULT.tileCountVertical)).setCryptoType(bundle.getInt(FIELD_CRYPTO_TYPE, Format.DEFAULT.cryptoType));
        return builder.build();
    }

    private static String keyForInitializationData(int initialisationDataIndex) {
        return FIELD_INITIALIZATION_DATA + "_" + Integer.toString(initialisationDataIndex, 36);
    }

    @Nullable
    private static <T> T defaultIfNull(@Nullable T value, @Nullable T defaultValue) {
        return value != null ? value : defaultValue;
    }

    private static String getDefaultLabel(List<Label> labels, @Nullable String language) {
        for (Label l : labels) {
            if (!TextUtils.equals((CharSequence)l.language, (CharSequence)language)) continue;
            return l.value;
        }
        return labels.get((int)0).value;
    }

    @UnstableApi
    public static final class Builder {
        @Nullable
        private String id;
        @Nullable
        private String label;
        private List<Label> labels;
        @Nullable
        private String language;
        private int selectionFlags;
        private int roleFlags;
        private int auxiliaryTrackType;
        private int averageBitrate;
        private int peakBitrate;
        @Nullable
        private String codecs;
        @Nullable
        private Metadata metadata;
        @Nullable
        private Object customData;
        @Nullable
        private String containerMimeType;
        @Nullable
        private String sampleMimeType;
        private int maxInputSize;
        private int maxNumReorderSamples;
        @Nullable
        private List<byte[]> initializationData;
        @Nullable
        private DrmInitData drmInitData;
        private long subsampleOffsetUs;
        private boolean hasPrerollSamples;
        private int width;
        private int height;
        private float frameRate;
        private int rotationDegrees;
        private float pixelWidthHeightRatio;
        @Nullable
        private byte[] projectionData;
        private int stereoMode;
        @Nullable
        private ColorInfo colorInfo;
        private int channelCount;
        private int sampleRate;
        private int pcmEncoding;
        private int encoderDelay;
        private int encoderPadding;
        private int accessibilityChannel;
        @UnstableApi
        private int cueReplacementBehavior;
        private int tileCountHorizontal;
        private int tileCountVertical;
        private int cryptoType;

        public Builder() {
            this.labels = ImmutableList.of();
            this.averageBitrate = -1;
            this.peakBitrate = -1;
            this.maxInputSize = -1;
            this.maxNumReorderSamples = -1;
            this.subsampleOffsetUs = Long.MAX_VALUE;
            this.width = -1;
            this.height = -1;
            this.frameRate = -1.0f;
            this.pixelWidthHeightRatio = 1.0f;
            this.stereoMode = -1;
            this.channelCount = -1;
            this.sampleRate = -1;
            this.pcmEncoding = -1;
            this.accessibilityChannel = -1;
            this.cueReplacementBehavior = 1;
            this.tileCountHorizontal = -1;
            this.tileCountVertical = -1;
            this.cryptoType = 0;
            this.auxiliaryTrackType = 0;
        }

        private Builder(Format format) {
            this.id = format.id;
            this.label = format.label;
            this.labels = format.labels;
            this.language = format.language;
            this.selectionFlags = format.selectionFlags;
            this.roleFlags = format.roleFlags;
            this.averageBitrate = format.averageBitrate;
            this.peakBitrate = format.peakBitrate;
            this.codecs = format.codecs;
            this.metadata = format.metadata;
            this.customData = format.customData;
            this.containerMimeType = format.containerMimeType;
            this.sampleMimeType = format.sampleMimeType;
            this.maxInputSize = format.maxInputSize;
            this.maxNumReorderSamples = format.maxNumReorderSamples;
            this.initializationData = format.initializationData;
            this.drmInitData = format.drmInitData;
            this.subsampleOffsetUs = format.subsampleOffsetUs;
            this.hasPrerollSamples = format.hasPrerollSamples;
            this.width = format.width;
            this.height = format.height;
            this.frameRate = format.frameRate;
            this.rotationDegrees = format.rotationDegrees;
            this.pixelWidthHeightRatio = format.pixelWidthHeightRatio;
            this.projectionData = format.projectionData;
            this.stereoMode = format.stereoMode;
            this.colorInfo = format.colorInfo;
            this.channelCount = format.channelCount;
            this.sampleRate = format.sampleRate;
            this.pcmEncoding = format.pcmEncoding;
            this.encoderDelay = format.encoderDelay;
            this.encoderPadding = format.encoderPadding;
            this.accessibilityChannel = format.accessibilityChannel;
            this.cueReplacementBehavior = format.cueReplacementBehavior;
            this.tileCountHorizontal = format.tileCountHorizontal;
            this.tileCountVertical = format.tileCountVertical;
            this.cryptoType = format.cryptoType;
        }

        @CanIgnoreReturnValue
        public Builder setId(@Nullable String id) {
            this.id = id;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setId(int id) {
            this.id = Integer.toString(id);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setLabel(@Nullable String label) {
            this.label = label;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setLabels(List<Label> labels) {
            this.labels = ImmutableList.copyOf(labels);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setLanguage(@Nullable String language) {
            this.language = language;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setSelectionFlags(int selectionFlags) {
            this.selectionFlags = selectionFlags;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setRoleFlags(int roleFlags) {
            this.roleFlags = roleFlags;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setAuxiliaryTrackType(int auxiliaryTrackType) {
            this.auxiliaryTrackType = auxiliaryTrackType;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setAverageBitrate(int averageBitrate) {
            this.averageBitrate = averageBitrate;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPeakBitrate(int peakBitrate) {
            this.peakBitrate = peakBitrate;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setCodecs(@Nullable String codecs) {
            this.codecs = codecs;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMetadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @UnstableApi
        @CanIgnoreReturnValue
        public Builder setCustomData(@Nullable Object customData) {
            this.customData = customData;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setContainerMimeType(@Nullable String containerMimeType) {
            this.containerMimeType = MimeTypes.normalizeMimeType(containerMimeType);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setSampleMimeType(@Nullable String sampleMimeType) {
            this.sampleMimeType = MimeTypes.normalizeMimeType(sampleMimeType);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMaxInputSize(int maxInputSize) {
            this.maxInputSize = maxInputSize;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMaxNumReorderSamples(int maxNumReorderSamples) {
            this.maxNumReorderSamples = maxNumReorderSamples;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setInitializationData(@Nullable List<byte[]> initializationData) {
            this.initializationData = initializationData;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setDrmInitData(@Nullable DrmInitData drmInitData) {
            this.drmInitData = drmInitData;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setSubsampleOffsetUs(long subsampleOffsetUs) {
            this.subsampleOffsetUs = subsampleOffsetUs;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setHasPrerollSamples(boolean hasPrerollSamples) {
            this.hasPrerollSamples = hasPrerollSamples;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setWidth(int width) {
            this.width = width;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setHeight(int height) {
            this.height = height;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setFrameRate(float frameRate) {
            this.frameRate = frameRate;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setRotationDegrees(int rotationDegrees) {
            this.rotationDegrees = rotationDegrees;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPixelWidthHeightRatio(float pixelWidthHeightRatio) {
            this.pixelWidthHeightRatio = pixelWidthHeightRatio;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setProjectionData(@Nullable byte[] projectionData) {
            this.projectionData = projectionData;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setStereoMode(int stereoMode) {
            this.stereoMode = stereoMode;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setColorInfo(@Nullable ColorInfo colorInfo) {
            this.colorInfo = colorInfo;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setChannelCount(int channelCount) {
            this.channelCount = channelCount;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setSampleRate(int sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPcmEncoding(int pcmEncoding) {
            this.pcmEncoding = pcmEncoding;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setEncoderDelay(int encoderDelay) {
            this.encoderDelay = encoderDelay;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setEncoderPadding(int encoderPadding) {
            this.encoderPadding = encoderPadding;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setAccessibilityChannel(int accessibilityChannel) {
            this.accessibilityChannel = accessibilityChannel;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setCueReplacementBehavior(int cueReplacementBehavior) {
            this.cueReplacementBehavior = cueReplacementBehavior;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setTileCountHorizontal(int tileCountHorizontal) {
            this.tileCountHorizontal = tileCountHorizontal;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setTileCountVertical(int tileCountVertical) {
            this.tileCountVertical = tileCountVertical;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setCryptoType(int cryptoType) {
            this.cryptoType = cryptoType;
            return this;
        }

        public Format build() {
            return new Format(this);
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    @UnstableApi
    public static @interface CueReplacementBehavior {
    }
}

