/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common.util;

import androidx.annotation.Nullable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.ParsableBitArray;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Chars;
import com.google.common.primitives.UnsignedBytes;
import com.google.errorprone.annotations.CheckReturnValue;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

@CheckReturnValue
@UnstableApi
public final class ParsableByteArray {
    private static final char[] CR_AND_LF = new char[]{'\r', '\n'};
    private static final char[] LF = new char[]{'\n'};
    private static final ImmutableSet<Charset> SUPPORTED_CHARSETS_FOR_READLINE = ImmutableSet.of((Object)Charsets.US_ASCII, (Object)Charsets.UTF_8, (Object)Charsets.UTF_16, (Object)Charsets.UTF_16BE, (Object)Charsets.UTF_16LE);
    private byte[] data;
    private int position;
    private int limit;

    public ParsableByteArray() {
        this.data = Util.EMPTY_BYTE_ARRAY;
    }

    public ParsableByteArray(int limit) {
        this.data = new byte[limit];
        this.limit = limit;
    }

    public ParsableByteArray(byte[] data) {
        this.data = data;
        this.limit = data.length;
    }

    public ParsableByteArray(byte[] data, int limit) {
        this.data = data;
        this.limit = limit;
    }

    public void reset(int limit) {
        this.reset(this.capacity() < limit ? new byte[limit] : this.data, limit);
    }

    public void reset(byte[] data) {
        this.reset(data, data.length);
    }

    public void reset(byte[] data, int limit) {
        this.data = data;
        this.limit = limit;
        this.position = 0;
    }

    public void ensureCapacity(int requiredCapacity) {
        if (requiredCapacity > this.capacity()) {
            this.data = Arrays.copyOf(this.data, requiredCapacity);
        }
    }

    public int bytesLeft() {
        return this.limit - this.position;
    }

    public int limit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        Assertions.checkArgument(limit >= 0 && limit <= this.data.length);
        this.limit = limit;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        Assertions.checkArgument(position >= 0 && position <= this.limit);
        this.position = position;
    }

    public byte[] getData() {
        return this.data;
    }

    public int capacity() {
        return this.data.length;
    }

    public void skipBytes(int bytes) {
        this.setPosition(this.position + bytes);
    }

    public void readBytes(ParsableBitArray bitArray, int length) {
        this.readBytes(bitArray.data, 0, length);
        bitArray.setPosition(0);
    }

    public void readBytes(byte[] buffer, int offset, int length) {
        System.arraycopy(this.data, this.position, buffer, offset, length);
        this.position += length;
    }

    public void readBytes(ByteBuffer buffer, int length) {
        buffer.put(this.data, this.position, length);
        this.position += length;
    }

    public int peekUnsignedByte() {
        return this.data[this.position] & 0xFF;
    }

    public char peekChar() {
        return (char)((this.data[this.position] & 0xFF) << 8 | this.data[this.position + 1] & 0xFF);
    }

    public char peekChar(Charset charset) {
        Assertions.checkArgument(SUPPORTED_CHARSETS_FOR_READLINE.contains((Object)charset), "Unsupported charset: " + charset);
        return (char)(this.peekCharacterAndSize(charset) >> 16);
    }

    public int readUnsignedByte() {
        return this.data[this.position++] & 0xFF;
    }

    public int readUnsignedShort() {
        return (this.data[this.position++] & 0xFF) << 8 | this.data[this.position++] & 0xFF;
    }

    public int readLittleEndianUnsignedShort() {
        return this.data[this.position++] & 0xFF | (this.data[this.position++] & 0xFF) << 8;
    }

    public short readShort() {
        return (short)((this.data[this.position++] & 0xFF) << 8 | this.data[this.position++] & 0xFF);
    }

    public short readLittleEndianShort() {
        return (short)(this.data[this.position++] & 0xFF | (this.data[this.position++] & 0xFF) << 8);
    }

    public int readUnsignedInt24() {
        return (this.data[this.position++] & 0xFF) << 16 | (this.data[this.position++] & 0xFF) << 8 | this.data[this.position++] & 0xFF;
    }

    public int readInt24() {
        return (this.data[this.position++] & 0xFF) << 24 >> 8 | (this.data[this.position++] & 0xFF) << 8 | this.data[this.position++] & 0xFF;
    }

    public int readLittleEndianInt24() {
        return this.data[this.position++] & 0xFF | (this.data[this.position++] & 0xFF) << 8 | (this.data[this.position++] & 0xFF) << 16;
    }

    public int readLittleEndianUnsignedInt24() {
        return this.data[this.position++] & 0xFF | (this.data[this.position++] & 0xFF) << 8 | (this.data[this.position++] & 0xFF) << 16;
    }

    public long readUnsignedInt() {
        return ((long)this.data[this.position++] & 0xFFL) << 24 | ((long)this.data[this.position++] & 0xFFL) << 16 | ((long)this.data[this.position++] & 0xFFL) << 8 | (long)this.data[this.position++] & 0xFFL;
    }

    public long readLittleEndianUnsignedInt() {
        return (long)this.data[this.position++] & 0xFFL | ((long)this.data[this.position++] & 0xFFL) << 8 | ((long)this.data[this.position++] & 0xFFL) << 16 | ((long)this.data[this.position++] & 0xFFL) << 24;
    }

    public int readInt() {
        return (this.data[this.position++] & 0xFF) << 24 | (this.data[this.position++] & 0xFF) << 16 | (this.data[this.position++] & 0xFF) << 8 | this.data[this.position++] & 0xFF;
    }

    public int readLittleEndianInt() {
        return this.data[this.position++] & 0xFF | (this.data[this.position++] & 0xFF) << 8 | (this.data[this.position++] & 0xFF) << 16 | (this.data[this.position++] & 0xFF) << 24;
    }

    public long readLong() {
        return ((long)this.data[this.position++] & 0xFFL) << 56 | ((long)this.data[this.position++] & 0xFFL) << 48 | ((long)this.data[this.position++] & 0xFFL) << 40 | ((long)this.data[this.position++] & 0xFFL) << 32 | ((long)this.data[this.position++] & 0xFFL) << 24 | ((long)this.data[this.position++] & 0xFFL) << 16 | ((long)this.data[this.position++] & 0xFFL) << 8 | (long)this.data[this.position++] & 0xFFL;
    }

    public long readLittleEndianLong() {
        return (long)this.data[this.position++] & 0xFFL | ((long)this.data[this.position++] & 0xFFL) << 8 | ((long)this.data[this.position++] & 0xFFL) << 16 | ((long)this.data[this.position++] & 0xFFL) << 24 | ((long)this.data[this.position++] & 0xFFL) << 32 | ((long)this.data[this.position++] & 0xFFL) << 40 | ((long)this.data[this.position++] & 0xFFL) << 48 | ((long)this.data[this.position++] & 0xFFL) << 56;
    }

    public int readUnsignedFixedPoint1616() {
        int result = (this.data[this.position++] & 0xFF) << 8 | this.data[this.position++] & 0xFF;
        this.position += 2;
        return result;
    }

    public int readSynchSafeInt() {
        int b1 = this.readUnsignedByte();
        int b2 = this.readUnsignedByte();
        int b3 = this.readUnsignedByte();
        int b4 = this.readUnsignedByte();
        return b1 << 21 | b2 << 14 | b3 << 7 | b4;
    }

    public int readUnsignedIntToInt() {
        int result = this.readInt();
        if (result < 0) {
            throw new IllegalStateException("Top bit not zero: " + result);
        }
        return result;
    }

    public int readLittleEndianUnsignedIntToInt() {
        int result = this.readLittleEndianInt();
        if (result < 0) {
            throw new IllegalStateException("Top bit not zero: " + result);
        }
        return result;
    }

    public long readUnsignedLongToLong() {
        long result = this.readLong();
        if (result < 0L) {
            throw new IllegalStateException("Top bit not zero: " + result);
        }
        return result;
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readString(int length) {
        return this.readString(length, Charsets.UTF_8);
    }

    public String readString(int length, Charset charset) {
        String result = new String(this.data, this.position, length, charset);
        this.position += length;
        return result;
    }

    public String readNullTerminatedString(int length) {
        if (length == 0) {
            return "";
        }
        int stringLength = length;
        int lastIndex = this.position + length - 1;
        if (lastIndex < this.limit && this.data[lastIndex] == 0) {
            --stringLength;
        }
        String result = Util.fromUtf8Bytes(this.data, this.position, stringLength);
        this.position += length;
        return result;
    }

    @Nullable
    public String readNullTerminatedString() {
        return this.readDelimiterTerminatedString('\u0000');
    }

    @Nullable
    public String readDelimiterTerminatedString(char delimiter) {
        int stringLimit;
        if (this.bytesLeft() == 0) {
            return null;
        }
        for (stringLimit = this.position; stringLimit < this.limit && this.data[stringLimit] != delimiter; ++stringLimit) {
        }
        String string = Util.fromUtf8Bytes(this.data, this.position, stringLimit - this.position);
        this.position = stringLimit;
        if (this.position < this.limit) {
            ++this.position;
        }
        return string;
    }

    @Nullable
    public String readLine() {
        return this.readLine(Charsets.UTF_8);
    }

    @Nullable
    public String readLine(Charset charset) {
        Assertions.checkArgument(SUPPORTED_CHARSETS_FOR_READLINE.contains((Object)charset), "Unsupported charset: " + charset);
        if (this.bytesLeft() == 0) {
            return null;
        }
        if (!charset.equals(Charsets.US_ASCII)) {
            Charset charset2 = this.readUtfCharsetFromBom();
        }
        int lineLimit = this.findNextLineTerminator(charset);
        String line = this.readString(lineLimit - this.position, charset);
        if (this.position == this.limit) {
            return line;
        }
        this.skipLineTerminator(charset);
        return line;
    }

    public long readUtf8EncodedLong() {
        int length = 0;
        long value = this.data[this.position];
        for (int j = 7; j >= 0; --j) {
            if ((value & (long)(1 << j)) != 0L) continue;
            if (j < 6) {
                value &= (long)((1 << j) - 1);
                length = 7 - j;
                break;
            }
            if (j != 7) break;
            length = 1;
            break;
        }
        if (length == 0) {
            throw new NumberFormatException("Invalid UTF-8 sequence first byte: " + value);
        }
        for (int i = 1; i < length; ++i) {
            byte x = this.data[this.position + i];
            if ((x & 0xC0) != 128) {
                throw new NumberFormatException("Invalid UTF-8 sequence continuation byte: " + value);
            }
            value = value << 6 | (long)(x & 0x3F);
        }
        this.position += length;
        return value;
    }

    @Nullable
    public Charset readUtfCharsetFromBom() {
        if (this.bytesLeft() >= 3 && this.data[this.position] == -17 && this.data[this.position + 1] == -69 && this.data[this.position + 2] == -65) {
            this.position += 3;
            return Charsets.UTF_8;
        }
        if (this.bytesLeft() >= 2) {
            if (this.data[this.position] == -2 && this.data[this.position + 1] == -1) {
                this.position += 2;
                return Charsets.UTF_16BE;
            }
            if (this.data[this.position] == -1 && this.data[this.position + 1] == -2) {
                this.position += 2;
                return Charsets.UTF_16LE;
            }
        }
        return null;
    }

    private int findNextLineTerminator(Charset charset) {
        int stride;
        if (charset.equals(Charsets.UTF_8) || charset.equals(Charsets.US_ASCII)) {
            stride = 1;
        } else if (charset.equals(Charsets.UTF_16) || charset.equals(Charsets.UTF_16LE) || charset.equals(Charsets.UTF_16BE)) {
            stride = 2;
        } else {
            throw new IllegalArgumentException("Unsupported charset: " + charset);
        }
        for (int i = this.position; i < this.limit - (stride - 1); i += stride) {
            if ((charset.equals(Charsets.UTF_8) || charset.equals(Charsets.US_ASCII)) && Util.isLinebreak(this.data[i])) {
                return i;
            }
            if ((charset.equals(Charsets.UTF_16) || charset.equals(Charsets.UTF_16BE)) && this.data[i] == 0 && Util.isLinebreak(this.data[i + 1])) {
                return i;
            }
            if (!charset.equals(Charsets.UTF_16LE) || this.data[i + 1] != 0 || !Util.isLinebreak(this.data[i])) continue;
            return i;
        }
        return this.limit;
    }

    private void skipLineTerminator(Charset charset) {
        if (this.readCharacterIfInList(charset, CR_AND_LF) == '\r') {
            char c = this.readCharacterIfInList(charset, LF);
        }
    }

    private char readCharacterIfInList(Charset charset, char[] chars) {
        int characterAndSize = this.peekCharacterAndSize(charset);
        if (characterAndSize != 0 && Chars.contains((char[])chars, (char)((char)(characterAndSize >> 16)))) {
            this.position += characterAndSize & 0xFFFF;
            return (char)(characterAndSize >> 16);
        }
        return '\u0000';
    }

    private int peekCharacterAndSize(Charset charset) {
        int characterSize;
        byte character;
        if ((charset.equals(Charsets.UTF_8) || charset.equals(Charsets.US_ASCII)) && this.bytesLeft() >= 1) {
            character = (byte)Chars.checkedCast((long)UnsignedBytes.toInt((byte)this.data[this.position]));
            characterSize = 1;
        } else if ((charset.equals(Charsets.UTF_16) || charset.equals(Charsets.UTF_16BE)) && this.bytesLeft() >= 2) {
            character = (byte)Chars.fromBytes((byte)this.data[this.position], (byte)this.data[this.position + 1]);
            characterSize = 2;
        } else if (charset.equals(Charsets.UTF_16LE) && this.bytesLeft() >= 2) {
            character = (byte)Chars.fromBytes((byte)this.data[this.position + 1], (byte)this.data[this.position]);
            characterSize = 2;
        } else {
            return 0;
        }
        return (Chars.checkedCast((long)character) << 16) + characterSize;
    }
}

