/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common;

import android.os.Bundle;
import androidx.annotation.CheckResult;
import androidx.annotation.Nullable;
import androidx.media3.common.Bundleable;
import androidx.media3.common.Format;
import androidx.media3.common.MimeTypes;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.BundleCollectionUtil;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;

public final class TrackGroup
implements Bundleable {
    private static final String TAG = "TrackGroup";
    @UnstableApi
    public final int length;
    @UnstableApi
    public final String id;
    @UnstableApi
    public final int type;
    private final Format[] formats;
    private int hashCode;
    private static final String FIELD_FORMATS = Util.intToStringMaxRadix(0);
    private static final String FIELD_ID = Util.intToStringMaxRadix(1);
    @Deprecated
    @UnstableApi
    public static final Bundleable.Creator<TrackGroup> CREATOR = TrackGroup::fromBundle;

    @UnstableApi
    public TrackGroup(Format ... formats) {
        this("", formats);
    }

    @UnstableApi
    public TrackGroup(String id, Format ... formats) {
        Assertions.checkArgument(formats.length > 0);
        this.id = id;
        this.formats = formats;
        this.length = formats.length;
        int type = MimeTypes.getTrackType(formats[0].sampleMimeType);
        if (type == -1) {
            type = MimeTypes.getTrackType(formats[0].containerMimeType);
        }
        this.type = type;
        this.verifyCorrectness();
    }

    @UnstableApi
    @CheckResult
    public TrackGroup copyWithId(String id) {
        return new TrackGroup(id, this.formats);
    }

    @UnstableApi
    public Format getFormat(int index) {
        return this.formats[index];
    }

    @UnstableApi
    public int indexOf(Format format) {
        for (int i = 0; i < this.formats.length; ++i) {
            if (format != this.formats[i]) continue;
            return i;
        }
        return -1;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 31 * result + this.id.hashCode();
            this.hashCode = result = 31 * result + Arrays.hashCode(this.formats);
        }
        return this.hashCode;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrackGroup other = (TrackGroup)obj;
        return this.id.equals(other.id) && Arrays.equals(this.formats, other.formats);
    }

    @Override
    @UnstableApi
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>(this.formats.length);
        for (Format format : this.formats) {
            arrayList.add(format.toBundle(true));
        }
        bundle.putParcelableArrayList(FIELD_FORMATS, arrayList);
        bundle.putString(FIELD_ID, this.id);
        return bundle;
    }

    @UnstableApi
    public static TrackGroup fromBundle(Bundle bundle) {
        ArrayList formatBundles = bundle.getParcelableArrayList(FIELD_FORMATS);
        ImmutableList<Format> formats = formatBundles == null ? ImmutableList.of() : BundleCollectionUtil.fromBundleList(Format::fromBundle, formatBundles);
        String id = bundle.getString(FIELD_ID, "");
        return new TrackGroup(id, formats.toArray((Format[])new Format[0]));
    }

    private void verifyCorrectness() {
        String language = TrackGroup.normalizeLanguage(this.formats[0].language);
        int roleFlags = TrackGroup.normalizeRoleFlags(this.formats[0].roleFlags);
        for (int i = 1; i < this.formats.length; ++i) {
            if (!language.equals(TrackGroup.normalizeLanguage(this.formats[i].language))) {
                TrackGroup.logErrorMessage("languages", this.formats[0].language, this.formats[i].language, i);
                return;
            }
            if (roleFlags == TrackGroup.normalizeRoleFlags(this.formats[i].roleFlags)) continue;
            TrackGroup.logErrorMessage("role flags", Integer.toBinaryString(this.formats[0].roleFlags), Integer.toBinaryString(this.formats[i].roleFlags), i);
            return;
        }
    }

    private static String normalizeLanguage(@Nullable String language) {
        return language == null || language.equals("und") ? "" : language;
    }

    private static int normalizeRoleFlags(int roleFlags) {
        return roleFlags | 0x4000;
    }

    private static void logErrorMessage(String mismatchField, @Nullable String valueIndex0, @Nullable String otherValue, int otherIndex) {
        Log.e(TAG, "", new IllegalStateException("Different " + mismatchField + " combined in one TrackGroup: '" + valueIndex0 + "' (track 0) and '" + otherValue + "' (track " + otherIndex + ")"));
    }
}

