/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.IntRange;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.media3.common.Bundleable;
import androidx.media3.common.MediaMetadata;
import androidx.media3.common.MimeTypes;
import androidx.media3.common.StreamKey;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.BundleCollectionUtil;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.InlineMe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class MediaItem
implements Bundleable {
    public static final String DEFAULT_MEDIA_ID = "";
    public static final MediaItem EMPTY = new Builder().build();
    public final String mediaId;
    @Nullable
    public final LocalConfiguration localConfiguration;
    @Deprecated
    @UnstableApi
    @Nullable
    public final LocalConfiguration playbackProperties;
    public final LiveConfiguration liveConfiguration;
    public final MediaMetadata mediaMetadata;
    public final ClippingConfiguration clippingConfiguration;
    @Deprecated
    @UnstableApi
    public final ClippingProperties clippingProperties;
    public final RequestMetadata requestMetadata;
    private static final String FIELD_MEDIA_ID = Util.intToStringMaxRadix(0);
    private static final String FIELD_LIVE_CONFIGURATION = Util.intToStringMaxRadix(1);
    private static final String FIELD_MEDIA_METADATA = Util.intToStringMaxRadix(2);
    private static final String FIELD_CLIPPING_PROPERTIES = Util.intToStringMaxRadix(3);
    private static final String FIELD_REQUEST_METADATA = Util.intToStringMaxRadix(4);
    private static final String FIELD_LOCAL_CONFIGURATION = Util.intToStringMaxRadix(5);
    @Deprecated
    @UnstableApi
    public static final Bundleable.Creator<MediaItem> CREATOR = MediaItem::fromBundle;

    public static MediaItem fromUri(String uri) {
        return new Builder().setUri(uri).build();
    }

    public static MediaItem fromUri(Uri uri) {
        return new Builder().setUri(uri).build();
    }

    private MediaItem(String mediaId, ClippingProperties clippingConfiguration, @Nullable LocalConfiguration localConfiguration, LiveConfiguration liveConfiguration, MediaMetadata mediaMetadata, RequestMetadata requestMetadata) {
        this.mediaId = mediaId;
        this.localConfiguration = localConfiguration;
        this.playbackProperties = localConfiguration;
        this.liveConfiguration = liveConfiguration;
        this.mediaMetadata = mediaMetadata;
        this.clippingConfiguration = clippingConfiguration;
        this.clippingProperties = clippingConfiguration;
        this.requestMetadata = requestMetadata;
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MediaItem)) {
            return false;
        }
        MediaItem other = (MediaItem)obj;
        return Util.areEqual(this.mediaId, other.mediaId) && this.clippingConfiguration.equals(other.clippingConfiguration) && Util.areEqual(this.localConfiguration, other.localConfiguration) && Util.areEqual(this.liveConfiguration, other.liveConfiguration) && Util.areEqual(this.mediaMetadata, other.mediaMetadata) && Util.areEqual(this.requestMetadata, other.requestMetadata);
    }

    public int hashCode() {
        int result = this.mediaId.hashCode();
        result = 31 * result + (this.localConfiguration != null ? this.localConfiguration.hashCode() : 0);
        result = 31 * result + this.liveConfiguration.hashCode();
        result = 31 * result + this.clippingConfiguration.hashCode();
        result = 31 * result + this.mediaMetadata.hashCode();
        result = 31 * result + this.requestMetadata.hashCode();
        return result;
    }

    @UnstableApi
    private Bundle toBundle(boolean includeLocalConfiguration) {
        Bundle bundle = new Bundle();
        if (!this.mediaId.equals(DEFAULT_MEDIA_ID)) {
            bundle.putString(FIELD_MEDIA_ID, this.mediaId);
        }
        if (!this.liveConfiguration.equals(LiveConfiguration.UNSET)) {
            bundle.putBundle(FIELD_LIVE_CONFIGURATION, this.liveConfiguration.toBundle());
        }
        if (!this.mediaMetadata.equals(MediaMetadata.EMPTY)) {
            bundle.putBundle(FIELD_MEDIA_METADATA, this.mediaMetadata.toBundle());
        }
        if (!this.clippingConfiguration.equals(ClippingConfiguration.UNSET)) {
            bundle.putBundle(FIELD_CLIPPING_PROPERTIES, this.clippingConfiguration.toBundle());
        }
        if (!this.requestMetadata.equals(RequestMetadata.EMPTY)) {
            bundle.putBundle(FIELD_REQUEST_METADATA, this.requestMetadata.toBundle());
        }
        if (includeLocalConfiguration && this.localConfiguration != null) {
            bundle.putBundle(FIELD_LOCAL_CONFIGURATION, this.localConfiguration.toBundle());
        }
        return bundle;
    }

    @Override
    @UnstableApi
    public Bundle toBundle() {
        return this.toBundle(false);
    }

    @UnstableApi
    public Bundle toBundleIncludeLocalConfiguration() {
        return this.toBundle(true);
    }

    @UnstableApi
    public static MediaItem fromBundle(Bundle bundle) {
        String mediaId = Assertions.checkNotNull(bundle.getString(FIELD_MEDIA_ID, DEFAULT_MEDIA_ID));
        Bundle liveConfigurationBundle = bundle.getBundle(FIELD_LIVE_CONFIGURATION);
        LiveConfiguration liveConfiguration = liveConfigurationBundle == null ? LiveConfiguration.UNSET : LiveConfiguration.fromBundle(liveConfigurationBundle);
        Bundle mediaMetadataBundle = bundle.getBundle(FIELD_MEDIA_METADATA);
        MediaMetadata mediaMetadata = mediaMetadataBundle == null ? MediaMetadata.EMPTY : MediaMetadata.fromBundle(mediaMetadataBundle);
        Bundle clippingConfigurationBundle = bundle.getBundle(FIELD_CLIPPING_PROPERTIES);
        ClippingProperties clippingConfiguration = clippingConfigurationBundle == null ? ClippingProperties.UNSET : ClippingConfiguration.fromBundle(clippingConfigurationBundle);
        Bundle requestMetadataBundle = bundle.getBundle(FIELD_REQUEST_METADATA);
        RequestMetadata requestMetadata = requestMetadataBundle == null ? RequestMetadata.EMPTY : RequestMetadata.fromBundle(requestMetadataBundle);
        Bundle localConfigurationBundle = bundle.getBundle(FIELD_LOCAL_CONFIGURATION);
        LocalConfiguration localConfiguration = localConfigurationBundle == null ? null : LocalConfiguration.fromBundle(localConfigurationBundle);
        return new MediaItem(mediaId, clippingConfiguration, localConfiguration, liveConfiguration, mediaMetadata, requestMetadata);
    }

    @Deprecated
    @UnstableApi
    public static final class ClippingProperties
    extends ClippingConfiguration {
        public static final ClippingProperties UNSET = new ClippingConfiguration.Builder().buildClippingProperties();

        private ClippingProperties(ClippingConfiguration.Builder builder) {
            super(builder);
        }
    }

    public static final class LocalConfiguration
    implements Bundleable {
        public final Uri uri;
        @Nullable
        public final String mimeType;
        @Nullable
        public final DrmConfiguration drmConfiguration;
        @Nullable
        public final AdsConfiguration adsConfiguration;
        @UnstableApi
        public final List<StreamKey> streamKeys;
        @UnstableApi
        @Nullable
        public final String customCacheKey;
        public final ImmutableList<SubtitleConfiguration> subtitleConfigurations;
        @Deprecated
        @UnstableApi
        public final List<Subtitle> subtitles;
        @Nullable
        public final Object tag;
        @UnstableApi
        public final long imageDurationMs;
        private static final String FIELD_URI = Util.intToStringMaxRadix(0);
        private static final String FIELD_MIME_TYPE = Util.intToStringMaxRadix(1);
        private static final String FIELD_DRM_CONFIGURATION = Util.intToStringMaxRadix(2);
        private static final String FIELD_ADS_CONFIGURATION = Util.intToStringMaxRadix(3);
        private static final String FIELD_STREAM_KEYS = Util.intToStringMaxRadix(4);
        private static final String FIELD_CUSTOM_CACHE_KEY = Util.intToStringMaxRadix(5);
        private static final String FIELD_SUBTITLE_CONFIGURATION = Util.intToStringMaxRadix(6);
        private static final String FIELD_IMAGE_DURATION_MS = Util.intToStringMaxRadix(7);
        @Deprecated
        @UnstableApi
        public static final Bundleable.Creator<LocalConfiguration> CREATOR = LocalConfiguration::fromBundle;

        private LocalConfiguration(Uri uri, @Nullable String mimeType, @Nullable DrmConfiguration drmConfiguration, @Nullable AdsConfiguration adsConfiguration, List<StreamKey> streamKeys, @Nullable String customCacheKey, ImmutableList<SubtitleConfiguration> subtitleConfigurations, @Nullable Object tag, long imageDurationMs) {
            this.uri = uri;
            this.mimeType = MimeTypes.normalizeMimeType(mimeType);
            this.drmConfiguration = drmConfiguration;
            this.adsConfiguration = adsConfiguration;
            this.streamKeys = streamKeys;
            this.customCacheKey = customCacheKey;
            this.subtitleConfigurations = subtitleConfigurations;
            ImmutableList.Builder subtitles = ImmutableList.builder();
            for (int i = 0; i < subtitleConfigurations.size(); ++i) {
                subtitles.add((Object)((SubtitleConfiguration)subtitleConfigurations.get(i)).buildUpon().buildSubtitle());
            }
            this.subtitles = subtitles.build();
            this.tag = tag;
            this.imageDurationMs = imageDurationMs;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LocalConfiguration)) {
                return false;
            }
            LocalConfiguration other = (LocalConfiguration)obj;
            return this.uri.equals((Object)other.uri) && Util.areEqual(this.mimeType, other.mimeType) && Util.areEqual(this.drmConfiguration, other.drmConfiguration) && Util.areEqual(this.adsConfiguration, other.adsConfiguration) && this.streamKeys.equals(other.streamKeys) && Util.areEqual(this.customCacheKey, other.customCacheKey) && this.subtitleConfigurations.equals(other.subtitleConfigurations) && Util.areEqual(this.tag, other.tag) && Util.areEqual(this.imageDurationMs, other.imageDurationMs);
        }

        public int hashCode() {
            int result = this.uri.hashCode();
            result = 31 * result + (this.mimeType == null ? 0 : this.mimeType.hashCode());
            result = 31 * result + (this.drmConfiguration == null ? 0 : this.drmConfiguration.hashCode());
            result = 31 * result + (this.adsConfiguration == null ? 0 : this.adsConfiguration.hashCode());
            result = 31 * result + this.streamKeys.hashCode();
            result = 31 * result + (this.customCacheKey == null ? 0 : this.customCacheKey.hashCode());
            result = 31 * result + this.subtitleConfigurations.hashCode();
            result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
            result = (int)(31L * (long)result + this.imageDurationMs);
            return result;
        }

        @Override
        @UnstableApi
        public Bundle toBundle() {
            Bundle bundle = new Bundle();
            bundle.putParcelable(FIELD_URI, (Parcelable)this.uri);
            if (this.mimeType != null) {
                bundle.putString(FIELD_MIME_TYPE, this.mimeType);
            }
            if (this.drmConfiguration != null) {
                bundle.putBundle(FIELD_DRM_CONFIGURATION, this.drmConfiguration.toBundle());
            }
            if (this.adsConfiguration != null) {
                bundle.putBundle(FIELD_ADS_CONFIGURATION, this.adsConfiguration.toBundle());
            }
            if (!this.streamKeys.isEmpty()) {
                bundle.putParcelableArrayList(FIELD_STREAM_KEYS, BundleCollectionUtil.toBundleArrayList(this.streamKeys, StreamKey::toBundle));
            }
            if (this.customCacheKey != null) {
                bundle.putString(FIELD_CUSTOM_CACHE_KEY, this.customCacheKey);
            }
            if (!this.subtitleConfigurations.isEmpty()) {
                bundle.putParcelableArrayList(FIELD_SUBTITLE_CONFIGURATION, BundleCollectionUtil.toBundleArrayList(this.subtitleConfigurations, SubtitleConfiguration::toBundle));
            }
            if (this.imageDurationMs != -9223372036854775807L) {
                bundle.putLong(FIELD_IMAGE_DURATION_MS, this.imageDurationMs);
            }
            return bundle;
        }

        @UnstableApi
        public static LocalConfiguration fromBundle(Bundle bundle) {
            Bundle drmBundle = bundle.getBundle(FIELD_DRM_CONFIGURATION);
            DrmConfiguration drmConfiguration = drmBundle == null ? null : DrmConfiguration.fromBundle(drmBundle);
            Bundle adsBundle = bundle.getBundle(FIELD_ADS_CONFIGURATION);
            AdsConfiguration adsConfiguration = adsBundle == null ? null : AdsConfiguration.fromBundle(adsBundle);
            ArrayList streamKeysBundles = bundle.getParcelableArrayList(FIELD_STREAM_KEYS);
            ImmutableList streamKeys = streamKeysBundles == null ? ImmutableList.of() : BundleCollectionUtil.fromBundleList(StreamKey::fromBundle, streamKeysBundles);
            ArrayList subtitleBundles = bundle.getParcelableArrayList(FIELD_SUBTITLE_CONFIGURATION);
            ImmutableList subtitleConfiguration = subtitleBundles == null ? ImmutableList.of() : BundleCollectionUtil.fromBundleList(SubtitleConfiguration::fromBundle, subtitleBundles);
            long imageDurationMs = bundle.getLong(FIELD_IMAGE_DURATION_MS, -9223372036854775807L);
            return new LocalConfiguration(Assertions.checkNotNull((Uri)bundle.getParcelable(FIELD_URI)), bundle.getString(FIELD_MIME_TYPE), drmConfiguration, adsConfiguration, (List<StreamKey>)streamKeys, bundle.getString(FIELD_CUSTOM_CACHE_KEY), (ImmutableList<SubtitleConfiguration>)subtitleConfiguration, null, imageDurationMs);
        }
    }

    public static final class LiveConfiguration
    implements Bundleable {
        public static final LiveConfiguration UNSET = new Builder().build();
        public final long targetOffsetMs;
        public final long minOffsetMs;
        public final long maxOffsetMs;
        public final float minPlaybackSpeed;
        public final float maxPlaybackSpeed;
        private static final String FIELD_TARGET_OFFSET_MS = Util.intToStringMaxRadix(0);
        private static final String FIELD_MIN_OFFSET_MS = Util.intToStringMaxRadix(1);
        private static final String FIELD_MAX_OFFSET_MS = Util.intToStringMaxRadix(2);
        private static final String FIELD_MIN_PLAYBACK_SPEED = Util.intToStringMaxRadix(3);
        private static final String FIELD_MAX_PLAYBACK_SPEED = Util.intToStringMaxRadix(4);
        @Deprecated
        @UnstableApi
        public static final Bundleable.Creator<LiveConfiguration> CREATOR = LiveConfiguration::fromBundle;

        private LiveConfiguration(Builder builder) {
            this(builder.targetOffsetMs, builder.minOffsetMs, builder.maxOffsetMs, builder.minPlaybackSpeed, builder.maxPlaybackSpeed);
        }

        @Deprecated
        @UnstableApi
        public LiveConfiguration(long targetOffsetMs, long minOffsetMs, long maxOffsetMs, float minPlaybackSpeed, float maxPlaybackSpeed) {
            this.targetOffsetMs = targetOffsetMs;
            this.minOffsetMs = minOffsetMs;
            this.maxOffsetMs = maxOffsetMs;
            this.minPlaybackSpeed = minPlaybackSpeed;
            this.maxPlaybackSpeed = maxPlaybackSpeed;
        }

        public Builder buildUpon() {
            return new Builder(this);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LiveConfiguration)) {
                return false;
            }
            LiveConfiguration other = (LiveConfiguration)obj;
            return this.targetOffsetMs == other.targetOffsetMs && this.minOffsetMs == other.minOffsetMs && this.maxOffsetMs == other.maxOffsetMs && this.minPlaybackSpeed == other.minPlaybackSpeed && this.maxPlaybackSpeed == other.maxPlaybackSpeed;
        }

        public int hashCode() {
            int result = (int)(this.targetOffsetMs ^ this.targetOffsetMs >>> 32);
            result = 31 * result + (int)(this.minOffsetMs ^ this.minOffsetMs >>> 32);
            result = 31 * result + (int)(this.maxOffsetMs ^ this.maxOffsetMs >>> 32);
            result = 31 * result + (this.minPlaybackSpeed != 0.0f ? Float.floatToIntBits(this.minPlaybackSpeed) : 0);
            result = 31 * result + (this.maxPlaybackSpeed != 0.0f ? Float.floatToIntBits(this.maxPlaybackSpeed) : 0);
            return result;
        }

        @Override
        @UnstableApi
        public Bundle toBundle() {
            Bundle bundle = new Bundle();
            if (this.targetOffsetMs != LiveConfiguration.UNSET.targetOffsetMs) {
                bundle.putLong(FIELD_TARGET_OFFSET_MS, this.targetOffsetMs);
            }
            if (this.minOffsetMs != LiveConfiguration.UNSET.minOffsetMs) {
                bundle.putLong(FIELD_MIN_OFFSET_MS, this.minOffsetMs);
            }
            if (this.maxOffsetMs != LiveConfiguration.UNSET.maxOffsetMs) {
                bundle.putLong(FIELD_MAX_OFFSET_MS, this.maxOffsetMs);
            }
            if (this.minPlaybackSpeed != LiveConfiguration.UNSET.minPlaybackSpeed) {
                bundle.putFloat(FIELD_MIN_PLAYBACK_SPEED, this.minPlaybackSpeed);
            }
            if (this.maxPlaybackSpeed != LiveConfiguration.UNSET.maxPlaybackSpeed) {
                bundle.putFloat(FIELD_MAX_PLAYBACK_SPEED, this.maxPlaybackSpeed);
            }
            return bundle;
        }

        @UnstableApi
        public static LiveConfiguration fromBundle(Bundle bundle) {
            return new Builder().setTargetOffsetMs(bundle.getLong(FIELD_TARGET_OFFSET_MS, LiveConfiguration.UNSET.targetOffsetMs)).setMinOffsetMs(bundle.getLong(FIELD_MIN_OFFSET_MS, LiveConfiguration.UNSET.minOffsetMs)).setMaxOffsetMs(bundle.getLong(FIELD_MAX_OFFSET_MS, LiveConfiguration.UNSET.maxOffsetMs)).setMinPlaybackSpeed(bundle.getFloat(FIELD_MIN_PLAYBACK_SPEED, LiveConfiguration.UNSET.minPlaybackSpeed)).setMaxPlaybackSpeed(bundle.getFloat(FIELD_MAX_PLAYBACK_SPEED, LiveConfiguration.UNSET.maxPlaybackSpeed)).build();
        }

        public static final class Builder {
            private long targetOffsetMs;
            private long minOffsetMs;
            private long maxOffsetMs;
            private float minPlaybackSpeed;
            private float maxPlaybackSpeed;

            public Builder() {
                this.targetOffsetMs = -9223372036854775807L;
                this.minOffsetMs = -9223372036854775807L;
                this.maxOffsetMs = -9223372036854775807L;
                this.minPlaybackSpeed = -3.4028235E38f;
                this.maxPlaybackSpeed = -3.4028235E38f;
            }

            private Builder(LiveConfiguration liveConfiguration) {
                this.targetOffsetMs = liveConfiguration.targetOffsetMs;
                this.minOffsetMs = liveConfiguration.minOffsetMs;
                this.maxOffsetMs = liveConfiguration.maxOffsetMs;
                this.minPlaybackSpeed = liveConfiguration.minPlaybackSpeed;
                this.maxPlaybackSpeed = liveConfiguration.maxPlaybackSpeed;
            }

            @CanIgnoreReturnValue
            public Builder setTargetOffsetMs(long targetOffsetMs) {
                this.targetOffsetMs = targetOffsetMs;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setMinOffsetMs(long minOffsetMs) {
                this.minOffsetMs = minOffsetMs;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setMaxOffsetMs(long maxOffsetMs) {
                this.maxOffsetMs = maxOffsetMs;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setMinPlaybackSpeed(float minPlaybackSpeed) {
                this.minPlaybackSpeed = minPlaybackSpeed;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setMaxPlaybackSpeed(float maxPlaybackSpeed) {
                this.maxPlaybackSpeed = maxPlaybackSpeed;
                return this;
            }

            public LiveConfiguration build() {
                return new LiveConfiguration(this);
            }
        }
    }

    public static final class RequestMetadata
    implements Bundleable {
        public static final RequestMetadata EMPTY = new Builder().build();
        @Nullable
        public final Uri mediaUri;
        @Nullable
        public final String searchQuery;
        @Nullable
        public final Bundle extras;
        private static final String FIELD_MEDIA_URI = Util.intToStringMaxRadix(0);
        private static final String FIELD_SEARCH_QUERY = Util.intToStringMaxRadix(1);
        private static final String FIELD_EXTRAS = Util.intToStringMaxRadix(2);
        @Deprecated
        @UnstableApi
        public static final Bundleable.Creator<RequestMetadata> CREATOR = RequestMetadata::fromBundle;

        private RequestMetadata(Builder builder) {
            this.mediaUri = builder.mediaUri;
            this.searchQuery = builder.searchQuery;
            this.extras = builder.extras;
        }

        public Builder buildUpon() {
            return new Builder(this);
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RequestMetadata)) {
                return false;
            }
            RequestMetadata that = (RequestMetadata)o;
            return Util.areEqual(this.mediaUri, that.mediaUri) && Util.areEqual(this.searchQuery, that.searchQuery) && this.extras == null == (that.extras == null);
        }

        public int hashCode() {
            int result = this.mediaUri == null ? 0 : this.mediaUri.hashCode();
            result = 31 * result + (this.searchQuery == null ? 0 : this.searchQuery.hashCode());
            result = 31 * result + (this.extras == null ? 0 : 1);
            return result;
        }

        @Override
        @UnstableApi
        public Bundle toBundle() {
            Bundle bundle = new Bundle();
            if (this.mediaUri != null) {
                bundle.putParcelable(FIELD_MEDIA_URI, (Parcelable)this.mediaUri);
            }
            if (this.searchQuery != null) {
                bundle.putString(FIELD_SEARCH_QUERY, this.searchQuery);
            }
            if (this.extras != null) {
                bundle.putBundle(FIELD_EXTRAS, this.extras);
            }
            return bundle;
        }

        @UnstableApi
        public static RequestMetadata fromBundle(Bundle bundle) {
            return new Builder().setMediaUri((Uri)bundle.getParcelable(FIELD_MEDIA_URI)).setSearchQuery(bundle.getString(FIELD_SEARCH_QUERY)).setExtras(bundle.getBundle(FIELD_EXTRAS)).build();
        }

        public static final class Builder {
            @Nullable
            private Uri mediaUri;
            @Nullable
            private String searchQuery;
            @Nullable
            private Bundle extras;

            public Builder() {
            }

            private Builder(RequestMetadata requestMetadata) {
                this.mediaUri = requestMetadata.mediaUri;
                this.searchQuery = requestMetadata.searchQuery;
                this.extras = requestMetadata.extras;
            }

            @CanIgnoreReturnValue
            public Builder setMediaUri(@Nullable Uri mediaUri) {
                this.mediaUri = mediaUri;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setSearchQuery(@Nullable String searchQuery) {
                this.searchQuery = searchQuery;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setExtras(@Nullable Bundle extras) {
                this.extras = extras;
                return this;
            }

            public RequestMetadata build() {
                return new RequestMetadata(this);
            }
        }
    }

    public static final class Builder {
        @Nullable
        private String mediaId;
        @Nullable
        private Uri uri;
        @Nullable
        private String mimeType;
        private ClippingConfiguration.Builder clippingConfiguration = new ClippingConfiguration.Builder();
        private DrmConfiguration.Builder drmConfiguration = new DrmConfiguration.Builder();
        private List<StreamKey> streamKeys = Collections.emptyList();
        @Nullable
        private String customCacheKey;
        private ImmutableList<SubtitleConfiguration> subtitleConfigurations = ImmutableList.of();
        @Nullable
        private AdsConfiguration adsConfiguration;
        @Nullable
        private Object tag;
        private long imageDurationMs = -9223372036854775807L;
        @Nullable
        private MediaMetadata mediaMetadata;
        private LiveConfiguration.Builder liveConfiguration = new LiveConfiguration.Builder();
        private RequestMetadata requestMetadata = RequestMetadata.EMPTY;

        public Builder() {
        }

        private Builder(MediaItem mediaItem) {
            this();
            this.clippingConfiguration = mediaItem.clippingConfiguration.buildUpon();
            this.mediaId = mediaItem.mediaId;
            this.mediaMetadata = mediaItem.mediaMetadata;
            this.liveConfiguration = mediaItem.liveConfiguration.buildUpon();
            this.requestMetadata = mediaItem.requestMetadata;
            LocalConfiguration localConfiguration = mediaItem.localConfiguration;
            if (localConfiguration != null) {
                this.customCacheKey = localConfiguration.customCacheKey;
                this.mimeType = localConfiguration.mimeType;
                this.uri = localConfiguration.uri;
                this.streamKeys = localConfiguration.streamKeys;
                this.subtitleConfigurations = localConfiguration.subtitleConfigurations;
                this.tag = localConfiguration.tag;
                this.drmConfiguration = localConfiguration.drmConfiguration != null ? localConfiguration.drmConfiguration.buildUpon() : new DrmConfiguration.Builder();
                this.adsConfiguration = localConfiguration.adsConfiguration;
                this.imageDurationMs = localConfiguration.imageDurationMs;
            }
        }

        @CanIgnoreReturnValue
        public Builder setMediaId(String mediaId) {
            this.mediaId = Assertions.checkNotNull(mediaId);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setUri(@Nullable String uri) {
            return this.setUri(uri == null ? null : Uri.parse((String)uri));
        }

        @CanIgnoreReturnValue
        public Builder setUri(@Nullable Uri uri) {
            this.uri = uri;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMimeType(@Nullable String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setClippingConfiguration(ClippingConfiguration clippingConfiguration) {
            this.clippingConfiguration = clippingConfiguration.buildUpon();
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setClipStartPositionMs(@IntRange(from=0L) long startPositionMs) {
            this.clippingConfiguration.setStartPositionMs(startPositionMs);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setClipEndPositionMs(long endPositionMs) {
            this.clippingConfiguration.setEndPositionMs(endPositionMs);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setClipRelativeToLiveWindow(boolean relativeToLiveWindow) {
            this.clippingConfiguration.setRelativeToLiveWindow(relativeToLiveWindow);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setClipRelativeToDefaultPosition(boolean relativeToDefaultPosition) {
            this.clippingConfiguration.setRelativeToDefaultPosition(relativeToDefaultPosition);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setClipStartsAtKeyFrame(boolean startsAtKeyFrame) {
            this.clippingConfiguration.setStartsAtKeyFrame(startsAtKeyFrame);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setDrmConfiguration(@Nullable DrmConfiguration drmConfiguration) {
            this.drmConfiguration = drmConfiguration != null ? drmConfiguration.buildUpon() : new DrmConfiguration.Builder();
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setDrmLicenseUri(@Nullable Uri licenseUri) {
            this.drmConfiguration.setLicenseUri(licenseUri);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setDrmLicenseUri(@Nullable String licenseUri) {
            this.drmConfiguration.setLicenseUri(licenseUri);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setDrmLicenseRequestHeaders(@Nullable Map<String, String> licenseRequestHeaders) {
            this.drmConfiguration.setLicenseRequestHeaders((Map<String, String>)(licenseRequestHeaders != null ? licenseRequestHeaders : ImmutableMap.of()));
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setDrmUuid(@Nullable UUID uuid) {
            this.drmConfiguration.setNullableScheme(uuid);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setDrmMultiSession(boolean multiSession) {
            this.drmConfiguration.setMultiSession(multiSession);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setDrmForceDefaultLicenseUri(boolean forceDefaultLicenseUri) {
            this.drmConfiguration.setForceDefaultLicenseUri(forceDefaultLicenseUri);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setDrmPlayClearContentWithoutKey(boolean playClearContentWithoutKey) {
            this.drmConfiguration.setPlayClearContentWithoutKey(playClearContentWithoutKey);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setDrmSessionForClearPeriods(boolean sessionForClearPeriods) {
            this.drmConfiguration.setForceSessionsForAudioAndVideoTracks(sessionForClearPeriods);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setDrmSessionForClearTypes(@Nullable List<Integer> sessionForClearTypes) {
            this.drmConfiguration.setForcedSessionTrackTypes((List<Integer>)(sessionForClearTypes != null ? sessionForClearTypes : ImmutableList.of()));
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setDrmKeySetId(@Nullable byte[] keySetId) {
            this.drmConfiguration.setKeySetId(keySetId);
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setStreamKeys(@Nullable List<StreamKey> streamKeys) {
            this.streamKeys = streamKeys != null && !streamKeys.isEmpty() ? Collections.unmodifiableList(new ArrayList<StreamKey>(streamKeys)) : Collections.emptyList();
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setCustomCacheKey(@Nullable String customCacheKey) {
            this.customCacheKey = customCacheKey;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setSubtitles(@Nullable List<Subtitle> subtitles) {
            this.subtitleConfigurations = subtitles != null ? ImmutableList.copyOf(subtitles) : ImmutableList.of();
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setSubtitleConfigurations(List<SubtitleConfiguration> subtitleConfigurations) {
            this.subtitleConfigurations = ImmutableList.copyOf(subtitleConfigurations);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setAdsConfiguration(@Nullable AdsConfiguration adsConfiguration) {
            this.adsConfiguration = adsConfiguration;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setAdTagUri(@Nullable String adTagUri) {
            return this.setAdTagUri(adTagUri != null ? Uri.parse((String)adTagUri) : null);
        }

        @Deprecated
        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setAdTagUri(@Nullable Uri adTagUri) {
            return this.setAdTagUri(adTagUri, null);
        }

        @Deprecated
        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setAdTagUri(@Nullable Uri adTagUri, @Nullable Object adsId) {
            this.adsConfiguration = adTagUri != null ? new AdsConfiguration.Builder(adTagUri).setAdsId(adsId).build() : null;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setLiveConfiguration(LiveConfiguration liveConfiguration) {
            this.liveConfiguration = liveConfiguration.buildUpon();
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setLiveTargetOffsetMs(long liveTargetOffsetMs) {
            this.liveConfiguration.setTargetOffsetMs(liveTargetOffsetMs);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setLiveMinOffsetMs(long liveMinOffsetMs) {
            this.liveConfiguration.setMinOffsetMs(liveMinOffsetMs);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setLiveMaxOffsetMs(long liveMaxOffsetMs) {
            this.liveConfiguration.setMaxOffsetMs(liveMaxOffsetMs);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setLiveMinPlaybackSpeed(float minPlaybackSpeed) {
            this.liveConfiguration.setMinPlaybackSpeed(minPlaybackSpeed);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setLiveMaxPlaybackSpeed(float maxPlaybackSpeed) {
            this.liveConfiguration.setMaxPlaybackSpeed(maxPlaybackSpeed);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setTag(@Nullable Object tag) {
            this.tag = tag;
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setImageDurationMs(long imageDurationMs) {
            Assertions.checkArgument(imageDurationMs > 0L || imageDurationMs == -9223372036854775807L);
            this.imageDurationMs = imageDurationMs;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMediaMetadata(MediaMetadata mediaMetadata) {
            this.mediaMetadata = mediaMetadata;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setRequestMetadata(RequestMetadata requestMetadata) {
            this.requestMetadata = requestMetadata;
            return this;
        }

        public MediaItem build() {
            Assertions.checkState(this.drmConfiguration.licenseUri == null || this.drmConfiguration.scheme != null);
            LocalConfiguration localConfiguration = null;
            Uri uri = this.uri;
            if (uri != null) {
                localConfiguration = new LocalConfiguration(uri, this.mimeType, this.drmConfiguration.scheme != null ? this.drmConfiguration.build() : null, this.adsConfiguration, this.streamKeys, this.customCacheKey, this.subtitleConfigurations, this.tag, this.imageDurationMs);
            }
            return new MediaItem(this.mediaId != null ? this.mediaId : MediaItem.DEFAULT_MEDIA_ID, this.clippingConfiguration.buildClippingProperties(), localConfiguration, this.liveConfiguration.build(), this.mediaMetadata != null ? this.mediaMetadata : MediaMetadata.EMPTY, this.requestMetadata);
        }
    }

    public static class ClippingConfiguration
    implements Bundleable {
        public static final ClippingConfiguration UNSET = new Builder().build();
        @IntRange(from=0L)
        public final long startPositionMs;
        @UnstableApi
        @IntRange(from=0L)
        public final long startPositionUs;
        public final long endPositionMs;
        @UnstableApi
        public final long endPositionUs;
        public final boolean relativeToLiveWindow;
        public final boolean relativeToDefaultPosition;
        public final boolean startsAtKeyFrame;
        private static final String FIELD_START_POSITION_MS = Util.intToStringMaxRadix(0);
        private static final String FIELD_END_POSITION_MS = Util.intToStringMaxRadix(1);
        private static final String FIELD_RELATIVE_TO_LIVE_WINDOW = Util.intToStringMaxRadix(2);
        private static final String FIELD_RELATIVE_TO_DEFAULT_POSITION = Util.intToStringMaxRadix(3);
        private static final String FIELD_STARTS_AT_KEY_FRAME = Util.intToStringMaxRadix(4);
        static final String FIELD_START_POSITION_US = Util.intToStringMaxRadix(5);
        static final String FIELD_END_POSITION_US = Util.intToStringMaxRadix(6);
        @Deprecated
        @UnstableApi
        public static final Bundleable.Creator<ClippingProperties> CREATOR = ClippingConfiguration::fromBundle;

        private ClippingConfiguration(Builder builder) {
            this.startPositionMs = Util.usToMs(builder.startPositionUs);
            this.endPositionMs = Util.usToMs(builder.endPositionUs);
            this.startPositionUs = builder.startPositionUs;
            this.endPositionUs = builder.endPositionUs;
            this.relativeToLiveWindow = builder.relativeToLiveWindow;
            this.relativeToDefaultPosition = builder.relativeToDefaultPosition;
            this.startsAtKeyFrame = builder.startsAtKeyFrame;
        }

        public Builder buildUpon() {
            return new Builder(this);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ClippingConfiguration)) {
                return false;
            }
            ClippingConfiguration other = (ClippingConfiguration)obj;
            return this.startPositionUs == other.startPositionUs && this.endPositionUs == other.endPositionUs && this.relativeToLiveWindow == other.relativeToLiveWindow && this.relativeToDefaultPosition == other.relativeToDefaultPosition && this.startsAtKeyFrame == other.startsAtKeyFrame;
        }

        public int hashCode() {
            int result = (int)(this.startPositionUs ^ this.startPositionUs >>> 32);
            result = 31 * result + (int)(this.endPositionUs ^ this.endPositionUs >>> 32);
            result = 31 * result + (this.relativeToLiveWindow ? 1 : 0);
            result = 31 * result + (this.relativeToDefaultPosition ? 1 : 0);
            result = 31 * result + (this.startsAtKeyFrame ? 1 : 0);
            return result;
        }

        @Override
        @UnstableApi
        public Bundle toBundle() {
            Bundle bundle = new Bundle();
            if (this.startPositionMs != ClippingConfiguration.UNSET.startPositionMs) {
                bundle.putLong(FIELD_START_POSITION_MS, this.startPositionMs);
            }
            if (this.endPositionMs != ClippingConfiguration.UNSET.endPositionMs) {
                bundle.putLong(FIELD_END_POSITION_MS, this.endPositionMs);
            }
            if (this.startPositionUs != ClippingConfiguration.UNSET.startPositionUs) {
                bundle.putLong(FIELD_START_POSITION_US, this.startPositionUs);
            }
            if (this.endPositionUs != ClippingConfiguration.UNSET.endPositionUs) {
                bundle.putLong(FIELD_END_POSITION_US, this.endPositionUs);
            }
            if (this.relativeToLiveWindow != ClippingConfiguration.UNSET.relativeToLiveWindow) {
                bundle.putBoolean(FIELD_RELATIVE_TO_LIVE_WINDOW, this.relativeToLiveWindow);
            }
            if (this.relativeToDefaultPosition != ClippingConfiguration.UNSET.relativeToDefaultPosition) {
                bundle.putBoolean(FIELD_RELATIVE_TO_DEFAULT_POSITION, this.relativeToDefaultPosition);
            }
            if (this.startsAtKeyFrame != ClippingConfiguration.UNSET.startsAtKeyFrame) {
                bundle.putBoolean(FIELD_STARTS_AT_KEY_FRAME, this.startsAtKeyFrame);
            }
            return bundle;
        }

        @UnstableApi
        public static ClippingProperties fromBundle(Bundle bundle) {
            long endPositionUs;
            Builder clippingConfiguration = new Builder().setStartPositionMs(bundle.getLong(FIELD_START_POSITION_MS, ClippingConfiguration.UNSET.startPositionMs)).setEndPositionMs(bundle.getLong(FIELD_END_POSITION_MS, ClippingConfiguration.UNSET.endPositionMs)).setRelativeToLiveWindow(bundle.getBoolean(FIELD_RELATIVE_TO_LIVE_WINDOW, ClippingConfiguration.UNSET.relativeToLiveWindow)).setRelativeToDefaultPosition(bundle.getBoolean(FIELD_RELATIVE_TO_DEFAULT_POSITION, ClippingConfiguration.UNSET.relativeToDefaultPosition)).setStartsAtKeyFrame(bundle.getBoolean(FIELD_STARTS_AT_KEY_FRAME, ClippingConfiguration.UNSET.startsAtKeyFrame));
            long startPositionUs = bundle.getLong(FIELD_START_POSITION_US, ClippingConfiguration.UNSET.startPositionUs);
            if (startPositionUs != ClippingConfiguration.UNSET.startPositionUs) {
                clippingConfiguration.setStartPositionUs(startPositionUs);
            }
            if ((endPositionUs = bundle.getLong(FIELD_END_POSITION_US, ClippingConfiguration.UNSET.endPositionUs)) != ClippingConfiguration.UNSET.endPositionUs) {
                clippingConfiguration.setEndPositionUs(endPositionUs);
            }
            return clippingConfiguration.buildClippingProperties();
        }

        public static final class Builder {
            private long startPositionUs;
            private long endPositionUs;
            private boolean relativeToLiveWindow;
            private boolean relativeToDefaultPosition;
            private boolean startsAtKeyFrame;

            public Builder() {
                this.endPositionUs = Long.MIN_VALUE;
            }

            private Builder(ClippingConfiguration clippingConfiguration) {
                this.startPositionUs = clippingConfiguration.startPositionUs;
                this.endPositionUs = clippingConfiguration.endPositionUs;
                this.relativeToLiveWindow = clippingConfiguration.relativeToLiveWindow;
                this.relativeToDefaultPosition = clippingConfiguration.relativeToDefaultPosition;
                this.startsAtKeyFrame = clippingConfiguration.startsAtKeyFrame;
            }

            @CanIgnoreReturnValue
            public Builder setStartPositionMs(@IntRange(from=0L) long startPositionMs) {
                return this.setStartPositionUs(Util.msToUs(startPositionMs));
            }

            @UnstableApi
            @CanIgnoreReturnValue
            public Builder setStartPositionUs(@IntRange(from=0L) long startPositionUs) {
                Assertions.checkArgument(startPositionUs >= 0L);
                this.startPositionUs = startPositionUs;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setEndPositionMs(long endPositionMs) {
                return this.setEndPositionUs(Util.msToUs(endPositionMs));
            }

            @UnstableApi
            @CanIgnoreReturnValue
            public Builder setEndPositionUs(long endPositionUs) {
                Assertions.checkArgument(endPositionUs == Long.MIN_VALUE || endPositionUs >= 0L);
                this.endPositionUs = endPositionUs;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setRelativeToLiveWindow(boolean relativeToLiveWindow) {
                this.relativeToLiveWindow = relativeToLiveWindow;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setRelativeToDefaultPosition(boolean relativeToDefaultPosition) {
                this.relativeToDefaultPosition = relativeToDefaultPosition;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setStartsAtKeyFrame(boolean startsAtKeyFrame) {
                this.startsAtKeyFrame = startsAtKeyFrame;
                return this;
            }

            public ClippingConfiguration build() {
                return new ClippingConfiguration(this);
            }

            @Deprecated
            @UnstableApi
            public ClippingProperties buildClippingProperties() {
                return new ClippingProperties(this);
            }
        }
    }

    @Deprecated
    @UnstableApi
    public static final class Subtitle
    extends SubtitleConfiguration {
        @Deprecated
        @UnstableApi
        public Subtitle(Uri uri, String mimeType, @Nullable String language) {
            this(uri, mimeType, language, 0);
        }

        @Deprecated
        @UnstableApi
        public Subtitle(Uri uri, String mimeType, @Nullable String language, int selectionFlags) {
            this(uri, mimeType, language, selectionFlags, 0, null);
        }

        @Deprecated
        @UnstableApi
        public Subtitle(Uri uri, String mimeType, @Nullable String language, int selectionFlags, int roleFlags, @Nullable String label) {
            super(uri, mimeType, language, selectionFlags, roleFlags, label, null);
        }

        private Subtitle(SubtitleConfiguration.Builder builder) {
            super(builder);
        }
    }

    public static class SubtitleConfiguration
    implements Bundleable {
        public final Uri uri;
        @Nullable
        public final String mimeType;
        @Nullable
        public final String language;
        public final int selectionFlags;
        public final int roleFlags;
        @Nullable
        public final String label;
        @Nullable
        public final String id;
        private static final String FIELD_URI = Util.intToStringMaxRadix(0);
        private static final String FIELD_MIME_TYPE = Util.intToStringMaxRadix(1);
        private static final String FIELD_LANGUAGE = Util.intToStringMaxRadix(2);
        private static final String FIELD_SELECTION_FLAGS = Util.intToStringMaxRadix(3);
        private static final String FIELD_ROLE_FLAGS = Util.intToStringMaxRadix(4);
        private static final String FIELD_LABEL = Util.intToStringMaxRadix(5);
        private static final String FIELD_ID = Util.intToStringMaxRadix(6);
        @Deprecated
        @UnstableApi
        public static final Bundleable.Creator<SubtitleConfiguration> CREATOR = SubtitleConfiguration::fromBundle;

        private SubtitleConfiguration(Uri uri, String mimeType, @Nullable String language, int selectionFlags, int roleFlags, @Nullable String label, @Nullable String id) {
            this.uri = uri;
            this.mimeType = MimeTypes.normalizeMimeType(mimeType);
            this.language = language;
            this.selectionFlags = selectionFlags;
            this.roleFlags = roleFlags;
            this.label = label;
            this.id = id;
        }

        private SubtitleConfiguration(Builder builder) {
            this.uri = builder.uri;
            this.mimeType = builder.mimeType;
            this.language = builder.language;
            this.selectionFlags = builder.selectionFlags;
            this.roleFlags = builder.roleFlags;
            this.label = builder.label;
            this.id = builder.id;
        }

        public Builder buildUpon() {
            return new Builder(this);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SubtitleConfiguration)) {
                return false;
            }
            SubtitleConfiguration other = (SubtitleConfiguration)obj;
            return this.uri.equals((Object)other.uri) && Util.areEqual(this.mimeType, other.mimeType) && Util.areEqual(this.language, other.language) && this.selectionFlags == other.selectionFlags && this.roleFlags == other.roleFlags && Util.areEqual(this.label, other.label) && Util.areEqual(this.id, other.id);
        }

        public int hashCode() {
            int result = this.uri.hashCode();
            result = 31 * result + (this.mimeType == null ? 0 : this.mimeType.hashCode());
            result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
            result = 31 * result + this.selectionFlags;
            result = 31 * result + this.roleFlags;
            result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        @UnstableApi
        public static SubtitleConfiguration fromBundle(Bundle bundle) {
            Uri uri = Assertions.checkNotNull((Uri)bundle.getParcelable(FIELD_URI));
            String mimeType = bundle.getString(FIELD_MIME_TYPE);
            String language = bundle.getString(FIELD_LANGUAGE);
            int selectionFlags = bundle.getInt(FIELD_SELECTION_FLAGS, 0);
            int roleFlags = bundle.getInt(FIELD_ROLE_FLAGS, 0);
            String label = bundle.getString(FIELD_LABEL);
            String id = bundle.getString(FIELD_ID);
            Builder builder = new Builder(uri);
            return builder.setMimeType(mimeType).setLanguage(language).setSelectionFlags(selectionFlags).setRoleFlags(roleFlags).setLabel(label).setId(id).build();
        }

        @Override
        @UnstableApi
        public Bundle toBundle() {
            Bundle bundle = new Bundle();
            bundle.putParcelable(FIELD_URI, (Parcelable)this.uri);
            if (this.mimeType != null) {
                bundle.putString(FIELD_MIME_TYPE, this.mimeType);
            }
            if (this.language != null) {
                bundle.putString(FIELD_LANGUAGE, this.language);
            }
            if (this.selectionFlags != 0) {
                bundle.putInt(FIELD_SELECTION_FLAGS, this.selectionFlags);
            }
            if (this.roleFlags != 0) {
                bundle.putInt(FIELD_ROLE_FLAGS, this.roleFlags);
            }
            if (this.label != null) {
                bundle.putString(FIELD_LABEL, this.label);
            }
            if (this.id != null) {
                bundle.putString(FIELD_ID, this.id);
            }
            return bundle;
        }

        public static final class Builder {
            private Uri uri;
            @Nullable
            private String mimeType;
            @Nullable
            private String language;
            private int selectionFlags;
            private int roleFlags;
            @Nullable
            private String label;
            @Nullable
            private String id;

            public Builder(Uri uri) {
                this.uri = uri;
            }

            private Builder(SubtitleConfiguration subtitleConfiguration) {
                this.uri = subtitleConfiguration.uri;
                this.mimeType = subtitleConfiguration.mimeType;
                this.language = subtitleConfiguration.language;
                this.selectionFlags = subtitleConfiguration.selectionFlags;
                this.roleFlags = subtitleConfiguration.roleFlags;
                this.label = subtitleConfiguration.label;
                this.id = subtitleConfiguration.id;
            }

            @CanIgnoreReturnValue
            public Builder setUri(Uri uri) {
                this.uri = uri;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setMimeType(@Nullable String mimeType) {
                this.mimeType = MimeTypes.normalizeMimeType(mimeType);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setLanguage(@Nullable String language) {
                this.language = language;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setSelectionFlags(int selectionFlags) {
                this.selectionFlags = selectionFlags;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setRoleFlags(int roleFlags) {
                this.roleFlags = roleFlags;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setLabel(@Nullable String label) {
                this.label = label;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setId(@Nullable String id) {
                this.id = id;
                return this;
            }

            public SubtitleConfiguration build() {
                return new SubtitleConfiguration(this);
            }

            private Subtitle buildSubtitle() {
                return new Subtitle(this);
            }
        }
    }

    public static final class AdsConfiguration
    implements Bundleable {
        public final Uri adTagUri;
        @Nullable
        public final Object adsId;
        private static final String FIELD_AD_TAG_URI = Util.intToStringMaxRadix(0);
        @Deprecated
        @UnstableApi
        public static final Bundleable.Creator<AdsConfiguration> CREATOR = AdsConfiguration::fromBundle;

        private AdsConfiguration(Builder builder) {
            this.adTagUri = builder.adTagUri;
            this.adsId = builder.adsId;
        }

        public Builder buildUpon() {
            return new Builder(this.adTagUri).setAdsId(this.adsId);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof AdsConfiguration)) {
                return false;
            }
            AdsConfiguration other = (AdsConfiguration)obj;
            return this.adTagUri.equals((Object)other.adTagUri) && Util.areEqual(this.adsId, other.adsId);
        }

        public int hashCode() {
            int result = this.adTagUri.hashCode();
            result = 31 * result + (this.adsId != null ? this.adsId.hashCode() : 0);
            return result;
        }

        @UnstableApi
        public static AdsConfiguration fromBundle(Bundle bundle) {
            Uri adTagUri = (Uri)bundle.getParcelable(FIELD_AD_TAG_URI);
            Assertions.checkNotNull(adTagUri);
            return new Builder(adTagUri).build();
        }

        @Override
        @UnstableApi
        public Bundle toBundle() {
            Bundle bundle = new Bundle();
            bundle.putParcelable(FIELD_AD_TAG_URI, (Parcelable)this.adTagUri);
            return bundle;
        }

        public static final class Builder {
            private Uri adTagUri;
            @Nullable
            private Object adsId;

            public Builder(Uri adTagUri) {
                this.adTagUri = adTagUri;
            }

            @CanIgnoreReturnValue
            public Builder setAdTagUri(Uri adTagUri) {
                this.adTagUri = adTagUri;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setAdsId(@Nullable Object adsId) {
                this.adsId = adsId;
                return this;
            }

            public AdsConfiguration build() {
                return new AdsConfiguration(this);
            }
        }
    }

    public static final class DrmConfiguration
    implements Bundleable {
        public final UUID scheme;
        @Deprecated
        @UnstableApi
        public final UUID uuid;
        @Nullable
        public final Uri licenseUri;
        @Deprecated
        @UnstableApi
        public final ImmutableMap<String, String> requestHeaders;
        public final ImmutableMap<String, String> licenseRequestHeaders;
        public final boolean multiSession;
        public final boolean playClearContentWithoutKey;
        public final boolean forceDefaultLicenseUri;
        @Deprecated
        @UnstableApi
        public final ImmutableList<Integer> sessionForClearTypes;
        public final ImmutableList<Integer> forcedSessionTrackTypes;
        @Nullable
        private final byte[] keySetId;
        private static final String FIELD_SCHEME = Util.intToStringMaxRadix(0);
        private static final String FIELD_LICENSE_URI = Util.intToStringMaxRadix(1);
        private static final String FIELD_LICENSE_REQUEST_HEADERS = Util.intToStringMaxRadix(2);
        private static final String FIELD_MULTI_SESSION = Util.intToStringMaxRadix(3);
        @VisibleForTesting
        static final String FIELD_PLAY_CLEAR_CONTENT_WITHOUT_KEY = Util.intToStringMaxRadix(4);
        private static final String FIELD_FORCE_DEFAULT_LICENSE_URI = Util.intToStringMaxRadix(5);
        private static final String FIELD_FORCED_SESSION_TRACK_TYPES = Util.intToStringMaxRadix(6);
        private static final String FIELD_KEY_SET_ID = Util.intToStringMaxRadix(7);
        @Deprecated
        @UnstableApi
        public static final Bundleable.Creator<DrmConfiguration> CREATOR = DrmConfiguration::fromBundle;

        private DrmConfiguration(Builder builder) {
            Assertions.checkState(!builder.forceDefaultLicenseUri || builder.licenseUri != null);
            this.uuid = this.scheme = Assertions.checkNotNull(builder.scheme);
            this.licenseUri = builder.licenseUri;
            this.requestHeaders = builder.licenseRequestHeaders;
            this.licenseRequestHeaders = builder.licenseRequestHeaders;
            this.multiSession = builder.multiSession;
            this.forceDefaultLicenseUri = builder.forceDefaultLicenseUri;
            this.playClearContentWithoutKey = builder.playClearContentWithoutKey;
            this.sessionForClearTypes = builder.forcedSessionTrackTypes;
            this.forcedSessionTrackTypes = builder.forcedSessionTrackTypes;
            this.keySetId = builder.keySetId != null ? Arrays.copyOf(builder.keySetId, builder.keySetId.length) : null;
        }

        @Nullable
        public byte[] getKeySetId() {
            return this.keySetId != null ? Arrays.copyOf(this.keySetId, this.keySetId.length) : null;
        }

        public Builder buildUpon() {
            return new Builder(this);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DrmConfiguration)) {
                return false;
            }
            DrmConfiguration other = (DrmConfiguration)obj;
            return this.scheme.equals(other.scheme) && Util.areEqual(this.licenseUri, other.licenseUri) && Util.areEqual(this.licenseRequestHeaders, other.licenseRequestHeaders) && this.multiSession == other.multiSession && this.forceDefaultLicenseUri == other.forceDefaultLicenseUri && this.playClearContentWithoutKey == other.playClearContentWithoutKey && this.forcedSessionTrackTypes.equals(other.forcedSessionTrackTypes) && Arrays.equals(this.keySetId, other.keySetId);
        }

        public int hashCode() {
            int result = this.scheme.hashCode();
            result = 31 * result + (this.licenseUri != null ? this.licenseUri.hashCode() : 0);
            result = 31 * result + this.licenseRequestHeaders.hashCode();
            result = 31 * result + (this.multiSession ? 1 : 0);
            result = 31 * result + (this.forceDefaultLicenseUri ? 1 : 0);
            result = 31 * result + (this.playClearContentWithoutKey ? 1 : 0);
            result = 31 * result + this.forcedSessionTrackTypes.hashCode();
            result = 31 * result + Arrays.hashCode(this.keySetId);
            return result;
        }

        @UnstableApi
        public static DrmConfiguration fromBundle(Bundle bundle) {
            UUID scheme = UUID.fromString(Assertions.checkNotNull(bundle.getString(FIELD_SCHEME)));
            Uri licenseUri = (Uri)bundle.getParcelable(FIELD_LICENSE_URI);
            Bundle licenseMapAsBundle = BundleCollectionUtil.getBundleWithDefault(bundle, FIELD_LICENSE_REQUEST_HEADERS, Bundle.EMPTY);
            ImmutableMap<String, String> licenseRequestHeaders = BundleCollectionUtil.bundleToStringImmutableMap(licenseMapAsBundle);
            boolean multiSession = bundle.getBoolean(FIELD_MULTI_SESSION, false);
            boolean playClearContentWithoutKey = bundle.getBoolean(FIELD_PLAY_CLEAR_CONTENT_WITHOUT_KEY, false);
            boolean forceDefaultLicenseUri = bundle.getBoolean(FIELD_FORCE_DEFAULT_LICENSE_URI, false);
            ArrayList<Integer> forcedSessionTrackTypesArray = BundleCollectionUtil.getIntegerArrayListWithDefault(bundle, FIELD_FORCED_SESSION_TRACK_TYPES, new ArrayList<Integer>());
            ImmutableList forcedSessionTrackTypes = ImmutableList.copyOf(forcedSessionTrackTypesArray);
            byte[] keySetId = bundle.getByteArray(FIELD_KEY_SET_ID);
            Builder builder = new Builder(scheme);
            return builder.setLicenseUri(licenseUri).setLicenseRequestHeaders((Map<String, String>)licenseRequestHeaders).setMultiSession(multiSession).setForceDefaultLicenseUri(forceDefaultLicenseUri).setPlayClearContentWithoutKey(playClearContentWithoutKey).setForcedSessionTrackTypes((List<Integer>)forcedSessionTrackTypes).setKeySetId(keySetId).build();
        }

        @Override
        @UnstableApi
        public Bundle toBundle() {
            Bundle bundle = new Bundle();
            bundle.putString(FIELD_SCHEME, this.scheme.toString());
            if (this.licenseUri != null) {
                bundle.putParcelable(FIELD_LICENSE_URI, (Parcelable)this.licenseUri);
            }
            if (!this.licenseRequestHeaders.isEmpty()) {
                bundle.putBundle(FIELD_LICENSE_REQUEST_HEADERS, BundleCollectionUtil.stringMapToBundle(this.licenseRequestHeaders));
            }
            if (this.multiSession) {
                bundle.putBoolean(FIELD_MULTI_SESSION, this.multiSession);
            }
            if (this.playClearContentWithoutKey) {
                bundle.putBoolean(FIELD_PLAY_CLEAR_CONTENT_WITHOUT_KEY, this.playClearContentWithoutKey);
            }
            if (this.forceDefaultLicenseUri) {
                bundle.putBoolean(FIELD_FORCE_DEFAULT_LICENSE_URI, this.forceDefaultLicenseUri);
            }
            if (!this.forcedSessionTrackTypes.isEmpty()) {
                bundle.putIntegerArrayList(FIELD_FORCED_SESSION_TRACK_TYPES, new ArrayList<Integer>((Collection<Integer>)this.forcedSessionTrackTypes));
            }
            if (this.keySetId != null) {
                bundle.putByteArray(FIELD_KEY_SET_ID, this.keySetId);
            }
            return bundle;
        }

        public static final class Builder {
            @Nullable
            private UUID scheme;
            @Nullable
            private Uri licenseUri;
            private ImmutableMap<String, String> licenseRequestHeaders;
            private boolean multiSession;
            private boolean playClearContentWithoutKey;
            private boolean forceDefaultLicenseUri;
            private ImmutableList<Integer> forcedSessionTrackTypes;
            @Nullable
            private byte[] keySetId;

            public Builder(UUID scheme) {
                this();
                this.scheme = scheme;
            }

            @Deprecated
            private Builder() {
                this.licenseRequestHeaders = ImmutableMap.of();
                this.playClearContentWithoutKey = true;
                this.forcedSessionTrackTypes = ImmutableList.of();
            }

            private Builder(DrmConfiguration drmConfiguration) {
                this.scheme = drmConfiguration.scheme;
                this.licenseUri = drmConfiguration.licenseUri;
                this.licenseRequestHeaders = drmConfiguration.licenseRequestHeaders;
                this.multiSession = drmConfiguration.multiSession;
                this.playClearContentWithoutKey = drmConfiguration.playClearContentWithoutKey;
                this.forceDefaultLicenseUri = drmConfiguration.forceDefaultLicenseUri;
                this.forcedSessionTrackTypes = drmConfiguration.forcedSessionTrackTypes;
                this.keySetId = drmConfiguration.keySetId;
            }

            @CanIgnoreReturnValue
            public Builder setScheme(UUID scheme) {
                this.scheme = scheme;
                return this;
            }

            @Deprecated
            @CanIgnoreReturnValue
            private Builder setNullableScheme(@Nullable UUID scheme) {
                this.scheme = scheme;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setLicenseUri(@Nullable Uri licenseUri) {
                this.licenseUri = licenseUri;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setLicenseUri(@Nullable String licenseUri) {
                this.licenseUri = licenseUri == null ? null : Uri.parse((String)licenseUri);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setLicenseRequestHeaders(Map<String, String> licenseRequestHeaders) {
                this.licenseRequestHeaders = ImmutableMap.copyOf(licenseRequestHeaders);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setMultiSession(boolean multiSession) {
                this.multiSession = multiSession;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setForceDefaultLicenseUri(boolean forceDefaultLicenseUri) {
                this.forceDefaultLicenseUri = forceDefaultLicenseUri;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setPlayClearContentWithoutKey(boolean playClearContentWithoutKey) {
                this.playClearContentWithoutKey = playClearContentWithoutKey;
                return this;
            }

            @Deprecated
            @CanIgnoreReturnValue
            @UnstableApi
            @InlineMe(replacement="this.setForceSessionsForAudioAndVideoTracks(forceSessionsForAudioAndVideoTracks)")
            public Builder forceSessionsForAudioAndVideoTracks(boolean forceSessionsForAudioAndVideoTracks) {
                return this.setForceSessionsForAudioAndVideoTracks(forceSessionsForAudioAndVideoTracks);
            }

            @CanIgnoreReturnValue
            public Builder setForceSessionsForAudioAndVideoTracks(boolean forceSessionsForAudioAndVideoTracks) {
                this.setForcedSessionTrackTypes((List<Integer>)(forceSessionsForAudioAndVideoTracks ? ImmutableList.of((Object)2, (Object)1) : ImmutableList.of()));
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setForcedSessionTrackTypes(List<Integer> forcedSessionTrackTypes) {
                this.forcedSessionTrackTypes = ImmutableList.copyOf(forcedSessionTrackTypes);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setKeySetId(@Nullable byte[] keySetId) {
                this.keySetId = keySetId != null ? Arrays.copyOf(keySetId, keySetId.length) : null;
                return this;
            }

            public DrmConfiguration build() {
                return new DrmConfiguration(this);
            }
        }
    }
}

